/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.share;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.fsmgr.client.FsMgrAccessListOption;
import com.sun.admin.fsmgr.client.FsMgrBooleanOption;
import com.sun.admin.fsmgr.client.FsMgrIntegerOption;
import com.sun.admin.fsmgr.client.FsMgrStringOption;
import com.sun.admin.fsmgr.client.share.FsMgrSecurityOption;
import com.sun.admin.fsmgr.common.FsMgrShare;
import com.sun.admin.fsmgr.common.FsMgrShareDataException;
import java.util.Vector;

public class FsMgrShareData
implements Cloneable {
    private static final String EMPTY_STRING = new String("");
    private static final String COMMA = new String(",");
    public static final String NFS = new String("nfs");
    private static Vector supportedSecurityModes = new Vector();
    private static String defaultSecurityMode = EMPTY_STRING;
    public static final String SHARETAB = new String("sharetab");
    public static final String DFSTAB = new String("dfstab");
    public static final String[] SHARETAB_ARRAY = new String[]{SHARETAB};
    public static final String[] DFSTAB_ARRAY = new String[]{DFSTAB};
    public static final String[] SHAREBOTH_ARRAY = new String[]{SHARETAB, DFSTAB};
    private String rawString = EMPTY_STRING;
    private String pathname = EMPTY_STRING;
    private String description = EMPTY_STRING;
    private String resource = EMPTY_STRING;
    private FsMgrSecurityOption secNone;
    private FsMgrSecurityOption secSys;
    private FsMgrSecurityOption secDh;
    private FsMgrSecurityOption secKrb4;
    private FsMgrBooleanOption rw;
    private FsMgrBooleanOption ro;
    private FsMgrAccessListOption rwList;
    private FsMgrAccessListOption roList;
    private FsMgrAccessListOption rootList;
    private FsMgrBooleanOption aclok;
    private FsMgrBooleanOption nosuid;
    private FsMgrBooleanOption nosub;
    private FsMgrBooleanOption kerberos;
    private FsMgrBooleanOption secure;
    private FsMgrBooleanOption webnfs;
    private FsMgrIntegerOption anon;
    private FsMgrStringOption index;
    public static final String NONE = new String("none");
    public static final String SYS = new String("sys");
    public static final String DH = new String("dh");
    public static final String KRB4 = new String("krb4");
    public static final String ACLOK = new String("aclok");
    public static final String NOSUID = new String("nosuid");
    public static final String NOSUB = new String("nosub");
    public static final String KERBEROS = new String("kerberos");
    public static final String SECURE = new String("secure");
    public static final String PUBLIC = new String("public");
    public static final String ANON = new String("anon");
    public static final String INDEX = new String("index");
    public static final String SEC = new String("sec");
    public static final String RW = new String("rw");
    public static final String RWLIST = new String("rwlist");
    public static final String RO = new String("ro");
    public static final String ROLIST = new String("rolist");
    public static final String ROOT = new String("root");
    public static final String ROOTLIST = new String("root");
    public static final String WINDOW = new String("window");
    public static final boolean RW_DEFAULT = true;
    public static final boolean RO_DEFAULT = false;
    public static final boolean ACLOK_DEFAULT = false;
    public static final boolean NOSUID_DEFAULT = false;
    public static final boolean NOSUB_DEFAULT = false;
    public static final boolean KERBEROS_DEFAULT = false;
    public static final boolean SECURE_DEFAULT = false;
    public static final boolean PUBLIC_DEFAULT = false;
    public static final int ANON_DEFAULT = 60001;
    private String accessListKing;

    public FsMgrShareData(String string) throws FsMgrShareDataException {
        if (string == null || string.length() == 0) {
            AdminCommonTools.CMN_HandleOutput("Invalid share path");
            throw new FsMgrShareDataException("EXM_SHRPATH");
        }
        this.pathname = string;
    }

    public FsMgrShareData(FsMgrShare fsMgrShare) throws FsMgrShareDataException {
        if (fsMgrShare == null) {
            return;
        }
        this.rawString = fsMgrShare.getRawString();
        this.pathname = fsMgrShare.getPathname();
        if (this.pathname == null || this.pathname.length() == 0) {
            AdminCommonTools.CMN_HandleOutput("Invalid share path");
            throw new FsMgrShareDataException("EXM_SHRPATH");
        }
        this.description = fsMgrShare.getDescription();
        this.resource = fsMgrShare.getResource();
        String string = fsMgrShare.getOptions();
        if (string != null && string.length() != 0) {
            int n = 0;
            int n2 = 0;
            int n3 = 44;
            boolean bl = true;
            while (bl) {
                String string2;
                n2 = string.indexOf(n3, n);
                if (n2 == -1) {
                    if (n == string.length() - 1) {
                        bl = false;
                    }
                    string2 = string.substring(n).trim();
                    bl = false;
                } else {
                    string2 = string.substring(n, n2).trim();
                    n = n2 + 1;
                }
                this.setOption(string2);
            }
        }
        this.verify();
        this.convertAccess();
    }

    public Object clone() {
        try {
            FsMgrShareData fsMgrShareData = (FsMgrShareData)super.clone();
            if (this.secNone != null) {
                fsMgrShareData.secNone = (FsMgrSecurityOption)this.secNone.clone();
            }
            if (this.secSys != null) {
                fsMgrShareData.secSys = (FsMgrSecurityOption)this.secSys.clone();
            }
            if (this.secDh != null) {
                fsMgrShareData.secDh = (FsMgrSecurityOption)this.secDh.clone();
            }
            if (this.secKrb4 != null) {
                fsMgrShareData.secKrb4 = (FsMgrSecurityOption)this.secKrb4.clone();
            }
            if (this.rw != null) {
                fsMgrShareData.rw = (FsMgrBooleanOption)this.rw.clone();
            }
            if (this.ro != null) {
                fsMgrShareData.ro = (FsMgrBooleanOption)this.ro.clone();
            }
            if (this.rwList != null) {
                fsMgrShareData.rwList = (FsMgrAccessListOption)this.rwList.clone();
            }
            if (this.roList != null) {
                fsMgrShareData.roList = (FsMgrAccessListOption)this.roList.clone();
            }
            if (this.rootList != null) {
                fsMgrShareData.rootList = (FsMgrAccessListOption)this.rootList.clone();
            }
            if (this.aclok != null) {
                fsMgrShareData.aclok = (FsMgrBooleanOption)this.aclok.clone();
            }
            if (this.nosuid != null) {
                fsMgrShareData.nosuid = (FsMgrBooleanOption)this.nosuid.clone();
            }
            if (this.nosub != null) {
                fsMgrShareData.nosub = (FsMgrBooleanOption)this.nosub.clone();
            }
            if (this.kerberos != null) {
                fsMgrShareData.kerberos = (FsMgrBooleanOption)this.kerberos.clone();
            }
            if (this.secure != null) {
                fsMgrShareData.secure = (FsMgrBooleanOption)this.secure.clone();
            }
            if (this.webnfs != null) {
                fsMgrShareData.webnfs = (FsMgrBooleanOption)this.webnfs.clone();
            }
            if (this.anon != null) {
                fsMgrShareData.anon = (FsMgrIntegerOption)this.anon.clone();
            }
            if (this.index != null) {
                fsMgrShareData.index = (FsMgrStringOption)this.index.clone();
            }
            return fsMgrShareData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equalAttributes(FsMgrBooleanOption fsMgrBooleanOption, FsMgrBooleanOption fsMgrBooleanOption2, boolean bl) {
        if (fsMgrBooleanOption == null && fsMgrBooleanOption2 == null) {
            return true;
        }
        if (fsMgrBooleanOption == null || fsMgrBooleanOption2 == null) {
            if (fsMgrBooleanOption == null) {
                fsMgrBooleanOption = new FsMgrBooleanOption(fsMgrBooleanOption2.getOptionName(), bl);
            } else {
                fsMgrBooleanOption2 = new FsMgrBooleanOption(fsMgrBooleanOption.getOptionName(), bl);
            }
        }
        return this.equalAttributes(fsMgrBooleanOption, fsMgrBooleanOption2);
    }

    public boolean equalAttributes(FsMgrStringOption fsMgrStringOption, FsMgrStringOption fsMgrStringOption2, String string) {
        if (fsMgrStringOption == null && fsMgrStringOption2 == null) {
            return true;
        }
        if (fsMgrStringOption == null || fsMgrStringOption2 == null) {
            if (fsMgrStringOption == null) {
                fsMgrStringOption = new FsMgrStringOption(fsMgrStringOption2.getOptionName(), string);
            } else {
                fsMgrStringOption2 = new FsMgrStringOption(fsMgrStringOption.getOptionName(), string);
            }
        }
        return this.equalAttributes(fsMgrStringOption, fsMgrStringOption2);
    }

    public boolean equalAttributes(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            AdminCommonTools.CMN_HandleOutput("null object not equal to non-null object");
            return false;
        }
        if (object instanceof String) {
            if (object2 instanceof String) {
                String string = (String)object;
                String string2 = (String)object2;
                return string.equals(string2);
            }
            return false;
        }
        if (object instanceof FsMgrSecurityOption) {
            if (object2 instanceof FsMgrSecurityOption) {
                FsMgrSecurityOption fsMgrSecurityOption = (FsMgrSecurityOption)object;
                FsMgrSecurityOption fsMgrSecurityOption2 = (FsMgrSecurityOption)object2;
                return fsMgrSecurityOption.equals(fsMgrSecurityOption2);
            }
            return false;
        }
        if (object instanceof FsMgrBooleanOption) {
            if (object instanceof FsMgrBooleanOption) {
                FsMgrBooleanOption fsMgrBooleanOption = (FsMgrBooleanOption)object;
                FsMgrBooleanOption fsMgrBooleanOption2 = (FsMgrBooleanOption)object2;
                return fsMgrBooleanOption.equals(fsMgrBooleanOption2);
            }
            return false;
        }
        if (object instanceof FsMgrAccessListOption) {
            if (object instanceof FsMgrAccessListOption) {
                FsMgrAccessListOption fsMgrAccessListOption = (FsMgrAccessListOption)object;
                FsMgrAccessListOption fsMgrAccessListOption2 = (FsMgrAccessListOption)object2;
                return fsMgrAccessListOption.equals(fsMgrAccessListOption2);
            }
            return false;
        }
        if (object instanceof FsMgrStringOption) {
            if (object instanceof FsMgrStringOption) {
                FsMgrStringOption fsMgrStringOption = (FsMgrStringOption)object;
                FsMgrStringOption fsMgrStringOption2 = (FsMgrStringOption)object2;
                return fsMgrStringOption.equals(fsMgrStringOption2);
            }
            return false;
        }
        if (object instanceof FsMgrIntegerOption) {
            if (object instanceof FsMgrIntegerOption) {
                FsMgrIntegerOption fsMgrIntegerOption = (FsMgrIntegerOption)object;
                FsMgrIntegerOption fsMgrIntegerOption2 = (FsMgrIntegerOption)object2;
                return fsMgrIntegerOption.equals(fsMgrIntegerOption2);
            }
            return false;
        }
        AdminCommonTools.CMN_HandleOutput("Can't compare unrecognizable attribute types");
        return false;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof FsMgrShareData)) {
            return false;
        }
        FsMgrShareData fsMgrShareData = (FsMgrShareData)object;
        String string = fsMgrShareData.getPathname();
        if (!this.equalAttributes(string, this.pathname)) {
            AdminCommonTools.CMN_HandleOutput("pathname NOT equal");
            return false;
        }
        String string2 = fsMgrShareData.getDescription();
        if (!this.equalAttributes(string2, this.description) && (string2 != null && string2.length() != 0 || this.description != null && this.description.length() != 0)) {
            AdminCommonTools.CMN_HandleOutput("description NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption = (FsMgrBooleanOption)fsMgrShareData.getOption(ACLOK);
        if (!this.equalAttributes(fsMgrBooleanOption, this.aclok, false)) {
            AdminCommonTools.CMN_HandleOutput("aclok NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption2 = (FsMgrBooleanOption)fsMgrShareData.getOption(NOSUID);
        if (!this.equalAttributes(fsMgrBooleanOption2, this.nosuid, false)) {
            AdminCommonTools.CMN_HandleOutput("nosuid NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption3 = (FsMgrBooleanOption)fsMgrShareData.getOption(NOSUB);
        if (!this.equalAttributes(fsMgrBooleanOption3, this.nosub, false)) {
            AdminCommonTools.CMN_HandleOutput("nosub NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption4 = (FsMgrBooleanOption)fsMgrShareData.getOption(PUBLIC);
        if (!this.equalAttributes(fsMgrBooleanOption4, this.webnfs, false)) {
            AdminCommonTools.CMN_HandleOutput("webnfs NOT equal");
            return false;
        }
        FsMgrIntegerOption fsMgrIntegerOption = (FsMgrIntegerOption)fsMgrShareData.getOption(ANON);
        if (!this.equalAttributes(fsMgrIntegerOption, this.anon)) {
            AdminCommonTools.CMN_HandleOutput("anon NOT equal");
            return false;
        }
        FsMgrStringOption fsMgrStringOption = (FsMgrStringOption)fsMgrShareData.getOption(INDEX);
        if (!this.equalAttributes(fsMgrStringOption, this.index)) {
            AdminCommonTools.CMN_HandleOutput("index NOT equal");
            return false;
        }
        return this.equalAccess(fsMgrShareData);
    }

    public boolean equalAccess(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof FsMgrShareData)) {
            return false;
        }
        FsMgrShareData fsMgrShareData = (FsMgrShareData)object;
        FsMgrSecurityOption fsMgrSecurityOption = (FsMgrSecurityOption)fsMgrShareData.getOption(NONE);
        if (!this.equalAttributes(fsMgrSecurityOption, this.secNone)) {
            AdminCommonTools.CMN_HandleOutput("secNone NOT equal");
            return false;
        }
        FsMgrSecurityOption fsMgrSecurityOption2 = (FsMgrSecurityOption)fsMgrShareData.getOption(SYS);
        if (!this.equalAttributes(fsMgrSecurityOption2, this.secSys)) {
            AdminCommonTools.CMN_HandleOutput("secSys NOT equal");
            return false;
        }
        FsMgrSecurityOption fsMgrSecurityOption3 = (FsMgrSecurityOption)fsMgrShareData.getOption(DH);
        if (!this.equalAttributes(fsMgrSecurityOption3, this.secDh)) {
            AdminCommonTools.CMN_HandleOutput("secDh NOT equal");
            return false;
        }
        FsMgrSecurityOption fsMgrSecurityOption4 = (FsMgrSecurityOption)fsMgrShareData.getOption(KRB4);
        if (!this.equalAttributes(fsMgrSecurityOption4, this.secKrb4)) {
            AdminCommonTools.CMN_HandleOutput("secKrb4 NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption = (FsMgrBooleanOption)fsMgrShareData.getOption(RW);
        if (!this.equalAttributes(fsMgrBooleanOption, this.rw, true)) {
            AdminCommonTools.CMN_HandleOutput("rw NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption2 = (FsMgrBooleanOption)fsMgrShareData.getOption(RO);
        if (!this.equalAttributes(fsMgrBooleanOption2, this.ro, false)) {
            AdminCommonTools.CMN_HandleOutput("ro NOT equal");
            return false;
        }
        FsMgrAccessListOption fsMgrAccessListOption = (FsMgrAccessListOption)fsMgrShareData.getOption(RWLIST);
        if (!this.equalAttributes(fsMgrAccessListOption, this.rwList)) {
            AdminCommonTools.CMN_HandleOutput("rwList NOT equal");
            return false;
        }
        FsMgrAccessListOption fsMgrAccessListOption2 = (FsMgrAccessListOption)fsMgrShareData.getOption(ROLIST);
        if (!this.equalAttributes(fsMgrAccessListOption2, this.roList)) {
            AdminCommonTools.CMN_HandleOutput("roList NOT equal");
            return false;
        }
        FsMgrAccessListOption fsMgrAccessListOption3 = (FsMgrAccessListOption)fsMgrShareData.getOption(ROOTLIST);
        if (!this.equalAttributes(fsMgrAccessListOption3, this.rootList)) {
            AdminCommonTools.CMN_HandleOutput("rootList NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption3 = (FsMgrBooleanOption)fsMgrShareData.getOption(KERBEROS);
        if (!this.equalAttributes(fsMgrBooleanOption3, this.kerberos, false)) {
            AdminCommonTools.CMN_HandleOutput("kerberos NOT equal");
            return false;
        }
        FsMgrBooleanOption fsMgrBooleanOption4 = (FsMgrBooleanOption)fsMgrShareData.getOption(SECURE);
        if (!this.equalAttributes(fsMgrBooleanOption4, this.secure, false)) {
            AdminCommonTools.CMN_HandleOutput("secure NOT equal");
            return false;
        }
        return true;
    }

    private FsMgrSecurityOption createOption(String string, FsMgrSecurityOption fsMgrSecurityOption) throws FsMgrShareDataException {
        if (fsMgrSecurityOption != null) {
            AdminCommonTools.CMN_HandleOutput("Can't set option twice");
            throw new FsMgrShareDataException("EXM_SHROPT", string);
        }
        boolean bl = false;
        int n = 0;
        while (n < supportedSecurityModes.size()) {
            String string2 = (String)supportedSecurityModes.elementAt(n);
            if (string.equals(string2)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            AdminCommonTools.CMN_HandleOutput("Attempt to create unsupported security mode = " + string);
            throw new FsMgrShareDataException("EXM_SHROPT", string);
        }
        return new FsMgrSecurityOption(string);
    }

    private FsMgrAccessListOption createOption(String string, FsMgrAccessListOption fsMgrAccessListOption, String string2) throws FsMgrShareDataException {
        if (fsMgrAccessListOption != null) {
            AdminCommonTools.CMN_HandleOutput("Can't set option twice");
            throw new FsMgrShareDataException("EXM_SHROPT", string);
        }
        return new FsMgrAccessListOption(string, string2);
    }

    private FsMgrBooleanOption createOption(String string, FsMgrBooleanOption fsMgrBooleanOption, boolean bl) throws FsMgrShareDataException {
        if (fsMgrBooleanOption != null) {
            AdminCommonTools.CMN_HandleOutput("Can't set option twice");
            throw new FsMgrShareDataException("EXM_SHROPT", string);
        }
        return new FsMgrBooleanOption(string, bl);
    }

    private FsMgrIntegerOption createOption(String string, FsMgrIntegerOption fsMgrIntegerOption, String string2) throws FsMgrShareDataException {
        if (fsMgrIntegerOption != null) {
            AdminCommonTools.CMN_HandleOutput("Can't set option twice");
            throw new FsMgrShareDataException("EXM_SHROPT", string);
        }
        return new FsMgrIntegerOption(string, string2);
    }

    private FsMgrStringOption createOption(String string, FsMgrStringOption fsMgrStringOption, String string2) throws FsMgrShareDataException {
        if (fsMgrStringOption != null) {
            AdminCommonTools.CMN_HandleOutput("Can't set option twice");
            throw new FsMgrShareDataException("EXM_SHROPT", string);
        }
        return new FsMgrStringOption(string, string2);
    }

    private void setOption(String string) throws FsMgrShareDataException {
        int n = 61;
        int n2 = string.indexOf(n);
        if (n2 != -1) {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1);
            this.setOption(string2, string3);
            return;
        }
        String string4 = string;
        this.setOption(string4, true);
    }

    public void setOption(String string, FsMgrSecurityOption fsMgrSecurityOption) throws FsMgrShareDataException {
        this.disableSecurityModes();
        if (string.equals(NONE)) {
            this.secNone = fsMgrSecurityOption;
            if (fsMgrSecurityOption != null) {
                this.secNone.enable();
                return;
            }
        } else if (string.equals(SYS)) {
            this.secSys = fsMgrSecurityOption;
            if (fsMgrSecurityOption != null) {
                this.secSys.enable();
                return;
            }
        } else if (string.equals(DH)) {
            this.secDh = fsMgrSecurityOption;
            if (fsMgrSecurityOption != null) {
                this.secDh.enable();
                return;
            }
        } else if (string.equals(KRB4)) {
            this.secKrb4 = fsMgrSecurityOption;
            if (fsMgrSecurityOption != null) {
                this.secKrb4.enable();
                return;
            }
        } else {
            AdminCommonTools.CMN_HandleOutput("Unsupported security mode = " + string);
            throw new FsMgrShareDataException("EXM_SHROPT", string);
        }
    }

    public void setOption(String string, String string2) throws FsMgrShareDataException {
        if (string.equals(INDEX)) {
            if (this.index == null) {
                this.index = this.createOption(INDEX, this.index, string2);
                return;
            }
            this.index.setValue(string2);
            return;
        }
        if (string.equals(ANON)) {
            if (this.anon == null) {
                this.anon = this.createOption(ANON, this.anon, string2);
                return;
            }
            this.anon.setValue(string2);
            return;
        }
        if (string.equals(SEC)) {
            this.disableSecurityModes();
            this.enableSecurityModes(string2);
            return;
        }
        if (string.equals(RW)) {
            if (this.securityModesAreEnabled()) {
                this.setSecurityModeOption(string, string2);
                return;
            }
            if (this.rwList == null) {
                this.rwList = this.createOption(RW, this.rwList, string2);
            } else {
                this.rwList.setValue(string2);
            }
            if (this.accessListKing == null) {
                this.accessListKing = RWLIST;
                return;
            }
        } else if (string.equals(RO)) {
            if (this.securityModesAreEnabled()) {
                this.setSecurityModeOption(string, string2);
                return;
            }
            if (this.roList == null) {
                this.roList = this.createOption(RO, this.roList, string2);
            } else {
                this.roList.setValue(string2);
            }
            if (this.accessListKing == null) {
                this.accessListKing = ROLIST;
                return;
            }
        } else {
            if (string.equals(ROOT) || string.equals(ROOTLIST)) {
                if (this.securityModesAreEnabled()) {
                    this.setSecurityModeOption(string, string2);
                    return;
                }
                if (this.rootList == null) {
                    this.rootList = this.createOption(ROOT, this.rootList, string2);
                    return;
                }
                this.rootList.setValue(string2);
                return;
            }
            if (string.equals(WINDOW)) {
                if (this.securityModesAreEnabled()) {
                    this.setSecurityModeOption(string, string2);
                    return;
                }
                AdminCommonTools.CMN_HandleOutput("Invalid share option");
                throw new FsMgrShareDataException("EXM_SHROPT", string);
            }
            AdminCommonTools.CMN_HandleOutput("Unsupported option = " + string);
            throw new FsMgrShareDataException("EXM_SHROPT", string);
        }
    }

    public void setOption(String string, int n) throws FsMgrShareDataException {
        this.setOption(string, Integer.toString(n));
    }

    public void setOption(String string, boolean bl) throws FsMgrShareDataException {
        if (string.equals(ACLOK)) {
            if (this.aclok == null) {
                this.aclok = this.createOption(ACLOK, this.aclok, bl);
                return;
            }
            this.aclok.setValue(bl);
            return;
        }
        if (string.equals(NOSUID)) {
            if (this.nosuid == null) {
                this.nosuid = this.createOption(NOSUID, this.nosuid, bl);
                return;
            }
            this.nosuid.setValue(bl);
            return;
        }
        if (string.equals(NOSUB)) {
            if (this.nosub == null) {
                this.nosub = this.createOption(NOSUB, this.nosub, bl);
                return;
            }
            this.nosub.setValue(bl);
            return;
        }
        if (string.equals(KERBEROS)) {
            if (this.kerberos == null) {
                this.kerberos = this.createOption(KERBEROS, this.kerberos, bl);
                return;
            }
            this.kerberos.setValue(bl);
            return;
        }
        if (string.equals(SECURE)) {
            if (this.secure == null) {
                this.secure = this.createOption(SECURE, this.secure, bl);
                return;
            }
            this.secure.setValue(bl);
            return;
        }
        if (string.equals(PUBLIC)) {
            if (this.webnfs == null) {
                this.webnfs = this.createOption(PUBLIC, this.webnfs, bl);
                return;
            }
            this.webnfs.setValue(bl);
            return;
        }
        if (string.equals(RW)) {
            if (this.securityModesAreEnabled()) {
                this.setSecurityModeOption(string, bl);
                return;
            }
            if (this.rw == null) {
                this.rw = this.createOption(RW, this.rw, bl);
                return;
            }
            this.rw.setValue(bl);
            return;
        }
        if (string.equals(RO)) {
            if (this.securityModesAreEnabled()) {
                this.setSecurityModeOption(string, bl);
                return;
            }
            if (this.ro == null) {
                this.ro = this.createOption(RO, this.ro, bl);
                return;
            }
            this.ro.setValue(bl);
            return;
        }
        AdminCommonTools.CMN_HandleOutput("Unsupported option = " + string);
        throw new FsMgrShareDataException("EXM_SHROPT", string);
    }

    public Object getOption(String string) {
        Cloneable cloneable = null;
        if (string == NONE) {
            cloneable = this.secNone;
        } else if (string == SYS) {
            cloneable = this.secSys;
        } else if (string == DH) {
            cloneable = this.secDh;
        } else if (string == KRB4) {
            cloneable = this.secKrb4;
        } else if (string == RW) {
            cloneable = this.rw;
        } else if (string == RO) {
            cloneable = this.ro;
        } else if (string == RWLIST) {
            cloneable = this.rwList;
        } else if (string == ROLIST) {
            cloneable = this.roList;
        } else if (string == ROOTLIST) {
            cloneable = this.rootList;
        } else if (string == ACLOK) {
            cloneable = this.aclok;
        } else if (string == NOSUID) {
            cloneable = this.nosuid;
        } else if (string == NOSUB) {
            cloneable = this.nosub;
        } else if (string == KERBEROS) {
            cloneable = this.kerberos;
        } else if (string == SECURE) {
            cloneable = this.secure;
        } else if (string == PUBLIC) {
            cloneable = this.webnfs;
        } else if (string == ANON) {
            cloneable = this.anon;
        } else if (string == INDEX) {
            cloneable = this.index;
        } else {
            AdminCommonTools.CMN_HandleOutput("Unsupported option = " + string);
        }
        return cloneable;
    }

    public static void setSupportedSecurityModes(Vector vector) {
        supportedSecurityModes = vector;
    }

    public static Vector getSupportedSecurityMode() {
        return supportedSecurityModes;
    }

    public static void setDefaultSecurityMode(String string) {
        defaultSecurityMode = string;
    }

    public static String getDefaultSecurityMode() {
        return defaultSecurityMode;
    }

    private void verify() throws FsMgrShareDataException {
        if (this.rw != null && this.rw.getValue() && this.rwList != null) {
            AdminCommonTools.CMN_HandleOutput("Invalid share option");
            throw new FsMgrShareDataException("EXM_SHROPT", RW);
        }
        if (this.ro != null && this.ro.getValue() && this.roList != null) {
            AdminCommonTools.CMN_HandleOutput("Invalid share option");
            throw new FsMgrShareDataException("EXM_SHROPT", RO);
        }
        if (this.securityModesAreEnabled()) {
            if (this.rw != null && this.rw.getValue()) {
                AdminCommonTools.CMN_HandleOutput("Invalid share option");
                throw new FsMgrShareDataException("EXM_SHROPT", RW);
            }
            if (this.ro != null && this.ro.getValue()) {
                AdminCommonTools.CMN_HandleOutput("Invalid share option");
                throw new FsMgrShareDataException("EXM_SHROPT", RO);
            }
            if (this.rwList != null) {
                AdminCommonTools.CMN_HandleOutput("Invalid share option");
                throw new FsMgrShareDataException("EXM_SHROPT", RW);
            }
            if (this.roList != null) {
                AdminCommonTools.CMN_HandleOutput("Invalid share option");
                throw new FsMgrShareDataException("EXM_SHROPT", RO);
            }
            if (this.kerberos != null) {
                AdminCommonTools.CMN_HandleOutput("Invalid share option");
                throw new FsMgrShareDataException("EXM_SHROPT", KERBEROS);
            }
            if (this.secure != null) {
                AdminCommonTools.CMN_HandleOutput("Invalid share option");
                throw new FsMgrShareDataException("EXM_SHROPT", SECURE);
            }
            if (this.secNone != null) {
                this.secNone.verify();
            }
            if (this.secSys != null) {
                this.secSys.verify();
            }
            if (this.secDh != null) {
                this.secDh.verify();
            }
            if (this.secKrb4 != null) {
                this.secKrb4.verify();
            }
        }
    }

    private FsMgrSecurityOption getSecurityOption(String string) {
        FsMgrSecurityOption fsMgrSecurityOption = null;
        fsMgrSecurityOption = this.secSys != null && this.secSys.getOptionName().equals(string) ? this.secSys : (this.secDh != null && this.secDh.getOptionName().equals(string) ? this.secDh : (this.secKrb4 != null && this.secKrb4.getOptionName().equals(string) ? this.secKrb4 : (this.secNone != null && this.secNone.getOptionName().equals(string) ? this.secNone : null)));
        return fsMgrSecurityOption;
    }

    private boolean securityModesAreEnabled() {
        return this.secNone != null && this.secNone.isEnabled() || this.secSys != null && this.secSys.isEnabled() || this.secDh != null && this.secDh.isEnabled() || this.secKrb4 != null && this.secKrb4.isEnabled();
    }

    private void setSecurityModeOption(String string, boolean bl) throws FsMgrShareDataException {
        if (this.secNone != null && this.secNone.isEnabled()) {
            this.secNone.setOption(string, bl);
        }
        if (this.secSys != null && this.secSys.isEnabled()) {
            this.secSys.setOption(string, bl);
        }
        if (this.secDh != null && this.secDh.isEnabled()) {
            this.secDh.setOption(string, bl);
        }
        if (this.secKrb4 != null && this.secKrb4.isEnabled()) {
            this.secKrb4.setOption(string, bl);
        }
    }

    private void setSecurityModeOption(String string, String string2) throws FsMgrShareDataException {
        if (this.secNone != null && this.secNone.isEnabled()) {
            this.secNone.setOption(string, string2);
        }
        if (this.secSys != null && this.secSys.isEnabled()) {
            this.secSys.setOption(string, string2);
        }
        if (this.secDh != null && this.secDh.isEnabled()) {
            this.secDh.setOption(string, string2);
        }
        if (this.secKrb4 != null && this.secKrb4.isEnabled()) {
            this.secKrb4.setOption(string, string2);
        }
    }

    private void disableSecurityModes() {
        if (this.secNone != null && this.secNone.isEnabled()) {
            this.secNone.disable();
        }
        if (this.secSys != null && this.secSys.isEnabled()) {
            this.secSys.disable();
        }
        if (this.secDh != null && this.secDh.isEnabled()) {
            this.secDh.disable();
        }
        if (this.secKrb4 != null && this.secKrb4.isEnabled()) {
            this.secKrb4.disable();
        }
    }

    private void enableSecurityModes(String string) throws FsMgrShareDataException {
        int n = 0;
        int n2 = 0;
        int n3 = 58;
        boolean bl = true;
        while (bl) {
            String string2;
            n2 = string.indexOf(n3, n);
            if (n2 == -1) {
                if (n == string.length() - 1) {
                    return;
                }
                string2 = string.substring(n).trim();
                bl = false;
            } else {
                string2 = string.substring(n, n2).trim();
                n = n2 + 1;
            }
            if (string2.equals(NONE)) {
                this.secNone = this.createOption(NONE, this.secNone);
                this.secNone.enable();
                continue;
            }
            if (string2.equals(SYS)) {
                this.secSys = this.createOption(SYS, this.secSys);
                this.secSys.enable();
                continue;
            }
            if (string2.equals(DH)) {
                this.secDh = this.createOption(DH, this.secDh);
                this.secDh.enable();
                continue;
            }
            if (string2.equals(KRB4)) {
                this.secKrb4 = this.createOption(KRB4, this.secKrb4);
                this.secKrb4.enable();
                continue;
            }
            AdminCommonTools.CMN_HandleOutput("Unsupported security mode = " + string2);
            throw new FsMgrShareDataException("EXM_SHROPT", string2);
        }
    }

    public boolean isRw() {
        FsMgrSecurityOption fsMgrSecurityOption = this.getSecurityOption(defaultSecurityMode);
        boolean bl = fsMgrSecurityOption != null ? (this.secSys != null && this.secSys != fsMgrSecurityOption || this.secNone != null && this.secNone != fsMgrSecurityOption || this.secDh != null && this.secDh != fsMgrSecurityOption || this.secKrb4 != null && this.secKrb4 != fsMgrSecurityOption ? false : fsMgrSecurityOption.isRw()) : (this.securityModesAreEnabled() ? false : (this.rwList != null || this.roList != null ? false : (this.ro != null && this.ro.getValue() ? false : (this.rw != null && this.rw.getValue() ? true : true))));
        return bl;
    }

    public boolean isRo() {
        FsMgrSecurityOption fsMgrSecurityOption = this.getSecurityOption(defaultSecurityMode);
        boolean bl = fsMgrSecurityOption != null ? (this.secSys != null && this.secSys != fsMgrSecurityOption || this.secNone != null && this.secNone != fsMgrSecurityOption || this.secDh != null && this.secDh != fsMgrSecurityOption || this.secKrb4 != null && this.secKrb4 != fsMgrSecurityOption ? false : fsMgrSecurityOption.isRo()) : (this.securityModesAreEnabled() ? false : (this.rwList != null || this.roList != null ? false : (this.rw != null && this.rw.getValue() ? false : this.ro != null && this.ro.getValue())));
        return bl;
    }

    public FsMgrShare toFsMgrShare() {
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this.rw != null && this.rw.getValue()) {
            stringBuffer.append(this.rw.toString());
            stringBuffer.append(COMMA);
        }
        if (this.ro != null && this.ro.getValue()) {
            stringBuffer.append(this.ro.toString());
            stringBuffer.append(COMMA);
        }
        if (this.rwList != null) {
            stringBuffer.append(this.rwList.toString());
            stringBuffer.append(COMMA);
        }
        if (this.roList != null) {
            stringBuffer.append(this.roList.toString());
            stringBuffer.append(COMMA);
        }
        if (this.rootList != null) {
            stringBuffer.append(this.rootList.toString());
            stringBuffer.append(COMMA);
        }
        if (this.aclok != null && this.aclok.getValue()) {
            stringBuffer.append(this.aclok.toString());
            stringBuffer.append(COMMA);
        }
        if (this.nosuid != null && this.nosuid.getValue()) {
            stringBuffer.append(this.nosuid.toString());
            stringBuffer.append(COMMA);
        }
        if (this.nosub != null && this.nosub.getValue()) {
            stringBuffer.append(this.nosub.toString());
            stringBuffer.append(COMMA);
        }
        if (this.kerberos != null && this.kerberos.getValue()) {
            stringBuffer.append(this.kerberos.toString());
            stringBuffer.append(COMMA);
        }
        if (this.secure != null && this.secure.getValue()) {
            stringBuffer.append(this.secure.toString());
            stringBuffer.append(COMMA);
        }
        if (this.webnfs != null && this.webnfs.getValue()) {
            stringBuffer.append(this.webnfs.toString());
            stringBuffer.append(COMMA);
        }
        if (this.anon != null) {
            stringBuffer.append(this.anon.toString());
            stringBuffer.append(COMMA);
        }
        if (this.index != null) {
            stringBuffer.append(this.index.toString());
            stringBuffer.append(COMMA);
        }
        if (this.secNone != null) {
            stringBuffer.append(this.secNone.toString());
            stringBuffer.append(COMMA);
        }
        if (this.secSys != null) {
            stringBuffer.append(this.secSys.toString());
            stringBuffer.append(COMMA);
        }
        if (this.secDh != null) {
            stringBuffer.append(this.secDh.toString());
            stringBuffer.append(COMMA);
        }
        if (this.secKrb4 != null) {
            stringBuffer.append(this.secKrb4.toString());
            stringBuffer.append(COMMA);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        FsMgrShare fsMgrShare = new FsMgrShare(this.pathname, this.resource, NFS, stringBuffer.toString(), this.description);
        fsMgrShare.setRawString(this.rawString);
        return fsMgrShare;
    }

    public void convertAccess() throws FsMgrShareDataException {
        if (this.secNone != null || this.secSys != null || this.secDh != null || this.secKrb4 != null) {
            return;
        }
        String string = defaultSecurityMode;
        if (this.kerberos != null && this.kerberos.getValue()) {
            string = KRB4;
            this.kerberos = null;
        } else if (this.secure != null && this.secure.getValue()) {
            string = DH;
            this.secure = null;
        }
        this.enableSecurityModes(string);
        if (this.rw != null) {
            this.setOption(RW, this.rw.getValue());
            this.rw = null;
        }
        if (this.ro != null) {
            this.setOption(RO, this.ro.getValue());
            this.ro = null;
        }
        if (this.accessListKing == null || this.accessListKing.equals(RWLIST)) {
            if (this.rwList != null) {
                this.setOption(this.rwList.toString());
                this.rwList = null;
            }
            if (this.roList != null) {
                this.setOption(this.roList.toString());
                this.roList = null;
            }
        } else {
            if (this.roList != null) {
                this.setOption(this.roList.toString());
                this.roList = null;
            }
            if (this.rwList != null) {
                this.setOption(this.rwList.toString());
                this.rwList = null;
            }
        }
        if (this.rootList != null) {
            this.setOption(this.rootList.toString());
            this.rootList = null;
        }
    }

    public String getRawString() {
        return this.rawString;
    }

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String string) {
        this.pathname = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }
}

