/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.mount;

import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.fsmgr.client.FsMgr;
import com.sun.admin.fsmgr.client.FsMgrClient;
import com.sun.admin.fsmgr.client.FsMgrResourceStrings;
import com.sun.admin.fsmgr.client.mount.FsMgrMountData;
import com.sun.admin.fsmgr.client.mount.Mount;
import com.sun.admin.fsmgr.client.mount.MountCacheEntry;
import com.sun.admin.fsmgr.common.FsMgrException;
import com.sun.admin.fsmgr.common.FsMgrMount;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UnmountAction {
    private MountCacheEntry cacheEntry;
    private String action;
    private boolean canUnmount = false;

    public UnmountAction(MountCacheEntry mountCacheEntry, String string) {
        String string2;
        boolean bl;
        this.cacheEntry = mountCacheEntry;
        this.action = string;
        boolean bl2 = this.willBeNotMounted(mountCacheEntry, string);
        boolean bl3 = bl = mountCacheEntry.getBootData() != null;
        if (string.equals("UnmountBoot") && !bl2) {
            this.canUnmount = true;
            return;
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        try {
            string2 = FsMgrResourceStrings.getString("ConfirmUnmountNumColumns");
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = 30;
        }
        if (bl2) {
            string2 = FsMgrResourceStrings.getString("ConfirmUnmount2");
            FlowArea flowArea = new FlowArea(string2, n, Constants.ERROR_DIALOG_FONT);
            Constraints.constrain(jPanel, flowArea, 0, 0, 2, 1, 20, 5, 0, 5);
            String string3 = FsMgrResourceStrings.getString("ConfirmUnmountWill");
            flowArea = new FlowArea(string3, n, Constants.ERROR_DIALOG_FONT);
            Constraints.constrain(jPanel, flowArea, 0, 1, 2, 1, 20, 5, 10, 5);
            String string4 = FsMgrResourceStrings.getString("DialogBulletGif");
            ImageIcon imageIcon = FsMgr.getFsMgr().loadImageIcon(string4, "DialogBulletGif");
            Constraints.constrain(jPanel, new JLabel(imageIcon), 0, 2, 1, 1, 0, 18, 0.0, 0.0, 0, 10, 10, 5);
            String string5 = FsMgrResourceStrings.getString("ConfirmUnmountBullet2.1");
            flowArea = new FlowArea(string5, n - 5, Constants.ERROR_DIALOG_FONT);
            Constraints.constrain(jPanel, flowArea, 1, 2, 1, 1, 0, 5, 10, 5);
            Constraints.constrain(jPanel, new JLabel(imageIcon), 0, 3, 1, 1, 0, 18, 0.0, 0.0, 0, 10, 10, 5);
            string5 = bl ? FsMgrResourceStrings.getString("ConfirmUnmountBullet2.2.1") : FsMgrResourceStrings.getString("ConfirmUnmountBullet2.2.2");
            flowArea = new FlowArea(string5, n - 5, Constants.ERROR_DIALOG_FONT);
            Constraints.constrain(jPanel, flowArea, 1, 3, 1, 1, 0, 5, 10, 5);
            Constraints.constrain(jPanel, new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), 0, -1, 1, 0, 3, 18, 0.0, 1.0, 0, 0, 0, 0);
        } else {
            string2 = FsMgrResourceStrings.getString("ConfirmUnmount");
            FlowArea flowArea = new FlowArea(string2, n, Constants.ERROR_DIALOG_FONT);
            Constraints.constrain(jPanel, flowArea, 0, 0, 2, 1, 20, 5, 0, 5);
            String string6 = FsMgrResourceStrings.getString("ConfirmUnmountWill");
            flowArea = new FlowArea(string6, n, Constants.ERROR_DIALOG_FONT);
            Constraints.constrain(jPanel, flowArea, 0, 1, 2, 1, 20, 5, 10, 5);
            String string7 = FsMgrResourceStrings.getString("DialogBulletGif");
            ImageIcon imageIcon = FsMgr.getFsMgr().loadImageIcon(string7, "DialogBulletGif");
            Constraints.constrain(jPanel, new JLabel(imageIcon), 0, 2, 1, 1, 0, 18, 0.0, 0.0, 0, 10, 10, 5);
            String string8 = FsMgrResourceStrings.getString("ConfirmUnmountBullet1");
            flowArea = new FlowArea(string8, n - 5, Constants.ERROR_DIALOG_FONT);
            Constraints.constrain(jPanel, flowArea, 1, 2, 1, 1, 0, 5, 10, 5);
            Constraints.constrain(jPanel, new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), 0, -1, 1, 0, 3, 18, 0.0, 1.0, 0, 0, 0, 0);
        }
        new WarningDialog(FsMgr.getFsMgr().getFrame(), FsMgrResourceStrings.getString("ConfirmUnmountTitle"), jPanel, (ActionListener)new ConfirmUnmountListener(mountCacheEntry, string), FsMgrResourceStrings.getString("Unmount"));
    }

    public void unmount() {
        if (!this.canUnmount) {
            return;
        }
        String string = FsMgrResourceStrings.getString("PerformingUnmountTitle");
        String string2 = FsMgrResourceStrings.getString("PerformingUnmountMessage");
        Object[] objectArray = new Object[]{this.cacheEntry.getResource()};
        String string3 = MessageFormat.format(string2, objectArray);
        ProgressPanel progressPanel = new ProgressPanel(FsMgr.getFsMgr().getFrame(), 1, 30, false, false);
        progressPanel.setTitle(string);
        progressPanel.setText(string3);
        ((Component)progressPanel).setVisible(true);
        progressPanel.show();
        FsMgrClient fsMgrClient = FsMgrClient.instance();
        FsMgrMountData fsMgrMountData = null;
        FsMgrMount fsMgrMount = null;
        try {
            if (this.action.equals("UnmountNow") || this.action.equals("UnmountBoth")) {
                fsMgrMountData = this.cacheEntry.getNowData();
                if (fsMgrMountData.isSpecial()) {
                    return;
                }
                fsMgrMount = fsMgrMountData.toFsMgrMount();
                fsMgrClient.removeMount(fsMgrMount, FsMgrMountData.MOUNTTAB);
            }
            if (this.action.equals("UnmountBoot") || this.action.equals("UnmountBoth")) {
                fsMgrMountData = this.cacheEntry.getBootData();
                if (fsMgrMountData.isSpecial()) {
                    return;
                }
                fsMgrMount = fsMgrMountData.toFsMgrMount();
                fsMgrClient.removeMount(fsMgrMount, FsMgrMountData.VFSTAB);
                fsMgrMount.setBootMount(FsMgrMountData.NO);
                fsMgrClient.addMount(fsMgrMount, FsMgrMountData.VFSTAB_ARRAY);
            }
        }
        catch (FsMgrException fsMgrException) {
            new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrException.getLocalizedMessage());
        }
        if (fsMgrMount != null) {
            Mount.getInstance().refresh(fsMgrMount.getResource(), fsMgrMount.getMountPoint());
        }
        try {
            Thread.currentThread();
            Thread.sleep(1500L);
        }
        catch (Exception exception) {}
        ((Component)progressPanel).setVisible(false);
        progressPanel.dispose();
    }

    private boolean willBeNotMounted(MountCacheEntry mountCacheEntry, String string) {
        boolean bl = false;
        if (string.equals("UnmountBoth")) {
            bl = true;
        } else if (string.equals("UnmountBoot") && mountCacheEntry.getStatusString().equals(MountCacheEntry.ATBOOT)) {
            bl = true;
        } else if (string.equals("UnmountNow") && mountCacheEntry.getStatusString().equals(MountCacheEntry.NOW)) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ boolean access$0(UnmountAction unmountAction) {
        return unmountAction.canUnmount;
    }

    private class ConfirmUnmountListener
    implements ActionListener {
        MountCacheEntry cacheEntry;
        String action;

        public ConfirmUnmountListener(MountCacheEntry mountCacheEntry, String string) {
            UnmountAction.this = UnmountAction.this;
            this.cacheEntry = mountCacheEntry;
            this.action = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UnmountAction.this.canUnmount = true;
        }
    }
}

