/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.security;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.server.AdminServerLibrary;
import com.sun.admin.cis.service.security.AdminAuthenticationException;
import com.sun.admin.cis.service.security.AdminPrincipal;
import com.sun.admin.cis.service.security.AdminSecurityException;
import com.sun.admin.cis.service.security.AdminSecurityUtil;
import com.sun.admin.cis.service.security.AdminVerificationException;
import com.sun.admin.cis.service.security.AuthenticationFlavor;
import com.sun.admin.cis.service.security.AuthenticatorSecurityToken;
import com.sun.admin.cis.service.security.DigestAuthFlavor;
import com.sun.admin.cis.service.security.DigestAuthenticatorSecurityToken;
import com.sun.admin.cis.service.security.DigestConfirmSecurityToken;
import com.sun.admin.cis.service.security.DigestResponseSecurityToken;
import com.sun.admin.cis.service.security.DigestSecurityUtil;
import com.sun.admin.cis.service.security.DigestVerifierSecurityToken;
import com.sun.admin.cis.service.security.RequestSecurityToken;
import com.sun.admin.cis.service.security.SecurityToken;
import com.sun.admin.cis.service.security.ServerSecurityContext;
import com.sun.admin.cis.service.security.VerifierSecurityToken;
import java.security.PublicKey;

public class DigestServerSecurityContext
extends ServerSecurityContext {
    private boolean signing;
    private boolean integrity = false;
    private PublicKey clientkey = null;
    private byte[] serverchg = null;
    private byte[] clientchg = null;
    private byte[] sessionkey = null;
    private byte[] hashpswd = null;
    private byte[] salt = null;
    private String userpswd = null;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public DigestServerSecurityContext(DigestAuthFlavor digestAuthFlavor) throws AdminSecurityException {
        super(digestAuthFlavor);
    }

    public boolean verifyAuthFlavor(AuthenticationFlavor authenticationFlavor) throws AdminSecurityException {
        boolean bl = true;
        boolean bl2 = false;
        DigestAuthFlavor digestAuthFlavor = null;
        try {
            digestAuthFlavor = (DigestAuthFlavor)authenticationFlavor;
        }
        catch (Exception exception) {
            this.writeLog(2, "LM_1030", "LM_1037", authenticationFlavor.getAuthTypeName(), "digest");
            bl = false;
        }
        DigestAuthFlavor digestAuthFlavor2 = (DigestAuthFlavor)this.getAuthFlavor();
        while (bl) {
            if (digestAuthFlavor.getAuthType() != 1) {
                this.writeLog(2, "LM_1030", "LM_1037", digestAuthFlavor.getAuthTypeName(), "digest");
                break;
            }
            if (!digestAuthFlavor2.getDigestAlgorithm().equals(digestAuthFlavor.getDigestAlgorithm())) {
                this.writeLog(2, "LM_1030", "LM_1038", digestAuthFlavor.getDigestAlgorithm(), digestAuthFlavor2.getDigestAlgorithm());
                break;
            }
            if (!digestAuthFlavor2.getSignatureAlgorithm().equals(digestAuthFlavor.getSignatureAlgorithm())) {
                this.writeLog(2, "LM_1030", "LM_1039", digestAuthFlavor.getSignatureAlgorithm(), digestAuthFlavor2.getSignatureAlgorithm());
                break;
            }
            if (!digestAuthFlavor2.getKeyGenerationAlgorithm().equals(digestAuthFlavor.getKeyGenerationAlgorithm())) {
                this.writeLog(2, "LM_1030", "LM_1040", digestAuthFlavor.getKeyGenerationAlgorithm(), digestAuthFlavor2.getKeyGenerationAlgorithm());
                break;
            }
            if (digestAuthFlavor2.getKeyStrength() != digestAuthFlavor.getKeyStrength()) {
                this.writeLog(2, "LM_1030", "LM_1041", new Integer(digestAuthFlavor.getKeyStrength()).toString(), new Integer(digestAuthFlavor2.getKeyStrength()).toString());
                break;
            }
            bl2 = true;
            bl = false;
        }
        if (!bl2) {
            AdminCommonTools.CMN_Trace1("Security service: authentication flavor mismatch");
        }
        return bl2;
    }

    public SecurityToken verifyRequest(RequestSecurityToken requestSecurityToken) throws AdminSecurityException {
        this.clientkey = null;
        this.serverchg = null;
        this.clientchg = null;
        this.sessionkey = null;
        this.hashpswd = null;
        this.userpswd = null;
        this.salt = null;
        RequestSecurityToken requestSecurityToken2 = requestSecurityToken;
        AdminCommonTools.CMN_Trace3("Security service: verifying authentication request...");
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        AdminPrincipal adminPrincipal = requestSecurityToken2.getAdminPrincipal();
        if (adminPrincipal != null) {
            string = adminPrincipal.getUserName();
            string2 = adminPrincipal.getDomainName();
            if (string != null) {
                try {
                    string3 = AdminServerLibrary.getEncryptedPassword(string);
                }
                catch (AdminException adminException) {
                    this.writeLog(2, "LM_1030", "LM_1031");
                    throw new AdminAuthenticationException(adminPrincipal.getName());
                }
                if (string3 == null || string3.trim().length() == 0) {
                    AdminCommonTools.CMN_Trace1("Security service: cannot access user password for " + adminPrincipal.getName());
                    this.writeLog(0, "LM_1000", "LM_1001", adminPrincipal.getName());
                    throw new AdminAuthenticationException(adminPrincipal.getName());
                }
                string4 = string3.substring(0, 2);
            } else {
                adminPrincipal = null;
            }
        }
        if (adminPrincipal == null) {
            this.writeLog(2, "LM_1030", "LM_1032");
            AdminCommonTools.CMN_Trace1("Security service: null or invalid admin principal identity");
            throw new AdminSecurityException("EXSS_BUI");
        }
        this.hashpswd = string3.getBytes();
        this.salt = string4.getBytes();
        AdminCommonTools.CMN_Trace3("   Client user identity=" + string);
        this.serverchg = new byte[16];
        DigestSecurityUtil.getRandomBytes(this.serverchg);
        PublicKey publicKey = DigestSecurityUtil.getPublicKey();
        AdminCommonTools.CMN_Trace3("   challenge=" + this.toHex(this.serverchg));
        AdminCommonTools.CMN_Trace3("   salt=" + string4);
        DigestResponseSecurityToken digestResponseSecurityToken = new DigestResponseSecurityToken(this.getSecurityId());
        digestResponseSecurityToken.setChallenge(this.serverchg);
        digestResponseSecurityToken.setPasswordSalt(this.salt);
        digestResponseSecurityToken.setServerKey(publicKey);
        this.setAdminPrincipal(adminPrincipal);
        this.setClientHost(requestSecurityToken2.getClientHost());
        this.setAuthState(2);
        return digestResponseSecurityToken;
    }

    public SecurityToken verifyAuthenticator(AuthenticatorSecurityToken authenticatorSecurityToken) throws AdminSecurityException {
        byte[] byArray;
        DigestAuthenticatorSecurityToken digestAuthenticatorSecurityToken = null;
        try {
            digestAuthenticatorSecurityToken = (DigestAuthenticatorSecurityToken)authenticatorSecurityToken;
        }
        catch (Exception exception) {
            this.writeLog(2, "LM_1030", "LM_1033");
            throw new AdminSecurityException("EXSS_BAT");
        }
        byte[] byArray2 = digestAuthenticatorSecurityToken.getMessageDigest();
        byte[] byArray3 = digestAuthenticatorSecurityToken.getAuthenticatorDigest();
        byte[] byArray4 = digestAuthenticatorSecurityToken.getSessionDigest();
        this.clientchg = digestAuthenticatorSecurityToken.getChallenge();
        this.clientkey = digestAuthenticatorSecurityToken.getClientKey();
        AdminCommonTools.CMN_Trace3("Security service:  verifying authenticator...");
        AdminCommonTools.CMN_Trace3("   msg  digest=" + this.toHex(byArray2));
        AdminCommonTools.CMN_Trace3("   auth digest=" + this.toHex(byArray3));
        AdminCommonTools.CMN_Trace3("   sess digest=" + this.toHex(byArray4));
        AdminCommonTools.CMN_Trace3("   client chal=" + this.toHex(this.clientchg));
        byte[] byArray5 = DigestSecurityUtil.generateDigest(this.serverchg, this.hashpswd, null);
        try {
            byArray = DigestSecurityUtil.decryptPassword(byArray5, byArray2);
        }
        catch (AdminException adminException) {
            AdminCommonTools.CMN_Trace3("   Authentication failed! (1)");
            this.clientkey = null;
            AdminPrincipal adminPrincipal = this.getAdminPrincipal();
            this.writeLog(0, "LM_1000", "LM_1002", adminPrincipal.getName());
            throw new AdminAuthenticationException(adminPrincipal.getName());
        }
        this.userpswd = AdminSecurityUtil.hashPassword(new String(byArray));
        try {
            this.sessionkey = DigestSecurityUtil.encryptDigest(byArray4, byArray5);
        }
        catch (AdminException adminException) {
            AdminCommonTools.CMN_Trace3("   Authentication failed! (2)");
            this.clientkey = null;
            this.userpswd = null;
            AdminPrincipal adminPrincipal = this.getAdminPrincipal();
            this.writeLog(0, "LM_1000", "LM_1016", adminPrincipal.getName());
            throw new AdminAuthenticationException(adminPrincipal.getName());
        }
        byte[] byArray6 = this.clientkey.getEncoded();
        if (byArray6 == null) {
            byArray6 = this.clientkey.toString().getBytes();
        }
        byArray5 = DigestSecurityUtil.generateDigest(byArray2, byArray6, byArray);
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = 0;
            ++n;
        }
        if (!DigestSecurityUtil.compareDigests(byArray3, byArray5)) {
            AdminCommonTools.CMN_Trace3("   Authentication failed! (3)");
            this.clientkey = null;
            this.userpswd = null;
            this.sessionkey = null;
            AdminPrincipal adminPrincipal = this.getAdminPrincipal();
            this.writeLog(0, "LM_1000", "LM_1003", adminPrincipal.getName());
            throw new AdminAuthenticationException(adminPrincipal.getName());
        }
        AdminCommonTools.CMN_Trace3("   Authenticator digest is verified!");
        byte[] byArray7 = "success".getBytes();
        byte[] byArray8 = DigestSecurityUtil.generateDigest(this.clientchg, this.hashpswd, byArray7);
        AdminCommonTools.CMN_Trace3("   result digest=" + this.toHex(byArray8));
        DigestConfirmSecurityToken digestConfirmSecurityToken = new DigestConfirmSecurityToken(this.getSecurityId());
        digestConfirmSecurityToken.setResultMessage("success");
        digestConfirmSecurityToken.setMessageDigest(byArray8);
        if (this.isIntegrityRequired()) {
            digestConfirmSecurityToken.setIntegrity();
        }
        this.setAuthState(4);
        return digestConfirmSecurityToken;
    }

    public void checkVerifier(VerifierSecurityToken verifierSecurityToken, Object[] objectArray) throws AdminSecurityException {
        DigestVerifierSecurityToken digestVerifierSecurityToken;
        try {
            digestVerifierSecurityToken = (DigestVerifierSecurityToken)verifierSecurityToken;
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("Security service: message verifier: client passed null digest!");
            throw new AdminSecurityException("EXSS_BVT");
        }
        byte[] byArray = null;
        if (this.isIntegrityRequired()) {
            byArray = objectArray != null && objectArray.length > 0 ? DigestSecurityUtil.generateDigest(objectArray) : this.serverchg;
            byte[] byArray2 = digestVerifierSecurityToken.getDigest();
            byte[] byArray3 = DigestSecurityUtil.encryptDigest(byArray2, this.sessionkey);
            if (byArray3 == null) {
                throw new AdminSecurityException("EXSS_BVD");
            }
            AdminCommonTools.CMN_Trace3("   server digest=" + this.toHex(byArray));
            AdminCommonTools.CMN_Trace3("   client digest=" + this.toHex(byArray3));
            if (!DigestSecurityUtil.compareDigests(byArray, byArray3)) {
                throw new AdminVerificationException();
            }
        }
    }

    public String decryptPassword(byte[] byArray) throws AdminSecurityException {
        byte[] byArray2;
        if (this.getAuthState() != 4) {
            throw new AdminSecurityException("EXSS_NAX", "encryptPassword");
        }
        byte[] byArray3 = DigestSecurityUtil.generateDigest(this.serverchg, this.hashpswd, null);
        try {
            byArray2 = DigestSecurityUtil.decryptPassword(byArray3, byArray);
        }
        catch (AdminException adminException) {
            throw new AdminSecurityException("EXSS_BEP");
        }
        String string = new String(byArray2);
        return string;
    }

    public ServerSecurityContext newCopy() throws AdminSecurityException {
        DigestServerSecurityContext digestServerSecurityContext = new DigestServerSecurityContext((DigestAuthFlavor)this.getAuthFlavor());
        super.copyAttrs(digestServerSecurityContext);
        digestServerSecurityContext.setClientKey(this.clientkey);
        digestServerSecurityContext.setServerChallenge(this.serverchg);
        digestServerSecurityContext.setClientChallenge(this.clientchg);
        digestServerSecurityContext.setPasswordHash(this.hashpswd);
        digestServerSecurityContext.setPasswordSalt(this.salt);
        digestServerSecurityContext.setUserPassword(this.userpswd);
        if (this.integrity) {
            digestServerSecurityContext.setIntegrity();
        }
        return digestServerSecurityContext;
    }

    public PublicKey getClientKey() {
        return this.clientkey;
    }

    public void setClientKey(PublicKey publicKey) {
        this.clientkey = publicKey;
    }

    public void setServerChallenge(byte[] byArray) {
        if (byArray != null) {
            this.serverchg = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.serverchg, 0, byArray.length);
            return;
        }
        this.serverchg = null;
    }

    public void setClientChallenge(byte[] byArray) {
        if (byArray != null) {
            this.clientchg = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.clientchg, 0, byArray.length);
            return;
        }
        this.clientchg = null;
    }

    public void setPasswordHash(byte[] byArray) {
        if (byArray != null) {
            this.hashpswd = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.hashpswd, 0, byArray.length);
            return;
        }
        this.hashpswd = null;
    }

    public void setPasswordSalt(byte[] byArray) {
        if (byArray != null) {
            this.salt = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.salt, 0, byArray.length);
            return;
        }
        this.salt = null;
    }

    public void setUserPassword(String string) {
        if (string != null) {
            this.userpswd = new String(string);
            return;
        }
        this.userpswd = null;
    }

    public boolean isIntegrityRequired() {
        return this.integrity & this.isVerify();
    }

    public void setIntegrity() {
        this.integrity = true;
    }

    private String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        if (byArray == null) {
            return "(null)";
        }
        if (byArray.length == 0) {
            return "(empty)";
        }
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(hex[byArray[n] >> 4 & 0xF]);
            stringBuffer.append(hex[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }
}

