/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.logging;

import com.sun.admin.cis.common.AdminMgmtScope;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class LogRecordHeader
implements Serializable {
    private int category = -1;
    private int severity = -1;
    private Date date;
    private String appName = "";
    private String eventId = "";
    private String userName = "";
    private String clientHostName = "";
    private String agentHostName = "";
    private String summaryMesgId = "";
    private String scope_string = "";
    private long recordId = -1L;
    private int hashCode = -1;

    public LogRecordHeader(String string, int n, int n2, String string2, String string3, String string4, String string5, String string6, AdminMgmtScope adminMgmtScope) {
        this.category = n;
        this.severity = n2;
        this.date = new Date();
        if (string != null) {
            this.appName = string;
            if (this.appName.toLowerCase().lastIndexOf("user") != -1) {
                this.appName = "LM_USER_APP_NAME";
            }
            if (this.appName.toLowerCase().lastIndexOf("host") != -1) {
                this.appName = "LM_HOST_APP_NAME";
            }
            if (this.appName.toLowerCase().lastIndexOf("fsmgr") != -1) {
                this.appName = "LM_FSMGR_APP_NAME";
            }
        }
        if (string3 != null) {
            this.eventId = string3;
        }
        if (string2 != null) {
            this.userName = string2;
        }
        if (string4 != null) {
            this.clientHostName = string4;
        }
        if (string5 != null) {
            this.agentHostName = string5;
        }
        if (string6 != null) {
            this.summaryMesgId = string6;
        }
        if (adminMgmtScope != null) {
            try {
                this.scope_string = adminMgmtScope.toDirectoryTableURL();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public LogRecordHeader() {
        this.date = new Date();
    }

    protected void setBasicInfo(String string, int n, int n2, String string2, String string3, String string4, String string5, String string6, AdminMgmtScope adminMgmtScope) {
        this.category = n;
        this.severity = n2;
        this.date = new Date();
        if (string != null) {
            this.appName = string;
            if (this.appName.toLowerCase().lastIndexOf("user") != -1) {
                this.appName = "LM_USER_APP_NAME";
            }
            if (this.appName.toLowerCase().lastIndexOf("host") != -1) {
                this.appName = "LM_HOST_APP_NAME";
            }
            if (this.appName.toLowerCase().lastIndexOf("fsmgr") != -1) {
                this.appName = "LM_FSMGR_APP_NAME";
            }
        }
        if (string2 != null) {
            this.eventId = string2;
        }
        if (string3 != null) {
            this.userName = string3;
        }
        if (string4 != null) {
            this.clientHostName = string4;
        }
        if (string5 != null) {
            this.agentHostName = string5;
        }
        if (string6 != null) {
            this.summaryMesgId = string6;
        }
        if (adminMgmtScope != null) {
            try {
                this.scope_string = adminMgmtScope.toDirectoryTableURL();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    protected void setCategory(int n) {
        this.category = n;
    }

    protected void setSeverity(int n) {
        this.severity = n;
    }

    protected void setEventId(String string) {
        if (string != null) {
            this.eventId = string;
        }
    }

    protected void setUserName(String string) {
        if (string != null) {
            this.userName = string;
        }
    }

    protected void setScope(AdminMgmtScope adminMgmtScope) {
        if (adminMgmtScope != null) {
            try {
                this.scope_string = adminMgmtScope.toDirectoryTableURL();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    protected void setAppName(String string) {
        if (string != null) {
            this.appName = string;
            if (this.appName.toLowerCase().lastIndexOf("user") != -1) {
                this.appName = "LM_USER_APP_NAME";
            }
            if (this.appName.toLowerCase().lastIndexOf("host") != -1) {
                this.appName = "LM_HOST_APP_NAME";
            }
            if (this.appName.toLowerCase().lastIndexOf("fsmgr") != -1) {
                this.appName = "LM_FSMGR_APP_NAME";
            }
        }
    }

    protected void setClientHostName(String string) {
        if (string != null) {
            this.clientHostName = string;
        }
    }

    protected void setAgentHostName(String string) {
        if (string != null) {
            this.agentHostName = string;
        }
    }

    protected void setSummaryMesgId(String string) {
        if (string != null) {
            this.summaryMesgId = string;
        }
    }

    protected void setDate(Date date) {
        if (date != null) {
            this.date = date;
        }
    }

    public int getCategory() {
        return this.category;
    }

    public String getCategoryString() {
        String string = "N/A";
        switch (this.category) {
            case -1: {
                string = LogRecordHeader.getPattern("LM_CAT_INV", null);
                break;
            }
            case 0: {
                string = LogRecordHeader.getPattern("LM_CAT_APP", null);
                break;
            }
            case 1: {
                string = LogRecordHeader.getPattern("LM_CAT_SEC", null);
                break;
            }
            case 2: {
                string = LogRecordHeader.getPattern("LM_CAT_SYS", null);
            }
        }
        return string;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getSeverityString() {
        String string = "N/A";
        switch (this.severity) {
            case -1: {
                string = LogRecordHeader.getPattern("LM_SEV_INV", null);
                break;
            }
            case 0: {
                string = LogRecordHeader.getPattern("LM_SEV_INF", null);
                break;
            }
            case 1: {
                string = LogRecordHeader.getPattern("LM_SEV_WAR", null);
                break;
            }
            case 2: {
                string = LogRecordHeader.getPattern("LM_SEV_ERR", null);
            }
        }
        return string;
    }

    public static String getSeverityString(int n) {
        String string = "N/A";
        switch (n) {
            case -1: {
                string = LogRecordHeader.getPattern("LM_SEV_INV", null);
                break;
            }
            case 0: {
                string = LogRecordHeader.getPattern("LM_SEV_INF", null);
                break;
            }
            case 1: {
                string = LogRecordHeader.getPattern("LM_SEV_WAR", null);
                break;
            }
            case 2: {
                string = LogRecordHeader.getPattern("LM_SEV_ERR", null);
            }
        }
        return string;
    }

    public Date getDate() {
        return this.date;
    }

    public String getDateString() {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(1);
        return simpleDateFormat.format(this.date);
    }

    public String getDateTimeString() {
        return DateFormat.getDateTimeInstance().format(this.date);
    }

    public String getTimeString() {
        return DateFormat.getTimeInstance().format(this.date);
    }

    public String getAppName() {
        return LogRecordHeader.getPattern(this.appName, null);
    }

    public String getAppKey() {
        return this.appName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getScopeString() {
        return this.scope_string;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getClientHostName() {
        return this.clientHostName;
    }

    public String getAgentHostName() {
        return this.agentHostName;
    }

    protected String getSummaryMesgId() {
        return this.summaryMesgId;
    }

    public String getSummaryMesg(boolean bl) {
        String string = "";
        Locale locale = bl ? Locale.getDefault() : new Locale("", "");
        string = LogRecordHeader.getPattern(this.summaryMesgId, locale);
        if (string != null) {
            return string;
        }
        return "";
    }

    public void setRecordId(long l) {
        this.recordId = l;
    }

    public void setHashCode(int n) {
        this.hashCode = n;
    }

    public long getRecordId() {
        return this.recordId;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public String toString() {
        String string = "    Category: " + this.getCategoryString() + "\n";
        string = String.valueOf(string) + "    Severity: " + this.getSeverityString() + "\n";
        string = String.valueOf(string) + "    EventId:  " + this.eventId + "\n";
        string = String.valueOf(string) + "    User:     " + this.userName + "\n";
        string = String.valueOf(string) + "    AppName:  " + LogRecordHeader.getPattern(this.appName, null) + "\n";
        string = String.valueOf(string) + "    Date:     " + this.getDateString() + "\n";
        string = String.valueOf(string) + "    Time:     " + this.getTimeString() + "\n";
        string = String.valueOf(string) + "    Client:   " + this.clientHostName + "\n";
        string = String.valueOf(string) + "    Agent:    " + this.agentHostName + "\n";
        string = String.valueOf(string) + "    Message:  " + this.getSummaryMesg(true) + "\n";
        return string;
    }

    private static String getPattern(String string, Locale locale) {
        PropertyResourceBundle propertyResourceBundle = null;
        String string2 = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String string3 = LogRecordHeader.getBundleName();
        try {
            propertyResourceBundle = (PropertyResourceBundle)ResourceBundle.getBundle(string3, locale);
            string2 = propertyResourceBundle.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    protected static String getBundleName() {
        return "com.sun.admin.cis.service.logging.resources.Messages";
    }
}

