/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.directorytable;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.AdminProps;
import com.sun.admin.cis.service.directorytable.DirectoryTableLibrary;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;

public class DirectoryUtility {
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_ISMASTER = "check";
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_PWDIR = "/etc";
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_ALIASES = "/etc/mail/aliases";
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_DIR = "/etc";
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_MAKEPATH = "/var/yp";
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_MAKEFILE = "Makefile";
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_UPDATESCHEDULE = "always";

    protected static int compareColumns(String string, String string2, int n) {
        if ((n & 8) == 8) {
            return string2.compareTo(string);
        }
        if ((n & 4) == 4) {
            int n2 = Integer.valueOf(string);
            int n3 = Integer.valueOf(string2);
            return n2 - n3;
        }
        if ((n & 2) == 2) {
            return DirectoryTableLibrary.addressCompare(string, string2);
        }
        return 0;
    }

    protected static String getDirectoryTableProperty(String string) throws AdminException {
        AdminProps adminProps = new AdminProps("admin.server.properties", "AdminServer.properties", 0);
        return adminProps.getAdminProp(string);
    }

    protected static Vector getDirectoryTablePropertyList(String string) throws AdminException {
        AdminProps adminProps = new AdminProps("admin.server.properties", "AdminServer.properties", 0);
        return adminProps.getAdminPropList(string);
    }

    protected static void setDirectoryTableProperty(String string, String string2) throws AdminException {
        AdminProps adminProps = new AdminProps("admin.server.properties", "AdminServer.properties", 1);
        adminProps.putAdminProp(string, string2);
        adminProps.saveAdminProps("Management Server Properties - Do Not Edit");
    }

    protected static String getContextProperty(String string, String string2) {
        int n = 0;
        int n2 = 0;
        if (string2.equals("serverName")) {
            String string3;
            try {
                string3 = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                string3 = new String("");
            }
            n2 = string.indexOf("/");
            if (n2 == -1) {
                n2 = string.length();
            }
            if (n2 > 0) {
                string3 = string.substring(n, n2);
            }
            return string3;
        }
        if (string2.equals("domainName")) {
            String string4 = new String("");
            n2 = string.indexOf("/");
            if (n2 == -1) {
                return string4;
            }
            if (n2 == string.length()) {
                return string4;
            }
            n = n2 + 1;
            if ((n2 = string.indexOf("/", n)) == -1) {
                n2 = string.length();
            }
            if (n2 - n > 0 && (string4 = string.substring(n, n2)).charAt(string4.length() - 1) == '.') {
                string4 = string4.substring(0, string4.length() - 1);
            }
            return string4;
        }
        String string5 = new String("");
        n2 = string.indexOf("/");
        if (n2 == -1) {
            return string5;
        }
        if (n2 == string.length()) {
            return string5;
        }
        n = n2 + 1;
        if ((n2 = string.indexOf("/", n)) == -1) {
            return string5;
        }
        String string6 = string.substring(n2 + 1, string.length());
        if (string6.length() > 0) {
            n = string6.indexOf(String.valueOf(string2) + " = ");
            if (n == -1) {
                return string5;
            }
            n2 = (string6 = string6.substring(n + string2.length() + 1, string6.length())).indexOf(", ");
            if (n2 == -1) {
                n2 = string6.length();
            }
            string5 = string6.substring(0, n2);
        }
        return string5;
    }

    protected static String getServerFromContext(String string) {
        String string2;
        int n = 0;
        int n2 = 0;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string2 = new String("");
        }
        n2 = string.indexOf("/");
        if (n2 == -1) {
            n2 = string.length();
        }
        if (n2 > 0) {
            string2 = string.substring(n, n2);
        }
        return string2;
    }

    protected static String getDomainFromContext(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = new String("");
        n2 = string.indexOf("/");
        if (n2 == -1) {
            return string2;
        }
        if (n2 == string.length()) {
            return string2;
        }
        n = n2 + 1;
        if ((n2 = string.indexOf("/", n)) == -1) {
            n2 = string.length();
        }
        if (n2 - n > 0) {
            string2 = string.substring(n, n2);
        }
        return string2;
    }

    protected static boolean isLocalServer(String string) {
        String string2 = null;
        InetAddress[] inetAddressArray = null;
        InetAddress inetAddress = null;
        Vector vector = DirectoryUtility.getListOfLocalHostnames();
        int n = 0;
        while (n < vector.size()) {
            String string3 = (String)vector.elementAt(n);
            if (string3.equals(string)) {
                return true;
            }
            ++n;
        }
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        try {
            inetAddressArray = InetAddress.getAllByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        int n2 = 0;
        while (n2 < inetAddressArray.length) {
            if (inetAddressArray[n2].equals(inetAddress)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static Vector getListOfLocalHostnames() {
        File file = new File("/etc");
        Vector<String> vector = new Vector<String>();
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].startsWith("hostname.")) {
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new FileReader("/etc/" + stringArray[n]));
                        String string = bufferedReader.readLine();
                        bufferedReader.close();
                        if (string != null) {
                            vector.addElement(string.trim());
                        }
                    }
                    catch (Exception exception) {}
                }
                ++n;
            }
        }
        return vector;
    }
}

