/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.client;

import com.sun.admin.cis.client.AddScopeDialog;
import com.sun.admin.cis.client.AdminClientComponent;
import com.sun.admin.cis.client.AdminContext;
import com.sun.admin.cis.client.AdminFrame;
import com.sun.admin.cis.client.AdminSession;
import com.sun.admin.cis.client.AppSplitPane;
import com.sun.admin.cis.client.IContext;
import com.sun.admin.cis.client.LogOnDialog;
import com.sun.admin.cis.client.MainToolBar;
import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ResourceStrings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class MainToolBar
extends JPanel {
    private MainToolBar mainToolBar;
    IContext adminContext;
    private JButton newWindowBtn;
    private JButton newScopeBtn;
    private JButton treePanelBtn;
    private JButton helpBtn;
    private ImageIcon helpIcon;
    private ImageIcon treeIcon;
    private Border defaultBorder;
    private Border bevelBorder = BorderFactory.createBevelBorder(1);

    public void openNav() {
        this.showAsDepressed(this.treePanelBtn);
    }

    public void closeNav() {
        this.showAsUnDepressed(this.treePanelBtn);
    }

    public void openHelp() {
        this.showAsDepressed(this.helpBtn);
    }

    public void closeHelp() {
        this.showAsUnDepressed(this.helpBtn);
    }

    public MainToolBar() {
        this.mainToolBar = this;
        this.adminContext = AdminContext.instance();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.mainToolBar.setLayout(gridBagLayout);
        this.newWindowBtn = new JButton(AdminFrame.instance().createImageIcon("newwindow.gif", "New Window"));
        this.setUpButton(this.newWindowBtn, ResourceStrings.getString("new_window"));
        Constraints.constrain(this.mainToolBar, this.newWindowBtn, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 2, 18, 2, 2);
        this.defaultBorder = this.newWindowBtn.getBorder();
        this.newScopeBtn = new JButton(AdminFrame.instance().createImageIcon("newscope.gif", "New Scope"));
        this.setUpButton(this.newScopeBtn, ResourceStrings.getString("new_scope"));
        Constraints.constrain(this.mainToolBar, this.newScopeBtn, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 2, 2, 2, 2);
        this.treeIcon = AdminFrame.instance().createImageIcon("opentree.gif", "Tree");
        this.treePanelBtn = new JButton(this.treeIcon);
        this.showAsDepressed(this.treePanelBtn);
        this.setUpButton(this.treePanelBtn, ResourceStrings.getString("hide_nav"));
        Constraints.constrain(this.mainToolBar, this.treePanelBtn, 2, 0, 1, 1, 0, 17, 0.0, 0.0, 2, 2, 2, 2);
        this.helpIcon = AdminFrame.instance().createImageIcon("openhelp.gif", "help");
        this.helpBtn = new JButton(this.helpIcon);
        this.showAsDepressed(this.helpBtn);
        this.setUpButton(this.helpBtn, ResourceStrings.getString("hide_help"));
        Constraints.constrain(this.mainToolBar, this.helpBtn, 3, 0, 1, 1, 0, 17, 0.0, 0.0, 2, 2, 2, 2);
        JPanel jPanel = new JPanel();
        Constraints.constrain(this.mainToolBar, jPanel, 4, 0, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
    }

    private void setUpButton(JButton jButton, String string) {
        jButton.setToolTipText(string);
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(new TBarBtnListener());
    }

    private void showAsDepressed(JButton jButton) {
        jButton.setBorder(this.bevelBorder);
    }

    private void showAsUnDepressed(JButton jButton) {
        jButton.setBorder(this.defaultBorder);
    }

    class TBarBtnListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JButton jButton = (JButton)actionEvent.getSource();
                ImageIcon imageIcon = (ImageIcon)jButton.getIcon();
                String string = imageIcon.getDescription();
                AdminCommonTools.CMN_HandleOutput("MainToolBar:TbarBtnListnener, iconTxt= " + string);
                if (string.compareTo("New Window") == 0) {
                    String string2 = System.getProperty("admin.client.script");
                    String string3 = AdminFrame.instance().getBinPath(string2);
                    AdminCommonTools.CMN_HandleOutput("Path to scriptPath = " + string3);
                    1 var7_12 = new 1(string3);
                    var7_12.start();
                } else if (string.compareTo("New Scope") == 0) {
                    AdminSession adminSession = AdminContext.instance().getAdminSession();
                    LogOnDialog logOnDialog = new LogOnDialog(AdminFrame.instance(), false, ResourceStrings.getString("change_scope"));
                    ((Component)logOnDialog).setVisible(true);
                    if (adminSession != AdminContext.instance().getAdminSession()) {
                        AdminFrame.instance().waitOn();
                        Vector vector = AdminContext.instance().getAdminClientComponents();
                        int n = 0;
                        while (n < vector.size()) {
                            ((AdminClientComponent)vector.elementAt(n)).appCloseDown();
                            ++n;
                        }
                        adminSession.close();
                        AppSplitPane appSplitPane = AppSplitPane.instance();
                        appSplitPane.doInitComponents();
                        AdminFrame.instance().loadClientApps();
                        AdminFrame.instance().updateTitle();
                        AdminFrame.instance().waitOff();
                    }
                } else if (string.compareTo("Modify Scope") == 0) {
                    AddScopeDialog addScopeDialog = new AddScopeDialog(AdminFrame.instance());
                    Dimension dimension = addScopeDialog.getPreferredSize();
                    Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                    ((Component)addScopeDialog).setLocation(dimension2.width / 2 - dimension.width / 2, dimension2.height / 2 - dimension.height / 2);
                    ((Component)addScopeDialog).setVisible(true);
                } else if (string.compareTo("Tree") == 0) {
                    if (jButton.getBorder() == MainToolBar.this.bevelBorder) {
                        MainToolBar.this.showAsUnDepressed(jButton);
                        AdminFrame.instance().mainMenuBar.closeNav();
                    } else {
                        MainToolBar.this.showAsDepressed(jButton);
                        AdminFrame.instance().mainMenuBar.openNav();
                    }
                } else if (string.compareTo("help") == 0) {
                    if (jButton.getBorder() == MainToolBar.this.bevelBorder) {
                        MainToolBar.this.showAsUnDepressed(jButton);
                        AdminFrame.instance().mainMenuBar.closeHelp();
                    } else {
                        MainToolBar.this.showAsDepressed(jButton);
                        AdminFrame.instance().mainMenuBar.openHelp();
                    }
                } else {
                    AdminCommonTools.CMN_HandleOutput("Button not handled");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            AdminCommonTools.CMN_HandleOutput("out of TBarBtnListnener");
        }

        TBarBtnListener() {
            MainToolBar.this = MainToolBar.this;
        }
    }

    class BtnMouseListener
    extends MouseAdapter {
        JButton jb;

        public void mouseEntered(MouseEvent mouseEvent) {
            this.jb = (JButton)mouseEvent.getComponent();
            if (this.jb.isEnabled()) {
                this.jb.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.jb = (JButton)mouseEvent.getComponent();
            this.jb.setBorderPainted(false);
        }

        BtnMouseListener() {
            MainToolBar.this = MainToolBar.this;
        }
    }
}

