/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.server;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.AdminMgmtScope;
import com.sun.admin.cis.common.FilterItem;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.service.directorytable.DirectoryFilter;
import com.sun.admin.cis.service.directorytable.DirectoryRow;
import com.sun.admin.cis.service.directorytable.DirectoryTable;
import com.sun.admin.cis.service.directorytable.DirectoryTableAccessException;
import com.sun.admin.cis.service.directorytable.DirectoryTableConnectionException;
import com.sun.admin.cis.service.directorytable.DirectoryTableDoesNotExistException;
import com.sun.admin.cis.service.directorytable.DirectoryTableException;
import com.sun.admin.cis.service.directorytable.DirectoryTableFactory;
import com.sun.admin.cis.service.directorytable.DirectoryTableInvalidParameterException;
import com.sun.admin.cis.service.directorytable.TableDefinitions;
import com.sun.admin.usermgr.common.GroupObj;
import com.sun.admin.usermgr.common.SolGroupAttr;
import com.sun.admin.usermgr.common.SolServerDirTableException;
import com.sun.admin.usermgr.common.SolServerException;
import com.sun.admin.usermgr.common.UserMgrIDAlreadyInUseException;
import com.sun.admin.usermgr.common.UserMgrNameAlreadyInUseException;
import com.sun.admin.usermgr.common.UserObj;
import java.util.StringTokenizer;
import java.util.Vector;

public class SolarisGroupTable {
    private String table = new String("group");
    private String emptyString = new String("");
    private String fileType = new String("File");
    private String nameCol = "name";
    private String passwdCol = "passwd";
    private String gidCol = "gid";
    private String memberCol = "members";
    private AdminMgmtScope scope;

    public SolarisGroupTable(AdminMgmtScope adminMgmtScope) {
        this.scope = adminMgmtScope;
    }

    public static String[] parseMembersIntoArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String formatMembersIntoString(String[] stringArray) {
        if (stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(",");
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private boolean isGroupMember(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if (string2 == "") {
            return false;
        }
        String[] stringArray = SolarisGroupTable.parseMembersIntoArray(string2);
        int n = 0;
        while (n < stringArray.length) {
            if (string.compareTo(stringArray[n]) == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private DirectoryTable openGroupTable() throws SolServerDirTableException, DirectoryTableException {
        try {
            DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
            directoryTable.open(this.table);
            return directoryTable;
        }
        catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
            throw new SolServerDirTableException("LM_2080");
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            throw new SolServerDirTableException("LM_2081");
        }
        catch (DirectoryTableConnectionException directoryTableConnectionException) {
            throw new SolServerDirTableException("LM_2084");
        }
    }

    public String translateNametoGID(String string) {
        try {
            DirectoryTable directoryTable = this.openGroupTable();
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), string);
            DirectoryRow directoryRow2 = directoryTable.getFirstRow(directoryRow);
            if (directoryRow2 == null) {
                return string;
            }
            String string2 = directoryRow2.getColumn(tableDefinitions.getColumnNumber(this.gidCol));
            directoryTable.close();
            return string2;
        }
        catch (Exception exception) {
            return string;
        }
    }

    public String translateGIDtoName(String string) {
        try {
            DirectoryTable directoryTable = this.openGroupTable();
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.gidCol), string);
            DirectoryRow directoryRow2 = directoryTable.getFirstRow(directoryRow);
            if (directoryRow2 == null) {
                return string;
            }
            String string2 = directoryRow2.getColumn(tableDefinitions.getColumnNumber(this.nameCol));
            directoryTable.close();
            return string2;
        }
        catch (Exception exception) {
            return string;
        }
    }

    public GroupObj getGroupRow(GroupObj groupObj) throws AdminException {
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openGroupTable();
        }
        catch (SolServerDirTableException solServerDirTableException) {
            throw solServerDirTableException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        try {
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), groupObj.getGroupName());
                directoryRow = directoryTable.getFirstRow(directoryRow);
                if (directoryRow == null) {
                    String[] stringArray = new String[]{""};
                    groupObj.setGroupUsers(stringArray);
                    groupObj.setGroupPassword("");
                    GroupObj groupObj2 = groupObj;
                    Object var5_11 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    return groupObj2;
                }
                groupObj.setGroupUsers(SolarisGroupTable.parseMembersIntoArray(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.memberCol))));
                groupObj.setGroupID(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.gidCol)));
                groupObj.setGroupPassword(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.passwdCol)));
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw new SolServerDirTableException("LM_2080");
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw new SolServerDirTableException("LM_2084");
            }
            catch (AdminException adminException) {
                throw adminException;
            }
        }
        catch (Throwable throwable) {
            Object var5_13 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        Object var5_12 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
        return groupObj;
    }

    public void addGroupRow(GroupObj groupObj) throws AdminException {
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openGroupTable();
        }
        catch (SolServerDirTableException solServerDirTableException) {
            throw solServerDirTableException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        try {
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.gidCol), groupObj.getGroupID());
                directoryRow = directoryTable.getFirstRow(directoryRow);
                if (directoryRow != null) {
                    AdminCommonTools.CMN_Trace1("Group " + groupObj.getGroupID() + " exists - can't create!");
                    throw new UserMgrIDAlreadyInUseException("EXM_SUS16", groupObj.getGroupID());
                }
                directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), groupObj.getGroupName());
                directoryRow = directoryTable.getFirstRow(directoryRow);
                if (directoryRow != null) {
                    AdminCommonTools.CMN_Trace1("Group " + groupObj.getGroupName() + " exists - can't create!");
                    throw new UserMgrNameAlreadyInUseException("EXM_SUS18", groupObj.getGroupName());
                }
                directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), groupObj.getGroupName());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.gidCol), groupObj.getGroupID());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.passwdCol), groupObj.getGroupPassword());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.memberCol), SolarisGroupTable.formatMembersIntoString(groupObj.getGroupUsers()));
                directoryTable.addRow(directoryRow);
            }
            catch (SolServerException solServerException) {
                throw solServerException;
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw new SolServerDirTableException("LM_2080");
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw new SolServerDirTableException("LM_2084");
            }
            catch (AdminException adminException) {
                throw adminException;
            }
            Object var4_11 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            return;
        }
        catch (Throwable throwable) {
            block14: {
                Object var4_12 = null;
                if (directoryTable == null) break block14;
                directoryTable.close();
            }
            throw throwable;
        }
    }

    public void modifyGroupRow(GroupObj groupObj) throws AdminException {
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openGroupTable();
        }
        catch (SolServerDirTableException solServerDirTableException) {
            throw solServerDirTableException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        try {
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.gidCol), groupObj.getGroupID());
                directoryRow = directoryTable.getFirstRow(directoryRow);
                if (directoryRow == null) {
                    this.addGroupRow(groupObj);
                    Object var4_11 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    return;
                }
                DirectoryRow directoryRow2 = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                String string = directoryRow.getColumn(tableDefinitions.getColumnNumber(this.nameCol));
                if (!string.equals(groupObj.getGroupName())) {
                    directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.nameCol), groupObj.getGroupName());
                    directoryRow2 = directoryTable.getFirstRow(directoryRow2);
                    if (directoryRow2 != null) {
                        AdminCommonTools.CMN_Trace1("Group " + groupObj.getGroupName() + " already exists!");
                        throw new UserMgrNameAlreadyInUseException("EXM_SUS18", groupObj.getGroupName());
                    }
                    directoryRow2 = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                }
                directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.memberCol), SolarisGroupTable.formatMembersIntoString(groupObj.getGroupUsers()));
                directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.nameCol), groupObj.getGroupName());
                directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.passwdCol), groupObj.getGroupPassword());
                directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.gidCol), groupObj.getGroupID());
                directoryTable.modifyRow(directoryRow, directoryRow2);
            }
            catch (SolServerException solServerException) {
                throw solServerException;
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw new SolServerDirTableException("LM_2080");
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw new SolServerDirTableException("LM_2084");
            }
            catch (AdminException adminException) {
                throw adminException;
            }
        }
        catch (Throwable throwable) {
            block18: {
                Object var4_13 = null;
                if (directoryTable == null) break block18;
                directoryTable.close();
            }
            throw throwable;
        }
        Object var4_12 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
    }

    public void deleteGroupRow(GroupObj groupObj) throws AdminException {
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openGroupTable();
        }
        catch (SolServerDirTableException solServerDirTableException) {
            throw solServerDirTableException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        try {
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), groupObj.getGroupName());
                directoryRow = directoryTable.getFirstRow(directoryRow);
                if (directoryRow == null) {
                    Object var4_10 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    return;
                }
                directoryTable.deleteRow(directoryRow);
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw new SolServerDirTableException("LM_2080");
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw new SolServerDirTableException("LM_2084");
            }
            catch (AdminException adminException) {
                throw adminException;
            }
        }
        catch (Throwable throwable) {
            block13: {
                Object var4_12 = null;
                if (directoryTable == null) break block13;
                directoryTable.close();
            }
            throw throwable;
        }
        Object var4_11 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
    }

    public Vector getAllGroupRows(ListProperties listProperties) throws AdminException {
        Vector<GroupObj> vector = new Vector<GroupObj>();
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openGroupTable();
        }
        catch (SolServerDirTableException solServerDirTableException) {
            throw solServerDirTableException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        try {
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                Vector vector2 = listProperties.getFilters();
                DirectoryFilter directoryFilter = new DirectoryFilter(vector2.size());
                int n = 0;
                while (n < vector2.size()) {
                    FilterItem filterItem = (FilterItem)vector2.elementAt(n);
                    String string = filterItem.getAttribute();
                    int n2 = 0;
                    if (string.equals("filter_group_name")) {
                        n2 = tableDefinitions.getColumnNumber(this.nameCol);
                    } else if (string.equals("filter_group_members")) {
                        n2 = tableDefinitions.getColumnNumber(this.memberCol);
                    } else if (string.equals("filter_group_id")) {
                        n2 = tableDefinitions.getColumnNumber(this.gidCol);
                    }
                    directoryFilter.add(n2, filterItem.getBooleanOperator(), filterItem.getOperator(), filterItem.getValue());
                    ++n;
                }
                directoryTable.getAll(directoryFilter);
                DirectoryRow directoryRow = directoryTable.getAll(directoryFilter);
                if (directoryRow == null) {
                    Vector<GroupObj> vector3 = vector;
                    Object var7_17 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    return vector3;
                }
                int n3 = 1;
                while (n3 <= directoryRow.getNumberOfRows()) {
                    GroupObj groupObj = new GroupObj(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.nameCol), n3));
                    groupObj.setGroupType("Solaris");
                    groupObj.setGroupID(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.gidCol), n3));
                    vector.addElement(groupObj);
                    ++n3;
                }
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw new SolServerDirTableException("LM_2080");
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw new SolServerDirTableException("LM_2084");
            }
            catch (AdminException adminException) {
                throw adminException;
            }
        }
        catch (Throwable throwable) {
            Object var7_19 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        Object var7_18 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
        return vector;
    }

    public Vector getAllGroupRows() throws AdminException {
        Vector<GroupObj> vector = new Vector<GroupObj>();
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openGroupTable();
        }
        catch (SolServerDirTableException solServerDirTableException) {
            throw solServerDirTableException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        try {
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = directoryTable.getAll();
                if (directoryRow == null) {
                    Vector<GroupObj> vector2 = vector;
                    Object var6_10 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    return vector2;
                }
                int n = 1;
                while (n <= directoryRow.getNumberOfRows()) {
                    GroupObj groupObj = new GroupObj(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.nameCol), n));
                    groupObj.setGroupType("Solaris");
                    groupObj.setGroupID(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.gidCol), n));
                    vector.addElement(groupObj);
                    ++n;
                }
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw new SolServerDirTableException("LM_2080");
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw new SolServerDirTableException("LM_2084");
            }
            catch (AdminException adminException) {
                throw adminException;
            }
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        Object var6_11 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
        return vector;
    }

    public String[] getAllSecondaryGroups(UserObj userObj) throws AdminException {
        Vector<String> vector = new Vector<String>();
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openGroupTable();
        }
        catch (SolServerDirTableException solServerDirTableException) {
            throw solServerDirTableException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getAll();
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                SolGroupAttr solGroupAttr = userObj.getSolGroupAttr();
                String string = "";
                if (solGroupAttr != null) {
                    string = solGroupAttr.getPrimaryGroup();
                }
                String string2 = "";
                int n = 1;
                while (n <= directoryRow.getNumberOfRows()) {
                    String string3 = directoryRow.getColumn(tableDefinitions.getColumnNumber(this.memberCol), n);
                    if (this.isGroupMember(userObj.getUserName(), string3) && (string2 = directoryRow.getColumn(tableDefinitions.getColumnNumber(this.nameCol), n)) != null && !string2.equals(string)) {
                        vector.addElement(string2);
                    }
                    ++n;
                }
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw new SolServerDirTableException("LM_2080");
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw new SolServerDirTableException("LM_2084");
            }
            catch (AdminException adminException) {
                throw adminException;
            }
            Object var5_17 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var5_18 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String getNextAvailableGID() throws AdminException {
        int n = 16;
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openGroupTable();
        }
        catch (SolServerDirTableException solServerDirTableException) {
            throw solServerDirTableException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
        int n2 = 0;
        boolean bl = false;
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getAll();
                directoryRow.sortByColumn(tableDefinitions.getColumnNumber(this.gidCol), tableDefinitions);
                int n3 = 1;
                while (n3 <= directoryRow.getNumberOfRows()) {
                    String string = directoryRow.getColumn(tableDefinitions.getColumnNumber(this.gidCol), n3);
                    if (string != null && string.trim().length() > 0 && (n2 = Integer.parseInt(string)) != 60001 && n2 != 60002 && n2 != 65534) {
                        if (n == n2) {
                            ++n;
                        } else if (n < n2) {
                            bl = true;
                        }
                    }
                    ++n3;
                }
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw new SolServerDirTableException("LM_2080");
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw new SolServerDirTableException("LM_2084");
            }
            catch (AdminException adminException) {
                throw adminException;
            }
            Object var8_13 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        return String.valueOf(n);
    }
}

