/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client;

import com.sun.admin.cis.client.AdminClientInfo;
import com.sun.admin.cis.client.AdminSession;
import com.sun.admin.cis.client.IClientComm;
import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.AdminMgmtScope;
import com.sun.admin.cis.common.AdminServerNotFoundException;
import com.sun.admin.cis.common.AdminUserContext;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.IConnection;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.PDCContext;
import com.sun.admin.cis.service.authorization.AuthAttrObj;
import com.sun.admin.cis.service.authorization.AuthNoAccessException;
import com.sun.admin.cis.service.authorization.UserAttrObj;
import com.sun.admin.cis.service.logging.LogRecord;
import com.sun.admin.cis.service.security.AdminAuthenticationException;
import com.sun.admin.cis.service.security.ClientSecurityContext;
import com.sun.admin.cis.service.security.SecurityToken;
import com.sun.admin.usermgr.client.AdminMainPanel;
import com.sun.admin.usermgr.common.EmailAliasObj;
import com.sun.admin.usermgr.common.GroupObj;
import com.sun.admin.usermgr.common.PDCPasswordAttr;
import com.sun.admin.usermgr.common.PartialSuccessObject;
import com.sun.admin.usermgr.common.SolHomedirAttr;
import com.sun.admin.usermgr.common.SolPasswordAttr;
import com.sun.admin.usermgr.common.SolServerException;
import com.sun.admin.usermgr.common.SolServerPartialSuccessException;
import com.sun.admin.usermgr.common.SolServicesAttr;
import com.sun.admin.usermgr.common.UserException;
import com.sun.admin.usermgr.common.UserMgrIDAlreadyInUseException;
import com.sun.admin.usermgr.common.UserMgrNameAlreadyInUseException;
import com.sun.admin.usermgr.common.UserObj;
import com.sun.admin.usermgr.server.UserMgrFactory;
import java.applet.Applet;
import java.rmi.RemoteException;
import java.util.Vector;

public class UserMgrClient
implements IConnection {
    private static UserMgrClient userMgrClient;
    static final String APP_NAME = "com.sun.admin.usermgr.server.UserMgrFactoryImpl";
    static final String PDC_APP_NAME = "com.sun.admin.usermgr.server.PDCUserMgrFactoryImpl";
    public PDCContext pdcContext;
    UserMgrFactory userMgrServer;
    AdminSession solarisSession;
    UserMgrFactory pdc_userMgrServer;
    static String pdcHostName;
    AdminSession pdcSession;
    private static String strUserName;
    private static String strPassword;
    private static String strServer;

    public boolean isApplet(Applet applet) {
        return applet != null;
    }

    public static UserMgrClient instance() {
        if (userMgrClient == null) {
            userMgrClient = new UserMgrClient();
        }
        return userMgrClient;
    }

    public void initUserMgrClient() {
        userMgrClient = null;
    }

    private UserMgrClient() {
    }

    public void setUpConnection(IClientComm iClientComm) throws Exception {
        this.solarisSession = iClientComm.getAdminSession();
        strUserName = new String(iClientComm.getUserName());
        strPassword = new String(iClientComm.getUserPassword());
        strServer = new String(iClientComm.getSolServerName());
        try {
            String string = APP_NAME;
            this.userMgrServer = (UserMgrFactory)this.solarisSession.getAppFactory(string);
            return;
        }
        catch (AdminException adminException) {
            AdminCommonTools.CMN_HandleOutput("Unable to get factory");
            throw adminException;
        }
    }

    public LogRecord initLogRecord(int n, String string, String string2, Vector vector) {
        LogRecord logRecord = new LogRecord("LM_USER_APP_NAME", 0, n, this.solarisSession.getUserName(), this.solarisSession.getClientHostName(), this.solarisSession.getServerHostName(), string, string2, vector, this.solarisSession.getMgmtScope());
        return logRecord;
    }

    public void writeLogRecord(LogRecord logRecord) throws AdminException {
        this.solarisSession.writeLogRecord(logRecord);
    }

    public void setPDCSession(AdminSession adminSession) {
        this.pdcSession = adminSession;
    }

    public void setPDCFactoryHandle(UserMgrFactory userMgrFactory) {
        this.pdc_userMgrServer = userMgrFactory;
    }

    public UserMgrFactory getPDCFactoryHandle() {
        return this.pdc_userMgrServer;
    }

    public void setPDCName(String string) {
        pdcHostName = new String(string);
    }

    public String getPDCName() {
        this.pdcContext = PDCContext.instance();
        pdcHostName = this.pdcContext.getPDCName();
        return pdcHostName;
    }

    public Vector getAllUsers(ListProperties listProperties) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        try {
            SecurityToken securityToken = this.solarisSession.getSecurityToken();
            vector = this.userMgrServer.getAllUsers(securityToken, listProperties);
            AdminCommonTools.CMN_HandleOutput("Number of Solaris users = " + vector.size());
            if (this.pdc_userMgrServer != null) {
                securityToken = this.pdcSession.getSecurityToken();
                vector2 = this.pdc_userMgrServer.getAllUsers(securityToken);
                AdminCommonTools.CMN_HandleOutput("Number of pdc users = " + vector2.size());
                this.checkForUsersInBothDomains(vector, vector2);
            }
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception" + exception.getLocalizedMessage());
        }
        return vector;
    }

    public Vector getAllUsers() {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        try {
            SecurityToken securityToken = this.solarisSession.getSecurityToken();
            vector = this.userMgrServer.getAllUsers(securityToken);
            AdminCommonTools.CMN_HandleOutput("Number of Solaris users = " + vector.size());
            if (this.pdc_userMgrServer != null) {
                securityToken = this.pdcSession.getSecurityToken();
                vector2 = this.pdc_userMgrServer.getAllUsers(securityToken);
                AdminCommonTools.CMN_HandleOutput("Number of pdc users = " + vector2.size());
                this.checkForUsersInBothDomains(vector, vector2);
            }
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception" + exception.getLocalizedMessage());
        }
        return vector;
    }

    public Vector getUserRights() throws AdminException {
        SecurityToken securityToken = null;
        Vector vector = null;
        try {
            securityToken = this.solarisSession.getSecurityToken();
            vector = this.userMgrServer.getUserRights(securityToken);
        }
        catch (RemoteException remoteException) {
            throw new UserException("EXM_SUS12");
        }
        catch (AdminException adminException) {
            throw new UserException("EXM_NO_USER_ADMIN_PRIV");
        }
        if (vector == null) {
            vector = new Vector(0);
        }
        return vector;
    }

    private Vector checkForUsersInBothDomains(Vector vector, Vector vector2) {
        String string = "";
        String string2 = "";
        UserObj userObj = null;
        UserObj userObj2 = null;
        int n = 0;
        while (n < vector2.size()) {
            userObj = (UserObj)vector2.elementAt(n);
            string = userObj.getUserName();
            string = string.trim();
            int n2 = 0;
            while (n2 < vector.size()) {
                userObj2 = (UserObj)vector.elementAt(n2);
                string2 = userObj2.getUserName();
                if (string.equals(string2 = string2.trim())) {
                    AdminCommonTools.CMN_HandleOutput("user  " + string + "  exists in NT and Unix");
                    userObj2.setUserType("Solaris and PC NetLink");
                    vector.setElementAt(userObj2, n2);
                }
                ++n2;
            }
            ++n;
        }
        return vector;
    }

    private boolean checkIfPDCUserExist(UserObj userObj) {
        String string = "";
        String string2 = "";
        UserObj userObj2 = null;
        boolean bl = false;
        Vector vector = new Vector();
        string2 = userObj.getUserName();
        try {
            if (this.pdc_userMgrServer != null) {
                SecurityToken securityToken = this.pdcSession.getSecurityToken();
                vector = this.pdc_userMgrServer.getAllUsers(securityToken);
                int n = 0;
                while (n < vector.size()) {
                    userObj2 = (UserObj)vector.elementAt(n);
                    string = userObj2.getUserName();
                    if ((string = string.trim()).equals(string2)) {
                        bl = true;
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception" + exception.getLocalizedMessage());
            AdminCommonTools.CMN_TraceStack(1, exception);
        }
        return bl;
    }

    public UserAttrObj getAdminUserAttr() throws AdminException {
        UserAttrObj userAttrObj = null;
        try {
            SecurityToken securityToken = this.solarisSession.getSecurityToken();
            userAttrObj = this.userMgrServer.getAdminUserAttr(securityToken);
        }
        catch (RemoteException remoteException) {
            throw new UserException("EXM_SUS12");
        }
        return userAttrObj;
    }

    public AuthAttrObj[] getAuthAttrList() throws AdminException {
        AuthAttrObj[] authAttrObjArray = null;
        try {
            SecurityToken securityToken = this.solarisSession.getSecurityToken();
            authAttrObjArray = this.userMgrServer.getAuthAttrList(securityToken);
        }
        catch (RemoteException remoteException) {
            throw new UserException("EXM_SUS11");
        }
        return authAttrObjArray;
    }

    public String getNextAvailableUID() {
        String string = "100";
        try {
            SecurityToken securityToken = this.solarisSession.getSecurityToken();
            string = this.userMgrServer.getNextAvailableUID(securityToken);
            AdminCommonTools.CMN_HandleOutput("Highest UID is: " + string);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception" + exception.getLocalizedMessage());
        }
        return string;
    }

    public String getNextAvailableGID() {
        String string = "15";
        try {
            SecurityToken securityToken = this.solarisSession.getSecurityToken();
            string = this.userMgrServer.getNextAvailableGID(securityToken);
            AdminCommonTools.CMN_HandleOutput("Highest GID is: " + string);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception" + exception.getLocalizedMessage());
        }
        return string;
    }

    public UserObj getFullAttributes(UserObj userObj) {
        UserObj userObj2 = new UserObj();
        try {
            Object object;
            Object object2;
            Object object3;
            SecurityToken securityToken = this.solarisSession.getSecurityToken();
            userObj2 = this.userMgrServer.getFullAttributes(securityToken, userObj);
            SolHomedirAttr solHomedirAttr = userObj2.getSolHomedirAttr();
            if (!AdminMgmtScope.compareServerHostNames(strServer, solHomedirAttr.getServer())) {
                AdminCommonTools.CMN_Trace2("UserMgrClient: connecting to home server: " + solHomedirAttr.getServer());
                object3 = null;
                try {
                    object2 = this.makeNewSession(strUserName, strPassword, solHomedirAttr.getServer());
                    ((AdminSession)object2).connect();
                    object3 = this.makeNewUserMgrFactory((AdminSession)object2, APP_NAME);
                    object = ((AdminSession)object2).getSecurityToken();
                    userObj2 = object3.getPermissions((SecurityToken)object, userObj2);
                    ((AdminSession)object2).close();
                }
                catch (Exception exception) {
                    solHomedirAttr.setModifyServer(true);
                    solHomedirAttr.setForceModify(true);
                    userObj2.setSolHomedirAttr(solHomedirAttr);
                }
            } else {
                userObj2 = this.userMgrServer.getPermissions(securityToken, userObj2);
            }
            if (!AdminMgmtScope.compareServerHostNames(strServer, ((SolServicesAttr)(object3 = userObj2.getSolServicesAttr())).getMailServer())) {
                AdminCommonTools.CMN_Trace2("UserMgrClient: connecting to mail server: " + ((SolServicesAttr)object3).getMailServer());
                object2 = null;
                try {
                    object = this.makeNewSession(strUserName, strPassword, ((SolServicesAttr)object3).getMailServer());
                    ((AdminSession)object).connect();
                    object2 = this.makeNewUserMgrFactory((AdminSession)object, APP_NAME);
                    ((AdminSession)object).close();
                }
                catch (Exception exception) {
                    ((SolServicesAttr)object3).setModifyMailServer(true);
                    ((SolServicesAttr)object3).setForceModify(true);
                    userObj2.setSolServicesAttr((SolServicesAttr)object3);
                }
            }
            if (this.pdc_userMgrServer != null && this.pdc_userMgrServer.userAccountExists(securityToken = this.pdcSession.getSecurityToken(), (UserObj)(object2 = new UserObj(userObj2.getUserName())))) {
                userObj2.setUserType("Solaris and PC NetLink");
            }
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception" + exception.getLocalizedMessage());
        }
        return userObj2;
    }

    public boolean verifyPDCUser(String string, String string2) {
        SecurityToken securityToken = null;
        boolean bl = false;
        Object[] objectArray = new Object[]{string};
        try {
            if (this.pdc_userMgrServer != null) {
                securityToken = this.pdcSession.getSecurityToken(objectArray);
            }
        }
        catch (AdminException adminException) {
            AdminCommonTools.CMN_HandleOutput("Error:  couldnt get security token for pdc user");
        }
        try {
            ClientSecurityContext clientSecurityContext = this.pdcSession.getSecurityContext();
            if (this.pdc_userMgrServer.isUserAnAdmin(securityToken, string, clientSecurityContext.encryptPassword(string2))) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
            new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, exception.getLocalizedMessage());
        }
        return bl;
    }

    public void addUser(UserObj userObj) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object[] objectArray = null;
        SecurityToken securityToken = null;
        SecurityToken securityToken2 = null;
        SecurityToken securityToken3 = null;
        Object[] objectArray2 = new Object[]{userObj};
        try {
            securityToken = this.solarisSession.getSecurityToken(objectArray2);
            if (this.pdc_userMgrServer != null) {
                securityToken2 = this.pdcSession.getSecurityToken(objectArray2);
                objectArray = new Object[]{this.pdcSession.getUserContext().getUserName()};
                securityToken3 = this.pdcSession.getSecurityToken(objectArray);
            }
        }
        catch (AdminException adminException) {
            AdminCommonTools.CMN_Trace1("addUser exception: " + adminException.getLocalizedMessage());
            throw adminException;
        }
        PartialSuccessObject partialSuccessObject = null;
        try {
            this.userMgrServer.addUser(securityToken, userObj);
        }
        catch (UserMgrIDAlreadyInUseException userMgrIDAlreadyInUseException) {
            AdminCommonTools.CMN_Trace3("duplicate uid - add failed");
            throw userMgrIDAlreadyInUseException;
        }
        catch (UserMgrNameAlreadyInUseException userMgrNameAlreadyInUseException) {
            AdminCommonTools.CMN_Trace3("duplicate user name - add failed");
            throw userMgrNameAlreadyInUseException;
        }
        catch (SolServerPartialSuccessException solServerPartialSuccessException) {
            AdminCommonTools.CMN_Trace1("addUser exception: " + solServerPartialSuccessException.getLocalizedMessage());
            partialSuccessObject = solServerPartialSuccessException.getPartialSuccessObject();
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("addUser exception: " + exception.getLocalizedMessage());
            throw exception;
        }
        SolHomedirAttr solHomedirAttr = userObj.getSolHomedirAttr();
        try {
            if (!AdminMgmtScope.compareServerHostNames(strServer, solHomedirAttr.getServer())) {
                AdminCommonTools.CMN_Trace2("UserMgrClient: connecting to home server: " + solHomedirAttr.getServer());
                object3 = null;
                object2 = null;
                object3 = this.makeNewSession(strUserName, strPassword, solHomedirAttr.getServer());
                ((AdminSession)object3).connect();
                object2 = this.makeNewUserMgrFactory((AdminSession)object3, APP_NAME);
                object = ((AdminSession)object3).getSecurityToken(objectArray2);
                object2.createHomeDir((SecurityToken)object, userObj);
                ((AdminSession)object3).close();
            } else {
                this.userMgrServer.createHomeDir(securityToken, userObj);
            }
        }
        catch (AdminServerNotFoundException adminServerNotFoundException) {
            AdminCommonTools.CMN_Trace1("addUser exception: " + adminServerNotFoundException.getLocalizedMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setHomedirFailed(true);
            partialSuccessObject.setHomedirException(new SolServerException("EXM_HDC", solHomedirAttr.getServer(), userObj.getUserName()));
        }
        catch (AdminAuthenticationException adminAuthenticationException) {
            AdminCommonTools.CMN_Trace1("addUser exception: " + adminAuthenticationException.getLocalizedMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setHomedirFailed(true);
            partialSuccessObject.setHomedirException(new SolServerException("EXM_HDAAF", userObj.getUserName(), solHomedirAttr.getServer()));
        }
        catch (AuthNoAccessException authNoAccessException) {
            AdminCommonTools.CMN_Trace1("addUser exception: " + authNoAccessException.getLocalizedMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setHomedirFailed(true);
            partialSuccessObject.setHomedirException(new SolServerException("EXM_HDA", solHomedirAttr.getServer()));
        }
        catch (SolServerException solServerException) {
            AdminCommonTools.CMN_Trace1("addUser exception: " + solServerException.getLocalizedMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setHomedirFailed(true);
            partialSuccessObject.setHomedirException(solServerException);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("addUser exception: " + exception.getLocalizedMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setHomedirFailed(true);
            partialSuccessObject.setHomedirException(exception);
        }
        object3 = userObj.getSolServicesAttr();
        try {
            if (!AdminMgmtScope.compareServerHostNames(strServer, ((SolServicesAttr)object3).getMailServer())) {
                AdminCommonTools.CMN_Trace2("UserMgrClient: connecting to mail server: " + ((SolServicesAttr)object3).getMailServer());
                object2 = null;
                object = null;
                object2 = this.makeNewSession(strUserName, strPassword, ((SolServicesAttr)object3).getMailServer());
                ((AdminSession)object2).connect();
                object = this.makeNewUserMgrFactory((AdminSession)object2, APP_NAME);
                SecurityToken securityToken4 = ((AdminSession)object2).getSecurityToken(objectArray2);
                object.createMailbox(securityToken4, userObj);
                ((AdminSession)object2).close();
            } else {
                this.userMgrServer.createMailbox(securityToken, userObj);
            }
        }
        catch (AdminServerNotFoundException adminServerNotFoundException) {
            AdminCommonTools.CMN_Trace1("addUser exception: " + adminServerNotFoundException.getLocalizedMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setMailboxFailed(true);
            partialSuccessObject.setMailboxException(new SolServerException("EXM_MBC", ((SolServicesAttr)object3).getMailServer()));
        }
        catch (AdminAuthenticationException adminAuthenticationException) {
            AdminCommonTools.CMN_Trace1("addUser exception: " + adminAuthenticationException.getLocalizedMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setMailboxFailed(true);
            partialSuccessObject.setMailboxException(new SolServerException("EXM_MBAAF", userObj.getUserName(), ((SolServicesAttr)object3).getMailServer()));
        }
        catch (AuthNoAccessException authNoAccessException) {
            AdminCommonTools.CMN_Trace1("addUser exception: " + authNoAccessException.getLocalizedMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setMailboxFailed(true);
            partialSuccessObject.setMailboxException(new SolServerException("EXM_MBA", ((SolServicesAttr)object3).getMailServer()));
        }
        catch (SolServerException solServerException) {
            AdminCommonTools.CMN_Trace1("addUser exception: " + solServerException.getLocalizedMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setMailboxFailed(true);
            partialSuccessObject.setMailboxException(solServerException);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("addUser exception: " + exception.getLocalizedMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setMailboxFailed(true);
            partialSuccessObject.setMailboxException(exception);
        }
        try {
            if (this.pdc_userMgrServer != null && !userObj.getUserType().equals("Solaris")) {
                object2 = this.pdcSession.getSecurityContext();
                userObj.setUserType("Solaris and PC NetLink");
                if (this.pdc_userMgrServer.isUserAnAdmin(securityToken3, this.pdcSession.getUserContext().getUserName(), ((ClientSecurityContext)object2).encryptPassword(this.pdcSession.getUserContext().getUserPassword()))) {
                    this.pdc_userMgrServer.addUser(securityToken2, userObj);
                }
            }
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("addUser exception: " + exception.getLocalizedMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setPdcFailed(true);
            partialSuccessObject.setPdcException(exception);
        }
        object2 = new Vector(1);
        ((Vector)object2).addElement(userObj.getUserName());
        if (partialSuccessObject != null) {
            object = this.initLogRecord(0, "LM_2024", "LM_2059", (Vector)object2);
            try {
                this.writeLogRecord((LogRecord)object);
            }
            catch (Exception exception) {}
            throw new SolServerPartialSuccessException("EXM_SUS64", partialSuccessObject);
        }
        object = this.initLogRecord(0, "LM_2000", "LM_2050", (Vector)object2);
        try {
            this.writeLogRecord((LogRecord)object);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void deleteUser(UserObj userObj) throws Exception {
        SecurityToken securityToken = null;
        SecurityToken securityToken2 = null;
        Object[] objectArray = new Object[]{userObj};
        securityToken = this.solarisSession.getSecurityToken(objectArray);
        if (this.pdc_userMgrServer != null) {
            securityToken2 = this.pdcSession.getSecurityToken(objectArray);
        }
        try {
            this.userMgrServer.deleteUser(securityToken, userObj);
            if (this.pdc_userMgrServer != null) {
                this.pdc_userMgrServer.deleteUser(securityToken2, userObj);
                return;
            }
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("deleteUser exception" + exception.getLocalizedMessage());
            throw exception;
        }
    }

    public UserObj setUpPassword(String string, UserObj userObj) {
        try {
            ClientSecurityContext clientSecurityContext = this.solarisSession.getSecurityContext();
            SolPasswordAttr solPasswordAttr = userObj.getSolPasswordAttr();
            if (string == null || string.length() == 0) {
                solPasswordAttr.setPasswd(null);
            } else {
                solPasswordAttr.setPasswd(clientSecurityContext.encryptPassword(string));
            }
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception" + exception.getLocalizedMessage());
        }
        return userObj;
    }

    public UserObj setUpPDCPassword(String string, UserObj userObj) {
        try {
            if (this.pdc_userMgrServer != null) {
                PDCPasswordAttr pDCPasswordAttr = userObj.getPDCPasswordAttr();
                if (pDCPasswordAttr == null) {
                    pDCPasswordAttr = new PDCPasswordAttr();
                }
                if (string.equals("") || string == null) {
                    pDCPasswordAttr.setPWDRequired(false);
                } else {
                    ClientSecurityContext clientSecurityContext = this.pdcSession.getSecurityContext();
                    pDCPasswordAttr.setPWDRequired(true);
                    pDCPasswordAttr.setUserPassword(clientSecurityContext.encryptPassword(string));
                }
                userObj.setPDCPasswordAttr(pDCPasswordAttr);
            }
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception" + exception.getLocalizedMessage());
            AdminCommonTools.CMN_TraceStack(1, exception);
        }
        return userObj;
    }

    public UserObj modifyUser(UserObj userObj, UserObj userObj2) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object[] objectArray = null;
        SecurityToken securityToken = null;
        SecurityToken securityToken2 = null;
        SecurityToken securityToken3 = null;
        Object[] objectArray2 = new Object[]{userObj, userObj2};
        securityToken = this.solarisSession.getSecurityToken(objectArray2);
        if (this.pdc_userMgrServer != null) {
            securityToken2 = this.pdcSession.getSecurityToken(objectArray2);
            objectArray = new Object[]{this.pdcSession.getUserContext().getUserName()};
            securityToken3 = this.pdcSession.getSecurityToken(objectArray);
        }
        UserObj userObj3 = new UserObj();
        PartialSuccessObject partialSuccessObject = null;
        try {
            userObj3 = this.userMgrServer.modifyUser(securityToken, userObj, userObj2);
        }
        catch (UserMgrNameAlreadyInUseException userMgrNameAlreadyInUseException) {
            AdminCommonTools.CMN_Trace3("duplicate user name - modify failed");
            throw userMgrNameAlreadyInUseException;
        }
        catch (SolServerPartialSuccessException solServerPartialSuccessException) {
            AdminCommonTools.CMN_Trace1("modifyUser exception: " + solServerPartialSuccessException.getLocalizedMessage());
            partialSuccessObject = solServerPartialSuccessException.getPartialSuccessObject();
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("modifyUser exception: " + exception.getLocalizedMessage());
            throw exception;
        }
        SolHomedirAttr solHomedirAttr = userObj.getSolHomedirAttr();
        try {
            if (solHomedirAttr.requireModify() || !solHomedirAttr.equals(userObj2.getSolHomedirAttr())) {
                if (!AdminMgmtScope.compareServerHostNames(strServer, solHomedirAttr.getServer())) {
                    AdminCommonTools.CMN_Trace2("UserMgrClient: connecting to home server: " + solHomedirAttr.getServer());
                    object4 = this.makeNewSession(strUserName, strPassword, solHomedirAttr.getServer());
                    ((AdminSession)object4).connect();
                    object3 = this.makeNewUserMgrFactory((AdminSession)object4, APP_NAME);
                    object2 = ((AdminSession)object4).getSecurityToken(objectArray2);
                    userObj3 = object3.modifyHomeDir((SecurityToken)object2, userObj, userObj2);
                    ((AdminSession)object4).close();
                } else {
                    userObj3 = this.userMgrServer.modifyHomeDir(securityToken, userObj, userObj2);
                }
            }
        }
        catch (AdminServerNotFoundException adminServerNotFoundException) {
            AdminCommonTools.CMN_Trace1("modifyUser exception: " + adminServerNotFoundException.getLocalizedMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setHomedirFailed(true);
            partialSuccessObject.setHomedirException(new SolServerException("EXM_HDMC", solHomedirAttr.getServer()));
        }
        catch (AdminAuthenticationException adminAuthenticationException) {
            AdminCommonTools.CMN_Trace1("modifyUser exception: " + adminAuthenticationException.getLocalizedMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setHomedirFailed(true);
            partialSuccessObject.setHomedirException(new SolServerException("EXM_HDMAF", userObj.getUserName(), solHomedirAttr.getServer()));
        }
        catch (AuthNoAccessException authNoAccessException) {
            AdminCommonTools.CMN_Trace1("modifyUser exception: " + authNoAccessException.getLocalizedMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setHomedirFailed(true);
            partialSuccessObject.setHomedirException(new SolServerException("EXM_HDMA", solHomedirAttr.getServer()));
        }
        catch (SolServerException solServerException) {
            AdminCommonTools.CMN_Trace1("modifyUser exception: " + solServerException.getLocalizedMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setHomedirFailed(true);
            partialSuccessObject.setHomedirException(solServerException);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("modifyUser exception: " + exception.getLocalizedMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setHomedirFailed(true);
            partialSuccessObject.setHomedirException(exception);
        }
        object4 = userObj.getUserName();
        object3 = userObj.getSolServicesAttr();
        try {
            if (((SolServicesAttr)object3).requireModify() || !((String)object4).equals(userObj2.getUserName())) {
                if (!AdminMgmtScope.compareServerHostNames(strServer, ((SolServicesAttr)object3).getMailServer())) {
                    AdminCommonTools.CMN_Trace2("UserMgrClient: connecting to mail server: " + ((SolServicesAttr)object3).getMailServer());
                    object2 = this.makeNewSession(strUserName, strPassword, ((SolServicesAttr)object3).getMailServer());
                    ((AdminSession)object2).connect();
                    object = this.makeNewUserMgrFactory((AdminSession)object2, APP_NAME);
                    SecurityToken securityToken4 = ((AdminSession)object2).getSecurityToken(objectArray2);
                    userObj3 = object.modifyMailbox(securityToken4, userObj, userObj2);
                    ((AdminSession)object2).close();
                } else {
                    userObj3 = this.userMgrServer.modifyMailbox(securityToken, userObj, userObj2);
                }
            }
        }
        catch (AdminServerNotFoundException adminServerNotFoundException) {
            AdminCommonTools.CMN_Trace1("modifyUser exception: " + adminServerNotFoundException.getLocalizedMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setMailboxFailed(true);
            partialSuccessObject.setHomedirException(new SolServerException("EXM_MBMC", ((SolServicesAttr)object3).getMailServer()));
        }
        catch (AdminAuthenticationException adminAuthenticationException) {
            AdminCommonTools.CMN_Trace1("modifyUser exception: " + adminAuthenticationException.getLocalizedMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setMailboxFailed(true);
            partialSuccessObject.setMailboxException(new SolServerException("EXM_MBMAF", userObj.getUserName(), ((SolServicesAttr)object3).getMailServer()));
        }
        catch (AuthNoAccessException authNoAccessException) {
            AdminCommonTools.CMN_Trace1("modifyUser exception: " + authNoAccessException.getLocalizedMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setMailboxFailed(true);
            partialSuccessObject.setHomedirException(new SolServerException("EXM_MBMA", ((SolServicesAttr)object3).getMailServer()));
        }
        catch (SolServerException solServerException) {
            AdminCommonTools.CMN_Trace1("modifyUser exception: " + solServerException.getLocalizedMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setMailboxFailed(true);
            partialSuccessObject.setMailboxException(solServerException);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("modifyUser exception: " + exception.getMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setMailboxFailed(true);
            partialSuccessObject.setMailboxException(exception);
        }
        try {
            if (this.pdc_userMgrServer != null && this.checkIfPDCUserExist(userObj2)) {
                object2 = this.pdcSession.getSecurityContext();
                userObj.setUserType("Solaris and PC NetLink");
                if (this.pdc_userMgrServer.isUserAnAdmin(securityToken3, this.pdcSession.getUserContext().getUserName(), ((ClientSecurityContext)object2).encryptPassword(this.pdcSession.getUserContext().getUserPassword()))) {
                    userObj = this.pdc_userMgrServer.modifyUser(securityToken2, userObj, userObj2);
                }
                userObj3.setUserType("Solaris and PC NetLink");
            }
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception" + exception.getLocalizedMessage());
            if (partialSuccessObject == null) {
                partialSuccessObject = new PartialSuccessObject();
            }
            partialSuccessObject.setPdcFailed(true);
            partialSuccessObject.setPdcException(exception);
        }
        object2 = new Vector<String>(1);
        ((Vector)object2).addElement(userObj.getUserName());
        if (partialSuccessObject != null) {
            object = this.initLogRecord(0, "LM_2025", "LM_2060", (Vector)object2);
            try {
                this.writeLogRecord((LogRecord)object);
            }
            catch (Exception exception) {}
            throw new SolServerPartialSuccessException("EXM_SUS65", partialSuccessObject);
        }
        object = this.initLogRecord(0, "LM_2004", "LM_2061", (Vector)object2);
        try {
            this.writeLogRecord((LogRecord)object);
        }
        catch (Exception exception) {}
        return userObj3;
    }

    public Vector getAllGroups(ListProperties listProperties) {
        Vector vector = new Vector();
        try {
            SecurityToken securityToken = this.solarisSession.getSecurityToken();
            vector = this.userMgrServer.getAllGroups(securityToken, listProperties);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception" + exception.getLocalizedMessage());
        }
        return vector;
    }

    public Vector getAllGroups() {
        Vector vector = new Vector();
        try {
            SecurityToken securityToken = this.solarisSession.getSecurityToken();
            vector = this.userMgrServer.getAllGroups(securityToken);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception" + exception.getLocalizedMessage());
        }
        return vector;
    }

    public GroupObj getGroupAttributes(GroupObj groupObj) {
        GroupObj groupObj2 = new GroupObj();
        try {
            SecurityToken securityToken = this.solarisSession.getSecurityToken();
            groupObj2 = this.userMgrServer.getGroupAttributes(securityToken, groupObj);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception" + exception.getLocalizedMessage());
        }
        return groupObj2;
    }

    public void addGroup(GroupObj groupObj) throws Exception {
        Object[] objectArray = null;
        if (this.solarisSession.isVerify()) {
            objectArray = new Object[]{groupObj};
        }
        try {
            SecurityToken securityToken = this.solarisSession.getSecurityToken(objectArray);
            this.userMgrServer.addGroup(securityToken, groupObj);
            return;
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception" + exception.getLocalizedMessage());
            throw exception;
        }
    }

    public void deleteGroup(GroupObj groupObj) throws Exception {
        Object[] objectArray = null;
        if (this.solarisSession.isVerify()) {
            objectArray = new Object[]{groupObj};
        }
        try {
            SecurityToken securityToken = this.solarisSession.getSecurityToken(objectArray);
            this.userMgrServer.deleteGroup(securityToken, groupObj);
            return;
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception: " + exception.getLocalizedMessage());
            throw exception;
        }
    }

    public GroupObj modifyGroup(GroupObj groupObj, GroupObj groupObj2) throws Exception {
        GroupObj groupObj3 = new GroupObj();
        Object[] objectArray = null;
        if (this.solarisSession.isVerify()) {
            objectArray = new Object[]{groupObj, groupObj2};
        }
        try {
            SecurityToken securityToken = this.solarisSession.getSecurityToken(objectArray);
            groupObj3 = this.userMgrServer.modifyGroup(securityToken, groupObj, groupObj2);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception: " + exception.getLocalizedMessage());
            throw exception;
        }
        return groupObj3;
    }

    public GroupObj addUsersToGroup(GroupObj groupObj, String[] stringArray) {
        GroupObj groupObj2 = new GroupObj();
        Object[] objectArray = null;
        if (this.solarisSession.isVerify()) {
            objectArray = new Object[]{groupObj, stringArray};
        }
        try {
            SecurityToken securityToken = this.solarisSession.getSecurityToken(objectArray);
            groupObj2 = this.userMgrServer.addUsersToGroup(securityToken, groupObj, stringArray);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception: " + exception.getLocalizedMessage());
        }
        return groupObj2;
    }

    public GroupObj deleteUsersFromGroup(GroupObj groupObj, String[] stringArray) {
        GroupObj groupObj2 = new GroupObj();
        Object[] objectArray = null;
        if (this.solarisSession.isVerify()) {
            objectArray = new Object[2];
            objectArray[0] = groupObj;
            objectArray[2] = stringArray;
        }
        try {
            SecurityToken securityToken = this.solarisSession.getSecurityToken(objectArray);
            groupObj2 = this.userMgrServer.deleteUsersFromGroup(securityToken, groupObj, stringArray);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception: " + exception.getLocalizedMessage());
        }
        return groupObj2;
    }

    public Vector getAllEmailAliases() throws Exception {
        Vector vector = new Vector();
        try {
            SecurityToken securityToken = this.solarisSession.getSecurityToken();
            vector = this.userMgrServer.getAllEmailAliases(securityToken);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception" + exception.getLocalizedMessage());
            throw exception;
        }
        return vector;
    }

    public Vector getAllEmailAliases(ListProperties listProperties) throws Exception {
        Vector vector = new Vector();
        try {
            SecurityToken securityToken = this.solarisSession.getSecurityToken();
            vector = this.userMgrServer.getAllEmailAliases(securityToken, listProperties);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception" + exception.getLocalizedMessage());
            throw exception;
        }
        return vector;
    }

    public EmailAliasObj getEmailAliasAttributes(EmailAliasObj emailAliasObj) throws Exception {
        EmailAliasObj emailAliasObj2 = new EmailAliasObj();
        try {
            SecurityToken securityToken = this.solarisSession.getSecurityToken();
            emailAliasObj2 = this.userMgrServer.getEmailAliasAttributes(securityToken, emailAliasObj);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception" + exception.getLocalizedMessage());
            throw exception;
        }
        return emailAliasObj2;
    }

    public void addEmailAlias(EmailAliasObj emailAliasObj) throws Exception {
        SecurityToken securityToken = null;
        Object[] objectArray = new Object[]{emailAliasObj};
        securityToken = this.solarisSession.getSecurityToken(objectArray);
        try {
            this.userMgrServer.addEmailAlias(securityToken, emailAliasObj);
            return;
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception" + exception.getLocalizedMessage());
            throw exception;
        }
    }

    public void deleteEmailAlias(EmailAliasObj emailAliasObj) throws Exception {
        Object[] objectArray = null;
        SecurityToken securityToken = null;
        if (this.solarisSession.isVerify()) {
            objectArray = new Object[]{emailAliasObj};
        }
        securityToken = this.solarisSession.getSecurityToken(objectArray);
        try {
            this.userMgrServer.deleteEmailAlias(securityToken, emailAliasObj);
            return;
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception" + exception.getLocalizedMessage());
            throw exception;
        }
    }

    public EmailAliasObj modifyEmailAlias(EmailAliasObj emailAliasObj, EmailAliasObj emailAliasObj2) throws Exception {
        Object[] objectArray = null;
        SecurityToken securityToken = null;
        if (this.solarisSession.isVerify()) {
            objectArray = new Object[]{emailAliasObj, emailAliasObj2};
        }
        securityToken = this.solarisSession.getSecurityToken(objectArray);
        EmailAliasObj emailAliasObj3 = new EmailAliasObj();
        try {
            emailAliasObj3 = this.userMgrServer.modifyEmailAlias(securityToken, emailAliasObj, emailAliasObj2);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("UserMgrClient exception" + exception.getLocalizedMessage());
            AdminCommonTools.CMN_TraceStack(1, exception);
            throw exception;
        }
        return emailAliasObj3;
    }

    public AdminSession makeNewSession(String string, String string2, String string3) throws Exception {
        AdminClientInfo adminClientInfo = null;
        AdminUserContext adminUserContext = null;
        AdminMgmtScope adminMgmtScope = null;
        AdminSession adminSession = null;
        string3 = string3.trim();
        try {
            adminClientInfo = new AdminClientInfo(null);
            adminMgmtScope = new AdminMgmtScope("file", string3, string3, string3);
            adminUserContext = new AdminUserContext(0, string, string2);
            adminSession = new AdminSession(adminClientInfo, adminUserContext, adminMgmtScope);
        }
        catch (AdminException adminException) {
            AdminCommonTools.CMN_HandleOutput("Unable to authenticate with " + string3);
        }
        return adminSession;
    }

    public UserMgrFactory makeNewUserMgrFactory(AdminSession adminSession, String string) throws Exception {
        UserMgrFactory userMgrFactory = null;
        try {
            userMgrFactory = (UserMgrFactory)adminSession.getAppFactory(string);
        }
        catch (AdminException adminException) {
            AdminCommonTools.CMN_HandleOutput("in makeNewUserMgrFactory() cant get pdc factory ");
        }
        return userMgrFactory;
    }

    static {
        pdcHostName = null;
        strUserName = "";
        strPassword = "";
        strServer = "";
    }
}

