/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FindDialog;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.usermgr.client.AdminMainPanel;
import com.sun.admin.usermgr.client.AdminMultiUserWiz;
import com.sun.admin.usermgr.client.AdminUserIconPane;
import com.sun.admin.usermgr.client.AdminUserTable;
import com.sun.admin.usermgr.client.AdminUserWizard;
import com.sun.admin.usermgr.client.AdminViews;
import com.sun.admin.usermgr.client.ConfActionListener;
import com.sun.admin.usermgr.client.ConfDelUserPanel;
import com.sun.admin.usermgr.client.FilterObj;
import com.sun.admin.usermgr.client.FindNextActionListener;
import com.sun.admin.usermgr.client.FindObj;
import com.sun.admin.usermgr.client.IChangeView;
import com.sun.admin.usermgr.client.IEnableState;
import com.sun.admin.usermgr.client.UserMgrClient;
import com.sun.admin.usermgr.common.UMgrResourceStrings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class UMgrUserTBar
extends JPanel
implements IEnableState,
IChangeView {
    private JButton deleteBtn;
    private JButton refreshBtn;
    private JButton findBtn;
    private JButton filterBtn;
    private JButton addUserBtn;
    private JButton addMultiUsersBtn;
    private JButton iconViewBtn;
    private JButton detailViewBtn;
    private JButton copyBtn;
    private ImageIcon detailOpen;
    private ImageIcon detailClose;
    private ImageIcon iconViewOpen;
    private ImageIcon iconViewClose;
    private Border defaultBorder;
    private Border bevelBorder = BorderFactory.createBevelBorder(1);

    public void setEnableState() {
        try {
            Vector vector = UserMgrClient.instance().getUserRights();
            if (vector.contains("solaris.admin.usermgr.write")) {
                if (AdminViews.instance().getSelectedNodeNames().size() == 0) {
                    this.deleteBtn.setEnabled(false);
                    this.copyBtn.setEnabled(false);
                    return;
                }
                this.deleteBtn.setEnabled(true);
                this.copyBtn.setEnabled(true);
                return;
            }
            this.deleteBtn.setEnabled(false);
            this.copyBtn.setEnabled(false);
            this.addUserBtn.setEnabled(false);
            this.addMultiUsersBtn.setEnabled(false);
            return;
        }
        catch (Exception exception) {
            new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, exception.getLocalizedMessage());
            return;
        }
    }

    public void changeViewState() {
        if (AdminMainPanel.sharedInstance().getActiveComponent() instanceof AdminUserIconPane) {
            this.iconViewBtn.setBorder(this.bevelBorder);
            this.detailViewBtn.setBorder(this.defaultBorder);
            this.invalidate();
            this.validate();
            this.repaint();
        }
        if (AdminMainPanel.sharedInstance().getActiveComponent() instanceof AdminUserTable) {
            this.iconViewBtn.setBorder(this.defaultBorder);
            this.detailViewBtn.setBorder(this.bevelBorder);
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    private void setUpButton(JButton jButton, String string) {
        jButton.setToolTipText(string);
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(new TBarBtnListener());
    }

    public UMgrUserTBar() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.addUserBtn = new JButton(AdminMainPanel.sharedInstance().createImageIcon("toolbar_new_user.gif", "Add User"));
        this.setUpButton(this.addUserBtn, UMgrResourceStrings.getString("tbar_adduser"));
        this.defaultBorder = this.addUserBtn.getBorder();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 11, 3, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.addUserBtn, gridBagConstraints, -1);
        this.addMultiUsersBtn = new JButton(AdminMainPanel.sharedInstance().createImageIcon("add_multiple_users_temp.gif", "Add Multple Users"));
        this.setUpButton(this.addMultiUsersBtn, UMgrResourceStrings.getString("tbar_addmulti"));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(2, 2, 3, 0);
        this.add(this.addMultiUsersBtn, gridBagConstraints, -1);
        this.findBtn = new JButton(AdminMainPanel.sharedInstance().createImageIcon("toolbar_find.gif", "Find"));
        this.setUpButton(this.findBtn, UMgrResourceStrings.getString("tbar_find"));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(2, 11, 3, 0);
        this.add(this.findBtn, gridBagConstraints, -1);
        this.filterBtn = new JButton(AdminMainPanel.sharedInstance().createImageIcon("toolbar_filter.gif", "Filter"));
        this.setUpButton(this.filterBtn, UMgrResourceStrings.getString("tbar_filter"));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(2, 2, 3, 0);
        this.add(this.filterBtn, gridBagConstraints, -1);
        this.copyBtn = new JButton(AdminMainPanel.sharedInstance().createImageIcon("copy_temp.gif", "Copy"));
        this.setUpButton(this.copyBtn, UMgrResourceStrings.getString("tbar_copy"));
        gridBagConstraints.gridx = 4;
        gridBagConstraints.insets = new Insets(2, 11, 3, 0);
        this.copyBtn.addActionListener(new CopyListener());
        this.add(this.copyBtn, gridBagConstraints, -1);
        this.deleteBtn = new JButton(AdminMainPanel.sharedInstance().createImageIcon("toolbar_delete.gif", "Delete"));
        this.setUpButton(this.deleteBtn, UMgrResourceStrings.getString("warning_delete"));
        gridBagConstraints.gridx = 5;
        gridBagConstraints.insets = new Insets(2, 2, 3, 0);
        this.add(this.deleteBtn, gridBagConstraints, -1);
        this.iconViewOpen = AdminMainPanel.sharedInstance().createImageIcon("toolbar_large_icons_enabled.gif", "IconViewOpen");
        this.iconViewBtn = new JButton(this.iconViewOpen);
        this.setUpButton(this.iconViewBtn, UMgrResourceStrings.getString("tbar_largeicons"));
        this.iconViewBtn.setBorder(this.bevelBorder);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 6;
        gridBagConstraints.insets = new Insets(2, 11, 3, 0);
        this.add(this.iconViewBtn, gridBagConstraints, -1);
        this.detailOpen = AdminMainPanel.sharedInstance().createImageIcon("toolbar_details_enabled.gif", "DetailOpen");
        this.detailViewBtn = new JButton(this.detailOpen);
        this.setUpButton(this.detailViewBtn, UMgrResourceStrings.getString("tbar_details"));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 7;
        gridBagConstraints.insets = new Insets(2, 2, 3, 0);
        this.add(this.detailViewBtn, gridBagConstraints, -1);
        this.refreshBtn = new JButton(AdminMainPanel.sharedInstance().createImageIcon("toolbar_refresh_enabled.gif", "Refresh"));
        this.setUpButton(this.refreshBtn, UMgrResourceStrings.getString("tbar_refresh"));
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 8;
        gridBagConstraints.insets = new Insets(2, 11, 3, 0);
        this.add(this.refreshBtn, gridBagConstraints, -1);
    }

    class TBarBtnListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JButton jButton = (JButton)actionEvent.getSource();
                ImageIcon imageIcon = (ImageIcon)jButton.getIcon();
                String string = imageIcon.getDescription();
                if (string.equals("Add Multple Users")) {
                    AdminMultiUserWiz adminMultiUserWiz = null;
                    adminMultiUserWiz = UserMgrClient.instance().getPDCFactoryHandle() == null ? new AdminMultiUserWiz(UMgrResourceStrings.getString("mu_wiz_dialog_name"), true, false) : new AdminMultiUserWiz(UMgrResourceStrings.getString("mu_wiz_dialog_name"), true, true);
                    Dimension dimension = adminMultiUserWiz.getPreferredSize();
                    Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                    ((Component)adminMultiUserWiz).setLocation(dimension2.width / 2 - dimension.width / 2, dimension2.height / 2 - dimension.height / 2);
                    adminMultiUserWiz.pack();
                    adminMultiUserWiz.setVisible(true);
                } else if (string.equals("Find")) {
                    FindObj findObj = FindObj.instance();
                    FindDialog findDialog = new FindDialog((Frame)AdminMainPanel.sharedInstance().jFrame, findObj.getSearchString());
                    findDialog.addFindNextListener(new FindNextActionListener());
                    ((Component)findDialog).setVisible(true);
                } else if (string.equals("Filter")) {
                    new FilterObj(UMgrResourceStrings.getString("users"), false);
                } else if (string.equals("Delete")) {
                    JPanel jPanel = new JPanel();
                    String string2 = new String(UMgrResourceStrings.getString("warning"));
                    int n = 0;
                    while (n < AdminViews.instance().getSelectedNodeNames().size()) {
                        AdminCommonTools.CMN_HandleOutput("Will delete the following users: " + (String)AdminViews.instance().getSelectedNodeNames().elementAt(n));
                        ++n;
                    }
                    if (AdminViews.instance().getCurrentViewName().equals(UMgrResourceStrings.getString("users"))) {
                        jPanel = new ConfDelUserPanel();
                        string2 = UMgrResourceStrings.getString("warning_user");
                    } else {
                        new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, "Not in supported view");
                    }
                    new WarningDialog(AdminMainPanel.sharedInstance().jFrame, string2, jPanel, (ActionListener)new ConfActionListener(), UMgrResourceStrings.getString("warning_delete"));
                } else if (string.compareTo("DetailOpen") == 0) {
                    if (jButton.getBorder() != UMgrUserTBar.this.bevelBorder) {
                        AdminMainPanel.sharedInstance().switchToDetailPanel();
                    }
                } else if (string.compareTo("IconViewOpen") == 0) {
                    if (jButton.getBorder() != UMgrUserTBar.this.bevelBorder) {
                        AdminMainPanel.sharedInstance().switchToIconPanel();
                    }
                } else if (string.equals("Refresh")) {
                    AdminViews.instance().refreshAllViews();
                } else if (string.equals("Add User")) {
                    AdminUserWizard adminUserWizard = null;
                    adminUserWizard = UserMgrClient.instance().getPDCFactoryHandle() == null ? new AdminUserWizard(UMgrResourceStrings.getString("au_wiz_dialog_name"), true, false) : new AdminUserWizard(UMgrResourceStrings.getString("au_wiz_dialog_name"), true, true);
                    Dimension dimension = adminUserWizard.getPreferredSize();
                    Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
                    ((Component)adminUserWizard).setLocation(dimension3.width / 2 - dimension.width / 2, dimension3.height / 2 - dimension.height / 2);
                    adminUserWizard.pack();
                    adminUserWizard.setVisible(true);
                } else {
                    AdminCommonTools.CMN_HandleOutput("Button not handled");
                }
            }
            catch (Exception exception) {
                AdminCommonTools.CMN_TraceStack(1, exception);
            }
            AdminCommonTools.CMN_HandleOutput("out of TBarBtnListnener");
        }

        TBarBtnListener() {
            UMgrUserTBar.this = UMgrUserTBar.this;
        }
    }

    class CopyListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            AdminCommonTools.CMN_HandleOutput("In CopyListener");
            String string = new String();
            int n = 0;
            while (n < AdminViews.instance().getSelectedNodeNames().size()) {
                object = (String)AdminViews.instance().getSelectedNodeNames().elementAt(n);
                string = string.concat(String.valueOf(object) + ";");
                ++n;
            }
            object = new StringSelection(string);
            AdminViews.instance().getClipBoard().setContents((Transferable)object, (ClipboardOwner)object);
        }

        CopyListener() {
            UMgrUserTBar.this = UMgrUserTBar.this;
        }
    }

    class BtnMouseListener
    extends MouseAdapter {
        JButton jb;

        public void mouseEntered(MouseEvent mouseEvent) {
            this.jb = (JButton)mouseEvent.getComponent();
            if (this.jb.isEnabled()) {
                this.jb.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.jb = (JButton)mouseEvent.getComponent();
            this.jb.setBorderPainted(false);
        }

        BtnMouseListener() {
            UMgrUserTBar.this = UMgrUserTBar.this;
        }
    }
}

