/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ObservableComp;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.service.authorization.AuthAttrObj;
import com.sun.admin.cis.service.authorization.UserAttrObj;
import com.sun.admin.usermgr.client.AdminMainPanel;
import com.sun.admin.usermgr.client.ISelection;
import com.sun.admin.usermgr.client.IUMgrFilter;
import com.sun.admin.usermgr.client.IViews;
import com.sun.admin.usermgr.client.UserMgrClient;
import com.sun.admin.usermgr.common.EmailAliasObj;
import com.sun.admin.usermgr.common.GroupObj;
import com.sun.admin.usermgr.common.PartialSuccessObject;
import com.sun.admin.usermgr.common.SolServerPartialSuccessException;
import com.sun.admin.usermgr.common.UMgrResourceStrings;
import com.sun.admin.usermgr.common.UserObj;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.util.Vector;

public class AdminViews
implements IViews,
ISelection,
IUMgrFilter {
    private Vector vUserViews;
    private Vector vEmailViews;
    private Vector vGroupViews;
    private Vector vSelectedNodeNames;
    private Vector vUnFilteredGroupViews;
    private AuthAttrObj[] aryAuthList;
    private UserAttrObj adminUserAttr;
    private String currentView;
    private String ancestorView;
    private ListProperties emailListProperties;
    private ListProperties groupListProperties;
    private ListProperties userListProperties;
    private boolean emailActiveValue = false;
    private boolean groupActiveValue = false;
    private boolean userActiveValue = false;
    private boolean emailDialogValue = true;
    private boolean groupDialogValue = true;
    private boolean userDialogValue = true;
    private boolean showNoEmailData = true;
    private boolean showNoGroupData = true;
    private boolean showNoUserData = true;
    private static AdminViews adminViews;
    private UserMgrClient userMgrClient;
    public Clipboard umClipBoard = new Clipboard("umgr");
    public ObservableComp myObservableComp = new ObservableComp();

    public static AdminViews instance() {
        if (adminViews == null) {
            adminViews = new AdminViews();
        }
        return adminViews;
    }

    public void initAdminViews() {
        adminViews = null;
    }

    public AuthAttrObj[] getAuthAttrObjList() {
        return this.aryAuthList;
    }

    public UserAttrObj getAdminUserAttr() {
        return this.adminUserAttr;
    }

    public void setAdminUserAttr(UserAttrObj userAttrObj) {
        this.adminUserAttr = userAttrObj;
    }

    public void setAuthAttrObjList(AuthAttrObj[] authAttrObjArray) {
        this.aryAuthList = authAttrObjArray;
    }

    public Clipboard getClipBoard() {
        return this.umClipBoard;
    }

    public ListProperties getEmailListProperties() {
        return this.emailListProperties;
    }

    public ListProperties getGroupListProperties() {
        return this.groupListProperties;
    }

    public ListProperties getUserListProperties() {
        return this.userListProperties;
    }

    public boolean isEmailFilterEnabled() {
        return this.emailActiveValue;
    }

    public boolean isGroupFilterEnabled() {
        return this.groupActiveValue;
    }

    public boolean isUserFilterEnabled() {
        return this.userActiveValue;
    }

    public void enableNoEmailData(boolean bl) {
        this.showNoEmailData = bl;
    }

    public void enableNoGroupData(boolean bl) {
        this.showNoGroupData = bl;
    }

    public void enableNoUserData(boolean bl) {
        this.showNoUserData = bl;
    }

    public boolean isShowNoEmailDataEnabled() {
        return this.showNoEmailData;
    }

    public boolean isShowNoGroupDataEnabled() {
        return this.showNoGroupData;
    }

    public boolean isShowNoUserDataEnabled() {
        return this.showNoUserData;
    }

    public void setEmailListProperties(ListProperties listProperties) {
        this.emailListProperties = listProperties;
    }

    public void setGroupListProperties(ListProperties listProperties) {
        this.groupListProperties = listProperties;
    }

    public void setUserListProperties(ListProperties listProperties) {
        this.userListProperties = listProperties;
    }

    public void activateEmailFiltering(boolean bl) {
        this.emailActiveValue = bl;
    }

    public void activateGroupFiltering(boolean bl) {
        this.groupActiveValue = bl;
    }

    public void activateUserFiltering(boolean bl) {
        this.userActiveValue = bl;
    }

    public void enableEmailFilterDialog(boolean bl) {
        this.emailDialogValue = bl;
    }

    public void enableGroupFilterDialog(boolean bl) {
        this.groupDialogValue = bl;
    }

    public void enableUserFilterDialog(boolean bl) {
        this.userDialogValue = bl;
    }

    public boolean showEmailFilterDialog() {
        return this.emailDialogValue;
    }

    public boolean showGroupFilterDialog() {
        return this.groupDialogValue;
    }

    public boolean showUserFilterDialog() {
        return this.userDialogValue;
    }

    public GroupObj getGroupObjFromName(String string) {
        GroupObj groupObj = null;
        int n = 0;
        while (n < this.vGroupViews.size()) {
            groupObj = (GroupObj)this.vGroupViews.elementAt(n);
            String string2 = groupObj.getGroupName();
            if (string2.equals(string)) break;
            ++n;
        }
        return groupObj;
    }

    public Vector getGroupViews() {
        if (this.vGroupViews == null) {
            this.vGroupViews = this.groupActiveValue ? this.userMgrClient.getAllGroups(this.getGroupListProperties()) : this.userMgrClient.getAllGroups();
        }
        return this.vGroupViews;
    }

    public Vector getGroupViewsNow() {
        this.vGroupViews = this.groupActiveValue ? this.userMgrClient.getAllGroups(this.getGroupListProperties()) : this.userMgrClient.getAllGroups();
        return this.vGroupViews;
    }

    public Vector getUnFilteredGroupViews() {
        if (this.vUnFilteredGroupViews == null) {
            this.vUnFilteredGroupViews = this.userMgrClient.getAllGroups();
        }
        return this.vUnFilteredGroupViews;
    }

    public EmailAliasObj getEmailAliasObjFromName(String string) {
        EmailAliasObj emailAliasObj = null;
        int n = 0;
        while (n < this.vEmailViews.size()) {
            emailAliasObj = (EmailAliasObj)this.vEmailViews.elementAt(n);
            String string2 = emailAliasObj.getAliasName();
            if (string2.equals(string)) break;
            ++n;
        }
        return emailAliasObj;
    }

    public Vector getEmailViews() {
        try {
            if (this.vEmailViews == null) {
                this.vEmailViews = this.emailActiveValue ? this.userMgrClient.getAllEmailAliases(this.getEmailListProperties()) : this.userMgrClient.getAllEmailAliases();
            }
        }
        catch (Exception exception) {
            new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, exception.getLocalizedMessage());
        }
        return this.vEmailViews;
    }

    public UserObj getUserObjFromName(String string) {
        UserObj userObj = null;
        int n = 0;
        while (n < this.vUserViews.size()) {
            userObj = (UserObj)this.vUserViews.elementAt(n);
            String string2 = userObj.getUserName();
            if (string2.equals(string)) break;
            ++n;
        }
        return userObj;
    }

    public Vector getUserViews() {
        if (this.vUserViews == null) {
            this.vUserViews = this.userActiveValue ? this.userMgrClient.getAllUsers(this.getUserListProperties()) : this.userMgrClient.getAllUsers();
        }
        return this.vUserViews;
    }

    public String getCurrentViewName() {
        return this.currentView;
    }

    public String getAncestorViewName() {
        return this.ancestorView;
    }

    public void setCurrentView(String string, String string2) {
        AdminCommonTools.CMN_HandleOutput("In setCurrentView");
        AdminCommonTools.CMN_HandleOutput("CurrentView = " + this.currentView);
        AdminCommonTools.CMN_HandleOutput("Ancestor View = " + this.ancestorView);
        this.currentView = string2;
        this.ancestorView = string;
        1 var3_3 = new 1();
        var3_3.start();
    }

    public void setCurrentViewWithoutProgress(String string, String string2) {
        AdminCommonTools.CMN_HandleOutput("In setCurrentViewWithoutProgress");
        AdminCommonTools.CMN_HandleOutput("CurrentView = " + this.currentView);
        AdminCommonTools.CMN_HandleOutput("Ancestor View = " + this.ancestorView);
        this.currentView = string2;
        this.ancestorView = string;
        if (this.currentView.equals(UMgrResourceStrings.getString("users")) && this.vUserViews == null) {
            this.vUserViews = this.showNoUserData ? new Vector() : (this.userActiveValue ? this.userMgrClient.getAllUsers(this.getUserListProperties()) : this.userMgrClient.getAllUsers());
        }
        if (this.currentView.equals(UMgrResourceStrings.getString("groups")) && this.vGroupViews == null) {
            this.vGroupViews = this.showNoGroupData ? new Vector() : (this.groupActiveValue ? this.userMgrClient.getAllGroups(this.getGroupListProperties()) : this.userMgrClient.getAllGroups());
        }
        try {
            if (this.currentView.equals(UMgrResourceStrings.getString("email")) && this.vEmailViews == null) {
                this.vEmailViews = this.showNoEmailData ? new Vector() : (this.emailActiveValue ? this.userMgrClient.getAllEmailAliases(this.getEmailListProperties()) : this.userMgrClient.getAllEmailAliases());
            }
        }
        catch (Exception exception) {
            new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, exception.getMessage());
        }
        this.myObservableComp.notifyIObservers(AdminViews.instance(), "changeView");
    }

    public void refreshAllViews() {
        this.adminUserAttr = null;
        this.aryAuthList = null;
        this.vEmailViews = null;
        this.vGroupViews = null;
        this.vUnFilteredGroupViews = null;
        this.vUserViews = null;
        this.setCurrentView(this.ancestorView, this.currentView);
    }

    public void refreshEmailViews() {
        this.vEmailViews = null;
        this.aryAuthList = null;
        this.adminUserAttr = null;
    }

    public void refreshGroupViews() {
        this.vGroupViews = null;
        this.vUnFilteredGroupViews = null;
        this.aryAuthList = null;
        this.adminUserAttr = null;
    }

    public void refreshUserViews() {
        this.vUserViews = null;
        this.aryAuthList = null;
        this.adminUserAttr = null;
    }

    public void addGroupToGroupViews(GroupObj groupObj) throws Exception {
        this.userMgrClient.addGroup(groupObj);
        this.vGroupViews.addElement(groupObj);
        this.vUnFilteredGroupViews = null;
        this.removeAllSelectedNodes();
        this.vSelectedNodeNames.addElement(groupObj.getGroupName());
        this.setCurrentView(this.ancestorView, this.currentView);
        return;
    }

    public void addUserToUserViews(UserObj userObj) throws Exception {
        try {
            this.userMgrClient.addUser(userObj);
            this.vUserViews.addElement(userObj);
            this.removeAllSelectedNodes();
            this.vSelectedNodeNames.addElement(userObj.getUserName());
            this.setCurrentView(this.ancestorView, this.currentView);
            return;
        }
        catch (SolServerPartialSuccessException solServerPartialSuccessException) {
            PartialSuccessObject partialSuccessObject = solServerPartialSuccessException.getPartialSuccessObject();
            if (partialSuccessObject != null) {
                if (partialSuccessObject.getHomedirFailed()) {
                    Exception exception = partialSuccessObject.getHomedirException();
                    if (exception != null) {
                        new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_information"), exception.getLocalizedMessage(), true);
                    }
                } else if (partialSuccessObject.getMailboxFailed()) {
                    Exception exception = partialSuccessObject.getMailboxException();
                    if (exception != null) {
                        new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_information"), exception.getLocalizedMessage(), true);
                    }
                } else {
                    String string = solServerPartialSuccessException.getLocalizedMessage();
                    if (string != null && !string.equals("")) {
                        new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_information"), string, true);
                    }
                }
            }
            this.vUserViews.addElement(userObj);
            this.removeAllSelectedNodes();
            this.vSelectedNodeNames.addElement(userObj.getUserName());
            this.setCurrentView(this.ancestorView, this.currentView);
            return;
        }
        catch (Exception exception) {
            String string = exception.getLocalizedMessage();
            if (string != null && !string.equals("")) {
                new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, string);
            }
            throw exception;
        }
    }

    public boolean addEmailAliasToEmailViews(EmailAliasObj emailAliasObj) {
        boolean bl = true;
        try {
            this.userMgrClient.addEmailAlias(emailAliasObj);
            this.vEmailViews.addElement(emailAliasObj);
            this.removeAllSelectedNodes();
            this.vSelectedNodeNames.addElement(emailAliasObj.getAliasName());
            this.setCurrentView(this.ancestorView, this.currentView);
        }
        catch (Exception exception) {
            bl = false;
            new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, exception.getMessage());
        }
        return bl;
    }

    public void modifyAliasObjInViews(EmailAliasObj emailAliasObj, EmailAliasObj emailAliasObj2) {
        int n = 0;
        while (n < this.vEmailViews.size()) {
            EmailAliasObj emailAliasObj3 = (EmailAliasObj)this.vEmailViews.elementAt(n);
            String string = emailAliasObj3.getAliasName();
            if (string.equals(emailAliasObj.getAliasName())) {
                this.vEmailViews.setElementAt(emailAliasObj2, n);
                return;
            }
            ++n;
        }
    }

    public void modifyGroupObjInViews(GroupObj groupObj, GroupObj groupObj2) {
        int n = 0;
        while (n < this.vGroupViews.size()) {
            GroupObj groupObj3 = (GroupObj)this.vGroupViews.elementAt(n);
            String string = groupObj3.getGroupName();
            if (string.equals(groupObj.getGroupName())) {
                this.vGroupViews.setElementAt(groupObj2, n);
                break;
            }
            ++n;
        }
        this.vUnFilteredGroupViews = null;
    }

    public void modifyUserObjInViews(UserObj userObj, UserObj userObj2) {
        int n = 0;
        while (n < this.vUserViews.size()) {
            UserObj userObj3 = (UserObj)this.vUserViews.elementAt(n);
            String string = userObj3.getUserName();
            if (string.equals(userObj.getUserName())) {
                this.vUserViews.setElementAt(userObj2, n);
                return;
            }
            ++n;
        }
    }

    public void removeGroupByName(String string) {
        GroupObj groupObj = null;
        int n = 0;
        while (n < this.vGroupViews.size()) {
            groupObj = (GroupObj)this.vGroupViews.elementAt(n);
            String string2 = groupObj.getGroupName();
            if (string2.equals(string)) {
                try {
                    this.userMgrClient.deleteGroup(groupObj);
                    this.vGroupViews.removeElementAt(n);
                    this.vUnFilteredGroupViews = null;
                    return;
                }
                catch (Exception exception) {
                    new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, exception.getMessage());
                    return;
                }
            }
            ++n;
        }
    }

    public void removeUserByName(String string) {
        UserObj userObj = null;
        int n = 0;
        while (n < this.vUserViews.size()) {
            userObj = (UserObj)this.vUserViews.elementAt(n);
            String string2 = userObj.getUserName();
            if (string2.equals(string)) {
                try {
                    this.userMgrClient.deleteUser(userObj);
                    this.vUserViews.removeElementAt(n);
                    return;
                }
                catch (Exception exception) {
                    new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, exception.getMessage());
                    return;
                }
            }
            ++n;
        }
    }

    public void removeAliasByName(String string) {
        EmailAliasObj emailAliasObj = null;
        int n = 0;
        while (n < this.vEmailViews.size()) {
            emailAliasObj = (EmailAliasObj)this.vEmailViews.elementAt(n);
            String string2 = emailAliasObj.getAliasName();
            if (string2.equals(string)) {
                try {
                    this.userMgrClient.deleteEmailAlias(emailAliasObj);
                    this.vEmailViews.removeElementAt(n);
                    return;
                }
                catch (Exception exception) {
                    new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, exception.getMessage());
                    return;
                }
            }
            ++n;
        }
    }

    public void removeEmailAliasFromEmailViews(EmailAliasObj emailAliasObj) {
        int n = 0;
        while (n < this.vEmailViews.size()) {
            EmailAliasObj emailAliasObj2 = (EmailAliasObj)this.vEmailViews.elementAt(n);
            if (emailAliasObj.getAliasName().equals(emailAliasObj2.getAliasName())) {
                try {
                    this.vEmailViews.removeElementAt(n);
                    this.userMgrClient.deleteEmailAlias(emailAliasObj);
                }
                catch (Exception exception) {
                    new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, exception.getMessage());
                }
                break;
            }
            ++n;
        }
        this.setCurrentView(this.ancestorView, this.currentView);
    }

    public Vector getSelectedNodeNames() {
        return this.vSelectedNodeNames;
    }

    public void notifySelectionObservers() {
        this.myObservableComp.notifyIObservers(this, "changeSelection");
    }

    public void setSelectedNodeName(String string) {
        AdminCommonTools.CMN_HandleOutput("adding selection =" + string);
        this.vSelectedNodeNames.addElement(string);
        this.myObservableComp.notifyIObservers(this, "changeSelection");
    }

    public void removeSelectedNodeName(String string) {
        int n = 0;
        while (n < this.vSelectedNodeNames.size()) {
            if (string.equals((String)this.vSelectedNodeNames.elementAt(n))) {
                this.vSelectedNodeNames.removeElementAt(n);
                break;
            }
            ++n;
        }
        this.myObservableComp.notifyIObservers(this, "changeSelection");
    }

    public void removeAllSelectedNodes() {
        this.vSelectedNodeNames.removeAllElements();
    }

    public void deleteSelections() {
        if (this.currentView.equals(UMgrResourceStrings.getString("rootname"))) {
            return;
        }
        int n = 0;
        while (n < this.vSelectedNodeNames.size()) {
            if (this.currentView.equals(UMgrResourceStrings.getString("users"))) {
                this.removeUserByName((String)this.vSelectedNodeNames.elementAt(n));
            }
            if (this.currentView.equals(UMgrResourceStrings.getString("groups"))) {
                this.removeGroupByName((String)this.vSelectedNodeNames.elementAt(n));
            }
            if (this.currentView.equals(UMgrResourceStrings.getString("email"))) {
                this.removeAliasByName((String)this.vSelectedNodeNames.elementAt(n));
            }
            ++n;
        }
        this.removeAllSelectedNodes();
        this.setCurrentView(this.ancestorView, this.currentView);
    }

    private AdminViews() {
        this.userMgrClient = UserMgrClient.instance();
        this.vSelectedNodeNames = new Vector();
    }

    private final class 1
    extends Thread {
        public void run() {
            int n;
            String string;
            String string2;
            ProgressPanel progressPanel = null;
            int n2 = 30;
            AdminMainPanel.sharedInstance().clientComm.waitOn();
            if (AdminViews.this.currentView.equals(UMgrResourceStrings.getString("users")) && AdminViews.this.vUserViews == null) {
                if (AdminViews.this.showNoUserData) {
                    AdminViews.this.vUserViews = new Vector();
                } else {
                    string2 = UMgrResourceStrings.getString("progress_user_title");
                    string = UMgrResourceStrings.getString("progress_user_msg");
                    n = n2;
                    progressPanel = new ProgressPanel(AdminMainPanel.sharedInstance().jFrame, 1, n, false, false);
                    progressPanel.setTitle(string2);
                    progressPanel.setText(string);
                    ((Component)progressPanel).setVisible(true);
                    progressPanel.show();
                    if (AdminViews.this.userActiveValue) {
                        AdminViews.this.vUserViews = AdminViews.this.userMgrClient.getAllUsers(AdminViews.this.getUserListProperties());
                    } else {
                        AdminViews.this.vUserViews = AdminViews.this.userMgrClient.getAllUsers();
                    }
                }
            }
            if (AdminViews.this.currentView.equals(UMgrResourceStrings.getString("groups")) && AdminViews.this.vGroupViews == null) {
                if (AdminViews.this.showNoGroupData) {
                    AdminViews.this.vGroupViews = new Vector();
                } else {
                    string2 = UMgrResourceStrings.getString("progress_groups_title");
                    string = UMgrResourceStrings.getString("progress_groups_msg");
                    n = n2;
                    progressPanel = new ProgressPanel(AdminMainPanel.sharedInstance().jFrame, 1, n, false, false);
                    progressPanel.setTitle(string2);
                    progressPanel.setText(string);
                    ((Component)progressPanel).setVisible(true);
                    progressPanel.show();
                    if (AdminViews.this.groupActiveValue) {
                        AdminViews.this.vGroupViews = AdminViews.this.userMgrClient.getAllGroups(AdminViews.this.getGroupListProperties());
                    } else {
                        AdminViews.this.vGroupViews = AdminViews.this.userMgrClient.getAllGroups();
                    }
                }
            }
            try {
                if (AdminViews.this.currentView.equals(UMgrResourceStrings.getString("email")) && AdminViews.this.vEmailViews == null) {
                    if (AdminViews.this.showNoEmailData) {
                        AdminViews.this.vEmailViews = new Vector();
                    } else {
                        string2 = UMgrResourceStrings.getString("progress_email_title");
                        string = UMgrResourceStrings.getString("progress_email_msg");
                        n = n2;
                        progressPanel = new ProgressPanel(AdminMainPanel.sharedInstance().jFrame, 1, n, false, false);
                        progressPanel.setTitle(string2);
                        progressPanel.setText(string);
                        ((Component)progressPanel).setVisible(true);
                        progressPanel.show();
                        if (AdminViews.this.emailActiveValue) {
                            AdminViews.this.vEmailViews = AdminViews.this.userMgrClient.getAllEmailAliases(AdminViews.this.getEmailListProperties());
                        } else {
                            AdminViews.this.vEmailViews = AdminViews.this.userMgrClient.getAllEmailAliases();
                        }
                    }
                }
            }
            catch (Exception exception) {
                new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, exception.getMessage());
            }
            AdminViews.this.myObservableComp.notifyIObservers(AdminViews.instance(), "changeView");
            if (progressPanel != null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
                ((Component)progressPanel).setVisible(false);
                progressPanel.dispose();
            }
            AdminMainPanel.sharedInstance().clientComm.waitOff();
        }

        /* synthetic */ 1() {
        }
    }
}

