/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.usermgr.client.AdminMainPanel;
import com.sun.admin.usermgr.client.AdminViews;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.UserMgrClient;
import com.sun.admin.usermgr.common.EmailAliasObj;
import com.sun.admin.usermgr.common.UMgrResourceStrings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class AdminEmailDialog
extends AdminDialog {
    AdminDialog adminEmailDialog;
    JPanel emailPanel;
    JButton okButton;
    JButton cancelButton;
    JTextField emailTextField;
    JTextArea emailMemTextArea;
    GenInfoPanel infoPanel;
    JPanel blankPanel;
    URL url;
    boolean bAddingNewAlias = false;
    EmailAliasObj thisEmailObj;
    String strOrigAliasname = "";
    AdminMainPanel adminMainPanel;
    UserMgrClient userMgrClient;

    public AdminEmailDialog(JFrame jFrame) {
        super(jFrame, " ", false);
        this.bAddingNewAlias = true;
        this.adminEmailDialog = this;
        this.adminEmailDialog.setTitle(UMgrResourceStrings.getString("new_email_title"));
        this.userMgrClient = UserMgrClient.instance();
        this.adminMainPanel = AdminMainPanel.sharedInstance();
        this.infoPanel = this.getInfoPanel();
        this.blankPanel = this.getRightPanel();
        this.blankPanel.setLayout(new BorderLayout());
        this.blankPanel.add("Center", this.createEmailPanel());
        this.okButton = this.getOKBtn();
        this.okButton.addActionListener(new OKCancelButtonListener());
        this.cancelButton = this.getCancelBtn();
        this.cancelButton.addActionListener(new OKCancelButtonListener());
        this.pack();
        Dimension dimension = this.getSize();
        this.setMySize(dimension);
        this.setDefaultFocusListener(new UMgrContextHelpListener(this.infoPanel, "email_add"), true);
        this.emailTextField.addFocusListener(new UMgrContextHelpListener(this.infoPanel, "email_add_alias"));
        this.emailMemTextArea.addFocusListener(new UMgrContextHelpListener(this.infoPanel, "email_add_members"));
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(dimension2.width / 2 - this.getSize().width / 2, dimension2.height / 2 - this.getSize().height / 2);
        1 var4_4 = new 1();
        this.adminEmailDialog.addWindowListener(var4_4);
    }

    public AdminEmailDialog(JFrame jFrame, EmailAliasObj emailAliasObj) {
        super(jFrame, "New Email Alias", false);
        Cloneable cloneable;
        this.bAddingNewAlias = false;
        this.strOrigAliasname = emailAliasObj.getAliasName();
        this.adminEmailDialog = this;
        this.adminEmailDialog.setTitle(UMgrResourceStrings.getString("email_props"));
        AdminCommonTools.CMN_HandleOutput("Setting emailObj: " + emailAliasObj);
        AdminCommonTools.CMN_HandleOutput("This emailObj: " + this.thisEmailObj);
        this.userMgrClient = UserMgrClient.instance();
        try {
            this.thisEmailObj = this.userMgrClient.getEmailAliasAttributes(emailAliasObj);
        }
        catch (Exception exception) {
            new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, exception.getLocalizedMessage());
        }
        this.setEmailAliasObj(this.thisEmailObj);
        this.adminMainPanel = AdminMainPanel.sharedInstance();
        this.infoPanel = this.getInfoPanel();
        this.blankPanel = this.getRightPanel();
        this.blankPanel.setLayout(new BorderLayout());
        this.blankPanel.add("Center", this.createEmailPanel());
        this.okButton = this.getOKBtn();
        this.okButton.addActionListener(new OKCancelButtonListener());
        this.okButton.setEnabled(false);
        try {
            cloneable = this.userMgrClient.getUserRights();
            if (cloneable.contains("solaris.admin.usermgr.write")) {
                this.okButton.setEnabled(true);
            }
        }
        catch (AdminException adminException) {
            new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, adminException.getLocalizedMessage());
        }
        this.cancelButton = this.getCancelBtn();
        this.cancelButton.addActionListener(new OKCancelButtonListener());
        this.pack();
        cloneable = this.getSize();
        this.setMySize((Dimension)cloneable);
        this.setDefaultFocusListener(new UMgrContextHelpListener(this.infoPanel, "email_prop"), true);
        this.emailTextField.addFocusListener(new UMgrContextHelpListener(this.infoPanel, "email_prop_alias"));
        this.emailMemTextArea.addFocusListener(new UMgrContextHelpListener(this.infoPanel, "email_prop_members"));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
        2 var5_7 = new 2();
        this.adminEmailDialog.addWindowListener(var5_7);
    }

    private JPanel createEmailPanel() {
        this.emailPanel = new JPanel();
        this.emailPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(UMgrResourceStrings.getString("alias_name"));
        jLabel.setFont(Constants.PROPS_LABEL_FONT);
        jLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        Constraints.constrain(this.emailPanel, jLabel, 0, 0, 1, 1, 0, 16, 0.0, 0.0, 30, 24, 10, 0);
        if (this.bAddingNewAlias) {
            this.emailTextField = new JTextField(15);
            this.emailMemTextArea = new JTextArea(9, 33);
        } else {
            this.emailTextField = new JTextField(this.getEmailAliasObj().getAliasName(), 15);
            this.emailMemTextArea = new JTextArea(this.getEmailAliasObj().getAliasExpansion(), 9, 33);
        }
        this.emailTextField.setMinimumSize(this.emailTextField.getPreferredSize());
        Constraints.constrain(this.emailPanel, this.emailTextField, 1, 0, 1, 1, 0, 16, 1.0, 0.0, 30, 16, 10, 0);
        JLabel jLabel2 = new JLabel(UMgrResourceStrings.getString("alias_mem"));
        jLabel2.setFont(Constants.PROPS_LABEL_FONT);
        jLabel2.setForeground(Constants.PROPS_LABEL_COLOR);
        Constraints.constrain(this.emailPanel, jLabel2, 0, 1, 2, 1, 0, 16, 1.0, 0.0, 20, 24, 10, 0);
        this.emailMemTextArea.setLineWrap(true);
        this.emailMemTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.emailMemTextArea);
        Constraints.constrain(this.emailPanel, jScrollPane, 0, 2, 2, 1, 1, 18, 1.0, 1.0, 10, 24, 10, 15);
        return this.emailPanel;
    }

    public void onEnterKey() {
    }

    public EmailAliasObj getEmailAliasObj() {
        return this.thisEmailObj;
    }

    public void setEmailAliasObj(EmailAliasObj emailAliasObj) {
        this.thisEmailObj = emailAliasObj;
    }

    public boolean isEmailSyntaxOK() {
        String[] stringArray = new String[]{"0", " ", "@", ".", "-", "_", "<", ">", "(", ")", "\""};
        String[] stringArray2 = new String[]{"0", "@", ".", "-", "_", "/", "\\", ":", "\"", "|", ",", " ", "\t", "\n", "\r"};
        String string = this.emailTextField.getText();
        String string2 = this.emailMemTextArea.getText();
        if (this.emailTextField.getText().equals("")) {
            ErrorDialog errorDialog = new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_email_add"));
            return false;
        }
        if (!CheckSyntax.isStringOK(this.emailTextField.getText(), stringArray)) {
            ErrorDialog errorDialog = new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_email_chars"));
            return false;
        }
        if (!Character.isLetter(this.emailTextField.getText().charAt(0)) && this.emailTextField.getText().charAt(0) != '<') {
            ErrorDialog errorDialog = new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_email_name1"));
            return false;
        }
        if (string.equalsIgnoreCase("postmaster") && this.emailMemTextArea.getText().equals("")) {
            ErrorDialog errorDialog = new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_email_postmaster_null"));
            return false;
        }
        if (string.equalsIgnoreCase("MAILER-DAEMON") && this.emailMemTextArea.getText().equals("")) {
            ErrorDialog errorDialog = new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_email_maildaemon_null"));
            return false;
        }
        if (!this.doSyntaxEndsMatchUp(string)) {
            return false;
        }
        if ((string2 = string2.trim()) == null || string2.equals("")) {
            return true;
        }
        if (string2.length() > 1000) {
            ErrorDialog errorDialog = new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_email_members1"));
            return false;
        }
        if (!this.isCommaUsageOK(string2)) {
            ErrorDialog errorDialog = new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_email_bad_comma"));
            return false;
        }
        if (!CheckSyntax.isStringOK(this.emailMemTextArea.getText(), stringArray2)) {
            ErrorDialog errorDialog = new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_email_members2"));
            return false;
        }
        return this.isValidDeliverySyntax(this.emailMemTextArea.getText());
    }

    private boolean isCommaUsageOK(String string) {
        boolean bl = true;
        String string2 = "";
        String[] stringArray = this.parseOutAddresses(string);
        int n = 0;
        while (n < stringArray.length) {
            string2 = stringArray[n];
            if ((string2 = string2.trim()) == null || string2.equals("")) {
                bl = false;
            }
            ++n;
        }
        if (string.charAt(0) == ',' || string.charAt(string.length() - 1) == ',') {
            bl = false;
        }
        return bl;
    }

    private boolean isValidDeliverySyntax(String string) {
        boolean bl = true;
        String string2 = "";
        String[] stringArray = this.parseOutAddresses(string);
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            string2 = stringArray[n];
            string2 = string2.trim();
            char c = string2.charAt(0);
            char c2 = '\u0000';
            if (string2.length() > 1) {
                c2 = string2.charAt(1);
            }
            if (c == '/' && c2 == '\u0000') {
                ErrorDialog errorDialog = new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_email_bad_file_path"));
                return false;
            }
            if (c == '/') {
                if (!CheckSyntax.isHomeDirPathnameOK(string2)) {
                    ErrorDialog errorDialog = new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_email_bad_file_path"));
                    return false;
                }
            } else if (c == '|' || c == '\"' && c2 == '|') {
                n2 = string2.charAt(string2.length() - 1);
                char c3 = c2;
                String string3 = "";
                if (c == '|') {
                    string3 = string2.substring(1);
                    string3 = string3.trim();
                    c3 = string3.charAt(0);
                }
                if (c == '\"' && n2 != 34) {
                    ErrorDialog errorDialog = new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_email_expans_quote_err"));
                    return false;
                }
                if (c == '|' && (c2 == '\"' || c3 == '\"') && n2 != 34) {
                    ErrorDialog errorDialog = new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_email_expans_quote_err"));
                    return false;
                }
                if (c != '\"' && c2 != '\"' && c3 != '\"' && n2 == 34) {
                    ErrorDialog errorDialog = new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_email_expans_quote_err"));
                    return false;
                }
                if (c != '\"' && c2 != '\"' && c3 != '\"') {
                    if (string2.indexOf(32, 0) != -1) {
                        ErrorDialog errorDialog = new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_email_expans_need_quotes"));
                        return false;
                    }
                    String string4 = string2.substring(1);
                    if (!CheckSyntax.isHomeDirPathnameOK(string4 = string4.trim())) {
                        ErrorDialog errorDialog = new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_email_expans_bad_path"));
                        return false;
                    }
                }
            } else if (c == ':') {
                if (!string2.startsWith(":include:")) {
                    ErrorDialog errorDialog = new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_email_expans_bad_mailing_list"));
                    return false;
                }
                String string5 = string2.substring(9);
                if (!CheckSyntax.isHomeDirPathnameOK(string5 = string5.trim())) {
                    ErrorDialog errorDialog = new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_email_expans_bad_mailing_list_path"));
                    return false;
                }
            } else {
                string2 = string2.trim();
                n2 = 0;
                while (n2 < string2.length()) {
                    if (!(string2.charAt(n2) != ' ' && string2.charAt(n2) != '\t' || string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"')) {
                        ErrorDialog errorDialog = new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_email_expans_bad_quoting"));
                        return false;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return bl;
    }

    private String[] parseOutAddresses(String string) {
        String string2 = "";
        String string3 = "";
        int n = 0;
        Vector<String> vector = new Vector<String>();
        string3 = string;
        string3 = string3.trim();
        n = string3.indexOf(44);
        while (n != -1) {
            string2 = string3.substring(0, n);
            string2 = string2.trim();
            vector.addElement(string2);
            string3 = string3.substring(n + 1);
            string3 = string3.trim();
            n = string3.indexOf(44);
        }
        if (n == -1) {
            vector.addElement(string3);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private boolean doSyntaxEndsMatchUp(String string) {
        ErrorDialog errorDialog;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = true;
        int n6 = 0;
        while (n6 < string.length()) {
            if (string.charAt(n6) == '<') {
                ++n;
            } else if (string.charAt(n6) == '>') {
                ++n2;
            } else if (string.charAt(n6) == '(') {
                ++n3;
            } else if (string.charAt(n6) == ')') {
                ++n4;
            } else if (string.charAt(n6) == '\"') {
                ++n5;
            }
            ++n6;
        }
        if (n != n2) {
            errorDialog = new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_email_bracket_mismatch"));
            bl = false;
        }
        if (n3 != n4) {
            errorDialog = new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_email_paren_mismatch"));
            bl = false;
        }
        if (n5 % 2 != 0) {
            errorDialog = new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_email_quote_mismatch"));
            bl = false;
        }
        return bl;
    }

    public boolean isModifyEmailOK() {
        block3: {
            EmailAliasObj emailAliasObj = this.getEmailAliasObj();
            EmailAliasObj emailAliasObj2 = (EmailAliasObj)emailAliasObj.clone();
            String string = this.emailTextField.getText();
            String string2 = this.emailMemTextArea.getText();
            if (emailAliasObj.getAliasName().equals(string) && emailAliasObj.getAliasExpansion().equals(string2)) break block3;
            emailAliasObj2.setAliasName(string);
            string2 = string2.replace('\n', ' ');
            string2 = string2.replace('\r', ' ');
            emailAliasObj2.setAliasExpansion(string2);
            try {
                if (!emailAliasObj2.equals(emailAliasObj)) {
                    EmailAliasObj emailAliasObj3 = UserMgrClient.instance().modifyEmailAlias(emailAliasObj2, emailAliasObj);
                    AdminViews.instance().modifyAliasObjInViews(emailAliasObj, emailAliasObj3);
                }
            }
            catch (Exception exception) {
                new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, exception.getLocalizedMessage());
            }
        }
        return true;
    }

    public boolean isCreateEmailOK() {
        boolean bl = true;
        String string = this.emailMemTextArea.getText();
        string = string.replace('\n', ' ');
        string = string.replace('\r', ' ');
        EmailAliasObj emailAliasObj = new EmailAliasObj(this.emailTextField.getText());
        emailAliasObj.setAliasExpansion(string);
        bl = AdminViews.instance().addEmailAliasToEmailViews(emailAliasObj);
        this.setEmailAliasObj(emailAliasObj);
        return bl;
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            AdminEmailDialog.this.adminEmailDialog.dispose();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            AdminEmailDialog.this.adminEmailDialog.dispose();
        }

        /* synthetic */ 2() {
        }
    }

    class OKCancelButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource() == AdminEmailDialog.this.okButton) {
                    if (AdminEmailDialog.this.isEmailSyntaxOK()) {
                        if (AdminEmailDialog.this.bAddingNewAlias && AdminEmailDialog.this.isCreateEmailOK()) {
                            AdminEmailDialog.this.adminEmailDialog.dispose();
                            return;
                        }
                        if (!AdminEmailDialog.this.bAddingNewAlias && AdminEmailDialog.this.isModifyEmailOK()) {
                            AdminEmailDialog.this.adminEmailDialog.dispose();
                            if (!AdminEmailDialog.this.strOrigAliasname.equals(AdminEmailDialog.this.emailTextField.getText())) {
                                AdminViews.instance().refreshEmailViews();
                                AdminViews.instance().setCurrentViewWithoutProgress(AdminViews.instance().getAncestorViewName(), AdminViews.instance().getCurrentViewName());
                                return;
                            }
                        }
                    }
                } else {
                    AdminEmailDialog.this.adminEmailDialog.dispose();
                }
                return;
            }
            catch (Exception exception) {
                new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, exception.getLocalizedMessage());
                return;
            }
        }

        OKCancelButtonListener() {
            AdminEmailDialog.this = AdminEmailDialog.this;
        }
    }
}

