/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.serialmgr.client;

import com.sun.admin.cis.client.AdminSession;
import com.sun.admin.cis.client.IClientComm;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.service.security.SecurityToken;
import com.sun.admin.serialmgr.common.SerialPortData;
import com.sun.admin.serialmgr.common.SerialPortException;
import com.sun.admin.serialmgr.server.SerialPortMgr;
import java.rmi.RemoteException;
import java.util.Vector;

public class SerialPortMgrWrapper {
    private SerialPortMgr serialPortManager;
    private AdminSession session;
    private Vector vRights = new Vector();

    public Vector getUserRights() {
        return this.vRights;
    }

    public void setUpConnection(IClientComm iClientComm) throws Exception {
        this.session = iClientComm.getAdminSession();
        SecurityToken securityToken = this.session.getSecurityToken();
        this.serialPortManager = (SerialPortMgr)this.session.getAppFactory("com.sun.admin.serialmgr.server.SerialPortMgrImpl");
        try {
            this.vRights = this.serialPortManager.getUserRights(securityToken);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public Vector getSerialPorts() throws AdminException {
        Vector vector = null;
        SecurityToken securityToken = this.session.getSecurityToken();
        try {
            vector = this.serialPortManager.getSerialPorts(securityToken);
        }
        catch (RemoteException remoteException) {
            throw new SerialPortException("EXM_REMOTE", remoteException);
        }
        return vector;
    }

    public SerialPortData getPortInfo(String string) throws AdminException {
        SerialPortData serialPortData = null;
        SecurityToken securityToken = this.session.getSecurityToken();
        try {
            serialPortData = this.serialPortManager.getPortInfo(securityToken, string);
        }
        catch (RemoteException remoteException) {
            throw new SerialPortException("EXM_REMOTE", remoteException);
        }
        return serialPortData;
    }

    public void setPortInfo(String string, SerialPortData serialPortData, boolean bl) throws AdminException {
        try {
            Object[] objectArray = new Object[]{string, serialPortData, new Boolean(bl)};
            SecurityToken securityToken = this.session.getSecurityToken(objectArray);
            this.serialPortManager.setPortInfo(securityToken, string, serialPortData, bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new SerialPortException("EXM_REMOTE", remoteException);
        }
    }

    public Vector deletePort(String string) throws AdminException {
        Vector vector = null;
        try {
            Object[] objectArray = new Object[]{string};
            SecurityToken securityToken = this.session.getSecurityToken(objectArray);
            vector = this.serialPortManager.deletePort(securityToken, string);
        }
        catch (RemoteException remoteException) {
            throw new SerialPortException("EXM_REMOTE", remoteException);
        }
        return vector;
    }
}

