/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.serialmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.serialmgr.client.AbstractPropsPanel;
import com.sun.admin.serialmgr.client.Main;
import com.sun.admin.serialmgr.client.SerialMgrContextHelpListener;
import com.sun.admin.serialmgr.common.SerialPortData;
import com.sun.admin.serialmgr.common.SerialPortException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SerialAdvPropsPanel
extends AbstractPropsPanel {
    private SerialPortData originalPortObj;
    private JLabel carrierDetectLabel;
    private JRadioButton swCarrierDetect;
    private JRadioButton hwCarrierDetect;
    private JCheckBox carrierConnect;
    private JCheckBox biDirectional;
    private JCheckBox initializeOnly;
    private JLabel timeoutLabel;
    private JComboBox timeout;
    private JLabel portMonitorLabel;
    private JTextField portMonitor;
    private JLabel serviceProgramLabel;
    private JTextField serviceProgram;
    private JLabel streamsModulesLabel;
    private JTextField streamsModules;
    private Vector timeoutKeys = new Vector();
    private final String keyPrefix = "Timeout";

    public SerialAdvPropsPanel(GenInfoPanel genInfoPanel, SerialPortData serialPortData, String string) {
        Object object;
        ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
        this.setLayout(new GridBagLayout());
        ActionString actionString = new ActionString(resourceBundle, "AdvPropsTabName");
        actionString = new ActionString(resourceBundle, "AdvPropsCarrierDetect");
        this.carrierDetectLabel = new JLabel(actionString.getString());
        Constraints.constrain(this, this.carrierDetectLabel, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 20, 5, 0, 5);
        this.carrierDetectLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.carrierDetectLabel.setFont(Constants.PROPS_LABEL_FONT);
        actionString = new ActionString(resourceBundle, "AdvPropsSWCarrier");
        this.swCarrierDetect = new JRadioButton(actionString.getString());
        this.swCarrierDetect.setMnemonic(actionString.getMnemonic());
        this.swCarrierDetect.addFocusListener(new SerialMgrContextHelpListener(genInfoPanel, "carrier"));
        actionString = new ActionString(resourceBundle, "AdvPropsHWCarrier");
        this.hwCarrierDetect = new JRadioButton(actionString.getString());
        this.hwCarrierDetect.setMnemonic(actionString.getMnemonic());
        this.hwCarrierDetect.addFocusListener(new SerialMgrContextHelpListener(genInfoPanel, "carrier"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.swCarrierDetect);
        buttonGroup.add(this.hwCarrierDetect);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Constraints.constrain(jPanel, this.swCarrierDetect, 0, 0, 1, 1);
        Constraints.constrain(jPanel, this.hwCarrierDetect, 0, 1, 1, 1);
        if (string.compareTo("Terminal") == 0) {
            this.swCarrierDetect.setSelected(true);
            this.hwCarrierDetect.setSelected(false);
        } else {
            this.swCarrierDetect.setSelected(serialPortData.isSoftwareCarrier());
            this.hwCarrierDetect.setSelected(!serialPortData.isSoftwareCarrier());
        }
        int n = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont()).stringWidth("AAAA");
        Constraints.constrain(this, jPanel, 0, -1, 2, 1, 0, 17, 0.0, 0.0, 0, n, 10, 0);
        actionString = new ActionString(resourceBundle, "AdvPropsCarrierConnect");
        this.carrierConnect = new JCheckBox(actionString.getString(), serialPortData.isConnectOnCarrierSet());
        Constraints.constrain(this, this.carrierConnect, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 10, 5);
        Constraints.constrain(this, new JLabel(" "), 1, -1, 1, 1);
        this.carrierConnect.setMnemonic(actionString.getMnemonic());
        this.carrierConnect.addFocusListener(new SerialMgrContextHelpListener(genInfoPanel, "connect"));
        actionString = new ActionString(resourceBundle, "AdvPropsBidirectional");
        this.biDirectional = new JCheckBox(actionString.getString(), serialPortData.isBidirectionalSet());
        Constraints.constrain(this, this.biDirectional, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 10, 5);
        Constraints.constrain(this, new JLabel(" "), 1, -1, 1, 1);
        this.biDirectional.setMnemonic(actionString.getMnemonic());
        this.biDirectional.addFocusListener(new SerialMgrContextHelpListener(genInfoPanel, "bi_direct"));
        if (string.compareTo("ModemDialInOut") == 0) {
            this.biDirectional.setSelected(true);
        } else {
            this.biDirectional.setSelected(serialPortData.isBidirectionalSet());
        }
        actionString = new ActionString(resourceBundle, "AdvPropsInitializeOnly");
        this.initializeOnly = new JCheckBox(actionString.getString(), serialPortData.isInitializeSet());
        Constraints.constrain(this, this.initializeOnly, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 10, 5);
        Constraints.constrain(this, new JLabel(" "), 1, -1, 1, 1);
        this.initializeOnly.setMnemonic(actionString.getMnemonic());
        this.initializeOnly.addFocusListener(new SerialMgrContextHelpListener(genInfoPanel, "init"));
        if (string.length() == 0) {
            this.initializeOnly.setSelected(serialPortData.isInitializeSet());
        } else if (string.compareTo("ModemDialOut") == 0) {
            this.initializeOnly.setSelected(true);
        } else {
            this.initializeOnly.setSelected(false);
        }
        actionString = new ActionString(resourceBundle, "AdvPropsTimeout");
        this.timeoutLabel = new JLabel(actionString.getString());
        Constraints.constrain(this, this.timeoutLabel, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 10, 5);
        this.timeoutLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.timeoutLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.timeoutLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.timeoutKeys.addElement(new String("TimeoutNone"));
        this.timeoutKeys.addElement(new String("Timeout30"));
        this.timeoutKeys.addElement(new String("Timeout60"));
        this.timeoutKeys.addElement(new String("Timeout90"));
        int n2 = -1;
        this.timeout = new JComboBox();
        int n3 = 0;
        while (n3 < this.timeoutKeys.size()) {
            object = (String)this.timeoutKeys.elementAt(n3);
            this.timeout.addItem(ResourceStrings.getString(resourceBundle, (String)object));
            String string2 = ((String)object).substring("Timeout".length());
            if (string2.compareTo(serialPortData.getTimeoutVal()) == 0) {
                n2 = n3;
            }
            ++n3;
        }
        this.timeout.setEditable(false);
        object = new SerialMgrContextHelpListener(genInfoPanel, "timeout");
        int n4 = 0;
        while (n4 < this.timeout.getComponentCount()) {
            Component component = this.timeout.getComponent(n4);
            component.addFocusListener((FocusListener)object);
            ++n4;
        }
        this.timeout.addFocusListener((FocusListener)object);
        try {
            Integer.parseInt(serialPortData.getTimeoutVal());
            if (n2 < 0) {
                this.timeoutKeys.addElement(new String(serialPortData.getTimeoutVal()));
                this.timeout.addItem(serialPortData.getTimeoutVal());
                n2 = this.timeoutKeys.size() - 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 0;
        }
        this.timeout.setSelectedIndex(n2);
        Constraints.constrain(this, this.timeout, 1, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 10, 5);
        this.timeout.setFont(Constants.PROPS_RW_VALUE_FONT);
        this.timeoutLabel.setLabelFor(this.timeout);
        actionString = new ActionString(resourceBundle, "AdvPropsPortMonitor");
        if (string.length() > 0 && serialPortData.isDeleted() && serialPortData.getPortMonTag().length() == 0) {
            serialPortData.setPortMonTag("zsmon");
        }
        this.portMonitorLabel = new JLabel(actionString.getString());
        Constraints.constrain(this, this.portMonitorLabel, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 10, 5);
        this.portMonitorLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.portMonitorLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.portMonitorLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.portMonitor = new JTextField(serialPortData.getPortMonTag(), 16);
        Constraints.constrain(this, this.portMonitor, 1, -1, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 10, 5);
        this.portMonitor.setMinimumSize(this.portMonitor.getPreferredSize());
        this.portMonitor.setFont(Constants.PROPS_RW_VALUE_FONT);
        this.portMonitor.addFocusListener(new SerialMgrContextHelpListener(genInfoPanel, "port"));
        this.portMonitorLabel.setLabelFor(this.portMonitor);
        actionString = new ActionString(resourceBundle, "AdvPropsServiceProgram");
        if (string.length() > 0 && serialPortData.isDeleted() && serialPortData.getServiceCmdLine().length() == 0) {
            serialPortData.setServiceCmdLine("/usr/bin/login");
        }
        this.serviceProgramLabel = new JLabel(actionString.getString());
        Constraints.constrain(this, this.serviceProgramLabel, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 10, 5);
        this.serviceProgramLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.serviceProgramLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.serviceProgramLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.serviceProgram = new JTextField(serialPortData.getServiceCmdLine(), 16);
        Constraints.constrain(this, this.serviceProgram, 1, -1, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 10, 5);
        this.serviceProgram.setMinimumSize(this.serviceProgram.getPreferredSize());
        this.serviceProgram.setFont(Constants.PROPS_RW_VALUE_FONT);
        this.serviceProgram.addFocusListener(new SerialMgrContextHelpListener(genInfoPanel, "service"));
        this.serviceProgramLabel.setLabelFor(this.serviceProgram);
        Constraints.constrain(this, new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), 0, -1, 1, 0, 3, 18, 0.0, 1.0, 0, 0, 0, 0);
        this.originalPortObj = serialPortData;
    }

    public void dialogDataExchange(Object object) throws SerialPortException {
        SerialPortData serialPortData = (SerialPortData)object;
        serialPortData.setSoftwareCarrier(this.swCarrierDetect.isSelected());
        serialPortData.setConnectOnCarrier(this.carrierConnect.isSelected());
        serialPortData.setBidirectional(this.biDirectional.isSelected());
        serialPortData.setInitialize(this.initializeOnly.isSelected());
        int n = this.timeout.getSelectedIndex();
        String string = (String)this.timeoutKeys.elementAt(n);
        if (string.indexOf("Timeout") >= 0) {
            String string2 = string.substring("Timeout".length());
            try {
                Integer.parseInt(string2);
                serialPortData.setTimeoutVal(string2);
            }
            catch (NumberFormatException numberFormatException) {
                serialPortData.setTimeoutVal("");
            }
        } else {
            serialPortData.setTimeoutVal(string);
        }
        try {
            serialPortData.validateTimeout();
        }
        catch (SerialPortException serialPortException) {
            this.timeout.requestFocus();
            throw serialPortException;
        }
        serialPortData.setPortMonTag(this.portMonitor.getText());
        try {
            serialPortData.validatePortMonitorTag();
        }
        catch (SerialPortException serialPortException) {
            this.portMonitor.requestFocus();
            throw serialPortException;
        }
        serialPortData.setServiceCmdLine(this.serviceProgram.getText());
        try {
            serialPortData.validateServiceCmdLine();
            return;
        }
        catch (SerialPortException serialPortException) {
            this.serviceProgram.requestFocus();
            throw serialPortException;
        }
    }

    public void dialogDataInitialize(Object object) {
    }

    public String getHelpName() {
        return "advancedtab";
    }
}

