/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.serialmgr.client;

import com.sun.admin.cis.client.AdminClientComponent;
import com.sun.admin.cis.client.AdminSession;
import com.sun.admin.cis.client.IClientComm;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.UnsupportedScopeTypeException;
import com.sun.admin.serialmgr.client.ContentPanel;
import com.sun.admin.serialmgr.client.MainMenuBar;
import com.sun.admin.serialmgr.client.MainToolBar;
import com.sun.admin.serialmgr.client.SerialActionsListener;
import com.sun.admin.serialmgr.client.SerialMgrTree;
import com.sun.admin.serialmgr.client.SerialPortMgrWrapper;
import java.awt.GridBagLayout;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class Main
extends JPanel
implements AdminClientComponent {
    private static Main theApp;
    private SerialPortMgrWrapper serialMgr;
    private MainMenuBar menuBar;
    private MainToolBar toolBar;
    private ContentPanel contentPanel;
    private IClientComm clientComm;
    private SerialMgrTree theTree;
    private ResourceBundle resourceBundle;
    private String[] serialMgrScopeTypes = new String[]{"file"};

    public Main(IClientComm iClientComm) throws Exception {
        theApp = this;
        this.clientComm = iClientComm;
        this.resourceBundle = ResourceBundle.getBundle("com.sun.admin.serialmgr.resources.ResourceBundle", Locale.getDefault());
        AdminSession adminSession = iClientComm.getAdminSession();
        String string = adminSession.getMgmtScope().getMgmtScopeType();
        boolean bl = false;
        int n = 0;
        while (n < this.serialMgrScopeTypes.length) {
            if (this.serialMgrScopeTypes[n].equals(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            throw new UnsupportedScopeTypeException(string, "com.sun.admin.serialmgr.client.Main");
        }
        this.setLayout(new GridBagLayout());
        this.serialMgr = new SerialPortMgrWrapper();
        this.serialMgr.setUpConnection(iClientComm);
        this.theTree = new SerialMgrTree();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.menuBar = new MainMenuBar();
        Constraints.constrain(jPanel, this.menuBar, 0, -1, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 20);
        this.menuBar.setBorderPainted(false);
        this.toolBar = new MainToolBar();
        Constraints.constrain(jPanel, this.toolBar, 1, -1, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        Constraints.constrain(this, jPanel, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
        this.contentPanel = this.theTree.getCurrentContentPanel();
        Constraints.constrain(this, this.contentPanel, 0, -1, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        this.registerKeyboardAction(new SerialActionsListener(), "Delete", KeyStroke.getKeyStroke(127, 0, true), 1);
        iClientComm.addToTreePanel(this.theTree);
        return;
    }

    public void setContentPanel(ContentPanel contentPanel) {
        this.remove(this.contentPanel);
        this.contentPanel = contentPanel;
        Constraints.constrain(this, this.contentPanel, 0, -1, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public static Main getApp() {
        return theApp;
    }

    public SerialPortMgrWrapper getSerialMgr() {
        return this.serialMgr;
    }

    public SerialMgrTree getTree() {
        return this.theTree;
    }

    public JFrame getFrame() {
        return this.clientComm.getFrame();
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void appReceivingMainFocus() {
        this.clientComm.addToMainView(this);
    }

    public void appLosingMainFocus() {
        this.theTree.removeSelectionRows(this.theTree.getSelectionRows());
        this.theTree.invalidate();
        this.theTree.validate();
        this.theTree.repaint();
        this.setStatusBar("");
    }

    public void appCloseDown() {
    }

    public void setHelp(String string) {
        try {
            URL uRL = new URL(this.clientComm.getHelpUrl("serialmgr", "serial_" + string + ".html"));
            this.clientComm.addToHelpPanel(uRL);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return;
        }
    }

    public void setStatusBar(String string) {
        this.clientComm.addToStatusPanel(string, 0);
    }

    public ImageIcon loadImageIcon(String string, String string2) {
        String string3 = "./images/";
        try {
            string3 = this.clientComm.getImagePath();
            string3 = String.valueOf(string3) + "/serialmgr/client/images/";
        }
        catch (Exception exception) {}
        String string4 = new String(String.valueOf(string3) + string);
        return new ImageIcon(string4, string2);
    }

    public IClientComm getClientComm() {
        return this.clientComm;
    }

    public void reportErrorException(Exception exception) {
        String string = "";
        while (exception != null) {
            if (exception instanceof AdminException) {
                AdminException adminException = (AdminException)exception;
                string = String.valueOf(string) + "\n" + adminException.getLocalizedMessage();
                if (adminException.isImbeddedException()) {
                    exception = adminException.getImbeddedException();
                    continue;
                }
                exception = null;
                continue;
            }
            string = String.valueOf(string) + "\n" + exception.getMessage();
            exception = null;
        }
        new ErrorDialog(this.getFrame(), ResourceStrings.getString(this.resourceBundle, "ErrorTitle"), string);
    }
}

