/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.serialmgr.client;

import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.CorkBoard;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.sort.Compare;
import com.sun.admin.cis.common.sort.Sort;
import com.sun.admin.serialmgr.client.AbstractIconModel;
import com.sun.admin.serialmgr.client.ListView;
import com.sun.admin.serialmgr.client.Main;
import com.sun.admin.serialmgr.common.SerialPortException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public abstract class AbstractIconView
extends ListView {
    private JPanel iconPanel;
    private boolean ascendSort = true;
    private Vector vButtons = new Vector();
    private Vector vSelectedBtns = new Vector();
    private int colLoc = 10;
    private int rowLoc = 10;
    private int rowHeight;
    ResourceBundle bundle = Main.getApp().getResourceBundle();
    private Vector dataCache = new Vector();
    private ButtonMouseListener buttonMouseListener = new ButtonMouseListener();

    protected abstract void onDoubleClick();

    protected abstract AbstractIconModel getIconModel();

    public AbstractIconView() {
        this.iconPanel = new JPanel();
        this.iconPanel.setBackground(Color.white);
        this.iconPanel.setLayout(new CorkBoard());
        JViewport jViewport = this.getViewport();
        jViewport.add(this.iconPanel);
    }

    public void setDataCache(Vector vector) {
        this.dataCache = vector;
    }

    public int getViewType() {
        return 1;
    }

    public void populate() {
        this.clear();
        String string = ResourceStrings.getString(this.bundle, "PopulateIconView");
        Object[] objectArray = new Object[2];
        objectArray[1] = new Integer(this.dataCache.size());
        int n = 0;
        while (n < this.dataCache.size()) {
            Object e = this.dataCache.elementAt(n);
            ImageIcon imageIcon = this.getIconModel().getIcon(e);
            this.vButtons.addElement(new IconButton(e, imageIcon));
            if ((n + 1) % 10 == 0) {
                objectArray[0] = new Integer(n + 1);
                Main.getApp().setStatusBar(MessageFormat.format(string, objectArray));
            }
            ++n;
        }
        this.paintView();
    }

    public void clear() {
        this.clearSelection();
        this.iconPanel.removeAll();
        this.iconPanel.invalidate();
        this.iconPanel.validate();
        this.iconPanel.repaint();
        Main.getApp().getFrame().invalidate();
        Main.getApp().getFrame().validate();
        Main.getApp().getFrame().repaint();
        this.vButtons.removeAllElements();
        System.gc();
        this.colLoc = 10;
        this.rowLoc = 10;
        this.rowHeight = 0;
    }

    public void append(Vector vector) {
        int n = 9999;
        int n2 = 0;
        while (n2 < vector.size()) {
            Object e = vector.elementAt(n2);
            this.dataCache.addElement(e);
            ImageIcon imageIcon = this.getIconModel().getIcon(e);
            IconButton iconButton = new IconButton(e, imageIcon);
            this.vButtons.addElement(iconButton);
            this.addIconButton(iconButton);
            Dimension dimension = iconButton.getPreferredSize();
            n = Math.min(n, dimension.height);
            ++n2;
        }
        this.getVerticalScrollBar().setUnitIncrement(n + 10);
        this.getHorizontalScrollBar().setUnitIncrement(this.getIconModel().getButtonWidth() + 10);
        this.iconPanel.invalidate();
        this.iconPanel.validate();
        this.iconPanel.repaint();
        Main.getApp().getFrame().invalidate();
        Main.getApp().getFrame().validate();
        Main.getApp().getFrame().repaint();
    }

    private void paintView() {
        int n = 9999;
        Sort.sort(this.vButtons, (Compare)new ClientDataCompare());
        this.fireSortChanged();
        Object[] objectArray = new Object[this.vSelectedBtns.size()];
        this.vSelectedBtns.copyInto(objectArray);
        this.clearSelection();
        this.iconPanel.removeAll();
        this.colLoc = 10;
        this.rowLoc = 10;
        this.rowHeight = 0;
        String string = ResourceStrings.getString(this.bundle, "PaintIconView");
        Object[] objectArray2 = new Object[2];
        objectArray2[1] = new Integer(this.vButtons.size());
        int n2 = 0;
        while (n2 < this.vButtons.size()) {
            IconButton iconButton = (IconButton)this.vButtons.elementAt(n2);
            this.addIconButton(iconButton);
            Dimension dimension = iconButton.getPreferredSize();
            n = Math.min(n, dimension.height);
            if ((n2 + 1) % 10 == 0) {
                objectArray2[0] = new Integer(n2 + 1);
                Main.getApp().setStatusBar(MessageFormat.format(string, objectArray2));
            }
            ++n2;
        }
        this.getVerticalScrollBar().setUnitIncrement(n + 10);
        this.getHorizontalScrollBar().setUnitIncrement(this.getIconModel().getButtonWidth() + 10);
        objectArray2[0] = new Integer(this.vButtons.size());
        Main.getApp().setStatusBar(MessageFormat.format(string, objectArray2));
        this.iconPanel.invalidate();
        this.iconPanel.validate();
        this.iconPanel.repaint();
        Main.getApp().getFrame().invalidate();
        Main.getApp().getFrame().validate();
        Main.getApp().getFrame().repaint();
        int n3 = 0;
        while (n3 < objectArray.length) {
            this.select((IconButton)objectArray[n3]);
            ++n3;
        }
    }

    private void addIconButton(IconButton iconButton) {
        iconButton.setBorderPainted(false);
        iconButton.setFocusPainted(false);
        iconButton.setBackground(Color.white);
        iconButton.setHorizontalTextPosition(0);
        iconButton.setVerticalTextPosition(3);
        iconButton.setHorizontalAlignment(0);
        iconButton.setVerticalAlignment(3);
        iconButton.setMargin(new Insets(0, 0, 0, 0));
        Dimension dimension = iconButton.getPreferredSize();
        dimension.width = this.getIconModel().getButtonWidth();
        iconButton.setPreferredSize(dimension);
        iconButton.removeMouseListener(this.buttonMouseListener);
        iconButton.addMouseListener(this.buttonMouseListener);
        Dimension dimension2 = iconButton.getPreferredSize();
        this.rowHeight = Math.max(this.rowHeight, dimension2.height);
        if (this.colLoc + dimension2.width + 10 >= this.getViewport().getBounds().width) {
            this.colLoc = 10;
            this.rowLoc += this.rowHeight + 10;
            this.rowHeight = 0;
        }
        iconButton.setLocation(this.colLoc, this.rowLoc);
        this.colLoc += dimension2.width + 10;
        this.iconPanel.add(iconButton);
    }

    private void handlePopupTrigger(MouseEvent mouseEvent) {
        IconButton iconButton = (IconButton)mouseEvent.getComponent();
        if (!iconButton.isSelected()) {
            this.clearSelection();
            this.select(iconButton);
        }
        this.firePopupTriggered(SwingUtilities.convertMouseEvent(iconButton, mouseEvent, this.getViewport()));
    }

    private void select(IconButton iconButton) {
        Main.getApp().setHelp(this.getIconModel().getHelpName(iconButton.getClientData()));
        if (iconButton.isSelected()) {
            return;
        }
        iconButton.setBackground(Constants.ICONCOLOR);
        iconButton.setSelected(true);
        this.vSelectedBtns.addElement(iconButton);
        this.fireItemPressed(0);
    }

    public void clearSelection() {
        int n = 0;
        while (n < this.vSelectedBtns.size()) {
            IconButton iconButton = (IconButton)this.vSelectedBtns.elementAt(n);
            iconButton.setBackground(Color.white);
            iconButton.setSelected(false);
            ++n;
        }
        this.vSelectedBtns.removeAllElements();
        this.fireItemPressed(0);
    }

    public void unselect(IconButton iconButton) {
        if (!iconButton.isSelected()) {
            return;
        }
        iconButton.setBackground(Color.white);
        iconButton.setSelected(false);
        int n = this.vSelectedBtns.indexOf(iconButton);
        if (n < 0) {
            return;
        }
        this.vSelectedBtns.removeElementAt(n);
        this.fireItemPressed(0);
    }

    public void selectAll() {
        this.vSelectedBtns.removeAllElements();
        int n = 0;
        while (n < this.vButtons.size()) {
            IconButton iconButton = (IconButton)this.vButtons.elementAt(n);
            iconButton.setBackground(Constants.ICONCOLOR);
            iconButton.setSelected(true);
            this.vSelectedBtns.addElement(iconButton);
            ++n;
        }
        this.fireItemPressed(0);
    }

    public Vector getSelected() {
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < this.vSelectedBtns.size()) {
            IconButton iconButton = (IconButton)this.vSelectedBtns.elementAt(n);
            vector.addElement(iconButton.getClientData());
            ++n;
        }
        return vector;
    }

    public void setSelected(Vector vector) {
        if (this.vButtons.size() == 0) {
            return;
        }
        this.clearSelection();
        if (vector.size() == 0) {
            return;
        }
        int n = 0;
        while (n < this.vButtons.size()) {
            IconButton iconButton = (IconButton)this.vButtons.elementAt(n);
            Object object = iconButton.getClientData();
            if (vector.indexOf(object) >= 0) {
                this.select(iconButton);
            }
            ++n;
        }
    }

    public int getNumSelections() {
        return this.vSelectedBtns.size();
    }

    public void sortAscending() {
        if (this.ascendSort) {
            return;
        }
        this.ascendSort = true;
        1 var1_1 = new 1();
        var1_1.start();
    }

    public void sortDescending() {
        if (!this.ascendSort) {
            return;
        }
        this.ascendSort = false;
        2 var1_1 = new 2();
        var1_1.start();
    }

    public void sortByAttribute(String string) {
    }

    public int getSortOrder() {
        if (this.ascendSort) {
            return 3;
        }
        return 4;
    }

    public void find(String string) {
        if (this.vButtons.size() == 0) {
            return;
        }
        int n = -1;
        if (this.getNumSelections() > 0) {
            IconButton iconButton = (IconButton)this.vSelectedBtns.elementAt(this.getNumSelections() - 1);
            n = this.vButtons.indexOf(iconButton);
        }
        int n2 = 0;
        while (n2++ < this.vButtons.size()) {
            if (++n == this.vButtons.size()) {
                n = 0;
            }
            IconButton iconButton = (IconButton)this.vButtons.elementAt(n);
            Object object = iconButton.getClientData();
            String string2 = this.getIconModel().getIconLabel(object);
            if (string2.length() == 0 || string2.indexOf(string) < 0) continue;
            this.clearSelection();
            this.select(iconButton);
            JViewport jViewport = this.getViewport();
            jViewport.setViewPosition(new Point(0, 0));
            jViewport.scrollRectToVisible(new Rectangle(iconButton.getLocation(null), iconButton.getPreferredSize()));
            return;
        }
        Main.getApp().reportErrorException(new SerialPortException("EXM_SPRT_GUI_FIND_FAILED", string));
    }

    public void find(Object object) {
        if (this.vButtons.size() == 0) {
            return;
        }
        int n = 0;
        while (n < this.vButtons.size()) {
            IconButton iconButton = (IconButton)this.vButtons.elementAt(n);
            Object object2 = iconButton.getClientData();
            if (object2 == object) {
                this.clearSelection();
                this.select(iconButton);
                JViewport jViewport = this.getViewport();
                jViewport.setViewPosition(new Point(0, 0));
                jViewport.scrollRectToVisible(new Rectangle(iconButton.getLocation(null), iconButton.getPreferredSize()));
                return;
            }
            ++n;
        }
    }

    private class IconButton
    extends JButton {
        private Object clientData;

        public IconButton(Object object, ImageIcon imageIcon) {
            super(imageIcon);
            AbstractIconView.this = AbstractIconView.this;
            this.clientData = object;
            this.setText(AbstractIconView.this.getIconModel().getIconLabel(object));
        }

        public Object getClientData() {
            return this.clientData;
        }
    }

    class ButtonMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                AbstractIconView.this.handlePopupTrigger(mouseEvent);
                return;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                IconButton iconButton = (IconButton)mouseEvent.getComponent();
                if (mouseEvent.isControlDown()) {
                    if (iconButton.isSelected()) {
                        AbstractIconView.this.unselect(iconButton);
                        return;
                    }
                    AbstractIconView.this.select(iconButton);
                    return;
                }
                AbstractIconView.this.clearSelection();
                AbstractIconView.this.select(iconButton);
                if (mouseEvent.getClickCount() == 2) {
                    AbstractIconView.this.onDoubleClick();
                }
                return;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                AbstractIconView.this.handlePopupTrigger(mouseEvent);
                return;
            }
        }

        ButtonMouseListener() {
            AbstractIconView.this = AbstractIconView.this;
        }
    }

    private final class 1
    extends Thread {
        public void run() {
            Main.getApp().getClientComm().waitOn();
            AbstractIconView.this.paintView();
            Main.getApp().getClientComm().waitOff();
            Main.getApp().getTree().getCurrentContentPanel().updateStatusBar();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends Thread {
        public void run() {
            Main.getApp().getClientComm().waitOn();
            AbstractIconView.this.paintView();
            Main.getApp().getClientComm().waitOff();
            Main.getApp().getTree().getCurrentContentPanel().updateStatusBar();
        }

        /* synthetic */ 2() {
        }
    }

    private class ClientDataCompare
    implements Compare {
        public int doCompare(Object object, Object object2) {
            Object object3 = ((IconButton)object).getClientData();
            Object object4 = ((IconButton)object2).getClientData();
            int n = AbstractIconView.this.getIconModel().compare(object3, object4);
            if (n != 0) {
                if (AbstractIconView.this.getSortOrder() == 3) {
                    return n;
                }
                return -n;
            }
            return 0;
        }

        ClientDataCompare() {
            AbstractIconView.this = AbstractIconView.this;
        }
    }
}

