/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.server;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.AdminMgmtScope;
import com.sun.admin.cis.common.FilterItem;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.QuickVector;
import com.sun.admin.cis.server.AdminFactoryImpl;
import com.sun.admin.cis.server.AdminServerImpl;
import com.sun.admin.cis.service.authorization.AuthNoAccessException;
import com.sun.admin.cis.service.directorytable.DirectoryFilter;
import com.sun.admin.cis.service.directorytable.DirectoryRow;
import com.sun.admin.cis.service.directorytable.DirectoryTable;
import com.sun.admin.cis.service.directorytable.DirectoryTableAccessException;
import com.sun.admin.cis.service.directorytable.DirectoryTableConnectionException;
import com.sun.admin.cis.service.directorytable.DirectoryTableDoesNotExistException;
import com.sun.admin.cis.service.directorytable.DirectoryTableException;
import com.sun.admin.cis.service.directorytable.DirectoryTableFactory;
import com.sun.admin.cis.service.directorytable.DirectoryTableRowNotFoundException;
import com.sun.admin.cis.service.directorytable.DirectoryTableRowNotUniqueException;
import com.sun.admin.cis.service.directorytable.TableDefinitions;
import com.sun.admin.cis.service.logging.AdminLogException;
import com.sun.admin.cis.service.logging.LogRecord;
import com.sun.admin.cis.service.logging.LogServiceFactoryImpl;
import com.sun.admin.cis.service.security.SecurityToken;
import com.sun.admin.hostmgr.common.HostData;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.admin.hostmgr.common.HostWarningException;
import com.sun.admin.hostmgr.common.NetworkData;
import com.sun.admin.hostmgr.server.HostMgr;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Vector;

public class HostMgrImpl
extends AdminFactoryImpl
implements HostMgr {
    private static final boolean LOG_SYSLOG = true;
    private static final String LOCAL_HOST_NAME = "localhost";
    private static final boolean EXPOSE_BAD_NETWORKS = true;
    private int ethersColumnAddr;
    private int ethersColumnName;
    private int ethersColumnComment;
    private int hostsColumnAddr;
    private int hostsColumnCname;
    private int hostsColumnAliases;
    private int hostsColumnComment;
    private int netmasksColumnAddr;
    private int netmasksColumnMask;
    private int netmasksColumnComment;
    private int networksColumnCname;
    private int networksColumnAddr;
    private int networksColumnAliases;
    private int networksColumnComment;
    private DirectoryRow etherListRow;
    private DirectoryRow etherMatchRow;
    private DirectoryRow hostListRow;
    private DirectoryRow netmaskListRow;
    private int chunkSize;
    private boolean sortAscending = true;
    private int hostListLimit = 1;
    private int hostListIndex = 1;
    private int hostListIncrement = 1;
    private int etherListLimit = 1;
    private int etherListIndex = 1;
    private TableDefinitions ethersTableDefn;
    private AdminServerImpl adminSvr;
    private AdminMgmtScope scope;
    private LogServiceFactoryImpl logService;
    private String scopeUserName = "";
    private String scopeClientHost = "";
    private String scopeHostName = "";
    private static final String[] rights = new String[]{"solaris.admin.hostmgr.write"};

    protected String[] myAuthRights() {
        return rights;
    }

    public HostMgrImpl(AdminServerImpl adminServerImpl) throws RemoteException, AdminException {
        super(adminServerImpl);
        this.adminSvr = adminServerImpl;
        this.logService = (LogServiceFactoryImpl)adminServerImpl.getServiceImpl("com.sun.admin.cis.service.logging.LogServiceFactoryImpl");
    }

    public void initializeScope(SecurityToken securityToken) throws RemoteException, AdminException {
        DirectoryTable directoryTable = null;
        String string = "unknown";
        TableDefinitions tableDefinitions = null;
        TableDefinitions tableDefinitions2 = null;
        TableDefinitions tableDefinitions3 = null;
        TableDefinitions tableDefinitions4 = null;
        this.scope = this.adminSvr.getMgmtScope(securityToken);
        try {
            this.scopeUserName = this.adminSvr.getUserName(securityToken);
            this.scopeClientHost = this.adminSvr.getClientHost(securityToken);
            this.scopeHostName = this.adminSvr.getHostName();
            directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
            tableDefinitions = directoryTable.getTableDefinitionsInstance();
            string = "ethers";
            tableDefinitions.loadTableDefinitions("ethers");
            this.ethersColumnAddr = tableDefinitions.getColumnNumber("addr");
            this.ethersColumnName = tableDefinitions.getColumnNumber("name");
            this.ethersColumnComment = tableDefinitions.getColumnNumber("comment");
            tableDefinitions2 = directoryTable.getTableDefinitionsInstance();
            string = "hosts";
            tableDefinitions2.loadTableDefinitions("hosts");
            this.hostsColumnAddr = tableDefinitions2.getColumnNumber("addr");
            this.hostsColumnCname = tableDefinitions2.getColumnNumber("cname");
            this.hostsColumnAliases = tableDefinitions2.getColumnNumber("aliases");
            this.hostsColumnComment = tableDefinitions2.getColumnNumber("comment");
            tableDefinitions3 = directoryTable.getTableDefinitionsInstance();
            string = "netmasks";
            tableDefinitions3.loadTableDefinitions("netmasks");
            this.netmasksColumnAddr = tableDefinitions3.getColumnNumber("addr");
            this.netmasksColumnMask = tableDefinitions3.getColumnNumber("mask");
            this.netmasksColumnComment = tableDefinitions3.getColumnNumber("comment");
            tableDefinitions4 = directoryTable.getTableDefinitionsInstance();
            string = "networks";
            tableDefinitions4.loadTableDefinitions("networks");
            this.networksColumnCname = tableDefinitions4.getColumnNumber("cname");
            this.networksColumnAddr = tableDefinitions4.getColumnNumber("addr");
            this.networksColumnAliases = tableDefinitions4.getColumnNumber("aliases");
            this.networksColumnComment = tableDefinitions4.getColumnNumber("comment");
            return;
        }
        catch (DirectoryTableAccessException directoryTableAccessException) {
            this.logDirTableException(securityToken, "LM_3202", string, directoryTableAccessException);
            HostException hostException = new HostException("EXM_HST_SRV30");
            throw new HostException("EXM_HST_SRV28", hostException);
        }
        catch (DirectoryTableConnectionException directoryTableConnectionException) {
            this.logDirTableException(securityToken, "LM_3203", string, directoryTableConnectionException);
            HostException hostException = new HostException("EXM_HST_SRV31");
            throw new HostException("EXM_HST_SRV28", hostException);
        }
        catch (DirectoryTableException directoryTableException) {
            this.logDirTableException(securityToken, "LM_3010", string, directoryTableException);
            HostException hostException = new HostException("EXM_HST_SRV32");
            throw new HostException("EXM_HST_SRV28", hostException);
        }
    }

    private void writeLog(SecurityToken securityToken, int n, String string, String string2, String[] stringArray, boolean bl) throws AdminException {
        if (this.logService == null) {
            return;
        }
        try {
            Vector<String> vector = new Vector<String>(stringArray.length);
            int n2 = 0;
            while (n2 < stringArray.length) {
                vector.addElement(stringArray[n2]);
                ++n2;
            }
            LogRecord logRecord = new LogRecord("LM_HOST_APP_NAME", 0, n, this.scopeUserName, this.scopeClientHost, this.scopeHostName, string, string2, vector, this.adminSvr.getMgmtScope(securityToken));
            this.logService.writeRecord(logRecord, bl);
            return;
        }
        catch (AdminLogException adminLogException) {
            throw adminLogException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
    }

    private void writeLog(SecurityToken securityToken, int n, String string, String string2, String[] stringArray, Vector vector, Vector vector2, boolean bl) throws AdminException {
        if (this.logService == null) {
            return;
        }
        try {
            Vector<String> vector3 = new Vector<String>(stringArray.length);
            int n2 = 0;
            while (n2 < stringArray.length) {
                vector3.addElement(stringArray[n2]);
                ++n2;
            }
            LogRecord logRecord = new LogRecord("LM_HOST_APP_NAME", 0, n, this.scopeUserName, this.scopeClientHost, this.scopeHostName, string, string2, vector3, this.adminSvr.getMgmtScope(securityToken));
            if (vector != null && vector2 != null) {
                logRecord.addData(vector, vector2);
            }
            this.logService.writeRecord(logRecord, bl);
            return;
        }
        catch (AdminLogException adminLogException) {
            throw adminLogException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
    }

    private void logDirTableException(SecurityToken securityToken, String string, String string2, Exception exception) throws AdminException {
        if (this.logService == null) {
            return;
        }
        try {
            LogRecord logRecord = new LogRecord("LM_HOST_APP_NAME", 0, 2, this.scopeUserName, this.scopeClientHost, this.scopeHostName, string, "LM_3200", null, this.adminSvr.getMgmtScope(securityToken));
            Vector<String> vector = new Vector<String>(4);
            Vector<String> vector2 = new Vector<String>(4);
            vector.addElement("Scope type");
            vector2.addElement(this.scope.getMgmtScopeType());
            vector.addElement("Scope name");
            vector2.addElement(this.scope.getMgmtScopeName());
            vector.addElement("Table name");
            vector2.addElement(string2);
            vector.addElement("Error message");
            vector2.addElement(exception.getMessage());
            logRecord.addData(vector, vector2);
            this.logService.writeRecord(logRecord, false);
            return;
        }
        catch (AdminLogException adminLogException) {
            throw adminLogException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
    }

    private void logException(SecurityToken securityToken, String string, String string2, Exception exception) throws AdminException {
        if (this.logService == null) {
            return;
        }
        try {
            LogRecord logRecord = new LogRecord("LM_HOST_APP_NAME", 0, 2, this.scopeUserName, this.scopeClientHost, this.scopeHostName, string, "LM_3201", null, this.adminSvr.getMgmtScope(securityToken));
            Vector<String> vector = new Vector<String>(2);
            Vector<String> vector2 = new Vector<String>(2);
            vector.addElement("Method:");
            vector2.addElement(string2);
            vector.addElement("Exception message:");
            vector2.addElement(exception.getMessage());
            logRecord.addData(vector, vector2);
            this.logService.writeRecord(logRecord, false);
            return;
        }
        catch (AdminLogException adminLogException) {
            throw adminLogException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
    }

    private void logInternalError(SecurityToken securityToken, String string, String string2, String string3) throws AdminException {
        if (this.logService == null) {
            return;
        }
        try {
            LogRecord logRecord = new LogRecord("LM_HOST_APP_NAME", 0, 2, this.scopeUserName, this.scopeClientHost, this.scopeHostName, string, "LM_3204", null, this.adminSvr.getMgmtScope(securityToken));
            Vector<String> vector = new Vector<String>(2);
            Vector<String> vector2 = new Vector<String>(2);
            vector.addElement("Method:");
            vector2.addElement(string2);
            vector.addElement("Reason for error:");
            vector2.addElement(string3);
            logRecord.addData(vector, vector2);
            this.logService.writeRecord(logRecord, false);
            return;
        }
        catch (AdminLogException adminLogException) {
            throw adminLogException;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
    }

    private NetworkData getNetworkLocal(SecurityToken securityToken, NetworkData networkData) throws RemoteException, AdminException {
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "getNetwork");
        }
        DirectoryFilter directoryFilter = new DirectoryFilter(2);
        DirectoryTable directoryTable = null;
        NetworkData networkData2 = null;
        String string = "";
        if (networkData.isNetwork()) {
            string = this.getNetmask(securityToken, networkData);
        }
        if (networkData.getNetworkName().length() == 0) {
            if (string.length() > 0) {
                networkData2 = new NetworkData(networkData.getNetworkAddress());
                networkData2.setNetmask(string);
            }
            return networkData2;
        }
        try {
            block20: {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("networks");
                    directoryTable.open(tableDefinitions);
                    String string2 = networkData.convertLongToAddress(networkData.getNetworkAddressLong());
                    directoryFilter.add(this.networksColumnAddr, 1, 5, string2);
                    directoryFilter.add(this.networksColumnAddr, 3, 3, String.valueOf(string2) + ".");
                    DirectoryRow directoryRow = directoryTable.getAll(directoryFilter);
                    if (directoryRow == null) break block20;
                    int n = 1;
                    while (n <= directoryRow.getNumberOfRows()) {
                        block21: {
                            try {
                                NetworkData.validateIPAddress(directoryRow.getColumn(this.networksColumnAddr, n));
                            }
                            catch (Exception exception) {
                                break block21;
                            }
                            if (networkData.getNetworkName().equals(directoryRow.getColumn(this.networksColumnCname, n)) && networkData.netAddrCompare(networkData2 = new NetworkData(directoryRow.getColumn(this.networksColumnAddr, n))) == 0) {
                                networkData2.setNetworkName(directoryRow.getColumn(this.networksColumnCname, n));
                                networkData2.setAliases(directoryRow.getColumn(this.networksColumnAliases, n));
                                networkData2.setDescription(directoryRow.getColumn(this.networksColumnComment, n));
                                networkData2.setNetmask(string);
                                break;
                            }
                        }
                        ++n;
                    }
                }
                catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                    HostException hostException = new HostException("EXM_HST_SRV42");
                    throw new HostException("EXM_HST_SRV1", hostException);
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    this.logDirTableException(securityToken, "LM_3202", "networks", directoryTableAccessException);
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    throw new HostException("EXM_HST_SRV1", hostException);
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    this.logDirTableException(securityToken, "LM_3203", "networks", directoryTableConnectionException);
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    throw new HostException("EXM_HST_SRV1", hostException);
                }
                catch (DirectoryTableException directoryTableException) {
                    this.logDirTableException(securityToken, "LM_3106", "networks", directoryTableException);
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    throw new HostException("EXM_HST_SRV1", hostException);
                }
                catch (Exception exception) {
                    this.logException(securityToken, "LM_3106", "getNetwork", exception);
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    throw new HostException("EXM_HST_SRV1", hostException);
                }
            }
            Object var13_21 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var13_22 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        return networkData2;
    }

    public NetworkData getNetwork(SecurityToken securityToken, NetworkData networkData) throws RemoteException, AdminException {
        Object[] objectArray = null;
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "getNetwork");
        }
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "getNetwork");
        }
        return this.getNetworkLocal(securityToken, networkData);
    }

    public NetworkData getNetworkByAddr(SecurityToken securityToken, String string) throws RemoteException, AdminException {
        Object[] objectArray = null;
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "getNetworkByAddr");
        }
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "getNetworkByAddr");
        }
        DirectoryTable directoryTable = null;
        NetworkData networkData = new NetworkData();
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("networks");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.networksColumnAddr, string);
                DirectoryRow directoryRow2 = directoryTable.getFirstRow(directoryRow);
                if (directoryRow2 == null) {
                    networkData.setNetworkAddress(string);
                    if (networkData.isNetwork()) {
                        networkData.setNetmask(this.getNetmask(securityToken, networkData));
                        if (networkData.getNetmask().length() == 0) {
                            networkData = null;
                        }
                    } else {
                        networkData = null;
                    }
                } else {
                    networkData.setNetworkAddress(directoryRow2.getColumn(this.networksColumnAddr));
                    networkData.setNetworkName(directoryRow2.getColumn(this.networksColumnCname));
                    networkData.setAliases(directoryRow2.getColumn(this.networksColumnAliases));
                    networkData.setDescription(directoryRow2.getColumn(this.networksColumnComment));
                    if (networkData.isNetwork()) {
                        networkData.setNetmask(this.getNetmask(securityToken, networkData));
                    }
                }
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV42");
                throw new HostException("EXM_HST_SRV1", hostException);
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "networks", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV1", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "networks", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV1", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3106", "networks", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV1", hostException);
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_SRV1", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3106", "getNetworkByAddr", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV1", hostException);
            }
            Object var12_20 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var12_21 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        return networkData;
    }

    public Vector listNetworks(SecurityToken securityToken, ListProperties listProperties) throws RemoteException, AdminException {
        DirectoryRow directoryRow;
        Object[] objectArray = null;
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "listNetworks");
        }
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "listNetworks");
        }
        if (listProperties == null) {
            this.logInternalError(securityToken, "LM_3107", "listNetworks", "listProps == null");
            throw new HostException("EXM_HST_SRV2", new HostException("EXM_HST_SRV99"));
        }
        if (!listProperties.hasCustomBooleanArg1BeenSet()) {
            this.logInternalError(securityToken, "LM_3107", "listNetworks", "listProps.hasCustomBooleanArg1BeenSet() == false");
            throw new HostException("EXM_HST_SRV2", new HostException("EXM_HST_SRV99"));
        }
        int n = 0;
        long l = 0L;
        DirectoryTable directoryTable = null;
        NetworkData networkData = null;
        QuickVector quickVector = new QuickVector();
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("networks");
                directoryTable.open(tableDefinitions);
                directoryRow = directoryTable.getAll();
                if (directoryRow != null) {
                    directoryRow.sortByColumn(this.networksColumnAddr, tableDefinitions);
                    n = directoryRow.getNumberOfRows();
                    networkData = new NetworkData();
                }
                int n2 = 1;
                while (n2 <= n) {
                    String string = directoryRow.getColumn(this.networksColumnAddr, n2);
                    try {
                        NetworkData.validateIPAddress(string);
                    }
                    catch (Exception exception) {}
                    networkData.setNetworkAddress(string);
                    if (networkData.isNetwork() || l != networkData.getNetIdLong()) {
                        if (networkData.isNetwork()) {
                            networkData.setNetworkName(directoryRow.getColumn(this.networksColumnCname, n2));
                            networkData.setAliases(directoryRow.getColumn(this.networksColumnAliases, n2));
                            networkData.setDescription(directoryRow.getColumn(this.networksColumnComment, n2));
                            networkData.setNetmask(this.getNetmask(securityToken, networkData));
                        } else {
                            networkData.setNetworkAddress(networkData.getNetId());
                        }
                        networkData.setNetmask(this.getNetmask(securityToken, networkData));
                        l = networkData.getNetIdLong();
                        quickVector.addElement(networkData);
                        networkData = new NetworkData();
                    }
                    ++n2;
                }
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "networks", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV2", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "networks", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV2", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3107", "networks", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV2", hostException);
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_SRV2", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3107", "listNetworks", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV2", hostException);
            }
            Object var16_23 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var16_24 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        directoryRow = null;
        if (listProperties.getCustomBooleanArg1()) {
            this.listHostNetworks(securityToken, quickVector);
        }
        this.listNetmaskNetworks(securityToken, quickVector);
        if (!listProperties.isSortOrderAscending()) {
            int n3 = quickVector.size() / 2;
            int n4 = 0;
            while (n4 < n3) {
                quickVector.quickSwapElementsAt(n4, quickVector.size() - n4 - 1);
                ++n4;
            }
        }
        return quickVector;
    }

    private void listHostNetworks(SecurityToken securityToken, QuickVector quickVector) throws RemoteException, AdminException {
        int n = 0;
        DirectoryTable directoryTable = null;
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("hosts");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getAll();
                if (directoryRow == null) {
                    Object var14_7 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    return;
                }
                NetworkData networkData = quickVector.size() > 0 ? (NetworkData)quickVector.quickElementAt(0) : new NetworkData("255");
                int n2 = 1;
                while (n2 <= directoryRow.getNumberOfRows()) {
                    block24: {
                        try {
                            NetworkData.validateIPAddress(directoryRow.getColumn(this.hostsColumnAddr, n2));
                        }
                        catch (Exception exception) {
                            break block24;
                        }
                        NetworkData networkData2 = new NetworkData(directoryRow.getColumn(this.hostsColumnAddr, n2));
                        if (networkData2.netIdCompare(networkData) != 0) {
                            boolean bl;
                            n = 0;
                            if (n < quickVector.size()) {
                                boolean bl2 = false;
                                bl = false;
                                networkData = (NetworkData)quickVector.quickElementAt(n);
                                while (!bl2) {
                                    int n3 = networkData2.netIdCompare(networkData);
                                    if (n3 == 0) {
                                        bl2 = true;
                                        continue;
                                    }
                                    if (n3 > 0) {
                                        if (++n < quickVector.size()) {
                                            networkData = (NetworkData)quickVector.quickElementAt(n);
                                            continue;
                                        }
                                        bl = true;
                                        bl2 = true;
                                        continue;
                                    }
                                    bl = true;
                                    bl2 = true;
                                }
                            } else {
                                bl = true;
                            }
                            if (bl) {
                                if (!networkData2.isNetwork()) {
                                    networkData2.setNetworkAddress(networkData2.getNetId());
                                }
                                networkData2.setNetmask(this.getNetmask(securityToken, networkData2));
                                quickVector.insertElementAt(networkData2, n);
                                networkData = networkData2;
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "hosts", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV2", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "hosts", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV2", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3107", "hosts", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV2", hostException);
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_SRV2", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3107", "listHostNetworks", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV2", hostException);
            }
        }
        catch (Throwable throwable) {
            block25: {
                Object var14_9 = null;
                if (directoryTable == null) break block25;
                directoryTable.close();
            }
            throw throwable;
        }
        Object var14_8 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
    }

    private void listNetmaskNetworks(SecurityToken securityToken, QuickVector quickVector) throws RemoteException, AdminException {
        int n = 0;
        DirectoryTable directoryTable = null;
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("netmasks");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getAll();
                if (directoryRow == null) {
                    Object var14_7 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    return;
                }
                directoryRow.sortByColumn(this.netmasksColumnAddr, tableDefinitions);
                NetworkData networkData = quickVector.size() > 0 ? (NetworkData)quickVector.quickElementAt(0) : new NetworkData("255");
                int n2 = 1;
                while (n2 <= directoryRow.getNumberOfRows()) {
                    block23: {
                        boolean bl;
                        try {
                            NetworkData.validateIPAddress(directoryRow.getColumn(this.netmasksColumnAddr, n2));
                        }
                        catch (Exception exception) {
                            break block23;
                        }
                        NetworkData networkData2 = new NetworkData(directoryRow.getColumn(this.netmasksColumnAddr, n2));
                        if (n < quickVector.size()) {
                            boolean bl2 = false;
                            bl = false;
                            while (!bl2) {
                                int n3 = networkData2.netIdCompare(networkData);
                                if (n3 == 0) {
                                    bl2 = true;
                                    continue;
                                }
                                if (n3 > 0) {
                                    if (++n < quickVector.size()) {
                                        networkData = (NetworkData)quickVector.quickElementAt(n);
                                        continue;
                                    }
                                    bl = true;
                                    bl2 = true;
                                    continue;
                                }
                                bl = true;
                                bl2 = true;
                            }
                        } else {
                            bl = true;
                        }
                        if (bl) {
                            if (!networkData2.isNetwork()) {
                                networkData2.setNetworkAddress(networkData2.getNetId());
                            }
                            networkData2.setNetmask(this.getNetmask(securityToken, networkData2));
                            quickVector.insertElementAt(networkData2, n);
                            networkData = networkData2;
                        }
                    }
                    ++n2;
                }
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "netmasks", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV2", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "netmasks", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV2", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3107", "netmasks", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV2", hostException);
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_SRV2", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3107", "listNetmaskNetworks", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV2", hostException);
            }
        }
        catch (Throwable throwable) {
            block24: {
                Object var14_9 = null;
                if (directoryTable == null) break block24;
                directoryTable.close();
            }
            throw throwable;
        }
        Object var14_8 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
    }

    public Vector listNetworkSubnets(SecurityToken securityToken, NetworkData networkData, ListProperties listProperties) throws RemoteException, AdminException {
        DirectoryRow directoryRow;
        Object[] objectArray = null;
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "listNetworkSubnets");
        }
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "listNetworkSubnets");
        }
        if (networkData == null) {
            this.logInternalError(securityToken, "LM_3108", "listNetworkSubnets", "networkData == null");
            throw new HostException("EXM_HST_SRV2", new HostException("EXM_HST_SRV99"));
        }
        if (listProperties == null) {
            this.logInternalError(securityToken, "LM_3108", "listNetworkSubnets", "listProps == null");
            throw new HostException("EXM_HST_SRV2", new HostException("EXM_HST_SRV99"));
        }
        if (!listProperties.hasCustomBooleanArg1BeenSet()) {
            this.logInternalError(securityToken, "LM_3108", "listNetworkSubnets", "listProps.hasCustomBooleanArg1BeenSet() == false");
            throw new HostException("EXM_HST_SRV2", new HostException("EXM_HST_SRV99"));
        }
        int n = 0;
        DirectoryTable directoryTable = null;
        NetworkData networkData2 = new NetworkData();
        QuickVector quickVector = new QuickVector();
        String string = networkData.getNetId();
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("networks");
                directoryTable.open(tableDefinitions);
                directoryRow = directoryTable.getAll();
                if (directoryRow != null) {
                    n = directoryRow.getNumberOfRows();
                }
                int n2 = 1;
                while (n2 <= n) {
                    block30: {
                        String string2 = directoryRow.getColumn(this.networksColumnAddr, n2);
                        try {
                            NetworkData.validateIPAddress(string2);
                        }
                        catch (Exception exception) {
                            break block30;
                        }
                        if (string2.startsWith(String.valueOf(string) + ".")) {
                            networkData2.setNetworkAddress(string2);
                            if (!networkData2.isNetwork()) {
                                int n3 = quickVector.size();
                                int n4 = 0;
                                while (n4 < quickVector.size()) {
                                    NetworkData networkData3 = (NetworkData)quickVector.quickElementAt(n4);
                                    int n5 = networkData3.netAddrCompare(networkData2);
                                    if (n5 == 0) {
                                        n3 = -1;
                                        break;
                                    }
                                    if (n5 > 0) {
                                        n3 = n4;
                                        break;
                                    }
                                    ++n4;
                                }
                                if (n3 >= 0) {
                                    networkData2.setNetworkName(directoryRow.getColumn(this.networksColumnCname, n2));
                                    networkData2.setAliases(directoryRow.getColumn(this.networksColumnAliases, n2));
                                    networkData2.setDescription(directoryRow.getColumn(this.networksColumnComment, n2));
                                    networkData2.setNetmaskForSubnet(networkData.getNetmask());
                                    quickVector.insertElementAt(networkData2, n3);
                                    networkData2 = new NetworkData();
                                }
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "networks", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV3", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "networks", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV3", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3108", "networks", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV3", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3108", "listNetworkSubnets", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV3", hostException);
            }
            Object var19_27 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var19_28 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        directoryRow = null;
        networkData.setNetmask(this.getNetmask(securityToken, networkData));
        if (listProperties.getCustomBooleanArg1()) {
            this.listHostSubnets(securityToken, quickVector, networkData);
        }
        if (!listProperties.isSortOrderAscending()) {
            int n6 = quickVector.size() / 2;
            int n7 = 0;
            while (n7 < n6) {
                quickVector.quickSwapElementsAt(n7, quickVector.size() - n7 - 1);
                ++n7;
            }
        }
        return quickVector;
    }

    private Vector listHostSubnets(SecurityToken securityToken, QuickVector quickVector, NetworkData networkData) throws RemoteException, AdminException {
        int n = 0;
        DirectoryTable directoryTable = null;
        NetworkData networkData2 = new NetworkData();
        long l = networkData.getNetmaskLong();
        if (l == 0L) {
            return quickVector;
        }
        String string = networkData.getNetId();
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("hosts");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getAll();
                if (directoryRow != null) {
                    n = directoryRow.getNumberOfRows();
                }
                int n2 = 1;
                while (n2 <= n) {
                    block21: {
                        String string2 = directoryRow.getColumn(this.hostsColumnAddr, n2);
                        try {
                            NetworkData.validateIPAddress(string2);
                        }
                        catch (Exception exception) {
                            break block21;
                        }
                        if (string2.startsWith(String.valueOf(string) + ".")) {
                            networkData2.setNetworkAddress(string2);
                            long l2 = l & networkData2.getNetworkAddressLong();
                            networkData2.setNetworkAddress(networkData2.convertLongToAddress(l2));
                            if (!networkData2.isNetwork()) {
                                int n3 = quickVector.size();
                                int n4 = 0;
                                while (n4 < quickVector.size()) {
                                    NetworkData networkData3 = (NetworkData)quickVector.quickElementAt(n4);
                                    int n5 = networkData3.netAddrCompare(networkData2);
                                    if (n5 == 0) {
                                        n3 = -1;
                                        break;
                                    }
                                    if (n5 > 0) {
                                        n3 = n4;
                                        break;
                                    }
                                    ++n4;
                                }
                                if (n3 >= 0) {
                                    quickVector.insertElementAt(networkData2, n3);
                                    networkData2.setNetmaskForSubnet(networkData.getNetmask());
                                    networkData2 = new NetworkData();
                                }
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "hosts", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV3", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "hosts", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV3", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3108", "hosts", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV3", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3108", "listHostSubnets", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV3", hostException);
            }
            Object var20_26 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var20_27 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        return quickVector;
    }

    public Vector listHostsByNetwork(SecurityToken securityToken, NetworkData networkData, ListProperties listProperties) throws RemoteException, AdminException {
        Object[] objectArray = null;
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "listHostsByNetwork");
        }
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "listHostsByNetwork");
        }
        if (listProperties == null) {
            this.logInternalError(securityToken, "LM_3009", "listHostsByNetwork", "listProps == null");
            throw new HostException("EXM_HST_SRV21", new HostException("EXM_HST_SRV99"));
        }
        if (networkData == null) {
            this.logInternalError(securityToken, "LM_3009", "listHostsByNetwork", "networkData == null");
            throw new HostException("EXM_HST_SRV21", new HostException("EXM_HST_SRV99"));
        }
        boolean bl = false;
        DirectoryTable directoryTable = null;
        HostData hostData = null;
        Vector<HostData> vector = null;
        try {
            try {
                int n;
                int n2;
                int n3;
                DirectoryFilter directoryFilter;
                if (!networkData.isNetwork()) {
                    networkData.setNetmask(this.getNetmask(securityToken, networkData));
                    if (networkData.getNetmask().length() == 0) {
                        throw new HostException("EXM_HST_SRV46");
                    }
                    if (networkData.getNetmaskShiftCount() % 8 != 0) {
                        bl = true;
                    }
                }
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("hosts");
                directoryTable.open(tableDefinitions);
                if (bl) {
                    directoryFilter = new DirectoryFilter(2);
                    String string = networkData.convertLongToAddress(networkData.getNetworkAddressLong() - 1L);
                    String string2 = networkData.convertLongToAddress(networkData.getNetworkAddressLong() + (long)(1 << networkData.getNetmaskShiftCount()));
                    directoryFilter.add(this.hostsColumnAddr, 1, 8, string);
                    directoryFilter.add(this.hostsColumnAddr, 2, 7, string2);
                } else {
                    directoryFilter = new DirectoryFilter(1);
                    String string = networkData.convertLongToAddress(networkData.getNetworkAddressLong());
                    directoryFilter.add(this.hostsColumnAddr, 1, 3, String.valueOf(string) + ".");
                }
                DirectoryRow directoryRow = directoryTable.getAll(directoryFilter);
                if (directoryRow == null) {
                    Vector vector2 = new Vector();
                    Object var22_17 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    return vector2;
                }
                directoryRow.sortByColumn(this.mapHostColumnToNum(listProperties.getSortColumn()), tableDefinitions);
                vector = new Vector<HostData>(directoryRow.getNumberOfRows());
                if (listProperties.isSortOrderAscending()) {
                    n3 = 1;
                    n2 = directoryRow.getNumberOfRows() + 1;
                    n = 1;
                } else {
                    n3 = directoryRow.getNumberOfRows();
                    n2 = 0;
                    n = -1;
                }
                while (n3 != n2) {
                    if (directoryRow.getColumn(this.hostsColumnCname, n3).length() == 0) {
                        n3 += n;
                        continue;
                    }
                    hostData = new HostData();
                    try {
                        HostData.validateIPAddress(directoryRow.getColumn(this.hostsColumnAddr, n3));
                    }
                    catch (Exception exception) {
                        n3 += n;
                        continue;
                    }
                    hostData.setNetworkAddress(directoryRow.getColumn(this.hostsColumnAddr, n3));
                    hostData.setHostName(directoryRow.getColumn(this.hostsColumnCname, n3));
                    hostData.setAliases(directoryRow.getColumn(this.hostsColumnAliases, n3));
                    hostData.setDescription(directoryRow.getColumn(this.hostsColumnComment, n3));
                    hostData.setEthernetAddress(this.getEtherAddrByHost(securityToken, hostData.getHostName()));
                    vector.addElement(hostData);
                    n3 += n;
                }
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "hosts", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV4", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "hosts", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV4", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3009", "hosts", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV4", hostException);
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_SRV4", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3009", "listHostsByNetwork", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV4", hostException);
            }
        }
        catch (Throwable throwable) {
            Object var22_19 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        Object var22_18 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
        return vector;
    }

    public int listHostsByNetworkPrime(SecurityToken securityToken, NetworkData networkData, ListProperties listProperties) throws RemoteException, AdminException {
        Object[] objectArray = null;
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "listHostsByNetworkPrime");
        }
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "listHostsByNetworkPrime");
        }
        boolean bl = false;
        DirectoryRow directoryRow = null;
        DirectoryTable directoryTable = null;
        if (listProperties == null || listProperties.getChunkSize() < 1) {
            this.logInternalError(securityToken, "LM_3009", "listHostsByNetworkPrime", "listProps == null || listProps.getChunkSize()<1");
            throw new HostException("EXM_HST_SRV21", new HostException("EXM_HST_SRV99"));
        }
        if (networkData == null) {
            this.logInternalError(securityToken, "LM_3009", "listHostsByNetworkPrime", "networkData == null");
            throw new HostException("EXM_HST_SRV21", new HostException("EXM_HST_SRV99"));
        }
        this.chunkSize = listProperties.getChunkSize();
        this.sortAscending = listProperties.isSortOrderAscending();
        try {
            try {
                DirectoryFilter directoryFilter;
                if (!networkData.isNetwork()) {
                    networkData.setNetmask(this.getNetmask(securityToken, networkData));
                    if (networkData.getNetmask().length() == 0) {
                        throw new HostException("EXM_HST_SRV46");
                    }
                    if (networkData.getNetmaskShiftCount() % 8 != 0) {
                        bl = true;
                    }
                }
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("hosts");
                directoryTable.open(tableDefinitions);
                if (bl) {
                    directoryFilter = new DirectoryFilter(2);
                    String string = networkData.convertLongToAddress(networkData.getNetworkAddressLong() - 1L);
                    String string2 = networkData.convertLongToAddress(networkData.getNetworkAddressLong() + (long)(1 << networkData.getNetmaskShiftCount()));
                    directoryFilter.add(this.hostsColumnAddr, 1, 8, string);
                    directoryFilter.add(this.hostsColumnAddr, 2, 7, string2);
                } else {
                    directoryFilter = new DirectoryFilter(1);
                    String string = networkData.convertLongToAddress(networkData.getNetworkAddressLong());
                    directoryFilter.add(this.hostsColumnAddr, 1, 3, String.valueOf(string) + ".");
                }
                this.hostListRow = directoryRow = directoryTable.getAll(directoryFilter);
                if (directoryRow == null) {
                    int n = 0;
                    Object var17_15 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    return n;
                }
                directoryRow.sortByColumn(this.mapHostColumnToNum(listProperties.getSortColumn()), tableDefinitions);
                if (this.sortAscending) {
                    this.hostListIndex = 1;
                    this.hostListLimit = directoryRow.getNumberOfRows() + 1;
                    this.hostListIncrement = 1;
                } else {
                    this.hostListIndex = directoryRow.getNumberOfRows();
                    this.hostListLimit = 0;
                    this.hostListIncrement = -1;
                }
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "hosts", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV4", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "hosts", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV4", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3009", "hosts", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV4", hostException);
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_SRV4", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3009", "listHostsByNetworkPrime", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV4", hostException);
            }
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        Object var17_16 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
        return directoryRow.getNumberOfRows();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector listHostsByNetworkNext(SecurityToken securityToken) throws RemoteException, AdminException {
        Object[] objectArray = null;
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "listHostsByNetworkNext");
        }
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "listHostsByNetworkNext");
        }
        int n = this.chunkSize;
        Vector<HostData> vector = new Vector<HostData>(this.chunkSize);
        if (this.hostListIndex == this.hostListLimit) {
            return new Vector();
        }
        try {
            while (n > 0) {
                if (this.hostListIndex == this.hostListLimit) {
                    return vector;
                }
                if (this.hostListRow.getColumn(this.hostsColumnCname, this.hostListIndex).length() == 0) {
                    this.hostListIndex += this.hostListIncrement;
                    continue;
                }
                HostData hostData = new HostData();
                try {
                    HostData.validateIPAddress(this.hostListRow.getColumn(this.hostsColumnAddr, this.hostListIndex));
                }
                catch (Exception exception) {
                    this.hostListIndex += this.hostListIncrement;
                    continue;
                }
                hostData.setNetworkAddress(this.hostListRow.getColumn(this.hostsColumnAddr, this.hostListIndex));
                hostData.setHostName(this.hostListRow.getColumn(this.hostsColumnCname, this.hostListIndex));
                hostData.setAliases(this.hostListRow.getColumn(this.hostsColumnAliases, this.hostListIndex));
                hostData.setDescription(this.hostListRow.getColumn(this.hostsColumnComment, this.hostListIndex));
                hostData.setEthernetAddress(this.getEtherAddrByHost(securityToken, hostData.getHostName()));
                vector.addElement(hostData);
                --n;
                this.hostListIndex += this.hostListIncrement;
            }
            return vector;
        }
        catch (DirectoryTableException directoryTableException) {
            this.logDirTableException(securityToken, "LM_3009", "hosts", directoryTableException);
            HostException hostException = new HostException("EXM_HST_SRV32");
            throw new HostException("EXM_HST_SRV4", hostException);
        }
        catch (Exception exception) {
            this.logException(securityToken, "LM_3009", "listHostsByNetworkNext", exception);
            HostException hostException = new HostException("EXM_HST_SRV99", exception);
            throw new HostException("EXM_HST_SRV4", hostException);
        }
    }

    public void listHostsByNetworkEnd(SecurityToken securityToken) throws RemoteException, AdminException {
        Object[] objectArray = null;
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "listHostsByNetworkEnd");
        }
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "listHostsByNetworkEnd");
        }
        this.hostListRow = null;
        this.hostListIndex = this.hostListLimit;
    }

    public void setNetwork(SecurityToken securityToken, NetworkData networkData, NetworkData networkData2) throws RemoteException, AdminException {
        Object[] objectArray = null;
        if (this.adminSvr.isVerify()) {
            objectArray = new Object[]{networkData, networkData2};
        }
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "setNetwork");
        }
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "setNetwork");
        }
        String string = "";
        try {
            string = this.adminSvr.getUserName(securityToken);
            if (!this.adminSvr.checkRights(securityToken, "solaris.admin.hostmgr.write")) {
                String[] stringArray = new String[]{string, "LM_HOST_APP_NAME"};
                this.writeLog(securityToken, 0, "LM_1010", "LM_1014", stringArray, false);
                throw new AuthNoAccessException(string, this.localAppName());
            }
        }
        catch (AuthNoAccessException authNoAccessException) {
            throw authNoAccessException;
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV82", string, "setNetwork");
        }
        DirectoryTable directoryTable = null;
        if (networkData2.getNetworkName().length() == 0) {
            boolean bl;
            if (networkData.getNetworkName().length() > 0) {
                String string2 = networkData.getNetmask();
                networkData.setNetmask("");
                this.deleteNetworkLocal(securityToken, networkData);
                networkData.setNetmask(string2);
            }
            if (!(bl = this.setNetmask(securityToken, networkData, networkData2))) {
                throw new HostException("EXM_HST_SRV45");
            }
            return;
        }
        boolean bl = this.setNetmask(securityToken, networkData, networkData2);
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("networks");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.networksColumnCname, networkData.getNetworkName());
                directoryRow.putColumn(this.networksColumnAddr, networkData.getNetworkAddress());
                directoryRow.putColumn(this.networksColumnAliases, networkData.getAliases());
                directoryRow.putColumn(this.networksColumnComment, networkData.getDescription());
                DirectoryRow directoryRow2 = directoryTable.getRowInstance();
                directoryRow2.putColumn(this.networksColumnCname, networkData2.getNetworkName());
                directoryRow2.putColumn(this.networksColumnAddr, networkData2.getNetworkAddress());
                directoryRow2.putColumn(this.networksColumnAliases, networkData2.getAliases());
                directoryRow2.putColumn(this.networksColumnComment, networkData2.getDescription());
                if (networkData.getNetworkName().length() == 0 && networkData2.getNetworkName().length() > 0) {
                    directoryTable.addRow(directoryRow2);
                } else {
                    directoryTable.modifyRow(directoryRow, directoryRow2);
                }
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV42");
                if (bl) {
                    throw new HostWarningException("EXM_HST_SRV5_WARN", hostException);
                }
                throw new HostException("EXM_HST_SRV5", hostException);
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV40");
                if (bl) {
                    throw new HostWarningException("EXM_HST_SRV5_WARN", hostException);
                }
                throw new HostException("EXM_HST_SRV5", hostException);
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "networks", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                if (bl) {
                    throw new HostWarningException("EXM_HST_SRV5_WARN", hostException);
                }
                throw new HostException("EXM_HST_SRV5", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "networks", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                if (bl) {
                    throw new HostWarningException("EXM_HST_SRV5_WARN", hostException);
                }
                throw new HostException("EXM_HST_SRV5", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3105", "networks", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                if (bl) {
                    throw new HostWarningException("EXM_HST_SRV5_WARN", hostException);
                }
                throw new HostException("EXM_HST_SRV5", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3105", "setNetwork", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                if (bl) {
                    throw new HostWarningException("EXM_HST_SRV5_WARN", hostException);
                }
                throw new HostException("EXM_HST_SRV5", hostException);
            }
            Object var14_28 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var14_29 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        String[] stringArray = new String[]{networkData.getNetworkName(), networkData.getNetworkAddress()};
        this.writeLog(securityToken, 0, "LM_3104", "LM_3152", stringArray, false);
    }

    public void addNetwork(SecurityToken securityToken, NetworkData networkData) throws RemoteException, AdminException {
        Object[] objectArray = null;
        if (this.adminSvr.isVerify()) {
            objectArray = new Object[]{networkData};
        }
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "addNetwork");
        }
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "addNetwork");
        }
        String string = "";
        try {
            string = this.adminSvr.getUserName(securityToken);
            if (!this.adminSvr.checkRights(securityToken, "solaris.admin.hostmgr.write")) {
                String[] stringArray = new String[]{string, "LM_HOST_APP_NAME"};
                this.writeLog(securityToken, 0, "LM_1010", "LM_1014", stringArray, false);
                throw new AuthNoAccessException(string, this.localAppName());
            }
        }
        catch (AuthNoAccessException authNoAccessException) {
            throw authNoAccessException;
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV82", string, "addNetwork");
        }
        DirectoryTable directoryTable = null;
        if (this.getNetworkLocal(securityToken, networkData) != null) {
            throw new HostException("EXM_HST_SRV6", new HostException("EXM_HST_SRV44"));
        }
        boolean bl = this.addNetmask(securityToken, networkData);
        if (networkData.getNetworkName().length() == 0) {
            return;
        }
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("networks");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.networksColumnCname, networkData.getNetworkName());
                directoryRow.putColumn(this.networksColumnAddr, networkData.getNetworkAddress());
                directoryRow.putColumn(this.networksColumnAliases, networkData.getAliases());
                directoryRow.putColumn(this.networksColumnComment, networkData.getDescription());
                directoryTable.addRow(directoryRow);
            }
            catch (DirectoryTableRowNotUniqueException directoryTableRowNotUniqueException) {
                HostException hostException = new HostException("EXM_HST_SRV44");
                if (bl) {
                    throw new HostWarningException("EXM_HST_SRV6_WARN", hostException);
                }
                throw new HostException("EXM_HST_SRV6", hostException);
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV40");
                if (bl) {
                    throw new HostWarningException("EXM_HST_SRV6_WARN", hostException);
                }
                throw new HostException("EXM_HST_SRV6", hostException);
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "networks", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                if (bl) {
                    throw new HostWarningException("EXM_HST_SRV6_WARN", hostException);
                }
                throw new HostException("EXM_HST_SRV6", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "networks", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                if (bl) {
                    throw new HostWarningException("EXM_HST_SRV6_WARN", hostException);
                }
                throw new HostException("EXM_HST_SRV6", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3101", "networks", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                if (bl) {
                    throw new HostWarningException("EXM_HST_SRV6_WARN", hostException);
                }
                throw new HostException("EXM_HST_SRV6", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3101", "addNetwork", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                if (bl) {
                    throw new HostWarningException("EXM_HST_SRV6_WARN", hostException);
                }
                throw new HostException("EXM_HST_SRV6", hostException);
            }
            Object var12_22 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var12_23 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        String[] stringArray = new String[]{networkData.getNetworkName(), networkData.getNetworkAddress()};
        this.writeLog(securityToken, 0, "LM_3100", "LM_3150", stringArray, false);
    }

    private void deleteNetworkLocal(SecurityToken securityToken, NetworkData networkData) throws RemoteException, AdminException {
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "deleteNetwork");
        }
        DirectoryTable directoryTable = null;
        this.deleteNetmask(securityToken, networkData);
        if (networkData.getNetworkName().equals("")) {
            return;
        }
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("networks");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.networksColumnCname, networkData.getNetworkName());
                directoryRow.putColumn(this.networksColumnAddr, networkData.getNetworkAddress());
                directoryRow.putColumn(this.networksColumnAliases, networkData.getAliases());
                directoryTable.deleteRow(directoryRow);
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV42");
                throw new HostException("EXM_HST_SRV7", hostException);
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV40");
                throw new HostException("EXM_HST_SRV7", hostException);
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "networks", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV7", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "networks", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV7", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3103", "networks", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV7", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3103", "deleteNetwork", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV7", hostException);
            }
            Object var9_17 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var9_18 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        String[] stringArray = new String[]{networkData.getNetworkName(), networkData.getNetworkAddress()};
        this.writeLog(securityToken, 0, "LM_3102", "LM_3151", stringArray, false);
    }

    public void deleteNetwork(SecurityToken securityToken, NetworkData networkData) throws RemoteException, AdminException {
        Object[] objectArray = null;
        if (this.adminSvr.isVerify()) {
            objectArray = new Object[]{networkData};
        }
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "deleteNetwork");
        }
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "deleteNetwork");
        }
        String string = "";
        try {
            string = this.adminSvr.getUserName(securityToken);
            if (!this.adminSvr.checkRights(securityToken, "solaris.admin.hostmgr.write")) {
                String[] stringArray = new String[]{string, "LM_HOST_APP_NAME"};
                this.writeLog(securityToken, 0, "LM_1010", "LM_1014", stringArray, false);
                throw new AuthNoAccessException(string, this.localAppName());
            }
        }
        catch (AuthNoAccessException authNoAccessException) {
            throw authNoAccessException;
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV82", string, "deleteNetwork");
        }
        this.deleteNetworkLocal(securityToken, networkData);
    }

    private String getNetmask(SecurityToken securityToken, NetworkData networkData) throws RemoteException, AdminException {
        DirectoryFilter directoryFilter = new DirectoryFilter(2);
        DirectoryTable directoryTable = null;
        String string = "";
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("netmasks");
                directoryTable.open(tableDefinitions);
                directoryFilter.add(this.netmasksColumnAddr, 1, 5, networkData.getNetId());
                directoryFilter.add(this.netmasksColumnAddr, 3, 3, String.valueOf(networkData.getNetId()) + ".");
                DirectoryRow directoryRow = directoryTable.getFirstRow(directoryFilter);
                if (directoryRow != null) {
                    string = directoryRow.getColumn(this.netmasksColumnMask);
                }
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV43");
                throw new HostException("EXM_HST_SRV8", hostException);
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "netmasks", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30", directoryTableAccessException);
                throw new HostException("EXM_HST_SRV8", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "netmasks", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31", directoryTableConnectionException);
                throw new HostException("EXM_HST_SRV8", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3106", "netmasks", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV8", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3106", "getNetmask", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV8", hostException);
            }
            Object var10_17 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var10_18 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        return string;
    }

    private boolean setNetmask(SecurityToken securityToken, NetworkData networkData, NetworkData networkData2) throws RemoteException, AdminException {
        DirectoryFilter directoryFilter = new DirectoryFilter(2);
        DirectoryTable directoryTable = null;
        if (networkData2.getNetmask().length() == 0) {
            this.deleteNetmask(securityToken, networkData);
            return true;
        }
        if (networkData.getNetmask().length() == 0) {
            return this.addNetmask(securityToken, networkData2);
        }
        if (!networkData.getNetworkAddress().equals(networkData2.getNetworkAddress())) {
            String string;
            try {
                string = this.getNetmask(securityToken, networkData2);
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_SRV10", hostException);
            }
            if (string != null && string.length() > 0) {
                if (string.equals(networkData2.getNetmask())) {
                    return false;
                }
                throw new HostException("EXM_HST_SRV45");
            }
        }
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("netmasks");
                directoryTable.open(tableDefinitions);
                directoryFilter.add(this.netmasksColumnAddr, 1, 5, networkData.getNetId());
                directoryFilter.add(this.netmasksColumnAddr, 3, 3, String.valueOf(networkData.getNetId()) + ".");
                DirectoryRow directoryRow = directoryTable.getFirstRow(directoryFilter);
                if (directoryRow == null) {
                    throw new HostException("EXM_HST_SRV43");
                }
                DirectoryRow directoryRow2 = directoryTable.getRowInstance();
                directoryRow2.putColumn(this.netmasksColumnMask, networkData2.getNetmask());
                if (networkData.getNetworkAddress().equals(networkData2.getNetworkAddress())) {
                    directoryRow2.putColumn(this.netmasksColumnAddr, directoryRow.getColumn(this.netmasksColumnAddr));
                } else {
                    directoryRow2.putColumn(this.netmasksColumnAddr, networkData2.getNetworkAddress());
                }
                directoryTable.modifyRow(directoryRow, directoryRow2);
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV43");
                throw new HostException("EXM_HST_SRV10", hostException);
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV41");
                throw new HostException("EXM_HST_SRV10", hostException);
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "netmasks", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV10", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "netmasks", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV10", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3105", "netmasks", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV10", hostException);
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_SRV10", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3105", "setNetmask", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV10", hostException);
            }
            Object var11_9 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        return true;
    }

    private boolean addNetmask(SecurityToken securityToken, NetworkData networkData) throws RemoteException, AdminException {
        String string;
        if (networkData.getNetmask().length() == 0) {
            return false;
        }
        try {
            string = this.getNetmask(securityToken, networkData);
        }
        catch (HostException hostException) {
            throw new HostException("EXM_HST_SRV11", hostException);
        }
        if (string != null && string.length() > 0) {
            if (string.equals(networkData.getNetmask())) {
                return false;
            }
            throw new HostException("EXM_HST_SRV45");
        }
        DirectoryTable directoryTable = null;
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("netmasks");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.netmasksColumnMask, networkData.getNetmask());
                directoryRow.putColumn(this.netmasksColumnAddr, networkData.getNetworkAddress());
                directoryTable.addRow(directoryRow);
            }
            catch (DirectoryTableRowNotUniqueException directoryTableRowNotUniqueException) {
                HostException hostException = new HostException("EXM_HST_SRV45");
                throw new HostException("EXM_HST_SRV11", hostException);
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV41");
                throw new HostException("EXM_HST_SRV11", hostException);
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "netmasks", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV11", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "netmasks", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV11", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3101", "netmasks", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV11", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3101", "addNetmask", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV11", hostException);
            }
            Object var9_18 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var9_19 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        return true;
    }

    private void deleteNetmask(SecurityToken securityToken, NetworkData networkData) throws RemoteException, AdminException {
        if (networkData.getNetmask().length() == 0) {
            return;
        }
        DirectoryFilter directoryFilter = new DirectoryFilter(2);
        DirectoryTable directoryTable = null;
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("netmasks");
                directoryTable.open(tableDefinitions);
                directoryFilter.add(this.netmasksColumnAddr, 1, 5, networkData.getNetId());
                directoryFilter.add(this.netmasksColumnAddr, 3, 3, String.valueOf(networkData.getNetId()) + ".");
                DirectoryRow directoryRow = directoryTable.getFirstRow(directoryFilter);
                if (directoryRow == null) {
                    throw new HostException("EXM_HST_SRV43");
                }
                DirectoryRow directoryRow2 = directoryTable.getRowInstance();
                directoryRow2.putColumn(this.netmasksColumnAddr, directoryRow.getColumn(this.netmasksColumnAddr));
                directoryRow2.putColumn(this.netmasksColumnMask, networkData.getNetmask());
                directoryTable.deleteRow(directoryRow2);
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV43");
                throw new HostException("EXM_HST_SRV12", hostException);
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV41");
                throw new HostException("EXM_HST_SRV12", hostException);
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "netmasks", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV12", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "netmasks", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV12", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3103", "netmasks", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV12", hostException);
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_SRV12", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3103", "deleteNetmask", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV12", hostException);
            }
            Object var10_19 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            return;
        }
        catch (Throwable throwable) {
            block13: {
                Object var10_20 = null;
                if (directoryTable == null) break block13;
                directoryTable.close();
            }
            throw throwable;
        }
    }

    private HostData getHostByEtherAddr(SecurityToken securityToken, String string) throws RemoteException, AdminException {
        if (string.length() == 0) {
            return null;
        }
        DirectoryTable directoryTable = null;
        HostData hostData = null;
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("ethers");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.ethersColumnAddr, string);
                DirectoryRow directoryRow2 = directoryTable.getFirstRow(directoryRow);
                if (directoryRow2 != null) {
                    hostData = new HostData(directoryRow2.getColumn(this.ethersColumnName));
                    hostData.setEthernetAddress(string);
                }
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "ethers", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV15", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "ethers", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV15", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3008", "ethers", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV15", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3008", "getHostByEtherAddr", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV15", hostException);
            }
            Object var10_16 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        return hostData;
    }

    private String getEtherAddrByHost(SecurityToken securityToken, String string) throws RemoteException, AdminException {
        DirectoryTable directoryTable = null;
        String string2 = "";
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("ethers");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.ethersColumnName, string);
                DirectoryRow directoryRow2 = directoryTable.getFirstRow(directoryRow);
                if (directoryRow2 != null) {
                    string2 = directoryRow2.getColumn(this.ethersColumnAddr);
                }
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV63");
                throw new HostException("EXM_HST_SRV15", hostException);
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "ethers", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV15", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "ethers", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV15", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3008", "ethers", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV15", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3008", "getEtherAddrByHost", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV15", hostException);
            }
            Object var10_17 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var10_18 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        return string2;
    }

    private DirectoryRow cacheEthersList(SecurityToken securityToken) throws RemoteException, AdminException {
        DirectoryRow directoryRow = null;
        DirectoryTable directoryTable = null;
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                this.ethersTableDefn = directoryTable.getTableDefinitionsInstance();
                this.ethersTableDefn.loadTableDefinitions("ethers");
                directoryTable.open(this.ethersTableDefn);
                this.etherMatchRow = directoryTable.getRowInstance();
                directoryRow = directoryTable.getAll();
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "ethers", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV16", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "ethers", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV16", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3009", "ethers", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV16", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3009", "cacheEthersList", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV16", hostException);
            }
            Object var6_12 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var6_13 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        return directoryRow;
    }

    private void setEthernetAddress(SecurityToken securityToken, HostData hostData, HostData hostData2) throws RemoteException, AdminException {
        if (hostData.getEthernetAddress().equals(hostData2.getEthernetAddress())) {
            return;
        }
        if (hostData2.getEthernetAddress().length() == 0) {
            this.deleteEthernetAddress(securityToken, hostData);
            return;
        }
        if (hostData.getEthernetAddress().length() == 0) {
            this.addEthernetAddress(securityToken, hostData2);
            return;
        }
        DirectoryTable directoryTable = null;
        HostData hostData3 = this.getHostByEtherAddr(securityToken, hostData2.getEthernetAddress());
        if (hostData3 != null && !hostData2.getHostName().equals(hostData3.getHostName())) {
            throw new HostWarningException("EXM_HST_SRV70_WARN");
        }
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("ethers");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.ethersColumnName, hostData.getHostName());
                directoryRow.putColumn(this.ethersColumnAddr, hostData.getEthernetAddress());
                DirectoryRow directoryRow2 = directoryTable.getRowInstance();
                directoryRow2.putColumn(this.ethersColumnName, hostData2.getHostName());
                directoryRow2.putColumn(this.ethersColumnAddr, hostData2.getEthernetAddress());
                directoryTable.modifyRow(directoryRow, directoryRow2);
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV63");
                throw new HostWarningException("EXM_HST_SRV17_WARN", hostException);
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV61");
                throw new HostWarningException("EXM_HST_SRV17_WARN", hostException);
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "ethers", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostWarningException("EXM_HST_SRV17_WARN", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "ethers", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostWarningException("EXM_HST_SRV17_WARN", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3005", "ethers", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostWarningException("EXM_HST_SRV17_WARN", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3005", "setEthernetAddress", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostWarningException("EXM_HST_SRV17_WARN", hostException);
            }
            Object var11_19 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            return;
        }
        catch (Throwable throwable) {
            block14: {
                Object var11_20 = null;
                if (directoryTable == null) break block14;
                directoryTable.close();
            }
            throw throwable;
        }
    }

    private void addEthernetAddress(SecurityToken securityToken, HostData hostData) throws RemoteException, AdminException {
        DirectoryTable directoryTable = null;
        HostWarningException hostWarningException = null;
        if (hostData.getEthernetAddress().length() == 0) {
            return;
        }
        HostData hostData2 = this.getHostByEtherAddr(securityToken, hostData.getEthernetAddress());
        if (hostData2 != null) {
            if (!hostData.getHostName().equals(hostData2.getHostName())) {
                throw new HostWarningException("EXM_HST_SRV70_WARN");
            }
            return;
        }
        String string = this.getEtherAddrByHost(securityToken, hostData.getHostName());
        if (string.length() > 0 && !string.equals(hostData.getEthernetAddress())) {
            hostWarningException = new HostWarningException("EXM_HST_SRV72_WARN");
        }
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("ethers");
                try {
                    directoryTable.open(tableDefinitions);
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    directoryTable.create(tableDefinitions);
                }
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.ethersColumnName, hostData.getHostName());
                directoryRow.putColumn(this.ethersColumnAddr, hostData.getEthernetAddress());
                directoryTable.addRow(directoryRow);
            }
            catch (DirectoryTableRowNotUniqueException directoryTableRowNotUniqueException) {
                HostException hostException = new HostException("EXM_HST_SRV65");
                throw new HostWarningException("EXM_HST_SRV18_WARN", hostException);
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "ethers", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostWarningException("EXM_HST_SRV18_WARN", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "ethers", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostWarningException("EXM_HST_SRV18_WARN", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3001", "ethers", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostWarningException("EXM_HST_SRV18_WARN", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3001", "addEthernetAddress", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostWarningException("EXM_HST_SRV18_WARN", hostException);
            }
            Object var11_18 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var11_19 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        if (hostWarningException != null) {
            throw hostWarningException;
        }
    }

    private void deleteEthernetAddress(SecurityToken securityToken, HostData hostData) throws RemoteException, AdminException {
        if (hostData.getEthernetAddress().length() == 0) {
            return;
        }
        DirectoryTable directoryTable = null;
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("ethers");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.ethersColumnAddr, hostData.getEthernetAddress());
                directoryRow.putColumn(this.ethersColumnName, hostData.getHostName());
                directoryTable.deleteRow(directoryRow);
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV63");
                throw new HostException("EXM_HST_SRV19", hostException);
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV61");
                throw new HostException("EXM_HST_SRV19", hostException);
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "ethers", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV19", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "ethers", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV19", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3003", "ethers", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV19", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3003", "deleteEthernetAddress", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV19", hostException);
            }
            Object var8_16 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            return;
        }
        catch (Throwable throwable) {
            block11: {
                Object var8_17 = null;
                if (directoryTable == null) break block11;
                directoryTable.close();
            }
            throw throwable;
        }
    }

    private void renameEthernetAddress(SecurityToken securityToken, HostData hostData, String string) throws RemoteException, AdminException {
        DirectoryTable directoryTable = null;
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("ethers");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.ethersColumnName, hostData.getHostName());
                DirectoryRow directoryRow2 = directoryTable.getAll(directoryRow);
                if (directoryRow2 == null) {
                    Object var12_8 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    return;
                }
                int n = 1;
                while (n <= directoryRow2.getNumberOfRows()) {
                    DirectoryRow directoryRow3 = directoryRow2.extractRows(n, n);
                    DirectoryRow directoryRow4 = directoryRow2.extractRows(n, n);
                    directoryRow4.putColumn(this.ethersColumnName, string);
                    directoryTable.modifyRow(directoryRow3, directoryRow4);
                    ++n;
                }
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "ethers", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV27", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "ethers", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV27", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3005", "ethers", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV27", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3005", "renameEthernetAddress", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV27", hostException);
            }
        }
        catch (Throwable throwable) {
            block13: {
                Object var12_10 = null;
                if (directoryTable == null) break block13;
                directoryTable.close();
            }
            throw throwable;
        }
        Object var12_9 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
    }

    private HostData getHostByAddress(SecurityToken securityToken, String string) throws RemoteException, AdminException {
        DirectoryTable directoryTable = null;
        HostData hostData = null;
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("hosts");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.hostsColumnAddr, string);
                DirectoryRow directoryRow2 = directoryTable.getFirstRow(directoryRow);
                if (directoryRow2 != null) {
                    hostData = new HostData();
                    hostData.setNetworkAddress(directoryRow2.getColumn(this.hostsColumnAddr));
                    hostData.setHostName(directoryRow2.getColumn(this.hostsColumnCname));
                }
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "hosts", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV20", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "hosts", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV20", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3008", "hosts", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV20", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3008", "getHostByAddress", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV20", hostException);
            }
            Object var10_16 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        return hostData;
    }

    public HostData getHostByNameAddr(SecurityToken securityToken, String string, String string2) throws RemoteException, AdminException {
        Object[] objectArray = null;
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "getHostByNameAddr");
        }
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "getHostByNameAddr");
        }
        DirectoryTable directoryTable = null;
        HostData hostData = null;
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("hosts");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.hostsColumnCname, string);
                directoryRow.putColumn(this.hostsColumnAddr, string2);
                DirectoryRow directoryRow2 = directoryTable.getFirstRow(directoryRow);
                if (directoryRow2 == null) {
                    HostData hostData2 = hostData;
                    Object var14_12 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    return hostData2;
                }
                hostData = new HostData();
                hostData.setNetworkAddress(directoryRow2.getColumn(this.hostsColumnAddr));
                hostData.setHostName(directoryRow2.getColumn(this.hostsColumnCname));
                hostData.setAliases(directoryRow2.getColumn(this.hostsColumnAliases));
                hostData.setDescription(directoryRow2.getColumn(this.hostsColumnComment));
                hostData.setEthernetAddress(this.getEtherAddrByHost(securityToken, hostData.getHostName()));
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "hosts", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV20", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "hosts", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV20", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3008", "hosts", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV20", hostException);
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_SRV20", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3008", "getHostByNameAddr", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV20", hostException);
            }
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        Object var14_13 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
        return hostData;
    }

    public Vector getHostOtherAddrs(SecurityToken securityToken, HostData hostData) throws RemoteException, AdminException {
        Object[] objectArray = null;
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "getHostOtherAddrs");
        }
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "getHostOtherAddrs");
        }
        DirectoryTable directoryTable = null;
        Vector<String> vector = new Vector<String>();
        try {
            try {
                hostData.getHostName();
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("hosts");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.hostsColumnCname, hostData.getHostName());
                DirectoryRow directoryRow2 = directoryTable.getAll(directoryRow);
                if (directoryRow2 == null) {
                    Vector<String> vector2 = vector;
                    Object var14_11 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    return vector2;
                }
                String string = hostData.getNetworkAddress();
                int n = 1;
                while (n <= directoryRow2.getNumberOfRows()) {
                    if (directoryRow2.getColumn(this.hostsColumnAddr, n).length() > 0 && !string.equals(directoryRow2.getColumn(this.hostsColumnAddr, n))) {
                        vector.addElement(directoryRow2.getColumn(this.hostsColumnAddr, n));
                    }
                    ++n;
                }
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "hosts", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV20", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "hosts", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV20", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3008", "hosts", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV20", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3008", "getHostOtherAddrs", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV20", hostException);
            }
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        Object var14_12 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
        return vector;
    }

    public Vector getHostsByName(SecurityToken securityToken, String string) throws RemoteException, AdminException {
        Object[] objectArray = null;
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "getHostsByName");
        }
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "getHostsByName");
        }
        DirectoryTable directoryTable = null;
        Vector<HostData> vector = new Vector<HostData>();
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("hosts");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.hostsColumnCname, string);
                DirectoryRow directoryRow2 = directoryTable.getAll(directoryRow);
                if (directoryRow2 == null) {
                    Vector<HostData> vector2 = vector;
                    Object var14_11 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    return vector2;
                }
                vector = new Vector(directoryRow2.getNumberOfRows());
                int n = 1;
                while (n <= directoryRow2.getNumberOfRows()) {
                    HostData hostData = new HostData();
                    hostData.setNetworkAddress(directoryRow2.getColumn(this.hostsColumnAddr, n));
                    hostData.setHostName(directoryRow2.getColumn(this.hostsColumnCname, n));
                    hostData.setAliases(directoryRow2.getColumn(this.hostsColumnAliases, n));
                    hostData.setDescription(directoryRow2.getColumn(this.hostsColumnComment, n));
                    hostData.setEthernetAddress(this.getEtherAddrByHost(securityToken, hostData.getHostName()));
                    vector.addElement(hostData);
                    ++n;
                }
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "hosts", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV20", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "hosts", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV20", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3008", "hosts", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV20", hostException);
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_SRV20", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3008", "getHostsByName", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV20", hostException);
            }
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        Object var14_12 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
        return vector;
    }

    public Vector listHosts(SecurityToken securityToken, ListProperties listProperties) throws RemoteException, AdminException {
        Object[] objectArray = null;
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "listHosts");
        }
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "listHosts");
        }
        if (listProperties == null) {
            this.logInternalError(securityToken, "LM_3009", "listHosts", "listProps == null");
            throw new HostException("EXM_HST_SRV21", new HostException("EXM_HST_SRV99"));
        }
        int n = 0;
        DirectoryRow directoryRow = null;
        DirectoryTable directoryTable = null;
        HostData hostData = null;
        QuickVector quickVector = null;
        try {
            try {
                int n2;
                int n3;
                int n4;
                int n5;
                DirectoryRow directoryRow2;
                directoryRow = this.cacheEthersList(securityToken);
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("hosts");
                TableDefinitions tableDefinitions2 = directoryTable.getTableDefinitionsInstance();
                tableDefinitions2.loadTableDefinitions("ethers");
                directoryTable.open(tableDefinitions);
                Vector vector = listProperties.getFilters();
                if (vector != null && !vector.isEmpty()) {
                    DirectoryFilter directoryFilter = new DirectoryFilter(vector.size());
                    int n6 = 0;
                    while (n6 < vector.size()) {
                        FilterItem filterItem = (FilterItem)vector.elementAt(n6);
                        directoryFilter.add(this.mapHostColumnToNum(filterItem.getAttribute()), filterItem.getBooleanOperator(), filterItem.getOperator(), filterItem.getValue());
                        ++n6;
                    }
                    directoryRow2 = directoryTable.getAll(directoryFilter);
                } else {
                    directoryRow2 = directoryTable.getAll();
                }
                if (directoryRow2 != null) {
                    directoryRow2.sortByColumn(this.mapHostColumnToNum(listProperties.getSortColumn()), tableDefinitions);
                    quickVector = new QuickVector(directoryRow2.getNumberOfRows());
                    n5 = directoryRow2.getNumberOfRows();
                    quickVector.setSize(n5);
                    if (listProperties.isSortOrderAscending()) {
                        n4 = 1;
                        n3 = directoryRow2.getNumberOfRows() + 1;
                        n2 = 1;
                    } else {
                        n4 = directoryRow2.getNumberOfRows();
                        n3 = 0;
                        n2 = -1;
                    }
                } else {
                    quickVector = new QuickVector(0);
                    quickVector.setSize(0);
                    n2 = 0;
                    n3 = 0;
                    n4 = 0;
                    n5 = 0;
                }
                while (n4 != n3) {
                    if (directoryRow2.getColumn(this.hostsColumnCname, n4).length() == 0) {
                        n4 += n2;
                        quickVector.setSize(--n5);
                        continue;
                    }
                    hostData = new HostData();
                    hostData.setNetworkAddress(directoryRow2.getColumn(this.hostsColumnAddr, n4));
                    hostData.setHostName(directoryRow2.getColumn(this.hostsColumnCname, n4));
                    hostData.setAliases(directoryRow2.getColumn(this.hostsColumnAliases, n4));
                    hostData.setDescription(directoryRow2.getColumn(this.hostsColumnComment, n4));
                    if (directoryRow != null) {
                        DirectoryRow directoryRow3 = directoryTable.getRowInstance();
                        directoryRow3.putColumn(this.ethersColumnName, hostData.getHostName());
                        int n7 = directoryRow.getFirstRow(directoryRow3, tableDefinitions2);
                        if (n7 > 0) {
                            hostData.setEthernetAddress(directoryRow.getColumn(this.ethersColumnAddr, n7));
                        }
                    }
                    quickVector.quickSetElementAt(hostData, n++);
                    n4 += n2;
                }
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "hosts", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV21", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "hosts", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV21", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3009", "hosts", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV21", hostException);
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_SRV21", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3009", "listHosts", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV21", hostException);
            }
            Object var24_32 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var24_33 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        return quickVector;
    }

    public int listHostsPrime(SecurityToken securityToken, ListProperties listProperties) throws RemoteException, AdminException {
        Object[] objectArray = null;
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "listHostsPrime");
        }
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "listHostsPrime");
        }
        DirectoryRow directoryRow = null;
        DirectoryTable directoryTable = null;
        if (listProperties == null || listProperties.getChunkSize() < 1) {
            this.logInternalError(securityToken, "LM_3009", "listHostsPrime", "listProps == null || listProps.getChunkSize()<1");
            throw new HostException("EXM_HST_SRV21", new HostException("EXM_HST_SRV99"));
        }
        this.chunkSize = listProperties.getChunkSize();
        this.sortAscending = listProperties.isSortOrderAscending();
        try {
            try {
                this.etherListRow = this.cacheEthersList(securityToken);
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("hosts");
                directoryTable.open(tableDefinitions);
                Vector vector = listProperties.getFilters();
                if (vector != null && !vector.isEmpty()) {
                    DirectoryFilter directoryFilter = new DirectoryFilter(vector.size());
                    int n = 0;
                    while (n < vector.size()) {
                        FilterItem filterItem = (FilterItem)vector.elementAt(n);
                        directoryFilter.add(this.mapHostColumnToNum(filterItem.getAttribute()), filterItem.getBooleanOperator(), filterItem.getOperator(), filterItem.getValue());
                        ++n;
                    }
                    directoryRow = directoryTable.getAll(directoryFilter);
                } else {
                    directoryRow = directoryTable.getAll();
                }
                this.hostListRow = directoryRow;
                if (directoryRow == null) {
                    int n = 0;
                    Object var14_18 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    return n;
                }
                directoryRow.sortByColumn(this.mapHostColumnToNum(listProperties.getSortColumn()), tableDefinitions);
                if (this.sortAscending) {
                    this.hostListIndex = 1;
                    this.hostListLimit = directoryRow.getNumberOfRows() + 1;
                    this.hostListIncrement = 1;
                } else {
                    this.hostListIndex = directoryRow.getNumberOfRows();
                    this.hostListLimit = 0;
                    this.hostListIncrement = -1;
                }
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "hosts", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV21", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "hosts", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV21", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3009", "hosts", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV21", hostException);
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_SRV21", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3009", "listHostsPrime", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV21", hostException);
            }
        }
        catch (Throwable throwable) {
            Object var14_20 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        Object var14_19 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
        return directoryRow.getNumberOfRows();
    }

    public Vector listHostsNext(SecurityToken securityToken) throws RemoteException, AdminException {
        Object[] objectArray = null;
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "listHostsNext");
        }
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "listHostsNext");
        }
        int n = this.chunkSize;
        int n2 = 0;
        HostData hostData = null;
        QuickVector quickVector = new QuickVector(this.chunkSize);
        try {
            quickVector.setSize(this.chunkSize);
            while (n > 0 && this.hostListIndex != this.hostListLimit) {
                if (this.hostListRow.getColumn(this.hostsColumnCname, this.hostListIndex).length() == 0) {
                    this.hostListIndex += this.hostListIncrement;
                    continue;
                }
                hostData = new HostData();
                hostData.setNetworkAddress(this.hostListRow.getColumn(this.hostsColumnAddr, this.hostListIndex));
                hostData.setHostName(this.hostListRow.getColumn(this.hostsColumnCname, this.hostListIndex));
                hostData.setAliases(this.hostListRow.getColumn(this.hostsColumnAliases, this.hostListIndex));
                hostData.setDescription(this.hostListRow.getColumn(this.hostsColumnComment, this.hostListIndex));
                if (this.etherListRow != null && this.ethersTableDefn != null) {
                    this.etherMatchRow.putColumn(this.ethersColumnName, hostData.getHostName());
                    int n3 = this.etherListRow.getFirstRow(this.etherMatchRow, this.ethersTableDefn);
                    if (n3 > 0) {
                        hostData.setEthernetAddress(this.etherListRow.getColumn(this.ethersColumnAddr, n3));
                    }
                }
                quickVector.quickSetElementAt(hostData, n2++);
                --n;
                this.hostListIndex += this.hostListIncrement;
            }
        }
        catch (DirectoryTableException directoryTableException) {
            this.logDirTableException(securityToken, "LM_3009", "hosts", directoryTableException);
            HostException hostException = new HostException("EXM_HST_SRV32");
            throw new HostException("EXM_HST_SRV21", hostException);
        }
        catch (Exception exception) {
            this.logException(securityToken, "LM_3009", "listHostsNext", exception);
            HostException hostException = new HostException("EXM_HST_SRV99", exception);
            throw new HostException("EXM_HST_SRV21", hostException);
        }
        if (n2 < this.chunkSize) {
            quickVector.setSize(n2);
        }
        return quickVector;
    }

    public void listHostsEnd(SecurityToken securityToken) throws RemoteException, AdminException {
        Object[] objectArray = null;
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "listHostsEnd");
        }
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "listHostsEnd");
        }
        this.hostListRow = null;
        this.hostListIndex = this.hostListLimit;
        this.etherListRow = null;
        this.ethersTableDefn = null;
    }

    public void setHost(SecurityToken securityToken, HostData hostData, HostData hostData2) throws RemoteException, AdminException {
        String[] stringArray;
        Object[] objectArray = null;
        if (this.adminSvr.isVerify()) {
            objectArray = new Object[]{hostData, hostData2};
        }
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "setHost");
        }
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "setHost");
        }
        String string = "";
        try {
            string = this.adminSvr.getUserName(securityToken);
            if (!this.adminSvr.checkRights(securityToken, "solaris.admin.hostmgr.write")) {
                String[] stringArray2 = new String[]{string, "LM_HOST_APP_NAME"};
                this.writeLog(securityToken, 0, "LM_1010", "LM_1014", stringArray2, false);
                throw new AuthNoAccessException(string, this.localAppName());
            }
        }
        catch (AuthNoAccessException authNoAccessException) {
            throw authNoAccessException;
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV82", string, "setHost");
        }
        DirectoryTable directoryTable = null;
        if (!hostData.getNetworkAddress().equals(hostData2.getNetworkAddress()) && (stringArray = this.getHostByAddress(securityToken, hostData2.getNetworkAddress())) != null) {
            if (stringArray.getHostName().equals(hostData2.getHostName())) {
                throw new HostException("EXM_HST_SRV22", new HostException("EXM_HST_SRV64"));
            }
            throw new HostException("EXM_HST_SRV22", new HostException("EXM_HST_SRV69"));
        }
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("hosts");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.hostsColumnCname, hostData.getHostName());
                directoryRow.putColumn(this.hostsColumnAddr, hostData.getNetworkAddress());
                directoryRow.putColumn(this.hostsColumnAliases, hostData.getAliases());
                directoryRow.putColumn(this.hostsColumnComment, hostData.getDescription());
                DirectoryRow directoryRow2 = directoryTable.getRowInstance();
                directoryRow2.putColumn(this.hostsColumnCname, hostData2.getHostName());
                directoryRow2.putColumn(this.hostsColumnAddr, hostData2.getNetworkAddress());
                directoryRow2.putColumn(this.hostsColumnAliases, hostData2.getAliases());
                directoryRow2.putColumn(this.hostsColumnComment, hostData2.getDescription());
                directoryTable.modifyRow(directoryRow, directoryRow2);
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV62");
                throw new HostException("EXM_HST_SRV22", hostException);
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV60");
                throw new HostException("EXM_HST_SRV22", hostException);
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "hosts", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV22", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "hosts", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV22", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3005", "hosts", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV22", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3005", "setHost", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV22", hostException);
            }
            Object var13_25 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var13_26 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        this.setEthernetAddress(securityToken, hostData, hostData2);
        stringArray = new String[]{hostData.getHostName()};
        this.writeLog(securityToken, 0, "LM_3004", "LM_3052", stringArray, false);
    }

    public void addHost(SecurityToken securityToken, HostData hostData) throws RemoteException, AdminException {
        Object[] objectArray = null;
        if (this.adminSvr.isVerify()) {
            objectArray = new Object[]{hostData};
        }
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "addHost");
        }
        String string = "";
        try {
            string = this.adminSvr.getUserName(securityToken);
            if (!this.adminSvr.checkRights(securityToken, "solaris.admin.hostmgr.write")) {
                String[] stringArray = new String[]{string, "LM_HOST_APP_NAME"};
                this.writeLog(securityToken, 0, "LM_1010", "LM_1014", stringArray, false);
                throw new AuthNoAccessException(string, this.localAppName());
            }
        }
        catch (AuthNoAccessException authNoAccessException) {
            throw authNoAccessException;
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV82", string, "addHost");
        }
        DirectoryTable directoryTable = null;
        HostData hostData2 = this.getHostByAddress(securityToken, hostData.getNetworkAddress());
        if (hostData2 != null) {
            if (hostData2.getHostName().equals(hostData.getHostName())) {
                throw new HostException("EXM_HST_SRV23", new HostException("EXM_HST_SRV64"));
            }
            throw new HostException("EXM_HST_SRV23", new HostException("EXM_HST_SRV69"));
        }
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("hosts");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.hostsColumnCname, hostData.getHostName());
                directoryRow.putColumn(this.hostsColumnAddr, hostData.getNetworkAddress());
                directoryRow.putColumn(this.hostsColumnAliases, hostData.getAliases());
                directoryRow.putColumn(this.hostsColumnComment, hostData.getDescription());
                directoryTable.addRow(directoryRow);
            }
            catch (DirectoryTableRowNotUniqueException directoryTableRowNotUniqueException) {
                HostException hostException = new HostException("EXM_HST_SRV64");
                throw new HostException("EXM_HST_SRV23", hostException);
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV60");
                throw new HostException("EXM_HST_SRV23", hostException);
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "hosts", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV23", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "hosts", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV23", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3001", "hosts", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV23", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3001", "addHost", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV23", hostException);
            }
            Object var11_21 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var11_22 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        this.addEthernetAddress(securityToken, hostData);
        String[] stringArray = new String[]{hostData.getHostName(), hostData.getNetworkAddress()};
        this.writeLog(securityToken, 0, "LM_3000", "LM_3050", stringArray, false);
    }

    public void deleteHost(SecurityToken securityToken, HostData hostData) throws RemoteException, AdminException {
        Object[] objectArray = null;
        if (this.adminSvr.isVerify()) {
            objectArray = new Object[]{hostData};
        }
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "deleteHost");
        }
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "deleteHost");
        }
        String string = "";
        try {
            string = this.adminSvr.getUserName(securityToken);
            if (!this.adminSvr.checkRights(securityToken, "solaris.admin.hostmgr.write")) {
                String[] stringArray = new String[]{string, "LM_HOST_APP_NAME"};
                this.writeLog(securityToken, 0, "LM_1010", "LM_1014", stringArray, false);
                throw new AuthNoAccessException(string, this.localAppName());
            }
        }
        catch (AuthNoAccessException authNoAccessException) {
            throw authNoAccessException;
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV82", string, "deleteHost");
        }
        DirectoryTable directoryTable = null;
        if (hostData.getHostName().equals(LOCAL_HOST_NAME)) {
            HostException hostException = new HostException("EXM_HST_SRV71");
            throw new HostException("EXM_HST_SRV24", hostException);
        }
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("hosts");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.hostsColumnCname, hostData.getHostName());
                directoryRow.putColumn(this.hostsColumnAddr, hostData.getNetworkAddress());
                directoryRow.putColumn(this.hostsColumnAliases, hostData.getAliases());
                directoryTable.deleteRow(directoryRow);
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV62");
                throw new HostException("EXM_HST_SRV24", hostException);
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV60");
                throw new HostException("EXM_HST_SRV24", hostException);
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "hosts", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV24", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "hosts", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV24", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3003", "hosts", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV24", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3003", "deleteHost", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV24", hostException);
            }
            Object var11_22 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var11_23 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        this.deleteEthernetAddress(securityToken, hostData);
        String[] stringArray = new String[]{hostData.getHostName(), hostData.getNetworkAddress()};
        this.writeLog(securityToken, 0, "LM_3002", "LM_3051", stringArray, false);
    }

    public int renameHost(SecurityToken securityToken, HostData hostData, String string, Integer n) throws RemoteException, AdminException {
        DirectoryRow directoryRow;
        Object[] objectArray = null;
        if (this.adminSvr.isVerify()) {
            objectArray = new Object[]{hostData, string, n};
        }
        try {
            this.adminSvr.checkVerifier(securityToken, objectArray);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV80", "renameHost");
        }
        try {
            AdminMgmtScope adminMgmtScope = this.adminSvr.getMgmtScope(securityToken);
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV81", "renameHost");
        }
        String string2 = "";
        try {
            string2 = this.adminSvr.getUserName(securityToken);
            if (!this.adminSvr.checkRights(securityToken, "solaris.admin.hostmgr.write")) {
                String[] stringArray = new String[]{string2, "LM_HOST_APP_NAME"};
                this.writeLog(securityToken, 0, "LM_1010", "LM_1014", stringArray, false);
                throw new AuthNoAccessException(string2, this.localAppName());
            }
        }
        catch (AuthNoAccessException authNoAccessException) {
            throw authNoAccessException;
        }
        catch (AdminException adminException) {
            throw new HostException("EXM_HST_SRV82", string2, "renameHost");
        }
        int n2 = n;
        DirectoryTable directoryTable = null;
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("hosts");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow2 = directoryTable.getRowInstance();
                directoryRow2.putColumn(this.hostsColumnCname, hostData.getHostName());
                directoryRow = directoryTable.getAll(directoryRow2);
                if (directoryRow == null) {
                    throw new HostException("EXM_HST_SRV62");
                }
                if (n2 == 0 && directoryRow.getNumberOfRows() > 1) {
                    int n3 = directoryRow.getNumberOfRows();
                    Object var18_17 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    return n3;
                }
                int n4 = 1;
                while (n4 <= directoryRow.getNumberOfRows()) {
                    if (n2 > 1 || hostData.getNetworkAddress().equals(directoryRow.getColumn(this.hostsColumnAddr, n4))) {
                        DirectoryRow directoryRow3 = directoryRow.extractRows(n4, n4);
                        DirectoryRow directoryRow4 = directoryRow.extractRows(n4, n4);
                        directoryRow4.putColumn(this.hostsColumnCname, string);
                        directoryTable.modifyRow(directoryRow3, directoryRow4);
                    }
                    ++n4;
                }
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV60");
                throw new HostException("EXM_HST_SRV25", hostException);
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException(securityToken, "LM_3202", "hosts", directoryTableAccessException);
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV25", hostException);
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException(securityToken, "LM_3203", "hosts", directoryTableConnectionException);
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV25", hostException);
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException(securityToken, "LM_3007", "hosts", directoryTableException);
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV25", hostException);
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_SRV25", hostException);
            }
            catch (Exception exception) {
                this.logException(securityToken, "LM_3007", "renameHost", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV25", hostException);
            }
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        Object var18_18 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
        this.renameEthernetAddress(securityToken, hostData, string);
        String[] stringArray = new String[]{hostData.getHostName(), string};
        this.writeLog(securityToken, 0, "LM_3006", "LM_3053", stringArray, false);
        return directoryRow.getNumberOfRows();
    }

    private int mapHostColumnToNum(String string) throws RemoteException, AdminException {
        if (string == null || string.length() == 0) {
            throw new HostException("EXM_HST_SRV99");
        }
        if (string.equals("hostListComputerName")) {
            return this.hostsColumnCname;
        }
        if (string.equals("hostListIPAddress")) {
            return this.hostsColumnAddr;
        }
        if (string.equals("hostListAliases")) {
            return this.hostsColumnAliases;
        }
        if (string.equals("hostListComment")) {
            return this.hostsColumnComment;
        }
        if (string.equals("hostListEnetAddress")) {
            throw new HostException("EXM_HST_SRV67");
        }
        throw new HostException("EXM_HST_SRV99");
    }

    class StopWatch {
        Date startTime;
        Date stopTime;

        public void start() {
            this.startTime = new Date();
        }

        public long stop() {
            this.stopTime = new Date();
            return (this.stopTime.getTime() - this.startTime.getTime()) / 1000L;
        }

        StopWatch() {
            HostMgrImpl.this = HostMgrImpl.this;
        }
    }
}

