/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.client.AdminClientComponent;
import com.sun.admin.cis.client.IClientComm;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.hostmgr.client.ClientProxy;
import com.sun.admin.hostmgr.client.ContentPanel;
import com.sun.admin.hostmgr.client.DemoMgrClient;
import com.sun.admin.hostmgr.client.HostActionsListener;
import com.sun.admin.hostmgr.client.HostMgrClient;
import com.sun.admin.hostmgr.client.HostMgrTree;
import com.sun.admin.hostmgr.client.MainMenuBar;
import com.sun.admin.hostmgr.client.MainToolBar;
import com.sun.admin.hostmgr.client.TreeNodeData;
import com.sun.admin.hostmgr.common.NetworkData;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;

public class Main
extends JPanel
implements AdminClientComponent {
    private static Main theApp;
    private ClientProxy hostMgr;
    private MainMenuBar menuBar;
    private MainToolBar toolBar;
    private JLabel contentLabel;
    private JTextField filterLabel;
    private ContentPanel contentPanel;
    private IClientComm clientComm;
    private HostMgrTree theTree;
    private ResourceBundle resourceBundle;
    private String filterStatusNone;
    private String filterStatusAll;
    private String filterStatusFiltered;

    public Main(IClientComm iClientComm) throws Exception {
        theApp = this;
        this.clientComm = iClientComm;
        this.resourceBundle = ResourceBundle.getBundle("com.sun.admin.hostmgr.resources.ResourceBundle", Locale.getDefault());
        this.filterStatusNone = ResourceStrings.getString(this.resourceBundle, "FilterStatusNone");
        this.filterStatusAll = ResourceStrings.getString(this.resourceBundle, "FilterStatusAll");
        this.filterStatusFiltered = ResourceStrings.getString(this.resourceBundle, "FilterStatusFiltered");
        try {
            this.setLayout(new GridBagLayout());
            this.hostMgr = iClientComm.getSolServerName().compareTo("demo") == 0 ? new DemoMgrClient() : new HostMgrClient();
            try {
                this.hostMgr.setUpConnection(iClientComm);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw exception;
            }
            this.theTree = new HostMgrTree();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            this.menuBar = new MainMenuBar();
            Constraints.constrain(jPanel, this.menuBar, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 20);
            this.menuBar.setBorderPainted(false);
            this.toolBar = new MainToolBar();
            Constraints.constrain(jPanel, this.toolBar, 1, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
            this.filterLabel = new JTextField(this.filterStatusNone.length());
            this.filterLabel.setBorder(BorderFactory.createEmptyBorder());
            this.filterLabel.setEditable(false);
            this.filterLabel.setSelectedTextColor(Color.red);
            this.filterLabel.setSelectionColor(jPanel.getBackground());
            this.filterLabel.setForeground(Color.red);
            Font font = this.filterLabel.getFont();
            this.filterLabel.setFont(new Font(font.getName(), 1, font.getSize() + 2));
            Constraints.constrain(jPanel, this.filterLabel, 2, -1, 0, 1, 0, 13, 1.0, 0.0, 0, 0, 0, 10);
            Constraints.constrain(this, jPanel, 0, -1, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            jPanel2.setBorder(BorderFactory.createEtchedBorder());
            this.contentLabel = new JLabel("  ");
            Constraints.constrain(jPanel2, this.contentLabel, 0, -1, 1, 1, 2, 17, 1.0, 0.0, 5, 5, 5, 0);
            font = this.contentLabel.getFont();
            this.contentLabel.setFont(new Font(font.getName(), 0, font.getSize() + 2));
            this.contentLabel.setForeground(Color.black);
            Constraints.constrain(this, jPanel2, 0, -1, 0, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
            this.contentPanel = this.theTree.getCurrentContentPanel();
            Constraints.constrain(this, this.contentPanel, 0, -1, 0, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
            this.registerKeyboardAction(new HostActionsListener(), "Delete", KeyStroke.getKeyStroke(127, 0, true), 1);
            iClientComm.addToTreePanel(this.theTree);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public void setContentPanel(ContentPanel contentPanel) {
        this.remove(this.contentPanel);
        this.contentPanel = contentPanel;
        Constraints.constrain(this, this.contentPanel, 0, -1, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        this.invalidate();
        this.validate();
        this.repaint();
        DefaultMutableTreeNode defaultMutableTreeNode = contentPanel.getTreeNode();
        TreeNodeData treeNodeData = (TreeNodeData)defaultMutableTreeNode.getUserObject();
        NetworkData networkData = treeNodeData.getNetworkData();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        TreeNodeData treeNodeData2 = null;
        NetworkData networkData2 = null;
        if (defaultMutableTreeNode2 != null) {
            treeNodeData2 = (TreeNodeData)defaultMutableTreeNode2.getUserObject();
            networkData2 = treeNodeData2.getNetworkData();
        }
        String string = "";
        String string2 = "";
        if (networkData == null) {
            string = "ContentsOfManagedScope";
            string2 = this.clientComm.getScopeName();
        } else if (networkData2 == null && networkData.getNetworkAddress().length() == 0) {
            string = "ComputersInManagedScope";
            string2 = this.clientComm.getScopeName();
        } else if (networkData2 == null) {
            string = "ContentsOfNetwork";
            string2 = treeNodeData.getName();
        } else if (networkData.getNetworkAddress().length() == 0) {
            string = "ComputersOnNetwork";
            string2 = treeNodeData2.getName();
        } else {
            string = "ComputersOnSubnetwork";
            string2 = treeNodeData.getName();
        }
        this.contentLabel.setText(String.valueOf(ResourceStrings.getString(this.resourceBundle, string)) + " " + string2);
        this.showFilteredStatus(contentPanel);
    }

    public void showFilteredStatus(ContentPanel contentPanel) {
        Vector vector = contentPanel.getFilters();
        if (!contentPanel.isFilteringSupported()) {
            this.filterLabel.setText("");
            return;
        }
        if (vector == null) {
            this.filterLabel.setText(this.filterStatusNone);
            return;
        }
        if (vector.size() == 0) {
            this.filterLabel.setText(this.filterStatusAll);
            return;
        }
        this.filterLabel.setText(this.filterStatusFiltered);
    }

    public static Main getApp() {
        return theApp;
    }

    public ClientProxy getHostMgr() {
        return this.hostMgr;
    }

    public HostMgrTree getTree() {
        return this.theTree;
    }

    public JFrame getFrame() {
        return this.clientComm.getFrame();
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void appReceivingMainFocus() {
        this.clientComm.addToMainView(this);
    }

    public void appLosingMainFocus() {
        this.theTree.removeSelectionRows(this.theTree.getSelectionRows());
        this.theTree.invalidate();
        this.theTree.validate();
        this.theTree.repaint();
        this.setStatusBar("");
    }

    public void appCloseDown() {
        try {
            this.hostMgr.terminateConnection();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setHelp(String string) {
        try {
            URL uRL = new URL(this.clientComm.getHelpUrl("hostmgr", "hm_ctx_" + string + ".html"));
            this.clientComm.addToHelpPanel(uRL);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return;
        }
    }

    public void setStatusBar(String string) {
        this.clientComm.addToStatusPanel(string, 0);
    }

    public ImageIcon loadImageIcon(String string, String string2) {
        String string3 = "./images/";
        try {
            string3 = this.clientComm.getImagePath();
            string3 = String.valueOf(string3) + "/hostmgr/client/images/";
        }
        catch (Exception exception) {}
        String string4 = new String(String.valueOf(string3) + string);
        return new ImageIcon(string4, string2);
    }

    public IClientComm getClientComm() {
        return this.clientComm;
    }

    public void reportErrorException(Exception exception) {
        String string = "";
        while (exception != null) {
            if (exception instanceof AdminException) {
                AdminException adminException = (AdminException)exception;
                string = String.valueOf(string) + "\n" + adminException.getLocalizedMessage();
                if (adminException.isImbeddedException()) {
                    exception = adminException.getImbeddedException();
                    continue;
                }
                exception = null;
                continue;
            }
            string = String.valueOf(string) + "\n" + exception.getMessage();
            exception = null;
        }
        new ErrorDialog(this.getFrame(), ResourceStrings.getString(this.resourceBundle, "ErrorTitle"), string);
    }
}

