/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.hostmgr.client.AbstractIconModel;
import com.sun.admin.hostmgr.client.AbstractIconView;
import com.sun.admin.hostmgr.client.HostActionsListener;
import com.sun.admin.hostmgr.client.Main;
import com.sun.admin.hostmgr.common.HostData;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;

public class HostIconView
extends AbstractIconView {
    private ImageIcon hostIcon;
    private IconModel iconModel = new IconModel();

    public HostIconView() {
        ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
        this.hostIcon = Main.getApp().loadImageIcon(ResourceStrings.getString(resourceBundle, "LargeHostGif"), "");
    }

    protected AbstractIconModel getIconModel() {
        return this.iconModel;
    }

    protected void onDoubleClick() {
        this.fireItemPressed(2);
        ActionEvent actionEvent = new ActionEvent(this, 1001, "ViewProps");
        HostActionsListener hostActionsListener = new HostActionsListener();
        hostActionsListener.actionPerformed(actionEvent);
    }

    public String getSortAttribute() {
        return "hostListComputerName";
    }

    public Vector getAvailableSortAttributes() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("hostListComputerName");
        return vector;
    }

    class IconModel
    extends AbstractIconModel {
        private int preferredWidth;

        public String getIconLabel(Object object) {
            return ((HostData)object).getHostName();
        }

        public ImageIcon getIcon(Object object) {
            return HostIconView.this.hostIcon;
        }

        public String getHelpName(Object object) {
            return "main_hostlist";
        }

        public int getButtonWidth() {
            if (this.preferredWidth > 0) {
                return this.preferredWidth;
            }
            try {
                ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
                this.preferredWidth = Integer.parseInt(ResourceStrings.getString(resourceBundle, "HostIconButtonWidth"));
            }
            catch (NumberFormatException numberFormatException) {
                this.preferredWidth = 85;
            }
            return this.preferredWidth;
        }

        public int compare(Object object, Object object2) {
            HostData hostData = (HostData)object;
            HostData hostData2 = (HostData)object2;
            String string = this.getIconLabel(hostData);
            String string2 = this.getIconLabel(hostData2);
            int n = string.compareTo(string2);
            return n;
        }

        IconModel() {
            HostIconView.this = HostIconView.this;
        }
    }
}

