/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.server;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.service.directorytable.DirectoryRow;
import com.sun.admin.cis.service.directorytable.DirectoryTable;
import com.sun.admin.cis.service.directorytable.DirectoryTableException;
import com.sun.admin.cis.service.directorytable.DirectoryTableFactory;
import com.sun.admin.cis.service.directorytable.FileTableDefinitions;
import com.sun.admin.fsmgr.common.FsMgrException;
import com.sun.admin.fsmgr.common.FsMgrUsage;
import com.sun.admin.fsmgr.server.FsMgrDfExec;
import com.sun.admin.fsmgr.server.FsMgrFactoryImpl;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class FsMgrUsageTable {
    private static final String USAGETAB = new String("usageTable");
    private static String fileSystem = new String("fileSystem");
    private static String totalBytes = new String("totalBytes");
    private static String usedBytes = new String("usedBytes");
    private static String availBytes = new String("availBytes");
    private static String capacity = new String("capacity");
    private static String mountPoint = new String("mountPoint");
    private int fileSystemColumn;
    private int totalBytesColumn;
    private int usedBytesColumn;
    private int availBytesColumn;
    private int capacityColumn;
    private int mountPointColumn;
    private static final String fileType = new String("File");
    private static final String FSM = new String("FSM");
    private static final String emptyString = new String("");
    private static final String[] dfCommand = new String[]{"/usr/bin/df", "-k"};
    private File tempFile;
    private FileTableDefinitions fileTableDefinitions = new FileTableDefinitions();
    private FsMgrFactoryImpl factoryImpl;

    public FsMgrUsageTable(FsMgrFactoryImpl fsMgrFactoryImpl) throws DirectoryTableException {
        this.factoryImpl = fsMgrFactoryImpl;
        this.fileTableDefinitions.loadTableDefinitions(USAGETAB);
        this.fileSystemColumn = this.fileTableDefinitions.getColumnNumber(fileSystem);
        this.totalBytesColumn = this.fileTableDefinitions.getColumnNumber(totalBytes);
        this.usedBytesColumn = this.fileTableDefinitions.getColumnNumber(usedBytes);
        this.availBytesColumn = this.fileTableDefinitions.getColumnNumber(availBytes);
        this.capacityColumn = this.fileTableDefinitions.getColumnNumber(capacity);
        this.mountPointColumn = this.fileTableDefinitions.getColumnNumber(mountPoint);
    }

    public Vector list(Vector vector) throws DirectoryTableException, FsMgrException {
        Vector<FsMgrUsage> vector2 = new Vector<FsMgrUsage>();
        DirectoryTable directoryTable = this.openUsageTable(vector);
        DirectoryRow directoryRow = directoryTable.getFirstRow();
        while (directoryRow != null) {
            FsMgrUsage fsMgrUsage = this.parseUsageEntry(directoryRow);
            vector2.addElement(fsMgrUsage);
            directoryRow = directoryTable.getNextRow();
        }
        this.closeUsageTable(directoryTable);
        return vector2;
    }

    public FsMgrUsage getUsageEntry(Vector vector, String string) throws DirectoryTableException, FsMgrException {
        DirectoryTable directoryTable = this.openUsageTable(vector);
        DirectoryRow directoryRow = null;
        FsMgrUsage fsMgrUsage = null;
        try {
            directoryRow = directoryTable.getFirstRow();
            while (directoryRow != null) {
                fsMgrUsage = this.parseUsageEntry(directoryRow);
                if (fsMgrUsage != null) {
                    if (string.equals(fsMgrUsage.getFileSystem())) break;
                    fsMgrUsage = null;
                }
                directoryRow = directoryTable.getNextRow();
            }
            this.closeUsageTable(directoryTable);
        }
        catch (DirectoryTableException directoryTableException) {
            this.closeUsageTable(directoryTable);
            throw directoryTableException;
        }
        return fsMgrUsage;
    }

    private DirectoryTable openUsageTable(Vector vector) throws DirectoryTableException, FsMgrException {
        FsMgrDfExec fsMgrDfExec = new FsMgrDfExec(vector);
        String[] stringArray = fsMgrDfExec.run();
        try {
            this.tempFile = AdminCommonTools.CMN_CreateTempFile(FSM);
            if (stringArray != null && stringArray.length != 0) {
                AdminCommonTools.CMN_WriteArray(this.tempFile, stringArray);
            }
        }
        catch (IOException iOException) {
            this.factoryImpl.writeLog(2, "LM_4062", "LM_4063", this.tempFile.getAbsolutePath(), null, null, null);
            throw new FsMgrException("EXM_FSS_DIE");
        }
        String string = this.tempFile.getAbsolutePath();
        this.fileTableDefinitions.setMappedTableName(string);
        DirectoryTableFactory directoryTableFactory = new DirectoryTableFactory();
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance(fileType, emptyString, emptyString);
        directoryTable.open(this.fileTableDefinitions);
        return directoryTable;
    }

    private void closeUsageTable(DirectoryTable directoryTable) throws DirectoryTableException {
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        directoryTable.close();
    }

    private FsMgrUsage parseUsageEntry(DirectoryRow directoryRow) throws DirectoryTableException {
        String string = directoryRow.getColumn(this.fileSystemColumn);
        String string2 = directoryRow.getColumn(this.totalBytesColumn);
        String string3 = directoryRow.getColumn(this.usedBytesColumn);
        String string4 = directoryRow.getColumn(this.availBytesColumn);
        String string5 = directoryRow.getColumn(this.capacityColumn);
        String string6 = directoryRow.getColumn(this.mountPointColumn);
        FsMgrUsage fsMgrUsage = new FsMgrUsage(string, string2, string3, string4, string5, string6);
        return fsMgrUsage;
    }
}

