/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.server;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.service.directorytable.DirectoryRow;
import com.sun.admin.cis.service.directorytable.DirectoryTable;
import com.sun.admin.cis.service.directorytable.DirectoryTableDoesNotExistException;
import com.sun.admin.cis.service.directorytable.DirectoryTableException;
import com.sun.admin.cis.service.directorytable.DirectoryTableFactory;
import com.sun.admin.fsmgr.common.FsMgrException;
import com.sun.admin.fsmgr.common.FsMgrShare;
import com.sun.admin.fsmgr.server.FsMgrFactoryImpl;
import com.sun.admin.fsmgr.server.FsMgrNfsd;
import com.sun.admin.fsmgr.server.FsMgrShareInterface;
import java.util.Vector;

public class FsMgrShareTable
implements FsMgrShareInterface {
    public static final String SHARETAB = new String("sharetab");
    private static final int pathnameColumn = 1;
    private static final int resourceColumn = 2;
    private static final int fsTypeColumn = 3;
    private static final int optionsColumn = 4;
    private static final int descriptionColumn = 5;
    private static final String unshareCommand = new String("/usr/sbin/unshare");
    private static final String emptyString = new String("");
    private static final String space = new String(" ");
    private static final String fileType = new String("File");
    private FsMgrFactoryImpl factoryImpl;

    public FsMgrShareTable(FsMgrFactoryImpl fsMgrFactoryImpl) {
        this.factoryImpl = fsMgrFactoryImpl;
    }

    public Vector list() throws DirectoryTableException {
        Vector<FsMgrShare> vector = new Vector<FsMgrShare>();
        FsMgrShare fsMgrShare = null;
        DirectoryRow directoryRow = null;
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openShareTable();
            directoryRow = directoryTable.getFirstRow();
            while (directoryRow != null) {
                fsMgrShare = this.parseShareEntry(directoryRow);
                if (fsMgrShare != null) {
                    vector.addElement(fsMgrShare);
                }
                directoryRow = directoryTable.getNextRow();
            }
            directoryTable.close();
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        return vector;
    }

    public FsMgrShare getShareEntry(String string) throws DirectoryTableException {
        FsMgrShare fsMgrShare = null;
        DirectoryRow directoryRow = null;
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openShareTable();
            directoryRow = directoryTable.getFirstRow();
            while (directoryRow != null) {
                fsMgrShare = this.parseShareEntry(directoryRow);
                if (fsMgrShare != null) {
                    if (string.equals(fsMgrShare.getPathname())) break;
                    fsMgrShare = null;
                }
                directoryRow = directoryTable.getNextRow();
            }
            directoryTable.close();
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        return fsMgrShare;
    }

    public void addShare(FsMgrShare fsMgrShare) throws FsMgrException {
        Vector vector;
        String[] stringArray;
        if (!FsMgrNfsd.isNfsdStarted(this.factoryImpl)) {
            FsMgrNfsd.startNfsd();
            this.factoryImpl.writeLog(0, "LM_4000", "LM_4014", null, null, null, null);
        }
        if (!FsMgrNfsd.isMountdStarted(this.factoryImpl)) {
            FsMgrNfsd.startMountd();
            this.factoryImpl.writeLog(0, "LM_4000", "LM_4015", null, null, null, null);
        }
        if ((stringArray = (String[])(vector = AdminCommonTools.CMN_exec(fsMgrShare.toArray(), true)).elementAt(1)).length != 0) {
            this.factoryImpl.writeLog(2, "LM_4066", "LM_4099", stringArray[0], null, null, null);
            int n = stringArray[0].indexOf(58) + 1;
            throw new FsMgrException("EXM_FSS_SHARE_ERROR", fsMgrShare.getPathname(), stringArray[0].substring(n));
        }
    }

    public void removeShare(FsMgrShare fsMgrShare) throws FsMgrException {
        String[] stringArray = new String[]{unshareCommand, fsMgrShare.getPathname()};
        Vector vector = AdminCommonTools.CMN_exec(stringArray, true);
        String[] stringArray2 = (String[])vector.elementAt(1);
        if (stringArray2.length != 0) {
            this.factoryImpl.writeLog(2, "LM_4067", "LM_4099", stringArray2[0], null, null, null);
            int n = stringArray2[0].indexOf(58) + 1;
            throw new FsMgrException("EXM_FSS_SHARE_ERROR", fsMgrShare.getPathname(), stringArray2[0].substring(n));
        }
    }

    public void modifyShare(FsMgrShare fsMgrShare, FsMgrShare fsMgrShare2) throws FsMgrException {
        this.addShare(fsMgrShare2);
    }

    private DirectoryTable openShareTable() throws DirectoryTableException {
        DirectoryTableFactory directoryTableFactory = new DirectoryTableFactory();
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance(fileType, emptyString, emptyString);
        directoryTable.open(SHARETAB);
        return directoryTable;
    }

    private FsMgrShare parseShareEntry(DirectoryRow directoryRow) throws DirectoryTableException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        string = directoryRow.getColumn(1);
        string2 = directoryRow.getColumn(2);
        string3 = directoryRow.getColumn(3);
        string4 = directoryRow.getColumn(4);
        string5 = directoryRow.getColumn(5);
        if (string5 != null) {
            String string6;
            int n = 6;
            while ((string6 = directoryRow.getColumn(n)) != null && string6.length() != 0) {
                string5 = String.valueOf(string5) + space + string6;
                ++n;
            }
        }
        FsMgrShare fsMgrShare = new FsMgrShare(string, string2, string3, string4, string5);
        return fsMgrShare;
    }
}

