/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.usage;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.fsmgr.client.FsMgr;
import com.sun.admin.fsmgr.client.usage.Usage;
import com.sun.admin.fsmgr.client.usage.UsageActionsListener;
import com.sun.admin.fsmgr.client.usage.UsageListView;
import com.sun.admin.fsmgr.client.usage.UsageListViewEvent;
import com.sun.admin.fsmgr.client.usage.UsageListViewListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;

public class UsageMenuBar
extends JMenuBar {
    private JRadioButtonMenuItem miAscendSort;
    private JRadioButtonMenuItem miDescendSort;
    private JRadioButtonMenuItem miFileSystemSort;
    private JRadioButtonMenuItem miMountPointSort;
    private JRadioButtonMenuItem miPercentUsedSort;
    private JRadioButtonMenuItem miTotalBytesSort;
    private JRadioButtonMenuItem miUsedBytesSort;
    private JRadioButtonMenuItem miAvailBytesSort;

    public UsageMenuBar() {
        ResourceBundle resourceBundle = FsMgr.getFsMgr().getResourceBundle();
        UsageActionsListener usageActionsListener = new UsageActionsListener();
        ActionString actionString = new ActionString(resourceBundle, "ViewMenu");
        JMenu jMenu = new JMenu(actionString.getString());
        jMenu.setMnemonic(actionString.getMnemonic());
        actionString = new ActionString(resourceBundle, "ViewSortBy");
        JMenu jMenu2 = new JMenu(actionString.getString());
        jMenu2.setMnemonic(actionString.getMnemonic());
        ButtonGroup buttonGroup = new ButtonGroup();
        actionString = new ActionString(resourceBundle, "ViewSortByFileSystem");
        this.miFileSystemSort = new JRadioButtonMenuItem(actionString.getString());
        jMenu2.add(this.miFileSystemSort);
        this.miFileSystemSort.setMnemonic(actionString.getMnemonic());
        this.miFileSystemSort.setActionCommand(UsageActionsListener.SORT_FILESYSTEM);
        this.miFileSystemSort.addActionListener(usageActionsListener);
        this.miFileSystemSort.setSelected(true);
        buttonGroup.add(this.miFileSystemSort);
        actionString = new ActionString(resourceBundle, "ViewSortByMounted");
        this.miMountPointSort = new JRadioButtonMenuItem(actionString.getString());
        jMenu2.add(this.miMountPointSort);
        this.miMountPointSort.setMnemonic(actionString.getMnemonic());
        this.miMountPointSort.setActionCommand(UsageActionsListener.SORT_MOUNTPOINT);
        this.miMountPointSort.addActionListener(usageActionsListener);
        this.miMountPointSort.setSelected(false);
        buttonGroup.add(this.miMountPointSort);
        actionString = new ActionString(resourceBundle, "ViewSortByPercentage");
        this.miPercentUsedSort = new JRadioButtonMenuItem(actionString.getString());
        jMenu2.add(this.miPercentUsedSort);
        this.miPercentUsedSort.setMnemonic(actionString.getMnemonic());
        this.miPercentUsedSort.setActionCommand(UsageActionsListener.SORT_PERCENTAGE);
        this.miPercentUsedSort.addActionListener(usageActionsListener);
        this.miPercentUsedSort.setSelected(false);
        buttonGroup.add(this.miPercentUsedSort);
        actionString = new ActionString(resourceBundle, "ViewSortByTotalBytes");
        this.miTotalBytesSort = new JRadioButtonMenuItem(actionString.getString());
        jMenu2.add(this.miTotalBytesSort);
        this.miTotalBytesSort.setMnemonic(actionString.getMnemonic());
        this.miTotalBytesSort.setActionCommand(UsageActionsListener.SORT_TOTALBYTES);
        this.miTotalBytesSort.addActionListener(usageActionsListener);
        this.miTotalBytesSort.setSelected(false);
        buttonGroup.add(this.miTotalBytesSort);
        actionString = new ActionString(resourceBundle, "ViewSortByUsedBytes");
        this.miUsedBytesSort = new JRadioButtonMenuItem(actionString.getString());
        jMenu2.add(this.miUsedBytesSort);
        this.miUsedBytesSort.setMnemonic(actionString.getMnemonic());
        this.miUsedBytesSort.setActionCommand(UsageActionsListener.SORT_USEDBYTES);
        this.miUsedBytesSort.addActionListener(usageActionsListener);
        this.miUsedBytesSort.setSelected(false);
        buttonGroup.add(this.miUsedBytesSort);
        actionString = new ActionString(resourceBundle, "ViewSortByAvailBytes");
        this.miAvailBytesSort = new JRadioButtonMenuItem(actionString.getString());
        jMenu2.add(this.miAvailBytesSort);
        this.miAvailBytesSort.setMnemonic(actionString.getMnemonic());
        this.miAvailBytesSort.setActionCommand(UsageActionsListener.SORT_AVAILBYTES);
        this.miAvailBytesSort.addActionListener(usageActionsListener);
        this.miAvailBytesSort.setSelected(false);
        buttonGroup.add(this.miAvailBytesSort);
        jMenu2.add(new JSeparator());
        ButtonGroup buttonGroup2 = new ButtonGroup();
        actionString = new ActionString(resourceBundle, "ViewSortByAscending");
        this.miAscendSort = new JRadioButtonMenuItem(actionString.getString());
        jMenu2.add(this.miAscendSort);
        this.miAscendSort.setMnemonic(actionString.getMnemonic());
        this.miAscendSort.setActionCommand("SortAscending");
        this.miAscendSort.addActionListener(usageActionsListener);
        this.miAscendSort.setSelected(true);
        buttonGroup2.add(this.miAscendSort);
        actionString = new ActionString(resourceBundle, "ViewSortByDescending");
        this.miDescendSort = new JRadioButtonMenuItem(actionString.getString());
        jMenu2.add(this.miDescendSort);
        this.miDescendSort.setMnemonic(actionString.getMnemonic());
        this.miDescendSort.setActionCommand("SortDescending");
        this.miDescendSort.addActionListener(usageActionsListener);
        buttonGroup2.add(this.miDescendSort);
        jMenu.add(jMenu2);
        jMenu.add(new JSeparator());
        actionString = new ActionString(resourceBundle, "ViewRefresh");
        JMenuItem jMenuItem = new JMenuItem(actionString.getString());
        jMenu.add(jMenuItem);
        jMenuItem.setMnemonic(actionString.getMnemonic());
        jMenuItem.setActionCommand("Refresh");
        jMenuItem.addActionListener(usageActionsListener);
        this.add(jMenu);
        Usage.getInstance().getContentPanel().addListViewListener(new UsageMenuViewListener());
        this.setMinimumSize(this.getPreferredSize());
    }

    private void showTableView() {
    }

    private void showAscendingSortOrder() {
        this.miAscendSort.setSelected(true);
        this.miDescendSort.setSelected(false);
    }

    private void showDescendingSortOrder() {
        this.miAscendSort.setSelected(false);
        this.miDescendSort.setSelected(true);
    }

    private void showSortAttribute(String string, Vector vector) {
        if (string.compareTo(UsageListView.FILESYSTEM_SORT) == 0) {
            this.miFileSystemSort.setSelected(true);
        }
        if (string.compareTo(UsageListView.TOTALBYTES_SORT) == 0) {
            this.miTotalBytesSort.setSelected(true);
        }
        if (string.compareTo(UsageListView.PERCENTAGE_SORT) == 0) {
            this.miPercentUsedSort.setSelected(true);
        }
        if (string.compareTo(UsageListView.USEDBYTES_SORT) == 0) {
            this.miUsedBytesSort.setSelected(true);
        }
        if (string.compareTo(UsageListView.AVAILBYTES_SORT) == 0) {
            this.miAvailBytesSort.setSelected(true);
        }
        if (string.compareTo(UsageListView.MOUNTPOINT_SORT) == 0) {
            this.miMountPointSort.setSelected(true);
        }
        this.miFileSystemSort.setEnabled(false);
        this.miTotalBytesSort.setEnabled(false);
        this.miUsedBytesSort.setEnabled(false);
        this.miAvailBytesSort.setEnabled(false);
        this.miMountPointSort.setEnabled(false);
        int n = 0;
        while (n < vector.size()) {
            string = (String)vector.elementAt(n);
            if (string.compareTo(UsageListView.FILESYSTEM_SORT) == 0) {
                this.miFileSystemSort.setEnabled(true);
            }
            if (string.compareTo(UsageListView.TOTALBYTES_SORT) == 0) {
                this.miTotalBytesSort.setEnabled(true);
            }
            if (string.compareTo(UsageListView.PERCENTAGE_SORT) == 0) {
                this.miPercentUsedSort.setEnabled(true);
            }
            if (string.compareTo(UsageListView.USEDBYTES_SORT) == 0) {
                this.miUsedBytesSort.setEnabled(true);
            }
            if (string.compareTo(UsageListView.AVAILBYTES_SORT) == 0) {
                this.miAvailBytesSort.setEnabled(true);
            }
            if (string.compareTo(UsageListView.MOUNTPOINT_SORT) == 0) {
                this.miMountPointSort.setEnabled(true);
            }
            ++n;
        }
    }

    private void notifySelectionChange(int n) {
    }

    private class UsageMenuViewListener
    implements UsageListViewListener {
        public void itemPressed(UsageListViewEvent usageListViewEvent) {
            UsageListView usageListView = usageListViewEvent.getSource();
            UsageMenuBar.this.notifySelectionChange(usageListView.getNumSelections());
        }

        public void viewChanged(UsageListViewEvent usageListViewEvent) {
            if (usageListViewEvent.getViewType() == 1) {
                UsageMenuBar.this.showTableView();
            }
        }

        public void sortChanged(UsageListViewEvent usageListViewEvent) {
            if (usageListViewEvent.getSortOrder() == 10) {
                UsageMenuBar.this.showAscendingSortOrder();
            }
            if (usageListViewEvent.getSortOrder() == 11) {
                UsageMenuBar.this.showDescendingSortOrder();
            }
            UsageMenuBar.this.showSortAttribute(usageListViewEvent.getSortAttribute(), usageListViewEvent.getAvailableSortAttributes());
        }

        UsageMenuViewListener() {
            UsageMenuBar.this = UsageMenuBar.this;
        }
    }
}

