/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.share;

import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.fsmgr.client.FsMgr;
import com.sun.admin.fsmgr.client.FsMgrClient;
import com.sun.admin.fsmgr.client.FsMgrResourceStrings;
import com.sun.admin.fsmgr.client.share.FsMgrShareData;
import com.sun.admin.fsmgr.client.share.Share;
import com.sun.admin.fsmgr.client.share.ShareCacheEntry;
import com.sun.admin.fsmgr.common.FsMgrException;
import com.sun.admin.fsmgr.common.FsMgrShare;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UnshareAction {
    private ShareCacheEntry cacheEntry;
    private String action;
    private boolean canUnshare = false;

    public UnshareAction(ShareCacheEntry shareCacheEntry, String string) {
        String string2;
        this.cacheEntry = shareCacheEntry;
        this.action = string;
        if (string.equals("UnshareBoot")) {
            this.canUnshare = true;
            return;
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        try {
            string2 = FsMgrResourceStrings.getString("ConfirmUnshareNumColumns");
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = 30;
        }
        string2 = FsMgrResourceStrings.getString("ConfirmUnshare");
        FlowArea flowArea = new FlowArea(string2, n, Constants.ERROR_DIALOG_FONT);
        Constraints.constrain(jPanel, flowArea, 0, 0, 2, 1, 20, 5, 0, 5);
        String string3 = FsMgrResourceStrings.getString("ConfirmUnshareWill");
        flowArea = new FlowArea(string3, n, Constants.ERROR_DIALOG_FONT);
        Constraints.constrain(jPanel, flowArea, 0, 1, 2, 1, 20, 5, 10, 5);
        String string4 = FsMgrResourceStrings.getString("DialogBulletGif");
        ImageIcon imageIcon = FsMgr.getFsMgr().loadImageIcon(string4, "DialogBulletGif");
        Constraints.constrain(jPanel, new JLabel(imageIcon), 0, 2, 1, 1, 0, 18, 0.0, 0.0, 0, 10, 10, 5);
        String string5 = FsMgrResourceStrings.getString("ConfirmUnshareBullet1");
        flowArea = new FlowArea(string5, n - 5, Constants.ERROR_DIALOG_FONT);
        Constraints.constrain(jPanel, flowArea, 1, 2, 1, 1, 0, 5, 10, 5);
        Constraints.constrain(jPanel, new JLabel(imageIcon), 0, 3, 1, 1, 0, 18, 0.0, 0.0, 0, 10, 10, 5);
        String string6 = FsMgrResourceStrings.getString("ConfirmUnshareBullet2");
        flowArea = new FlowArea(string6, n - 5, Constants.ERROR_DIALOG_FONT);
        Constraints.constrain(jPanel, flowArea, 1, 3, 1, 1, 0, 5, 10, 5);
        Constraints.constrain(jPanel, new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), 0, -1, 1, 0, 3, 18, 0.0, 1.0, 0, 0, 0, 0);
        new WarningDialog(FsMgr.getFsMgr().getFrame(), FsMgrResourceStrings.getString("ConfirmUnshareTitle"), jPanel, (ActionListener)new ConfirmUnshareListener(shareCacheEntry, string), FsMgrResourceStrings.getString("Unshare"));
    }

    public void unshare() {
        if (!this.canUnshare) {
            return;
        }
        String string = FsMgrResourceStrings.getString("PerformingUnshareTitle");
        String string2 = FsMgrResourceStrings.getString("PerformingUnshareMessage");
        Object[] objectArray = new Object[]{this.cacheEntry.getPathname()};
        String string3 = MessageFormat.format(string2, objectArray);
        ProgressPanel progressPanel = new ProgressPanel(FsMgr.getFsMgr().getFrame(), 1, 30, false, false);
        progressPanel.setTitle(string);
        progressPanel.setText(string3);
        ((Component)progressPanel).setVisible(true);
        progressPanel.show();
        try {
            FsMgrShare fsMgrShare = null;
            FsMgrClient fsMgrClient = FsMgrClient.instance();
            if (this.action.equals("UnshareNow") || this.action.equals("UnshareBoth")) {
                fsMgrShare = this.cacheEntry.getNowData().toFsMgrShare();
                fsMgrClient.removeShare(fsMgrShare, FsMgrShareData.SHARETAB);
            }
            if (this.action.equals("UnshareBoot") || this.action.equals("UnshareBoth")) {
                fsMgrShare = this.cacheEntry.getBootData().toFsMgrShare();
                fsMgrClient.removeShare(fsMgrShare, FsMgrShareData.DFSTAB);
            }
            Share.getInstance().refresh(fsMgrShare.getPathname());
        }
        catch (FsMgrException fsMgrException) {
            new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrException.getLocalizedMessage());
        }
        try {
            Thread.currentThread();
            Thread.sleep(1500L);
        }
        catch (Exception exception) {}
        ((Component)progressPanel).setVisible(false);
        progressPanel.dispose();
    }

    static /* synthetic */ boolean access$0(UnshareAction unshareAction) {
        return unshareAction.canUnshare;
    }

    private class ConfirmUnshareListener
    implements ActionListener {
        ShareCacheEntry cacheEntry;
        String action;

        public ConfirmUnshareListener(ShareCacheEntry shareCacheEntry, String string) {
            UnshareAction.this = UnshareAction.this;
            this.cacheEntry = shareCacheEntry;
            this.action = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UnshareAction.this.canUnshare = true;
        }
    }
}

