/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.share;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.fsmgr.client.FsMgrResourceStrings;
import com.sun.admin.fsmgr.client.share.FsMgrShareData;

public class ShareCacheEntry {
    private FsMgrShareData nowData;
    private FsMgrShareData bootData;
    public static final String NOW = FsMgrResourceStrings.getString("now");
    public static final String ATBOOT = FsMgrResourceStrings.getString("atboot");
    public static final String BOTH = FsMgrResourceStrings.getString("both");
    public static final String CONFLICT = FsMgrResourceStrings.getString("conflict");
    private static final String COMMA = new String(", ");
    private static final String DASH = new String("-");
    private static final String READONLY = FsMgrResourceStrings.getString("read_only");
    private static final String READWRITE = FsMgrResourceStrings.getString("read_write");
    private static final String ADVANCED = FsMgrResourceStrings.getString("advanced");

    public ShareCacheEntry(FsMgrShareData fsMgrShareData, FsMgrShareData fsMgrShareData2) {
        this.bootData = fsMgrShareData;
        this.nowData = fsMgrShareData2;
    }

    public void setNowData(FsMgrShareData fsMgrShareData) {
        this.nowData = fsMgrShareData;
    }

    public FsMgrShareData getNowData() {
        return this.nowData;
    }

    public void setBootData(FsMgrShareData fsMgrShareData) {
        this.bootData = fsMgrShareData;
    }

    public FsMgrShareData getBootData() {
        return this.bootData;
    }

    public String getPathname() {
        String string = null;
        if (this.nowData != null) {
            string = this.nowData.getPathname();
        } else if (this.bootData != null) {
            string = this.bootData.getPathname();
        } else {
            AdminCommonTools.CMN_HandleOutput("Illegal ShareCacheEntry object");
        }
        return string;
    }

    public String getDescription() {
        String string = null;
        if (this.isConflict() && !this.nowData.getDescription().equals(this.bootData.getDescription())) {
            string = DASH;
        } else if (this.nowData != null) {
            string = this.nowData.getDescription();
        } else if (this.bootData != null) {
            string = this.bootData.getDescription();
        } else {
            AdminCommonTools.CMN_HandleOutput("Illegal ShareCacheEntry object");
        }
        return string;
    }

    public String getAccess() {
        FsMgrShareData fsMgrShareData = null;
        String string = null;
        if (this.nowData != null) {
            fsMgrShareData = this.nowData;
        } else if (this.bootData != null) {
            fsMgrShareData = this.bootData;
        } else {
            AdminCommonTools.CMN_HandleOutput("Illegal ShareCacheEntry object");
            return string;
        }
        string = this.isConflict() && !this.nowData.equalAccess(this.bootData) ? DASH : (fsMgrShareData.isRw() ? READWRITE : (fsMgrShareData.isRo() ? READONLY : ADVANCED));
        return string;
    }

    public FsMgrShareData getData(String string) {
        FsMgrShareData fsMgrShareData = null;
        if (string.equals(BOTH) && this.nowData != null && this.bootData != null && !this.isConflict()) {
            fsMgrShareData = this.bootData;
        } else if (string.equals(NOW)) {
            fsMgrShareData = this.nowData;
        } else if (string.equals(ATBOOT)) {
            fsMgrShareData = this.bootData;
        } else {
            AdminCommonTools.CMN_HandleOutput("Invalid data type specified in ShareCacheEntry.getData()");
        }
        return fsMgrShareData;
    }

    public String getTable(String string) {
        String string2 = null;
        if (string.equals(NOW)) {
            string2 = FsMgrShareData.SHARETAB;
        } else if (string.equals(ATBOOT)) {
            string2 = FsMgrShareData.DFSTAB;
        } else {
            AdminCommonTools.CMN_HandleOutput("Invalid data type specified in ShareCacheEntry.getTable()");
        }
        return string2;
    }

    public String[] getTableArray(String string) {
        String[] stringArray = null;
        if (string.equals(BOTH)) {
            stringArray = FsMgrShareData.SHAREBOTH_ARRAY;
        } else if (string.equals(NOW)) {
            stringArray = FsMgrShareData.SHARETAB_ARRAY;
        } else if (string.equals(ATBOOT)) {
            stringArray = FsMgrShareData.DFSTAB_ARRAY;
        } else {
            AdminCommonTools.CMN_HandleOutput("Invalid data type specified in ShareCacheEntry.getData()");
        }
        return stringArray;
    }

    public String getStatus() {
        String string = null;
        if (this.isConflict()) {
            string = CONFLICT;
        } else if (this.nowData != null && this.bootData != null) {
            string = BOTH;
        } else if (this.nowData != null) {
            string = NOW;
        } else if (this.bootData != null) {
            string = ATBOOT;
        }
        return string;
    }

    public String getStatusString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        if (this.isConflict()) {
            stringBuffer.append(CONFLICT);
        } else {
            if (this.nowData != null) {
                stringBuffer.append(NOW);
                stringBuffer.append(COMMA);
            }
            if (this.bootData != null) {
                stringBuffer.append(ATBOOT);
                stringBuffer.append(COMMA);
            }
            if (stringBuffer.length() != 0) {
                stringBuffer.setLength(stringBuffer.length() - 2);
            }
        }
        return stringBuffer.toString();
    }

    public boolean isConflict() {
        if (this.nowData == null || this.bootData == null) {
            return false;
        }
        return !this.nowData.equals(this.bootData);
    }
}

