/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.mount;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.JMenuPlus;
import com.sun.admin.cis.common.sort.TableSorter;
import com.sun.admin.fsmgr.client.FsMgr;
import com.sun.admin.fsmgr.client.FsMgrResourceStrings;
import com.sun.admin.fsmgr.client.mount.Mount;
import com.sun.admin.fsmgr.client.mount.MountActionsListener;
import com.sun.admin.fsmgr.client.mount.MountCache;
import com.sun.admin.fsmgr.client.mount.MountCacheEntry;
import com.sun.admin.fsmgr.client.mount.MountListView;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class MountTableView
extends MountListView {
    public JTable table;
    JScrollPane scrollPane;
    Object[][] theData;
    MountTableModel dataModel;
    TableSorter tableSorter;
    int oldSortColumn;
    int theSortColumn;
    boolean ascendSort = true;
    MountTableView thisView;
    Vector vColumns = new Vector();
    ResourceBundle bundle = FsMgr.getFsMgr().getResourceBundle();
    private static String MOUNTPOINT = FsMgrResourceStrings.getString("MountTableMountPoint");
    private static String RESOURCE = FsMgrResourceStrings.getString("MountTableResource");
    private static String TYPE = FsMgrResourceStrings.getString("MountTableType");
    private static String STATUS = FsMgrResourceStrings.getString("MountTableStatus");
    private static String ACCESS = FsMgrResourceStrings.getString("MountTableAccess");
    String[] columnKeys = new String[]{MOUNTPOINT, RESOURCE, TYPE, STATUS, ACCESS};

    public MountTableView() {
        this.thisView = this;
        this.vColumns.addElement(new String(MOUNTPOINT));
        this.vColumns.addElement(new String(RESOURCE));
        this.vColumns.addElement(new String(TYPE));
        this.vColumns.addElement(new String(STATUS));
        this.vColumns.addElement(new String(ACCESS));
        this.dataModel = new MountTableModel();
        this.theData = new Object[0][this.dataModel.getMaxColumnCount()];
        this.tableSorter = new TableSorter(this.dataModel);
        this.table = new JTable(this.tableSorter);
        this.table.setBackground(Color.white);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoResizeMode(4);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new 1());
        this.table.addMouseListener(new TableMouseListener(this));
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.addMouseListener(new 2());
        this.setViewportView(this.table);
        this.setBackground(Color.white);
    }

    protected int getViewType() {
        return 1;
    }

    public void populate() {
        MountCache mountCache = Mount.getInstance().getMountCache();
        this.theData = new Object[mountCache.size()][this.dataModel.getMaxColumnCount()];
        int n = 0;
        while (n < mountCache.size()) {
            MountCacheEntry mountCacheEntry = (MountCacheEntry)mountCache.elementAt(n);
            this.dataModel.addMountAtRow(n, mountCacheEntry);
            ++n;
        }
        this.tableSorter.tableChanged(new TableModelEvent(this.dataModel));
        this.tableSorter.sortByColumn(this.theSortColumn, this.ascendSort);
        this.fireSortChanged();
    }

    public void clear() {
        this.clearSelection();
        this.theData = new Object[0][this.dataModel.getMaxColumnCount()];
        this.tableSorter.tableChanged(new TableModelEvent(this.dataModel));
    }

    public void append(Vector vector) {
    }

    public Object getSelectedItem() {
        int[] nArray = this.table.getSelectedRows();
        MountCache mountCache = Mount.getInstance().getMountCache();
        Object e = mountCache.elementAt(this.tableSorter.convertRowIndexToModel(nArray[0]));
        return e;
    }

    public int getNumSelections() {
        return this.table.getSelectedRowCount();
    }

    private void onSelect() {
        this.fireItemPressed(1);
    }

    public void selectAll() {
        this.table.setRowSelectionInterval(0, this.table.getRowCount() - 1);
    }

    public void clearSelection() {
        this.table.clearSelection();
        this.fireItemPressed(0);
    }

    public void sortAscending() {
        this.ascendSort = true;
        this.tableSorter.sortByColumn(this.theSortColumn, this.ascendSort);
        this.fireSortChanged();
    }

    public void sortDescending() {
        this.ascendSort = false;
        this.tableSorter.sortByColumn(this.theSortColumn, this.ascendSort);
        this.fireSortChanged();
    }

    public void sortByAttribute(String string) {
        try {
            int n;
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            this.theSortColumn = n = tableColumnModel.getColumnIndex(string);
            this.tableSorter.sortByColumn(this.theSortColumn, this.ascendSort);
            this.fireSortChanged();
            return;
        }
        catch (Exception exception) {
            this.fireSortChanged();
            return;
        }
    }

    protected int getSortOrder() {
        if (this.ascendSort) {
            return 10;
        }
        return 11;
    }

    public String getSortAttribute() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(this.theSortColumn);
        return (String)tableColumn.getIdentifier();
    }

    public void find(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        if (this.table.getRowCount() == 0) {
            return;
        }
        int n = 0;
        while (n < this.table.getRowCount()) {
            int n2 = this.tableSorter.convertRowIndexToModel(n);
            String string3 = this.dataModel.getResource(n2);
            String string4 = this.dataModel.getMountPoint(n2);
            if (string3 != null && string4 != null && string.equals(string3) && string2.equals(string4)) {
                this.table.clearSelection();
                this.table.setRowSelectionInterval(n, n);
                Rectangle rectangle = this.table.getCellRect(n, 0, false);
                this.table.scrollRectToVisible(rectangle);
                return;
            }
            ++n;
        }
    }

    public Vector getAvailableSortAttributes() {
        return this.vColumns;
    }

    public void doPopupMenu(MouseEvent mouseEvent, boolean bl) {
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        if (bl) {
            this.table.clearSelection();
            this.table.setRowSelectionInterval(n, n);
        }
        Mount mount = Mount.getInstance();
        JMenuPlus jMenuPlus = mount.getMountMenuBar().getActionMenu();
        MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(this.table, mouseEvent, this.getViewport());
        Point point = mouseEvent2.getPoint();
        jMenuPlus.showPopupAt(this, point.x, point.y);
    }

    class MountTableModel
    extends AbstractTableModel {
        Vector tableColumns = new Vector();

        public int getColumnCount() {
            return MountTableView.this.vColumns.size();
        }

        public int getRowCount() {
            return MountTableView.this.theData.length;
        }

        public String getResource(int n) {
            int n2 = this.getColumnModelIndex(RESOURCE);
            return (String)this.getValueAt(n, n2);
        }

        public String getMountPoint(int n) {
            int n2 = this.getColumnModelIndex(MOUNTPOINT);
            return (String)this.getValueAt(n, n2);
        }

        public Object getValueAt(int n, int n2) {
            if (MountTableView.this.theData.length == 0) {
                return null;
            }
            return MountTableView.this.theData[n][n2];
        }

        public String getColumnName(int n) {
            String string = (String)MountTableView.this.vColumns.elementAt(n);
            ActionString actionString = new ActionString(MountTableView.this.bundle, string);
            return actionString.getString();
        }

        public void addMountAtRow(int n, MountCacheEntry mountCacheEntry) {
            int n2 = this.getColumnModelIndex(MOUNTPOINT);
            MountTableView.this.theData[n][n2] = mountCacheEntry.getMountPoint();
            n2 = this.getColumnModelIndex(RESOURCE);
            MountTableView.this.theData[n][n2] = mountCacheEntry.getResource();
            n2 = this.getColumnModelIndex(TYPE);
            MountTableView.this.theData[n][n2] = mountCacheEntry.getType();
            n2 = this.getColumnModelIndex(STATUS);
            MountTableView.this.theData[n][n2] = mountCacheEntry.getStatusString();
            n2 = this.getColumnModelIndex(ACCESS);
            MountTableView.this.theData[n][n2] = mountCacheEntry.getAccess();
        }

        public int getMaxColumnCount() {
            return MountTableView.this.columnKeys.length;
        }

        public String getColumnModelKey(int n) {
            return MountTableView.this.columnKeys[n];
        }

        public TableColumn getTableColumn(int n) {
            return (TableColumn)this.tableColumns.elementAt(n);
        }

        public int getColumnModelIndex(String string) {
            int n = 0;
            while (n < this.getMaxColumnCount()) {
                if (string.compareTo(MountTableView.this.columnKeys[n]) == 0) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public MountTableModel() {
            MountTableView.this = MountTableView.this;
            int n = 0;
            while (n < MountTableView.this.columnKeys.length) {
                String string = MountTableView.this.columnKeys[n];
                ActionString actionString = new ActionString(MountTableView.this.bundle, string);
                TableColumn tableColumn = new TableColumn();
                tableColumn.setIdentifier(string);
                tableColumn.setHeaderValue(actionString.getString());
                tableColumn.setModelIndex(n);
                this.tableColumns.addElement(tableColumn);
                ++n;
            }
        }
    }

    private final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            MountTableView.this.onSelect();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseAdapter {
        boolean needSort = false;

        public void mouseExited(MouseEvent mouseEvent) {
            this.needSort = false;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.needSort = true;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!this.needSort) {
                return;
            }
            this.needSort = false;
            TableColumnModel tableColumnModel = MountTableView.this.table.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = MountTableView.this.table.convertColumnIndexToModel(n);
            if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                MountCacheEntry mountCacheEntry = null;
                if (MountTableView.this.getNumSelections() != 0) {
                    mountCacheEntry = (MountCacheEntry)MountTableView.this.getSelectedItem();
                }
                MountTableView.this.oldSortColumn = MountTableView.this.theSortColumn;
                MountTableView.this.theSortColumn = n2;
                MountTableView.this.ascendSort = MountTableView.this.theSortColumn == MountTableView.this.oldSortColumn ? !MountTableView.this.ascendSort : true;
                MountTableView.this.tableSorter.sortByColumn(MountTableView.this.theSortColumn, MountTableView.this.ascendSort);
                MountTableView.this.fireSortChanged();
                if (mountCacheEntry != null) {
                    MountTableView.this.find(mountCacheEntry.getResource(), mountCacheEntry.getMountPoint());
                }
            }
        }

        /* synthetic */ 2() {
        }
    }

    class TableMouseListener
    extends MouseAdapter {
        MountTableView listView;

        public TableMouseListener(MountTableView mountTableView2) {
            MountTableView.this = MountTableView.this;
            this.listView = mountTableView2;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = MountTableView.this.table.rowAtPoint(point);
            MountTableView.this.table.columnAtPoint(point);
            if (mouseEvent.isPopupTrigger()) {
                MountTableView.this.doPopupMenu(mouseEvent, true);
                return;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && n == -1) {
                MountTableView.this.table.clearSelection();
                return;
            }
            if (mouseEvent.isControlDown() || mouseEvent.getClickCount() != 2) {
                return;
            }
            this.listView.fireItemPressed(2);
            ActionEvent actionEvent = new ActionEvent(this.listView, 1001, "ViewMount");
            MountActionsListener mountActionsListener = new MountActionsListener();
            mountActionsListener.actionPerformed(actionEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MountTableView.this.doPopupMenu(mouseEvent, true);
            }
        }
    }
}

