/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.logging;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.service.logging.AdminLogException;
import com.sun.admin.cis.service.logging.Buffer;
import com.sun.admin.cis.service.logging.LogFilter;
import com.sun.admin.cis.service.logging.LogRecordHeader;
import com.sun.admin.cis.service.logging.LogServiceWrapper;
import java.util.Vector;

public class ChunkThread
implements Runnable {
    private static int CHUNK_SIZE = 200;
    Buffer shared_buffer;
    LogServiceWrapper logService;
    long recordId;
    int numRecords;
    LogFilter filter;
    String fileName;

    public ChunkThread(Buffer buffer, LogServiceWrapper logServiceWrapper, long l, int n, LogFilter logFilter, String string) {
        this.shared_buffer = buffer;
        this.logService = logServiceWrapper;
        this.recordId = l;
        this.filter = logFilter;
        this.numRecords = n;
        this.fileName = string;
    }

    public void run() {
        Vector vector = new Vector();
        int n = 0;
        while (this.shared_buffer.getMessage()) {
            try {
                int n2 = this.numRecords - n > CHUNK_SIZE ? CHUNK_SIZE : this.numRecords - n;
                vector = this.logService.getList(n2, this.filter, this.recordId, this.fileName);
            }
            catch (AdminLogException adminLogException) {
                this.shared_buffer.setException(adminLogException);
                this.shared_buffer.setMessage();
                this.shared_buffer.setDone(true);
                return;
            }
            catch (AdminException adminException) {
                this.shared_buffer.setException(new AdminLogException(adminException.getMessage()));
                this.shared_buffer.setMessage();
                this.shared_buffer.setDone(true);
                return;
            }
            if (vector == null) {
                this.shared_buffer.setMessage();
                this.shared_buffer.putRecs(null);
                return;
            }
            this.shared_buffer.putRecs(vector);
            if ((n += vector.size()) >= this.numRecords || vector.size() == 0) {
                this.shared_buffer.setMessage();
                this.shared_buffer.setDone(true);
                return;
            }
            LogRecordHeader logRecordHeader = (LogRecordHeader)vector.lastElement();
            this.recordId = logRecordHeader.getRecordId();
        }
    }
}

