/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.directorytable;

import com.sun.admin.cis.service.directorytable.DirectoryTableAccessException;
import com.sun.admin.cis.service.directorytable.DirectoryTableException;
import com.sun.admin.cis.service.directorytable.DirectoryTableLibrary;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

class FileEditor {
    String fileToEdit;
    BufferedReader readStream;
    BufferedWriter writeStream;
    boolean locked;
    int tableAttributes;
    String saveLine;

    FileEditor(String string, int n) {
        this.fileToEdit = string;
        this.tableAttributes = n;
        this.saveLine = null;
        this.locked = false;
        this.readStream = null;
        this.writeStream = null;
    }

    String getFirstLine() throws DirectoryTableException {
        try {
            if (this.readStream != null) {
                this.readStream.close();
                this.readStream = null;
            }
            this.readStream = new BufferedReader(new FileReader(this.fileToEdit), 32768);
            this.saveLine = null;
            String string = this.getNextLine();
            return string;
        }
        catch (IOException iOException) {
            throw new DirectoryTableAccessException("EXM_READERROR", this.fileToEdit);
        }
    }

    String getNextLine() throws DirectoryTableException {
        try {
            String string;
            if (this.saveLine != null) {
                string = this.saveLine;
                this.saveLine = null;
            } else {
                string = this.readStream.readLine();
            }
            if (string == null) {
                return string;
            }
            if ((this.tableAttributes & 0x40) == 64) {
                this.saveLine = this.readStream.readLine();
                while (this.saveLine != null && this.saveLine.length() != 0 && (this.saveLine.charAt(0) == ' ' || this.saveLine.charAt(0) == '\t')) {
                    int n = 0;
                    while (n < this.saveLine.length() && (this.saveLine.charAt(n) == ' ' || this.saveLine.charAt(n) == '\t')) {
                        ++n;
                    }
                    if (n < this.saveLine.length()) {
                        string = String.valueOf(string) + this.saveLine.substring(n, this.saveLine.length());
                    }
                    this.saveLine = this.readStream.readLine();
                }
                return string;
            }
            if ((this.tableAttributes & 0x20) == 32) {
                String string2 = null;
                while (string.charAt(string.length() - 1) == '\\') {
                    string2 = this.readStream.readLine();
                    string = string2 != null ? String.valueOf(string.substring(0, string.length() - 1)) + string2 : string.substring(0, string.length() - 1);
                }
                return string;
            }
            return string;
        }
        catch (IOException iOException) {
            throw new DirectoryTableAccessException("EXM_READERROR", this.fileToEdit);
        }
    }

    void modifyLine(String string, String string2) throws DirectoryTableException {
        try {
            try {
                this.lockFile();
                String string3 = this.makeTempName(this.fileToEdit);
                File file = new File(string3);
                file.delete();
                file = null;
                this.writeStream = new BufferedWriter(new FileWriter(string3), 32768);
                String string4 = this.getFirstLine();
                while (string4 != null) {
                    if (string.equals(string4)) {
                        this.writeStream.write(string2);
                        this.writeStream.newLine();
                    } else {
                        this.writeStream.write(string4);
                        this.writeStream.newLine();
                    }
                    string4 = this.getNextLine();
                }
                this.writeStream.close();
                this.readStream.close();
                this.readStream = null;
                this.writeStream = null;
                this.replaceFile(this.fileToEdit, string3);
            }
            catch (IOException iOException) {
                throw new DirectoryTableAccessException("EXM_WRITEERROR", this.fileToEdit);
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.unlockFile();
            throw throwable;
        }
        this.unlockFile();
    }

    void addLine(String string) throws DirectoryTableException {
        try {
            try {
                this.lockFile();
                String string2 = this.makeTempName(this.fileToEdit);
                File file = new File(string2);
                file.delete();
                file = null;
                this.writeStream = new BufferedWriter(new FileWriter(string2), 32768);
                String string3 = this.getFirstLine();
                while (string3 != null) {
                    this.writeStream.write(string3);
                    this.writeStream.newLine();
                    string3 = this.getNextLine();
                }
                this.writeStream.write(string);
                this.writeStream.newLine();
                this.writeStream.close();
                this.readStream.close();
                this.readStream = null;
                this.writeStream = null;
                this.replaceFile(this.fileToEdit, string2);
            }
            catch (IOException iOException) {
                throw new DirectoryTableAccessException("EXM_WRITEERROR", this.fileToEdit);
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.unlockFile();
            throw throwable;
        }
        this.unlockFile();
    }

    void deleteLine(String string) throws DirectoryTableException {
        try {
            try {
                this.lockFile();
                String string2 = this.makeTempName(this.fileToEdit);
                File file = new File(string2);
                file.delete();
                file = null;
                this.writeStream = new BufferedWriter(new FileWriter(string2), 32768);
                String string3 = this.getFirstLine();
                while (string3 != null) {
                    if (!string.equals(string3)) {
                        this.writeStream.write(string3);
                        this.writeStream.newLine();
                    }
                    string3 = this.getNextLine();
                }
                this.writeStream.close();
                this.readStream.close();
                this.readStream = null;
                this.writeStream = null;
                this.replaceFile(this.fileToEdit, string2);
            }
            catch (IOException iOException) {
                throw new DirectoryTableAccessException("EXM_WRITEERROR", this.fileToEdit);
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.unlockFile();
            throw throwable;
        }
        this.unlockFile();
    }

    private String makeTempName(String string) throws DirectoryTableException {
        String string2 = null;
        File file = null;
        int n = 1;
        while (n < 256) {
            string2 = String.valueOf(string) + "." + n;
            file = new File(string2);
            if (!file.exists()) break;
            ++n;
        }
        if (n < 256) {
            return string2;
        }
        throw new DirectoryTableAccessException("EXM_NOTEMP", string);
    }

    private void lockFile() throws DirectoryTableException {
        String string = String.valueOf(this.fileToEdit) + ".as_lock_dir";
        int n = 0;
        File file = new File(string);
        while (n < 100) {
            if (file.mkdir()) {
                this.locked = true;
                break;
            }
            if (file.isDirectory()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            ++n;
        }
        if (n == 100) {
            if (file.isDirectory()) {
                throw new DirectoryTableAccessException("EXM_LOCKED", string);
            }
            throw new DirectoryTableAccessException("EXM_NOCREATELOCK", string);
        }
    }

    private void unlockFile() throws DirectoryTableException {
        if (this.locked) {
            String string = String.valueOf(this.fileToEdit) + ".as_lock_dir";
            File file = new File(string);
            file.delete();
        }
    }

    private void replaceFile(String string, String string2) throws DirectoryTableException {
        File file = null;
        File file2 = null;
        File file3 = null;
        try {
            file = new File(string);
            String string3 = file.getCanonicalPath();
            file = null;
            DirectoryTableLibrary.fileCopyStat(string3, string2);
            file2 = new File(string3);
            file2.delete();
            file3 = new File(string2);
            file3.renameTo(file2);
            file3 = null;
            file2 = null;
            return;
        }
        catch (IOException iOException) {
            throw new DirectoryTableAccessException("EXM_WRITEERROR", string);
        }
    }
}

