/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.authorization;

import com.sun.admin.cis.common.AdminCommonTools;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class UserAttrObj
implements Serializable,
Cloneable {
    private String userName;
    private String qualifier;
    private Vector authNames;
    private String[] userType;
    private Vector roleNames;
    public static final String SOLARIS_USER = "normal";
    public static final String SOLARIS_ROLE = "role";
    public static final String SOLARIS_DOT = ".";
    public static final String SOLARIS_ALL = "*";
    public static final String SOLARIS_GRANT = "grant";
    public static final String SOLARIS_AUTHS = "auths";
    public static final String SOLARIS_USERTYPE = "type";
    public static final String SOLARIS_ROLES = "roles";
    public static final String[] knownKeys = new String[]{"auths", "type", "roles"};
    public static final String[] setters = new String[]{"setAuthNames", "setUserType", "setRoleNames"};
    public static final String[] getters = new String[]{"getAuthNames", "getUserTypes", "getRoleNames"};

    public UserAttrObj() {
        this.qualifier = "";
        this.userType = new String[1];
        this.userType[0] = SOLARIS_USER;
        this.authNames = new Vector(10);
        this.roleNames = new Vector(10);
    }

    public UserAttrObj(String string) {
        this.userName = string;
        this.qualifier = "";
        this.userType = new String[1];
        this.userType[0] = SOLARIS_USER;
        this.authNames = new Vector(10);
        this.roleNames = new Vector(10);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public Object clone() {
        UserAttrObj userAttrObj = new UserAttrObj(this.userName);
        userAttrObj.setUserType(this.userType);
        userAttrObj.setQualifier(this.qualifier);
        userAttrObj.setAuthNames(this.getAuthNames());
        userAttrObj.setRoleNames(this.getRoleNames());
        return userAttrObj;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String string) {
        this.qualifier = string;
    }

    public String[] getAuthNames() {
        Object[] objectArray = new String[this.authNames.size()];
        this.authNames.copyInto(objectArray);
        return objectArray;
    }

    public void setAuthNames(String[] stringArray) {
        this.authNames.removeAllElements();
        int n = 0;
        while (n < stringArray.length) {
            this.authNames.addElement(stringArray[n]);
            ++n;
        }
    }

    public void addAuthNames(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (!this.authNames.contains(stringArray[n])) {
                this.authNames.addElement(stringArray[n]);
            }
            ++n;
        }
    }

    public void addAuthNames(String string) {
        if (!this.authNames.contains(string)) {
            this.authNames.addElement(string);
        }
    }

    public void delAuthNames(String string) {
        this.authNames.removeElement(string);
    }

    public void delAuthNames(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.authNames.removeElement(stringArray[n]);
            ++n;
        }
    }

    public boolean checkAuthName(String string) {
        if (this.authNames.contains(string)) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, SOLARIS_DOT);
        int n = stringTokenizer.countTokens() - 1;
        if (n < 1) {
            return false;
        }
        String string2 = string.endsWith(".grant") ? SOLARIS_GRANT : SOLARIS_ALL;
        String string3 = "";
        int n2 = 0;
        while (n2 < n) {
            if (this.authNames.contains((string3 = string3.concat(String.valueOf((String)stringTokenizer.nextElement()) + SOLARIS_DOT)).concat(string2))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean checkAuthName(String[] stringArray, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < stringArray.length) {
                if (this.checkAuthName(stringArray[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!this.checkAuthName(stringArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean checkAuthGrant(String string) {
        boolean bl = false;
        if (string != null) {
            int n = string.lastIndexOf(46);
            String string2 = n > 0 ? string.substring(0, n + 1) : string.concat(SOLARIS_DOT);
            String string3 = string2.concat(SOLARIS_GRANT);
            if (this.checkAuthName(string) && this.checkAuthName(string3)) {
                bl = true;
            }
        }
        return bl;
    }

    public String getUserType() {
        return this.userType[0];
    }

    public String[] getUserTypes() {
        String[] stringArray = new String[this.userType.length];
        int n = 0;
        while (n < this.userType.length) {
            stringArray[n] = this.userType[n];
            ++n;
        }
        return stringArray;
    }

    public void setUserType(String string) {
        this.userType[0] = string;
    }

    public void setUserType(String[] stringArray) {
        this.userType = new String[stringArray.length];
        int n = 0;
        while (n < this.userType.length) {
            this.userType[n] = stringArray[n];
            ++n;
        }
    }

    public String[] getRoleNames() {
        Object[] objectArray = new String[this.roleNames.size()];
        this.roleNames.copyInto(objectArray);
        return objectArray;
    }

    public void setRoleNames(String[] stringArray) {
        this.roleNames.removeAllElements();
        int n = 0;
        while (n < stringArray.length) {
            this.roleNames.addElement(stringArray[n]);
            ++n;
        }
    }

    public void addRoleNames(String string) {
        if (!this.roleNames.contains(string)) {
            this.roleNames.addElement(string);
        }
    }

    public void addRoleNames(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (!this.roleNames.contains(stringArray[n])) {
                this.roleNames.addElement(stringArray[n]);
            }
            ++n;
        }
    }

    public void delRoleNames(String string) {
        this.roleNames.removeElement(string);
    }

    public void delRoleNames(String[] stringArray) {
        this.roleNames.removeAllElements();
        int n = 0;
        while (n < stringArray.length) {
            this.roleNames.addElement(stringArray[n]);
            ++n;
        }
    }

    public boolean equals(UserAttrObj userAttrObj) {
        int n;
        String string;
        String[] stringArray;
        if (!this.userName.equals(userAttrObj.getUserName())) {
            return false;
        }
        if (!this.qualifier.equals(userAttrObj.getQualifier())) {
            return false;
        }
        int n2 = this.authNames.size();
        if (n2 != (stringArray = userAttrObj.getAuthNames()).length) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            string = (String)this.authNames.elementAt(n3);
            n = 0;
            while (n < n2) {
                if (string.equals(stringArray[n])) {
                    stringArray[n] = null;
                    break;
                }
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] != null) {
                return false;
            }
            ++n3;
        }
        n2 = this.userType.length;
        stringArray = userAttrObj.getUserTypes();
        if (n2 != stringArray.length) {
            return false;
        }
        n3 = 0;
        while (n3 < n2) {
            n = 0;
            while (n < n2) {
                if (this.userType[n3].equals(stringArray[n])) {
                    stringArray[n] = null;
                    break;
                }
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] != null) {
                return false;
            }
            ++n3;
        }
        n2 = this.roleNames.size();
        if (n2 != (stringArray = userAttrObj.getRoleNames()).length) {
            return false;
        }
        n3 = 0;
        while (n3 < n2) {
            string = (String)this.roleNames.elementAt(n3);
            n = 0;
            while (n < n2) {
                if (string.equals(stringArray[n])) {
                    stringArray[n] = null;
                    break;
                }
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3] != null) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public void debugPrint() {
        int n;
        AdminCommonTools.CMN_Trace3("Authorization attributes for " + this.userName);
        AdminCommonTools.CMN_Trace3("   qual:  " + this.qualifier);
        String string = new String("");
        String string2 = "  ";
        if (this.userType.length > 0) {
            n = 0;
            while (n < this.userType.length) {
                string = String.valueOf(string) + string2 + this.userType[n];
                string2 = ", ";
                ++n;
            }
        }
        AdminCommonTools.CMN_Trace3("   types:" + string);
        string = new String("");
        string2 = "  ";
        if (this.authNames != null) {
            n = 0;
            while (n < this.authNames.size()) {
                string = String.valueOf(string) + string2 + (String)this.authNames.elementAt(n);
                string2 = ", ";
                ++n;
            }
        }
        AdminCommonTools.CMN_Trace3("   auths:" + string);
        string = new String("");
        string2 = "  ";
        if (this.roleNames != null) {
            n = 0;
            while (n < this.roleNames.size()) {
                string = String.valueOf(string) + string2 + (String)this.roleNames.elementAt(n);
                string2 = ", ";
                ++n;
            }
        }
        AdminCommonTools.CMN_Trace3("   roles:" + string);
    }
}

