/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.server;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.AdminMgmtScope;
import com.sun.admin.cis.common.AdminProps;
import com.sun.admin.cis.common.AdminScopeNotOnServerException;
import com.sun.admin.cis.common.AdminVersion;
import com.sun.admin.cis.common.AuthServerErrorException;
import com.sun.admin.cis.server.AdminFactory;
import com.sun.admin.cis.server.AdminFactoryImpl;
import com.sun.admin.cis.server.AdminFactoryListEntry;
import com.sun.admin.cis.server.AdminServer;
import com.sun.admin.cis.server.AdminServerException;
import com.sun.admin.cis.server.AdminServerLibrary;
import com.sun.admin.cis.service.authorization.AuthLibnsl;
import com.sun.admin.cis.service.authorization.AuthNoAccessException;
import com.sun.admin.cis.service.authorization.UserAttrObj;
import com.sun.admin.cis.service.directorytable.DirectoryTableSetup;
import com.sun.admin.cis.service.logging.LogRecord;
import com.sun.admin.cis.service.logging.LogServiceFactoryImpl;
import com.sun.admin.cis.service.security.AdminAuthenticationException;
import com.sun.admin.cis.service.security.AdminPrincipal;
import com.sun.admin.cis.service.security.AdminSecurityException;
import com.sun.admin.cis.service.security.AdminVerificationException;
import com.sun.admin.cis.service.security.AuthenticationFlavor;
import com.sun.admin.cis.service.security.AuthenticatorSecurityToken;
import com.sun.admin.cis.service.security.DigestAuthFlavor;
import com.sun.admin.cis.service.security.DigestSecurityUtil;
import com.sun.admin.cis.service.security.DigestServerSecurityContext;
import com.sun.admin.cis.service.security.RequestSecurityToken;
import com.sun.admin.cis.service.security.SecurityIdentifier;
import com.sun.admin.cis.service.security.SecurityPolicyObj;
import com.sun.admin.cis.service.security.SecurityToken;
import com.sun.admin.cis.service.security.ServerSecurityContext;
import com.sun.admin.cis.service.security.VerifierSecurityToken;
import com.sun.admin.cis.service.security.WeakAuthFlavor;
import com.sun.admin.cis.service.security.WeakServerSecurityContext;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.security.Provider;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class AdminServerImpl
extends UnicastRemoteObject
implements AdminServer {
    private static final String SYSTEM_FRAMEWORK_NAME = "CIS System";
    private static final String SERVER_TRACE_FILENAME = "admsvr";
    private static final String SERVER_TRACE_FILETYPE = "file";
    private static final String NS_ORDER_TABLE_NAME = "passwd";
    private static final String NS_ORDER_TYPES = "nis nisplus";
    private static final String LIB_PATH = "lib";
    private String hostname;
    private int portnum;
    private int regport;
    private String svrname;
    private AdminProps svrProps;
    private String svrSecProv;
    private SecurityPolicyObj svrPolicy;
    private AuthenticationFlavor svrAuth;
    private ServerSecurityContext svrSec;
    private Hashtable svrSecTable;
    private Vector svrFactList;
    private Vector serviceList;
    private Vector appList;
    private AuthLibnsl authSearch;
    private LogServiceFactoryImpl logsvc;
    private DirectoryTableSetup dirtbl;

    public AdminServerImpl(String string) throws RemoteException, AdminException {
        this.svrProps = string == null || string.trim().length() == 0 ? new AdminProps("admin.server.properties", "AdminServer.properties", 1) : new AdminProps(string, 1);
        this.initProperties();
        this.initTrace();
        this.initSecurity();
        this.initScopes();
        this.initAuthSearch();
        this.svrSecTable = new Hashtable();
        this.svrFactList = new Vector(25);
        this.serviceList = this.getServerPropertyList("admin.service");
        this.appList = this.getServerPropertyList("admin.app");
        this.initServices();
        this.logsvc = (LogServiceFactoryImpl)this.getServiceImpl("com.sun.admin.cis.service.logging.LogServiceFactoryImpl");
        this.svrSec.setLogService(this.logsvc);
    }

    public SecurityToken startAuthentication(RequestSecurityToken requestSecurityToken, AdminMgmtScope adminMgmtScope, long l) throws RemoteException, AdminException {
        String string = "";
        String string2 = "";
        if (requestSecurityToken != null) {
            AdminPrincipal adminPrincipal = requestSecurityToken.getAdminPrincipal();
            if (adminPrincipal != null) {
                string = adminPrincipal.getName();
            }
            string2 = requestSecurityToken.getClientHost();
        }
        if (!AdminVersion.checkClientVersion(l)) {
            Vector<String> vector = new Vector<String>(2);
            vector.addElement(AdminVersion.getVersionString(l));
            vector.addElement(AdminVersion.getVersionString());
            this.writeLog(SYSTEM_FRAMEWORK_NAME, 2, 2, string, string2, this.getHostName(), "LM_0001", "LM_0011", vector, null);
            throw new AuthServerErrorException();
        }
        String string3 = adminMgmtScope.toDirectoryTableURL();
        if (!this.dirtbl.isValidScope(string3)) {
            Vector<String> vector = new Vector<String>(2);
            vector.addElement(adminMgmtScope.getMgmtScopeType());
            vector.addElement(adminMgmtScope.getMgmtDomainName());
            this.writeLog(SYSTEM_FRAMEWORK_NAME, 2, 1, string, string2, this.getHostName(), "LM_0004", "LM_0020", vector, adminMgmtScope);
            throw new AdminScopeNotOnServerException(adminMgmtScope.toString(), this.getHostName());
        }
        AuthenticationFlavor authenticationFlavor = requestSecurityToken.getAuthFlavor();
        if (!this.svrSec.verifyAuthFlavor(authenticationFlavor)) {
            throw new AuthServerErrorException();
        }
        SecurityIdentifier securityIdentifier = null;
        SecurityToken securityToken = null;
        ServerSecurityContext serverSecurityContext = this.svrSec.newCopy();
        serverSecurityContext.setClientVersion(l);
        serverSecurityContext.setMgmtScope(adminMgmtScope);
        try {
            securityIdentifier = this.genSecurityId();
            serverSecurityContext.setSecurityId(securityIdentifier);
        }
        catch (AdminException adminException) {
            this.writeLog(serverSecurityContext, 2, "LM_0001", "LM_0021", string, string2, new Long(securityIdentifier.getValue()).toString());
            AdminCommonTools.CMN_Trace1("Session connect: Unable to generate sesion identifier");
            throw new AuthServerErrorException();
        }
        try {
            securityToken = serverSecurityContext.verifyRequest(requestSecurityToken);
        }
        catch (AdminAuthenticationException adminAuthenticationException) {
            throw adminAuthenticationException;
        }
        catch (AdminException adminException) {
            AdminCommonTools.CMN_Trace1("Session connect: Exception verifying request: " + adminException.getMessage());
            throw new AuthServerErrorException();
        }
        this.addSecurityContext(securityIdentifier, serverSecurityContext);
        if (securityToken.getAuthState() == 4) {
            this.initUserAuth(serverSecurityContext);
            this.writeLog(serverSecurityContext, 0, "LM_0002", "LM_0012", string, string2, new Long(securityIdentifier.getValue()).toString());
        }
        return securityToken;
    }

    public SecurityToken completeAuthentication(AuthenticatorSecurityToken authenticatorSecurityToken) throws RemoteException, AdminException {
        SecurityToken securityToken;
        SecurityIdentifier securityIdentifier = authenticatorSecurityToken.getSecurityId();
        ServerSecurityContext serverSecurityContext = this.findSecurityContext(securityIdentifier);
        if (serverSecurityContext == null) {
            this.writeNoConnxLog("LM_0018", securityIdentifier);
            throw new AuthServerErrorException();
        }
        try {
            securityToken = serverSecurityContext.verifyAuthenticator(authenticatorSecurityToken);
        }
        catch (AdminAuthenticationException adminAuthenticationException) {
            throw adminAuthenticationException;
        }
        catch (AdminException adminException) {
            this.removeSecurityContext(securityIdentifier);
            throw new AuthServerErrorException();
        }
        this.initUserAuth(serverSecurityContext);
        this.writeLog(serverSecurityContext, 0, "LM_0002", "LM_0012", serverSecurityContext.getAdminPrincipal().getName(), serverSecurityContext.getClientHost(), new Long(securityIdentifier.getValue()).toString());
        return securityToken;
    }

    public void close(SecurityToken securityToken) throws AdminException {
        String string;
        SecurityIdentifier securityIdentifier = securityToken.getSecurityId();
        ServerSecurityContext serverSecurityContext = this.findSecurityContext(securityIdentifier);
        if (serverSecurityContext != null) {
            string = null;
            AdminPrincipal adminPrincipal = serverSecurityContext.getAdminPrincipal();
            if (adminPrincipal != null) {
                string = adminPrincipal.getName();
            }
            this.writeLog(serverSecurityContext, 0, "LM_0003", "LM_0013", string, serverSecurityContext.getClientHost(), new Long(securityIdentifier.getValue()).toString());
            this.removeSecurityContext(securityIdentifier);
        }
        AdminFactoryImpl adminFactoryImpl = null;
        string = null;
        boolean bl = true;
        while (bl) {
            AdminFactoryListEntry adminFactoryListEntry = this.findFactoryEntry(securityIdentifier);
            if (adminFactoryListEntry == null) {
                bl = false;
                continue;
            }
            adminFactoryImpl = adminFactoryListEntry.getFactoryReference();
            this.removeFactoryEntry(adminFactoryListEntry);
            if (adminFactoryListEntry.isSingleton() && this.isFactoryInList(adminFactoryImpl)) {
                adminFactoryImpl = null;
            }
            if (adminFactoryImpl == null) continue;
            string = adminFactoryImpl.localAppName();
            try {
                adminFactoryImpl.localShutDown();
            }
            catch (AdminException adminException) {
                this.writeLog(serverSecurityContext, 1, "LM_0004", "LM_0014", string, null, null);
                AdminCommonTools.CMN_Trace1("Server daemon: Error shutting down factory: " + string);
            }
        }
    }

    public AdminFactory getAppFactory(VerifierSecurityToken verifierSecurityToken, String string) throws RemoteException, AdminException {
        boolean bl;
        ServerSecurityContext serverSecurityContext = this.getAuthenticatedContext(verifierSecurityToken);
        if (serverSecurityContext == null) {
            this.writeNoConnxLog("LM_0019", verifierSecurityToken.getSecurityId());
            AdminCommonTools.CMN_Trace1("Server daemon: Unauthenticated client access getting factory: " + string);
            throw new AdminServerException("EXM_BSS");
        }
        SecurityIdentifier securityIdentifier = serverSecurityContext.getSecurityId();
        Object[] objectArray = new Object[]{string};
        this.checkVerifier(verifierSecurityToken, objectArray);
        if (!this.serviceList.contains(string) && !this.appList.contains(string)) {
            throw new AdminServerException("EXM_UCC", string);
        }
        AdminFactoryImpl adminFactoryImpl = null;
        AdminFactoryListEntry adminFactoryListEntry = this.findFactoryEntry(string);
        if (adminFactoryListEntry != null) {
            adminFactoryImpl = adminFactoryListEntry.getFactoryReference();
            if (!adminFactoryListEntry.isSingleton() && !adminFactoryListEntry.equals(securityIdentifier)) {
                adminFactoryListEntry = this.findFactoryEntry(securityIdentifier, string);
                adminFactoryImpl = adminFactoryListEntry != null ? adminFactoryListEntry.getFactoryReference() : null;
            }
        }
        if (adminFactoryImpl == null) {
            adminFactoryImpl = this.createFactoryInstance(serverSecurityContext, string);
            bl = false;
        } else {
            bl = true;
        }
        AdminPrincipal adminPrincipal = serverSecurityContext.getAdminPrincipal();
        String string2 = adminFactoryImpl.localAppName();
        boolean bl2 = true;
        try {
            adminFactoryImpl.localCheckExecuteRight(verifierSecurityToken);
        }
        catch (AdminException adminException) {
            this.writeLog(serverSecurityContext, 0, "LM_1010", "LM_1012", adminPrincipal.getUserName(), string2, serverSecurityContext.getMgmtScope().getMgmtScopeName());
            AdminCommonTools.CMN_Trace1("Server daemon: factory authorization failure getting factory: " + string);
            bl2 = false;
        }
        if (!bl2) {
            if (!bl) {
                try {
                    adminFactoryImpl.localShutDown();
                }
                catch (AdminException adminException) {
                    this.writeLog(serverSecurityContext, 1, "LM_0004", "LM_0014", string2, null, null);
                    AdminCommonTools.CMN_Trace1("Server deamon: factory shutdown failed getting factory: " + string);
                }
            }
            throw new AuthNoAccessException(adminPrincipal.getName(), string2);
        }
        if (!bl) {
            this.addFactoryEntry(securityIdentifier, adminFactoryImpl);
        }
        return adminFactoryImpl;
    }

    public void closeAppFactory(VerifierSecurityToken verifierSecurityToken, String string) throws RemoteException, AdminException {
        ServerSecurityContext serverSecurityContext = this.getAuthenticatedContext(verifierSecurityToken);
        if (serverSecurityContext == null) {
            if (verifierSecurityToken != null) {
                this.writeNoConnxLog("LM_0019", verifierSecurityToken.getSecurityId());
            }
            throw new AdminServerException("EXM_BSS");
        }
        SecurityIdentifier securityIdentifier = serverSecurityContext.getSecurityId();
        Object[] objectArray = new Object[]{string};
        this.checkVerifier(verifierSecurityToken, objectArray);
        AdminFactoryImpl adminFactoryImpl = null;
        AdminFactoryListEntry adminFactoryListEntry = this.findFactoryEntry(securityIdentifier, string);
        if (adminFactoryListEntry != null) {
            adminFactoryImpl = adminFactoryListEntry.getFactoryReference();
            this.removeFactoryEntry(adminFactoryListEntry);
            if (adminFactoryListEntry.isSingleton() && this.isFactoryInList(adminFactoryImpl)) {
                adminFactoryImpl = null;
            }
        }
        if (adminFactoryImpl != null) {
            try {
                adminFactoryImpl.localShutDown();
                return;
            }
            catch (Exception exception) {
                this.writeLog(serverSecurityContext, 1, "LM_0004", "LM_0014", adminFactoryImpl.localAppName(), null, null);
                return;
            }
        }
    }

    public Vector getUserRights(VerifierSecurityToken verifierSecurityToken) throws RemoteException, AdminException {
        ServerSecurityContext serverSecurityContext = this.getAuthenticatedContext(verifierSecurityToken);
        if (serverSecurityContext == null) {
            if (verifierSecurityToken != null) {
                this.writeNoConnxLog("LM_0019", verifierSecurityToken.getSecurityId());
            }
            AdminCommonTools.CMN_Trace1("Server daemon: Unauthenticated client access getting user rights");
            throw new AdminServerException("EXM_BSS");
        }
        this.checkVerifier(verifierSecurityToken, null);
        Vector<String> vector = new Vector<String>();
        UserAttrObj userAttrObj = serverSecurityContext.getUserAttr();
        if (userAttrObj != null) {
            String[] stringArray = userAttrObj.getAuthNames();
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(stringArray[n]);
                ++n;
            }
        }
        return vector;
    }

    public SecurityPolicyObj getSecurityPolicy(VerifierSecurityToken verifierSecurityToken) throws RemoteException, AdminException {
        ServerSecurityContext serverSecurityContext = this.getAuthenticatedContext(verifierSecurityToken);
        if (serverSecurityContext == null) {
            if (verifierSecurityToken != null) {
                this.writeNoConnxLog("LM_0019", verifierSecurityToken.getSecurityId());
            }
            AdminCommonTools.CMN_Trace1("Server daemon: Unauthenticated client access getting security policy");
            throw new AdminServerException("EXM_BSS");
        }
        this.checkVerifier(verifierSecurityToken, null);
        return this.svrPolicy;
    }

    public void setSecurityPolicy(VerifierSecurityToken verifierSecurityToken, SecurityPolicyObj securityPolicyObj) throws RemoteException, AdminException {
        ServerSecurityContext serverSecurityContext = this.getAuthenticatedContext(verifierSecurityToken);
        if (serverSecurityContext == null) {
            if (verifierSecurityToken != null) {
                this.writeNoConnxLog("LM_0019", verifierSecurityToken.getSecurityId());
            }
            AdminCommonTools.CMN_Trace1("Server daemon: Unauthenticated client access setting security policy");
            throw new AdminServerException("EXM_BSS");
        }
        Object[] objectArray = new Object[]{securityPolicyObj};
        this.checkVerifier(verifierSecurityToken, objectArray);
        if (!this.checkRights(verifierSecurityToken, "solaris.*")) {
            throw new AuthNoAccessException(this.getUserName(verifierSecurityToken), SYSTEM_FRAMEWORK_NAME);
        }
        if (securityPolicyObj != null) {
            this.svrPolicy = securityPolicyObj;
            this.initAuthSearch();
            this.svrSec.setVerify(securityPolicyObj.isSecureMsgEnabled());
            this.setServerProperty("admin.authorization.policy", securityPolicyObj.getAuthPolicy());
            this.setServerProperty("admin.security.msg.verify", securityPolicyObj.getSecureMsgPolicy());
            this.saveServerProperties();
        }
    }

    public void writeLogRecord(VerifierSecurityToken verifierSecurityToken, LogRecord logRecord) throws RemoteException, AdminException {
        ServerSecurityContext serverSecurityContext = this.getAuthenticatedContext(verifierSecurityToken);
        if (serverSecurityContext == null) {
            if (verifierSecurityToken != null) {
                this.writeNoConnxLog("LM_0019", verifierSecurityToken.getSecurityId());
            }
            AdminCommonTools.CMN_Trace1("Server daemon: Unauthenticated client access setting security policy");
            throw new AdminServerException("EXM_BSS");
        }
        this.checkVerifier(verifierSecurityToken, null);
        if (this.logsvc != null) {
            try {
                this.logsvc.writeRecord(logRecord, false);
                return;
            }
            catch (Exception exception) {
                AdminCommonTools.CMN_Trace1("Server daemon: write log: exception: " + exception.getMessage());
                return;
            }
        }
    }

    public Vector getUserRights(SecurityToken securityToken, String[] stringArray) throws AdminException {
        ServerSecurityContext serverSecurityContext = this.getAuthenticatedContext(securityToken);
        Vector<String> vector = new Vector<String>();
        UserAttrObj userAttrObj = serverSecurityContext.getUserAttr();
        if (userAttrObj != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (userAttrObj.checkAuthName(stringArray[n])) {
                    vector.addElement(stringArray[n]);
                }
                ++n;
            }
        }
        return vector;
    }

    public boolean checkRights(SecurityToken securityToken, String string) throws AdminException {
        ServerSecurityContext serverSecurityContext = this.getAuthenticatedContext(securityToken);
        UserAttrObj userAttrObj = serverSecurityContext.getUserAttr();
        boolean bl = false;
        if (userAttrObj != null) {
            bl = userAttrObj.checkAuthName(string);
        }
        return bl;
    }

    public boolean checkRights(SecurityToken securityToken, String[] stringArray, boolean bl) throws AdminException {
        ServerSecurityContext serverSecurityContext = this.getAuthenticatedContext(securityToken);
        UserAttrObj userAttrObj = serverSecurityContext.getUserAttr();
        boolean bl2 = false;
        if (userAttrObj != null) {
            bl2 = userAttrObj.checkAuthName(stringArray, bl);
        }
        return bl2;
    }

    public AdminFactoryImpl getServiceImpl(String string) throws AdminException {
        SecurityIdentifier securityIdentifier = new SecurityIdentifier(0L);
        AdminFactoryListEntry adminFactoryListEntry = this.findFactoryEntry(securityIdentifier, string);
        if (adminFactoryListEntry == null) {
            throw new AdminServerException("EXM_UFS", string);
        }
        return adminFactoryListEntry.getFactoryReference();
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getServerPort() {
        return this.portnum;
    }

    public String getServerName() {
        return this.svrname;
    }

    public AdminPrincipal getAdminPrincipal(SecurityToken securityToken) throws AdminException {
        ServerSecurityContext serverSecurityContext = this.getAuthenticatedContext(securityToken);
        AdminPrincipal adminPrincipal = serverSecurityContext.getAdminPrincipal();
        if (adminPrincipal == null) {
            throw new AdminServerException("EXM_BAP");
        }
        return adminPrincipal;
    }

    public AdminMgmtScope getMgmtScope(SecurityToken securityToken) throws AdminException {
        ServerSecurityContext serverSecurityContext = this.getAuthenticatedContext(securityToken);
        AdminMgmtScope adminMgmtScope = serverSecurityContext.getMgmtScope();
        if (adminMgmtScope == null) {
            throw new AdminServerException("EXM_BMS");
        }
        return adminMgmtScope;
    }

    public UserAttrObj getAdminAuthAttr(SecurityToken securityToken) throws AdminException {
        ServerSecurityContext serverSecurityContext = this.getAuthenticatedContext(securityToken);
        return serverSecurityContext.getUserAttr();
    }

    public ServerSecurityContext getAuthenticatedContext(SecurityToken securityToken) throws AdminException {
        if (!this.isAuthenticated(securityToken)) {
            throw new AdminServerException("EXM_BAT");
        }
        ServerSecurityContext serverSecurityContext = this.findSecurityContext(securityToken.getSecurityId());
        if (serverSecurityContext == null) {
            throw new AdminServerException("EXM_BSS");
        }
        return serverSecurityContext;
    }

    public boolean isVerify() {
        boolean bl = false;
        if (this.svrSec != null) {
            bl = this.svrSec.isVerify();
        }
        return bl;
    }

    public void checkVerifier(SecurityToken securityToken, Object[] objectArray) throws AdminException {
        VerifierSecurityToken verifierSecurityToken;
        try {
            verifierSecurityToken = (VerifierSecurityToken)securityToken;
        }
        catch (Exception exception) {
            throw new AdminSecurityException("EXSS_BVT");
        }
        ServerSecurityContext serverSecurityContext = this.getAuthenticatedContext(securityToken);
        if (serverSecurityContext.isVerify()) {
            AdminCommonTools.CMN_Trace3("Security service: verifying message...");
        }
        try {
            serverSecurityContext.checkVerifier(verifierSecurityToken, objectArray);
            return;
        }
        catch (AdminVerificationException adminVerificationException) {
            this.writeVerifyErrorLog(serverSecurityContext, 1, 1, "LM_1020", "LM_1021", AdminCommonTools.CMN_CallingClassMethod());
            throw adminVerificationException;
        }
        catch (AdminException adminException) {
            this.writeVerifyErrorLog(serverSecurityContext, 2, 2, "LM_1030", "LM_1034", AdminCommonTools.CMN_CallingClassMethod());
            throw adminException;
        }
    }

    public String getUserName(SecurityToken securityToken) throws AdminException {
        return this.getAdminPrincipal(securityToken).getUserName();
    }

    public long getClientVersion(SecurityToken securityToken) throws AdminException {
        return this.getAuthenticatedContext(securityToken).getClientVersion();
    }

    public String getClientHost(SecurityToken securityToken) throws AdminException {
        return this.getAuthenticatedContext(securityToken).getClientHost();
    }

    public String getServerProperty(String string) throws AdminException {
        return this.svrProps.getAdminProp(string);
    }

    public Vector getServerPropertyList(String string) throws AdminException {
        return this.svrProps.getAdminPropList(string);
    }

    public void setServerProperty(String string, String string2) throws AdminException {
        this.svrProps.putAdminProp(string, string2);
    }

    public void saveServerProperties() throws AdminException {
        this.svrProps.saveAdminProps("Management Server Properties - Do Not Edit");
    }

    public String getLibPath(String string) throws AdminException {
        String string2 = this.getServerProperty("admin.base.dir");
        if (string2 == null || string2.trim().length() == 0) {
            throw new AdminServerException("EXM_NSP", "admin.base.dir");
        }
        String string3 = File.separator;
        String string4 = String.valueOf(string2) + string3 + LIB_PATH + string3 + string;
        return string4;
    }

    private void initProperties() throws AdminException {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            throw new AdminServerException("EXM_NHN");
        }
        String string = this.getServerProperty("admin.server.name");
        if (string == null || string.trim().length() == 0) {
            throw new AdminServerException("EXM_NSP", "admin.server.name");
        }
        this.svrname = string.concat(AdminVersion.getVersionSuffix());
        string = this.getServerProperty("admin.server.port");
        if (string == null || string.trim().length() == 0) {
            throw new AdminServerException("EXM_NSP", "admin.server.port");
        }
        try {
            this.portnum = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AdminServerException("EXM_NSP", "admin.server.port");
        }
        String string2 = this.getServerProperty("admin.security.auth.flavor");
        if (string2 == null || string2.trim().length() == 0) {
            throw new AdminServerException("EXM_NSP", "admin.security.auth.flavor");
        }
        this.svrSecProv = this.getServerProperty("admin.security.provider");
        if (this.svrSecProv == null || this.svrSecProv.trim().length() == 0) {
            throw new AdminServerException("EXM_NSP", "admin.security.provider");
        }
        if (string2.equals("weak")) {
            this.svrAuth = new WeakAuthFlavor();
            return;
        }
        if (string2.equals("digest")) {
            int n;
            String string3 = this.getServerProperty("admin.security.digest.algo");
            if (string3 == null || string3.trim().length() == 0) {
                string3 = "SHA";
            }
            string3 = "SHA";
            String string4 = this.getServerProperty("admin.security.sign.algo");
            if (string4 == null || string4.trim().length() == 0) {
                string4 = "DSA";
            }
            string4 = "DSA";
            String string5 = this.getServerProperty("admin.security.key.algo");
            if (string5 == null || string5.trim().length() == 0) {
                string5 = "DSA";
            }
            string5 = "DSA";
            string = this.getServerProperty("admin.security.key.strength");
            if (string == null || string.trim().length() == 0) {
                string = "1024";
            }
            try {
                n = new Integer(string);
                if (n > 1024) {
                    n = 1024;
                }
            }
            catch (Exception exception) {
                n = -1;
            }
            this.svrAuth = new DigestAuthFlavor(string3, string4, string5, n);
            return;
        }
        if (string2.equals("encryption")) {
            throw new AdminSecurityException("EXSS_UAF", string2);
        }
        throw new AdminSecurityException("EXSS_UAF", string2);
    }

    private void initTrace() {
        String string = null;
        try {
            string = this.getServerProperty("admin.trace.level");
        }
        catch (Exception exception) {
            string = null;
        }
        int n = 0;
        if (string != null && string.trim().length() > 0) {
            try {
                n = new Integer(string);
            }
            catch (Exception exception) {}
        }
        string = null;
        try {
            string = this.getServerProperty("admin.trace.device");
        }
        catch (Exception exception) {
            string = null;
        }
        if (string == null || string.trim().length() == 0) {
            string = SERVER_TRACE_FILETYPE;
        }
        if (string.equals(SERVER_TRACE_FILETYPE)) {
            string = SERVER_TRACE_FILENAME;
        }
        AdminCommonTools.CMN_TraceOpen(n, string);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy 'at' hh:mm:ss z");
        string = simpleDateFormat.format(new Date());
        AdminCommonTools.CMN_Trace1("Management server version " + AdminVersion.getVersionString() + " initializing on " + string);
    }

    private void initServices() throws AdminException {
        SecurityIdentifier securityIdentifier = new SecurityIdentifier(0L);
        int n = this.serviceList.size();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                String string = (String)this.serviceList.elementAt(n2);
                AdminFactoryImpl adminFactoryImpl = this.createFactoryInstance(this.svrSec, string);
                this.addFactoryEntry(securityIdentifier, adminFactoryImpl);
                ++n2;
            }
        }
    }

    private void initSecurity() throws AdminException {
        String string;
        ServerSecurityContext serverSecurityContext = null;
        Provider provider = null;
        String string2 = this.getServerProperty("admin.authorization.policy");
        if (string2 == null || string2.trim().length() == 0) {
            string2 = "files domain";
        }
        if ((string = this.getServerProperty("admin.security.msg.verify")) == null || string.trim().length() == 0) {
            string = "off";
        }
        this.svrPolicy = new SecurityPolicyObj(string2, string);
        int n = this.svrAuth.getAuthType();
        switch (n) {
            case 0: {
                serverSecurityContext = new WeakServerSecurityContext();
                serverSecurityContext.setVerify(false);
                break;
            }
            case 1: {
                DigestAuthFlavor digestAuthFlavor = (DigestAuthFlavor)this.svrAuth;
                provider = this.getSecurityProvider();
                DigestSecurityUtil.initialize(provider, digestAuthFlavor.getDigestAlgorithm(), digestAuthFlavor.getSignatureAlgorithm(), digestAuthFlavor.getKeyGenerationAlgorithm(), digestAuthFlavor.getKeyStrength());
                DigestServerSecurityContext digestServerSecurityContext = new DigestServerSecurityContext(digestAuthFlavor);
                digestServerSecurityContext.setVerify(this.svrPolicy.isSecureMsgEnabled());
                string2 = this.getServerProperty("admin.security.msg.integrity");
                if (string2 != null && string2.equals("on")) {
                    digestServerSecurityContext.setIntegrity();
                }
                serverSecurityContext = digestServerSecurityContext;
                break;
            }
            case 2: {
                throw new AdminSecurityException("EXSS_UAF", new Integer(n));
            }
            default: {
                throw new AdminSecurityException("EXSS_UAF", new Integer(n));
            }
        }
        this.svrSec = serverSecurityContext;
    }

    private void initScopes() throws AdminException {
        Vector vector = null;
        try {
            this.dirtbl = new DirectoryTableSetup();
            vector = this.dirtbl.getScopes(2);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("Server daemon: error getting scopes: " + exception.getMessage());
            exception.printStackTrace();
            vector = null;
        }
        if (vector == null || vector.size() == 0) {
            throw new AdminServerException("EXM_MMS");
        }
    }

    private void initUserAuth(ServerSecurityContext serverSecurityContext) throws AdminException {
        AdminMgmtScope adminMgmtScope = serverSecurityContext.getMgmtScope();
        AdminPrincipal adminPrincipal = serverSecurityContext.getAdminPrincipal();
        String string = adminPrincipal.getUserName();
        UserAttrObj userAttrObj = this.authSearch.getUserAttrEntry(string);
        serverSecurityContext.setUserAttr(userAttrObj);
        if (userAttrObj == null) {
            AdminCommonTools.CMN_Trace1("Server deamon: user " + string + " has no authorization rights");
            this.writeLog(serverSecurityContext, 0, "LM_1010", "LM_1011", string, adminMgmtScope.getMgmtScopeName(), null);
        }
    }

    private void initAuthSearch() throws AdminException {
        Vector<String> vector = null;
        try {
            vector = this.dirtbl.getNameServiceSwitchOrder(NS_ORDER_TABLE_NAME);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("Server daemon: error getting name service search order: " + exception.getMessage());
            vector = new Vector<String>(1);
            vector.addElement("files");
        }
        String string = "";
        String string2 = "";
        if (this.svrPolicy.isLocalEnabled()) {
            string = "files";
        }
        if (this.svrPolicy.isDomainEnabled()) {
            int n = 0;
            while (n < vector.size()) {
                string2 = (String)vector.elementAt(n);
                if (NS_ORDER_TYPES.indexOf(string2) != -1) break;
                string2 = "";
                ++n;
            }
            if (string2.length() > 0) {
                String string3 = "";
                try {
                    string3 = AdminServerLibrary.getDomainName();
                }
                catch (Exception exception) {
                    string3 = "";
                }
                this.svrPolicy.setDomainType(string2);
                this.svrPolicy.setDomainName(string3);
            }
        }
        String string4 = this.svrPolicy.isLocalFirst() ? String.valueOf(string) + " " + string2 : String.valueOf(string2) + " " + string;
        string4.trim();
        AdminCommonTools.CMN_Trace3("Server daemon: security policy: auth=" + string4);
        this.authSearch = new AuthLibnsl(string4);
    }

    private AdminFactoryImpl createFactoryInstance(ServerSecurityContext serverSecurityContext, String string) throws AdminException {
        AdminFactoryImpl adminFactoryImpl = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            this.writeLog(serverSecurityContext, 2, "LM_0001", "LM_0015", string, null, null);
            AdminCommonTools.CMN_Trace1("Server daemon: cannot find class file for: " + string);
            throw new AdminServerException("EXM_UFC", string);
        }
        try {
            Class[] classArray = new Class[]{Class.forName("com.sun.admin.cis.server.AdminServerImpl")};
            Object[] objectArray = new Object[]{this};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            adminFactoryImpl = (AdminFactoryImpl)constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            this.writeLog(serverSecurityContext, 2, "LM_0001", "LM_0016", string, throwable.getMessage(), null);
            AdminCommonTools.CMN_Trace1("Server daemon: exception thrown by " + string + " factory constructor: " + throwable.getMessage());
            throw new AdminServerException("EXM_FCE", string);
        }
        catch (Exception exception) {
            this.writeLog(serverSecurityContext, 2, "LM_0001", "LM_0017", string, exception.getMessage(), null);
            AdminCommonTools.CMN_Trace1("Server daemon: cannot create " + string + " factory: " + exception.getMessage());
            exception.printStackTrace();
            throw new AdminServerException("EXM_UCC", string);
        }
        return adminFactoryImpl;
    }

    private Provider getSecurityProvider() throws AdminServerException {
        Provider provider = null;
        if (this.svrSecProv != null && (provider = Security.getProvider(this.svrSecProv)) == null) {
            throw new AdminServerException("EXM_SPI", this.svrSecProv);
        }
        return provider;
    }

    private SecurityIdentifier genSecurityId() throws AdminException {
        long l = System.currentTimeMillis();
        if (!this.svrSecTable.isEmpty()) {
            int n = 0;
            while (n < 5) {
                if (!this.svrSecTable.contains(new Long(l))) break;
                ++l;
                ++n;
            }
            if (n == 5) {
                throw new AdminServerException("EXM_NID");
            }
        }
        SecurityIdentifier securityIdentifier = new SecurityIdentifier(l);
        return securityIdentifier;
    }

    private boolean isAuthenticated(SecurityToken securityToken) {
        SecurityIdentifier securityIdentifier;
        ServerSecurityContext serverSecurityContext;
        boolean bl = false;
        if (securityToken != null && securityToken.getAuthState() == 4 && (serverSecurityContext = this.findSecurityContext(securityIdentifier = securityToken.getSecurityId())) != null && serverSecurityContext.getAuthState() == 4) {
            bl = true;
        }
        return bl;
    }

    private synchronized ServerSecurityContext findSecurityContext(SecurityIdentifier securityIdentifier) {
        ServerSecurityContext serverSecurityContext = null;
        if (securityIdentifier != null) {
            Long l = new Long(securityIdentifier.getValue());
            serverSecurityContext = (ServerSecurityContext)this.svrSecTable.get(l);
        }
        return serverSecurityContext;
    }

    private synchronized void addSecurityContext(SecurityIdentifier securityIdentifier, ServerSecurityContext serverSecurityContext) {
        if (securityIdentifier != null) {
            Long l = new Long(securityIdentifier.getValue());
            this.svrSecTable.put(l, serverSecurityContext);
        }
    }

    private synchronized void removeSecurityContext(SecurityIdentifier securityIdentifier) {
        if (securityIdentifier != null) {
            Long l = new Long(securityIdentifier.getValue());
            this.svrSecTable.remove(l);
        }
    }

    private synchronized void addFactoryEntry(SecurityIdentifier securityIdentifier, AdminFactoryImpl adminFactoryImpl) {
        AdminFactoryListEntry adminFactoryListEntry = new AdminFactoryListEntry(adminFactoryImpl.localIsSingleton(), securityIdentifier, adminFactoryImpl);
        this.svrFactList.addElement(adminFactoryListEntry);
    }

    private synchronized void removeFactoryEntry(AdminFactoryListEntry adminFactoryListEntry) {
        this.svrFactList.removeElement(adminFactoryListEntry);
    }

    private synchronized AdminFactoryListEntry findFactoryEntry(SecurityIdentifier securityIdentifier) {
        int n = this.svrFactList.size();
        AdminFactoryListEntry adminFactoryListEntry = null;
        int n2 = 0;
        while (n2 < n) {
            adminFactoryListEntry = (AdminFactoryListEntry)this.svrFactList.elementAt(n2);
            if (adminFactoryListEntry.equals(securityIdentifier)) break;
            adminFactoryListEntry = null;
            ++n2;
        }
        return adminFactoryListEntry;
    }

    private synchronized AdminFactoryListEntry findFactoryEntry(String string) {
        int n = this.svrFactList.size();
        AdminFactoryListEntry adminFactoryListEntry = null;
        int n2 = 0;
        while (n2 < n) {
            String string2;
            adminFactoryListEntry = (AdminFactoryListEntry)this.svrFactList.elementAt(n2);
            try {
                AdminFactoryImpl adminFactoryImpl = adminFactoryListEntry.getFactoryReference();
                string2 = adminFactoryImpl.getClass().getName();
            }
            catch (Exception exception) {
                string2 = "";
            }
            if (string.equals(string2)) break;
            adminFactoryListEntry = null;
            ++n2;
        }
        return adminFactoryListEntry;
    }

    private synchronized AdminFactoryListEntry findFactoryEntry(SecurityIdentifier securityIdentifier, String string) {
        int n = this.svrFactList.size();
        AdminFactoryListEntry adminFactoryListEntry = null;
        int n2 = 0;
        while (n2 < n) {
            adminFactoryListEntry = (AdminFactoryListEntry)this.svrFactList.elementAt(n2);
            if (!adminFactoryListEntry.equals(securityIdentifier)) {
                adminFactoryListEntry = null;
            } else {
                String string2;
                try {
                    AdminFactoryImpl adminFactoryImpl = adminFactoryListEntry.getFactoryReference();
                    string2 = adminFactoryImpl.getClass().getName();
                }
                catch (Exception exception) {
                    string2 = "";
                }
                if (string.equals(string2)) break;
                adminFactoryListEntry = null;
            }
            ++n2;
        }
        return adminFactoryListEntry;
    }

    private synchronized boolean isFactoryInList(AdminFactoryImpl adminFactoryImpl) {
        int n = this.svrFactList.size();
        AdminFactoryListEntry adminFactoryListEntry = null;
        int n2 = 0;
        while (n2 < n) {
            adminFactoryListEntry = (AdminFactoryListEntry)this.svrFactList.elementAt(n2);
            AdminFactoryImpl adminFactoryImpl2 = adminFactoryListEntry.getFactoryReference();
            if (adminFactoryImpl.equals(adminFactoryImpl2)) break;
            adminFactoryListEntry = null;
            ++n2;
        }
        return adminFactoryListEntry != null;
    }

    private void writeLog(ServerSecurityContext serverSecurityContext, int n, String string, String string2, String string3, String string4, String string5) {
        AdminMgmtScope adminMgmtScope = null;
        String string6 = null;
        String string7 = null;
        if (serverSecurityContext != null) {
            AdminPrincipal adminPrincipal = serverSecurityContext.getAdminPrincipal();
            if (adminPrincipal != null) {
                string6 = adminPrincipal.getName();
            }
            string7 = serverSecurityContext.getClientHost();
            adminMgmtScope = serverSecurityContext.getMgmtScope();
        }
        Vector<String> vector = new Vector<String>(3);
        if (string3 != null) {
            vector.addElement(string3);
        }
        if (string4 != null) {
            vector.addElement(string4);
        }
        if (string5 != null) {
            vector.addElement(string5);
        }
        this.writeLog(SYSTEM_FRAMEWORK_NAME, 2, n, string6, string7, this.getHostName(), string, string2, vector, adminMgmtScope);
    }

    private void writeNoConnxLog(String string, SecurityIdentifier securityIdentifier) {
        Vector<String> vector = new Vector<String>(1);
        ServerSecurityContext serverSecurityContext = null;
        AdminMgmtScope adminMgmtScope = null;
        vector.addElement(new Long(securityIdentifier.getValue()).toString());
        serverSecurityContext = this.findSecurityContext(securityIdentifier);
        if (serverSecurityContext != null) {
            adminMgmtScope = serverSecurityContext.getMgmtScope();
        }
        this.writeLog(SYSTEM_FRAMEWORK_NAME, 2, 2, null, null, this.getHostName(), "LM_0001", string, vector, adminMgmtScope);
    }

    private void writeVerifyErrorLog(ServerSecurityContext serverSecurityContext, int n, int n2, String string, String string2, String string3) {
        String string4;
        String string5;
        int n3;
        AdminMgmtScope adminMgmtScope = null;
        String string6 = null;
        String string7 = null;
        if (serverSecurityContext != null) {
            AdminPrincipal adminPrincipal = serverSecurityContext.getAdminPrincipal();
            if (adminPrincipal != null) {
                string6 = adminPrincipal.getName();
            }
            string7 = serverSecurityContext.getClientHost();
            adminMgmtScope = serverSecurityContext.getMgmtScope();
        }
        if ((n3 = string3.indexOf(58)) > 0) {
            string5 = string3.substring(0, n3);
            string4 = string3.substring(n3 + 1);
        } else {
            string5 = string3;
            string4 = "";
        }
        String string8 = n == 1 ? "Security Service" : SYSTEM_FRAMEWORK_NAME;
        if (this.logsvc != null) {
            try {
                LogRecord logRecord = new LogRecord(string8, n, n2, string6, string7, this.getHostName(), string, string2, null, adminMgmtScope);
                logRecord.addData("LM_CIS_CLASS", string5);
                logRecord.addData("LM_CIS_METHOD", string4);
                this.logsvc.writeRecord(logRecord, false);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    private void writeLog(String string, int n, int n2, String string2, String string3, String string4, String string5, String string6, Vector vector, AdminMgmtScope adminMgmtScope) {
        LogRecord logRecord = null;
        if (this.logsvc != null) {
            logRecord = new LogRecord(string, n, n2, string2, string3, string4, string5, string6, vector, adminMgmtScope);
            try {
                this.logsvc.writeRecord(logRecord, false);
                return;
            }
            catch (Exception exception) {
                AdminCommonTools.CMN_Trace1("Server daemon: write log: exception: " + exception.getMessage());
                return;
            }
        }
    }

    public static void main(String[] stringArray) {
        AdminServerException adminServerException;
        String string = null;
        if (stringArray.length == 1) {
            string = stringArray[0];
        }
        System.setSecurityManager(new RMISecurityManager());
        AdminServerImpl adminServerImpl = null;
        try {
            adminServerImpl = new AdminServerImpl(string);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("Unable to create management server daemon: " + exception.getMessage());
            AdminCommonTools.CMN_TraceStack(1, exception);
            adminServerException = new AdminServerException("EXM_CMM1", exception.getLocalizedMessage());
            try {
                AdminServerLibrary.writeToSyslog(adminServerException.getLocalizedMessage(), "AdminSuite", 2);
            }
            catch (Exception exception2) {}
            System.out.println(adminServerException.getLocalizedMessage());
            System.out.println(exception.getLocalizedMessage());
            System.exit(1);
        }
        String string2 = adminServerImpl.getHostName();
        int n = adminServerImpl.getServerPort();
        try {
            LocateRegistry.createRegistry(n);
        }
        catch (Exception exception) {
            try {
                LocateRegistry.getRegistry(n);
            }
            catch (Exception exception3) {
                AdminCommonTools.CMN_Trace1("Server was not started!  Error starting RMI registry.");
                AdminCommonTools.CMN_Trace1(exception3.getLocalizedMessage());
                adminServerException = new AdminServerException("EXM_CMM2");
                try {
                    AdminServerLibrary.writeToSyslog(adminServerException.getLocalizedMessage(), "AdminSuite", 2);
                }
                catch (Exception exception4) {}
                System.out.println(adminServerException.getLocalizedMessage());
                System.out.println(exception3.getLocalizedMessage());
                System.exit(1);
            }
        }
        String string3 = adminServerImpl.getServerName();
        String string4 = "rmi://" + string2 + ":" + n + "/" + string3;
        Remote remote = null;
        try {
            remote = Naming.lookup(string4);
        }
        catch (Exception exception) {
            remote = null;
        }
        if (remote != null) {
            AdminCommonTools.CMN_Trace1("Another instance of the management server is already running!");
            adminServerException = new AdminServerException("EXM_CMM3", string3);
            try {
                AdminServerLibrary.writeToSyslog(adminServerException.getLocalizedMessage(), "AdminSuite", 1);
            }
            catch (Exception exception) {}
            System.out.println(adminServerException.getLocalizedMessage());
            adminServerException = new AdminServerException("EXM_CMM12");
            System.out.println(adminServerException.getLocalizedMessage());
            System.exit(1);
        }
        try {
            Naming.rebind(string4, adminServerImpl);
            AdminCommonTools.CMN_Trace1(String.valueOf(string3) + " bound in RMI registry at port " + n);
            adminServerException = new AdminServerException("EXM_CMM4", (Object)string3, new Integer(n).toString());
            try {
                AdminServerLibrary.writeToSyslog(adminServerException.getLocalizedMessage(), "AdminSuite", 0);
            }
            catch (Exception exception) {}
            System.out.println(adminServerException.getLocalizedMessage());
            return;
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1(String.valueOf(string3) + " failed to bind to RMI registry at port " + n);
            AdminCommonTools.CMN_Trace1(exception.getMessage());
            adminServerException = new AdminServerException("EXM_CMM5", (Object)string3, new Integer(n).toString());
            try {
                AdminServerLibrary.writeToSyslog(adminServerException.getLocalizedMessage(), "AdminSuite", 2);
            }
            catch (Exception exception5) {}
            System.out.println(adminServerException.getLocalizedMessage());
            System.out.println(exception.getMessage());
            System.exit(1);
            return;
        }
    }
}

