/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.DoubleBufferedContainer;
import com.sun.admin.cis.common.Sequence;
import com.sun.admin.cis.common.Stopwatch;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

public class Sprite
extends Component {
    private DoubleBufferedContainer container;
    private Sequence currentSequence;
    private Sequence mainSequence;
    private Stopwatch moveTimer = new Stopwatch();
    private Point startPt = new Point(0, 0);
    private Point moveVector = new Point(1, 1);
    private long moveInterval;

    public Sprite(DoubleBufferedContainer doubleBufferedContainer, Sequence sequence, Point point) {
        this.container = doubleBufferedContainer;
        this.setSequence(sequence);
        this.setMainSequence(sequence);
        this.moveTimer.start();
        this.currentSequence.start();
        this.setLocation(point);
    }

    public void reverseX() {
        this.moveVector.x = -this.moveVector.x;
    }

    public void reverseY() {
        this.moveVector.y = -this.moveVector.y;
    }

    public void reverse() {
        this.reverseX();
        this.reverseY();
    }

    public void setMoveVector(Point point) {
        this.moveVector = point;
    }

    public Point getMoveVector() {
        return this.moveVector;
    }

    public void paint(Graphics graphics) {
        if (this.isVisible()) {
            Image image = this.currentSequence.getCurrentImage();
            graphics.drawImage(image, 0, 0, this);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Dimension preferredSize() {
        Image image = this.currentSequence.getCurrentImage();
        return new Dimension(image.getWidth(this), image.getHeight(this));
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public void play(Sequence sequence, long l) {
        this.setSequence(sequence);
        sequence.setCyclesPerAnimation(l);
        sequence.setCurrentCycle(0L);
    }

    public void animate() {
        if (this.currentSequence.animationOver()) {
            this.currentSequence = this.mainSequence;
        }
        if (this.timeToChangeImage()) {
            this.currentSequence.advance();
        }
        if (this.timeToMove()) {
            this.advance();
            return;
        }
        if (this.needsRepainting()) {
            this.container.paintComponent(this);
        }
    }

    public void setMainSequence(Sequence sequence) {
        this.mainSequence = sequence;
    }

    public Sequence getMainSequence() {
        return this.mainSequence;
    }

    public void setSequence(Sequence sequence) {
        this.currentSequence = sequence;
    }

    public Sequence getSequence() {
        return this.currentSequence;
    }

    public boolean willIntersect(Sprite sprite) {
        return this.getNextBounds().intersects(sprite.getNextBounds());
    }

    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
        this.moveTimer.reset();
    }

    public void setMoveInterval(long l) {
        this.moveInterval = l;
    }

    public void setImageChangeInterval(long l) {
        this.currentSequence.setAdvanceInterval(l);
    }

    public Point getNextLocation() {
        Rectangle rectangle = this.getBounds();
        return new Point(rectangle.x + this.moveVector.x, rectangle.y + this.moveVector.y);
    }

    public Rectangle getNextBounds() {
        Rectangle rectangle = this.getBounds();
        Point point = this.getNextLocation();
        return new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
    }

    protected boolean timeToChangeImage() {
        return this.currentSequence.timeToAdvanceCell();
    }

    protected boolean timeToMove() {
        return this.moveTimer.elapsedTime() > this.moveInterval;
    }

    protected boolean needsRepainting() {
        Rectangle rectangle = this.getBounds();
        return this.currentSequence.needsRepainting(new Point(rectangle.x, rectangle.y));
    }

    protected void advance() {
        Rectangle rectangle = this.getBounds();
        this.container.blitBackgroundToWorkplace(rectangle);
        Image image = this.currentSequence.getCurrentImage();
        this.setBounds(rectangle.x + this.moveVector.x, rectangle.y + this.moveVector.y, image.getWidth(this), image.getHeight(this));
        this.container.paintComponents(rectangle.union(this.getBounds()), true);
    }
}

