/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.UmbrellaConnection;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InfoDialog {
    private JDialog dialog;
    private JButton continueBtn;
    private JButton filterBtn;
    private JButton cancelBtn;
    private JFrame parent;
    private String title = ResourceStrings.getString("info_title");
    private JPanel msgPanel;
    private String continueLbl = ResourceStrings.getString("i_continue_lbl");
    private String filterLbl = ResourceStrings.getString("i_filter_lbl");
    private String cancelLbl = ResourceStrings.getString("i_cancel_lbl");
    private ActionListener continue_listener;
    private ActionListener filter_listener;
    private ActionListener cancel_listener;
    private static final String imageDir = String.valueOf(UmbrellaConnection.sharedInstance().getClientComm().getImagePath()) + "/cis/common/images/";
    private static final ImageIcon infoIcon = new ImageIcon(String.valueOf(imageDir) + "info_icon.gif");
    private static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

    public InfoDialog(JFrame jFrame, JPanel jPanel, ActionListener actionListener, String string, String string2) {
        this.parent = jFrame;
        this.msgPanel = jPanel;
        this.continueLbl = string;
        this.createInfoDialog();
    }

    public InfoDialog(JFrame jFrame, String string, JPanel jPanel, ActionListener actionListener, ActionListener actionListener2, ActionListener actionListener3) {
        this.parent = jFrame;
        this.title = string;
        this.msgPanel = jPanel;
        this.continue_listener = actionListener;
        this.filter_listener = actionListener2;
        this.cancel_listener = actionListener3;
        this.createInfoDialog();
    }

    public InfoDialog(JFrame jFrame, String string, String string2, ActionListener actionListener, ActionListener actionListener2, String string3) {
        this.parent = jFrame;
        this.title = string;
        this.continueLbl = string3;
        this.continue_listener = actionListener;
        this.filter_listener = actionListener2;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        FlowArea flowArea = new FlowArea(string2, 30, Constants.ERROR_DIALOG_FONT);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain(jPanel, flowArea, 0, 0, 1, 1, 1, 17, 1.0, 1.0, 0, 0, 0, 0);
        this.msgPanel = jPanel;
        this.createInfoDialog();
    }

    private void createInfoDialog() {
        this.dialog = new JDialog(this.parent, this.title, true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        SpecialKeyListener specialKeyListener = new SpecialKeyListener();
        this.dialog.addKeyListener(specialKeyListener);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        Constraints.constrain(jPanel, jPanel2, 0, 0, 1, 2, 3, 17, 0.0, 1.0, 5, 5, 5, 0);
        JLabel jLabel = this.getIconLabel();
        Constraints.constrain(jPanel2, jLabel, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 5, 5);
        JPanel jPanel3 = new JPanel();
        Constraints.constrain(jPanel2, jPanel3, 0, 1, 1, 1, 3, 17, 0.0, 1.0, 0, 0, 0, 0);
        this.msgPanel.setSize(this.msgPanel.getPreferredSize());
        Constraints.constrain(jPanel, this.msgPanel, 1, 0, 1, 1, 1, 17, 1.0, 1.0, 20, 10, 20, 20);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(gridBagLayout);
        jPanel3 = new JPanel();
        Constraints.constrain(jPanel4, jPanel3, 0, 0, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        this.continueBtn = new JButton(ResourceStrings.getString("i_continue_lbl"));
        this.continueBtn.addActionListener(new ContinueBtnListener());
        Constraints.constrain(jPanel4, this.continueBtn, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 5, 5);
        this.filterBtn = new JButton(ResourceStrings.getString("i_filter_lbl"));
        this.filterBtn.addActionListener(new FilterBtnListener());
        Constraints.constrain(jPanel4, this.filterBtn, 2, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 5, 5);
        this.cancelBtn = new JButton(ResourceStrings.getString("i_cancel_lbl"));
        this.cancelBtn.addActionListener(new CancelBtnListener());
        Constraints.constrain(jPanel4, this.cancelBtn, 3, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 0, 5, 5);
        Constraints.constrain(jPanel, jPanel4, 1, 1, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        this.dialog.getContentPane().setLayout(gridBagLayout);
        Constraints.constrain(this.dialog.getContentPane(), jPanel, 0, 0, 1, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.dialog.pack();
        this.dialog.setResizable(false);
        this.centerDialog();
        ((Component)this.dialog).setVisible(true);
    }

    private JLabel getIconLabel() {
        JLabel jLabel = new JLabel(infoIcon);
        return jLabel;
    }

    public void centerDialog() {
        ((Component)this.dialog).setLocation(InfoDialog.screenSize.width / 2 - this.dialog.getSize().width / 2, InfoDialog.screenSize.height / 2 - this.dialog.getSize().height / 2);
    }

    class ContinueBtnListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = new JButton();
            jButton.addActionListener(InfoDialog.this.continue_listener);
            jButton.doClick();
            InfoDialog.this.dialog.dispose();
        }

        ContinueBtnListener() {
            InfoDialog.this = InfoDialog.this;
        }
    }

    class FilterBtnListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = new JButton();
            jButton.addActionListener(InfoDialog.this.filter_listener);
            jButton.doClick();
            InfoDialog.this.dialog.dispose();
        }

        FilterBtnListener() {
            InfoDialog.this = InfoDialog.this;
        }
    }

    class CancelBtnListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = new JButton();
            jButton.addActionListener(InfoDialog.this.cancel_listener);
            jButton.doClick();
            InfoDialog.this.dialog.dispose();
        }

        CancelBtnListener() {
            InfoDialog.this = InfoDialog.this;
        }
    }

    protected class SpecialKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                InfoDialog.this.continueBtn.doClick();
                return;
            }
            if (keyEvent.getKeyCode() == 27) {
                InfoDialog.this.dialog.dispose();
            }
        }

        protected SpecialKeyListener() {
            InfoDialog.this = InfoDialog.this;
        }
    }
}

