/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.LAYOUT_ALIGNMENT;
import com.sun.admin.cis.common.LinkEvent;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.RowLayout;
import com.sun.admin.cis.common.TwoStateButton;
import com.sun.admin.cis.common.UmbrellaConnection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class GenInfoPanel
extends JPanel {
    public static final int MAIN_WINDOW = 0;
    public static final int PROPERTY_DIALOG = 1;
    private InfoBar infoBar;
    private JButton infoButton;
    private JLabel titleText;
    private JPanel titleBar;
    private JEditorPane editorPane;
    private JScrollPane infoScroller;
    private boolean isHelpOn = true;
    JPanel infoP = this;

    public GenInfoPanel(String string, int n) {
        this(string, n, null);
    }

    public GenInfoPanel(String string, int n, ActionListener actionListener) {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.infoBar = new InfoBar(string, n, actionListener);
        this.add("North", this.infoBar);
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.editorPane.addHyperlinkListener(new LinkEvent(this.editorPane));
        this.infoScroller = new JScrollPane(this.editorPane);
        this.add("Center", this.infoScroller);
    }

    public void setUrl(URL uRL) {
        try {
            this.editorPane.setPage(uRL);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Malformed URL: " + malformedURLException);
            return;
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException);
            return;
        }
    }

    public void setTitle(String string) {
        this.infoBar.setTitleText(string);
    }

    public JButton getInfoButton() {
        return this.infoButton;
    }

    public void hideInfoPanel(boolean bl) {
        this.infoBar.setState(bl);
        if (bl) {
            this.remove(this.infoScroller);
            this.setBackground(new Color(204, 204, 204));
            return;
        }
        this.add("Center", this.infoScroller);
        this.setBackground(Color.white);
    }

    public void setFocusListener(FocusListener focusListener, boolean bl) {
        if (this.infoBar.getHideButton() != null) {
            this.infoBar.getHideButton().addFocusListener(focusListener);
        }
        this.infoBar.getTitleLabel().addMouseListener(new LabelFocusListener(focusListener));
        if (bl) {
            if (this.infoBar.getHideButton() != null) {
                this.infoBar.getHideButton().requestFocus();
                return;
            }
            this.editorPane.requestFocus();
        }
    }

    class LabelFocusListener
    extends MouseAdapter {
        private FocusListener listener;

        public LabelFocusListener(FocusListener focusListener) {
            GenInfoPanel.this = GenInfoPanel.this;
            this.listener = focusListener;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (GenInfoPanel.this.infoBar.getHideButton() != null) {
                GenInfoPanel.this.infoBar.getHideButton().requestFocus();
                return;
            }
            GenInfoPanel.this.editorPane.requestFocus();
        }
    }

    class InfoBar
    extends JPanel {
        private Vector icons;
        private Color bgColor;
        private ImageIcon infoIcon;
        private JLabel titleLabel;
        protected TwoStateButton hide;

        public InfoBar(String string, int n, ActionListener actionListener) {
            Object object;
            GenInfoPanel.this = GenInfoPanel.this;
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new RowLayout(LAYOUT_ALIGNMENT.EXPAND));
            JLabel jLabel = null;
            if (n == 1) {
                object = UmbrellaConnection.sharedInstance().getClientComm().getImagePath();
                object = String.valueOf(object) + "/cis/common/images/";
                this.infoIcon = new ImageIcon(String.valueOf(object) + "i_small.gif");
                this.hide = new TwoStateButton(this.infoIcon);
                this.hide.setPreferredSize(new Dimension(this.infoIcon.getIconWidth() + 10, this.infoIcon.getIconHeight() + 10));
                this.hide.setState(true);
                this.hide.setActionCommand("infopanel");
                this.hide.setToolTipText(ResourceStrings.getString("IB_CollapsedTooltip"));
                if (actionListener != null) {
                    this.hide.addActionListener(actionListener);
                }
            } else if (n == 0) {
                jLabel = new JLabel(this.infoIcon);
                jLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 0));
            }
            this.titleLabel = new JLabel(string);
            this.titleLabel.setFont(new Font("dialog", 1, 12));
            if (n == 1) {
                object = new Dimension(135, this.titleLabel.getPreferredSize().height);
                this.titleLabel.setPreferredSize((Dimension)object);
                this.titleLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(204, 204, 255)));
            } else if (n == 0) {
                this.titleLabel.setForeground(Color.black);
            }
            if (this.hide != null) {
                jPanel.add(this.hide);
            }
            if (jLabel != null) {
                jPanel.add(jLabel);
            }
            jPanel.setBackground(Color.white);
            jPanel.add(this.titleLabel);
            this.add("West", jPanel);
            this.setBackground(Color.white);
            if (n == 0) {
                object = new JButton(ResourceStrings.getString("IB_HelpTopics"));
                ((AbstractButton)object).setMargin(new Insets(0, 0, 0, 0));
                ((AbstractButton)object).setActionCommand("help topics");
                ((AbstractButton)object).addActionListener(actionListener);
                this.add("East", (Component)object);
                MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(204, 204, 255));
                Border border = BorderFactory.createEmptyBorder(2, 0, 2, 50);
                this.setBorder(BorderFactory.createCompoundBorder(matteBorder, border));
                return;
            }
            if (n == 1) {
                this.setBorder(BorderFactory.createEmptyBorder(3, 5, 0, 5));
            }
        }

        public void setState(boolean bl) {
            if (bl) {
                this.hide.setState(true);
                this.hide.setBorder(BorderFactory.createRaisedBevelBorder());
                this.hide.setBorderPainted(true);
                this.hide.setToolTipText(ResourceStrings.getString("IB_ExpandedTooltip"));
                this.remove(this.titleLabel);
                this.setBackground(new Color(204, 204, 204));
                return;
            }
            this.setBackground(Color.white);
            this.hide.setBorder(BorderFactory.createLoweredBevelBorder());
            this.hide.setState(true);
            this.hide.setToolTipText(ResourceStrings.getString("IB_CollapsedTooltip"));
            this.add(this.titleLabel);
        }

        public void setTitleText(String string) {
            this.titleLabel.setText(string);
        }

        public JButton getHideButton() {
            return this.hide;
        }

        public JLabel getTitleLabel() {
            return this.titleLabel;
        }
    }
}

