/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public class DoubleBufferedContainer
extends Container {
    protected OffscreenBuffer buffers = new OffscreenBuffer();
    private Image wallpaperImage;

    public DoubleBufferedContainer() {
        this(null);
    }

    public DoubleBufferedContainer(Image image) {
        this.setWallpaperImage(image);
        this.addComponentListener(new 1());
    }

    public void setWallpaperImage(Image image) {
        this.wallpaperImage = image;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (this.windowDamaged(graphics)) {
            this.buffers.blitWorkplaceToScreen(rectangle);
            return;
        }
        Graphics graphics2 = this.buffers.getWorkplaceGraphics();
        Dimension dimension = this.getSize();
        this.paintBackground();
        graphics2.setClip(0, 0, dimension.width, dimension.height);
        super.paint(graphics2);
        this.buffers.blitWorkplaceToScreen();
        graphics2.dispose();
    }

    public void blitWorkplaceToScreen() {
        this.buffers.blitWorkplaceToScreen();
    }

    public void blitBackgroundToWorkplace() {
        this.buffers.blitBackgroundToWorkplace();
    }

    public void blitWorkplaceToScreen(Rectangle rectangle) {
        this.buffers.blitWorkplaceToScreen(rectangle);
    }

    public void blitBackgroundToWorkplace(Rectangle rectangle) {
        this.buffers.blitBackgroundToWorkplace(rectangle);
    }

    public void paintComponents(Rectangle rectangle, boolean bl) {
        Graphics graphics = this.buffers.getWorkplaceGraphics();
        graphics.setClip(rectangle);
        super.paint(graphics);
        if (bl) {
            this.buffers.blitWorkplaceToScreen(rectangle);
        }
        graphics.dispose();
    }

    public void paintComponent(Component component) {
        this.paintComponent(component, true);
    }

    public void eraseComponent(Component component) {
        this.eraseComponent(component, true);
    }

    public void paintComponent(Component component, boolean bl) {
        Graphics graphics = this.buffers.getWorkplaceGraphics();
        Rectangle rectangle = component.getBounds();
        Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        component.paint(graphics2);
        if (bl) {
            this.buffers.blitWorkplaceToScreen(rectangle);
        }
        graphics.dispose();
    }

    public void eraseComponent(Component component, boolean bl) {
        Rectangle rectangle = component.getBounds();
        this.buffers.blitBackgroundToWorkplace(rectangle);
        this.paintOverlappingComponents(component);
        if (bl) {
            this.buffers.blitWorkplaceToScreen(rectangle);
        }
    }

    public void moveComponent(Component component, Point point) {
        Rectangle rectangle = component.getBounds();
        this.eraseComponent(component, false);
        component.setLocation(point);
        this.paintComponent(component, false);
        this.buffers.blitWorkplaceToScreen(rectangle.union(component.getBounds()));
    }

    protected boolean windowDamaged(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        Dimension dimension = this.getSize();
        return rectangle.x != 0 || rectangle.y != 0 || rectangle.width < dimension.width || rectangle.height < dimension.height;
    }

    protected void paintOverlappingComponents(Component component) {
        Graphics graphics = this.buffers.getWorkplaceGraphics();
        Rectangle rectangle = component.getBounds();
        graphics.setClip(rectangle);
        component.setVisible(false);
        super.paint(graphics);
        component.setVisible(true);
        graphics.dispose();
    }

    protected void paintBackground() {
        this.paintBackground((Rectangle)null);
    }

    protected void paintBackground(Rectangle rectangle) {
        Graphics graphics = this.buffers.getBackgroundGraphics();
        if (rectangle != null) {
            graphics.setClip(rectangle);
        }
        this.paintBackground(graphics);
        this.buffers.blitBackgroundToWorkplace();
        graphics.dispose();
    }

    protected void paintBackground(Graphics graphics) {
        if (this.wallpaperImage != null) {
            Util.wallPaper(this, graphics, this.wallpaperImage);
        }
    }

    private final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            DoubleBufferedContainer.this.buffers.update();
        }

        /* synthetic */ 1() {
        }
    }

    class OffscreenBuffer {
        private Image workplaceBuffer;
        private Image backgroundBuffer;
        private Dimension offscreenSize;

        public Image getWorkplaceBuffer() {
            return this.workplaceBuffer;
        }

        public Image getBackground() {
            return this.backgroundBuffer;
        }

        public Graphics getWorkplaceGraphics() {
            return this.workplaceBuffer.getGraphics();
        }

        public Graphics getBackgroundGraphics() {
            return this.backgroundBuffer.getGraphics();
        }

        public void blitWorkplaceToScreen() {
            this.blitWorkplaceToScreen(null);
        }

        public void blitBackgroundToWorkplace() {
            this.blitBackgroundToWorkplace(null);
        }

        public void blitWorkplaceToScreen(Rectangle rectangle) {
            Graphics graphics = DoubleBufferedContainer.this.getGraphics();
            if (graphics != null) {
                if (rectangle != null) {
                    graphics.setClip(rectangle);
                }
                graphics.drawImage(this.workplaceBuffer, 0, 0, DoubleBufferedContainer.this);
                graphics.dispose();
            }
        }

        public void blitBackgroundToWorkplace(Rectangle rectangle) {
            Graphics graphics = this.getWorkplaceGraphics();
            if (rectangle != null) {
                graphics.setClip(rectangle);
            }
            graphics.drawImage(this.backgroundBuffer, 0, 0, DoubleBufferedContainer.this);
            graphics.dispose();
        }

        void update() {
            if (this.needNewOffscreenBuffer()) {
                this.createBuffers();
            }
        }

        private boolean needNewOffscreenBuffer() {
            Dimension dimension = DoubleBufferedContainer.this.getSize();
            return this.workplaceBuffer == null || dimension.width != this.offscreenSize.width || dimension.height != this.offscreenSize.height;
        }

        private void createBuffers() {
            this.offscreenSize = DoubleBufferedContainer.this.getSize();
            this.workplaceBuffer = this.createOffscreenImage(this.offscreenSize);
            this.backgroundBuffer = this.createOffscreenImage(this.offscreenSize);
        }

        private Image createOffscreenImage(Dimension dimension) {
            Image image = DoubleBufferedContainer.this.createImage(dimension.width, dimension.height);
            Util.waitForImage(DoubleBufferedContainer.this, image);
            return image;
        }

        OffscreenBuffer() {
            DoubleBufferedContainer.this = DoubleBufferedContainer.this;
        }
    }
}

