/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.AdminClientException;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ResourceStrings;
import java.io.Serializable;
import java.util.StringTokenizer;

public class AdminMgmtScope
implements Cloneable,
Serializable {
    public static final String ADM_SCOPE_SYSTEM = "file";
    public static final String ADM_SCOPE_NIS = "nis";
    public static final String ADM_SCOPE_NISPLUS = "nisplus";
    public static final String ADM_SCOPE_DNS = "dns";
    private static final String[] type_name = new String[]{"file", "nis", "nisplus", "dns"};
    private static final String[] type_show = new String[]{"LG_server", "LG_nis", "LG_nis+", "LG_dns"};
    private String scopetype;
    private String scopename;
    private String servername;
    private String domainname;

    public static boolean compareServerHostNames(String string, String string2) {
        boolean bl = false;
        int n = string.indexOf(46);
        int n2 = string2.indexOf(46);
        bl = n > 0 ? (n2 > 0 ? string.equals(string2) : string2.equals(string.substring(0, n))) : (n2 > 0 ? string.equals(string2.substring(0, n2)) : string.equals(string2));
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AdminMgmtScope(String string, String string2, String string3, String string4) throws AdminException {
        this.scopetype = this.checkScopeType(string);
        if (this.scopetype == null) {
            throw new AdminClientException("EXM_BMS");
        }
        this.servername = string3;
        if (this.servername == null || this.servername.trim().length() == 0) {
            throw new AdminClientException("EXM_BMS");
        }
        this.domainname = string4;
        if (this.domainname == null || this.domainname.trim().length() == 0) {
            if (!this.scopetype.equals(ADM_SCOPE_SYSTEM)) throw new AdminClientException("EXM_BMS");
            this.domainname = this.servername;
        } else if (this.scopetype.equals(ADM_SCOPE_SYSTEM) && !this.servername.equals(this.domainname)) {
            throw new AdminClientException("EXM_BMS");
        }
        this.scopename = string2;
        if (this.scopename != null && this.scopename.trim().length() != 0) return;
        this.scopename = this.defaultName();
    }

    public AdminMgmtScope(String string, String string2) throws AdminException {
        String string3;
        String string4;
        String string5;
        if (string2 == null || string2.trim().length() == 0) {
            throw new AdminClientException("EXM_BMS");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":/", true);
        try {
            string5 = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            throw new AdminClientException("EXM_BMS");
        }
        this.scopetype = this.checkScopeType(string5);
        if (this.scopetype == null) {
            throw new AdminClientException("EXM_BMS");
        }
        try {
            string4 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            throw new AdminClientException("EXM_BMS");
        }
        if (!string4.equals(":") || !string3.equals("/")) {
            throw new AdminClientException("EXM_BMS");
        }
        try {
            this.servername = stringTokenizer.nextToken();
            string4 = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            throw new AdminClientException("EXM_MSS");
        }
        if (!string4.equals("/")) {
            throw new AdminClientException("EXM_BMS");
        }
        try {
            this.domainname = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            this.domainname = null;
        }
        if (this.domainname == null ? !this.scopetype.equals(ADM_SCOPE_SYSTEM) : this.scopetype.equals(ADM_SCOPE_SYSTEM) && !this.servername.equals(this.domainname)) {
            throw new AdminClientException("EXM_BMS");
        }
        this.scopename = string;
        if (this.scopename == null || this.scopename.trim().length() == 0) {
            this.scopename = this.defaultName();
        }
    }

    public String getMgmtScopeType() {
        return this.scopetype;
    }

    public String getMgmtScopeName() {
        return this.scopename;
    }

    public String getMgmtServerName() {
        return this.servername;
    }

    public String getMgmtDomainName() {
        String string = this.domainname;
        if (string == null) {
            string = this.scopetype == ADM_SCOPE_SYSTEM ? this.servername : this.scopename;
        }
        return string;
    }

    public void setMgmtScopeName(String string) {
        this.scopename = string;
    }

    public boolean equals(AdminMgmtScope adminMgmtScope) throws AdminException {
        boolean bl = false;
        if (adminMgmtScope != null) {
            String string = adminMgmtScope.getMgmtScopeType();
            String string2 = adminMgmtScope.getMgmtServerName();
            String string3 = adminMgmtScope.getMgmtDomainName();
            bl = this.isEqual(string, string2, string3);
        }
        return bl;
    }

    public boolean equals(String string) throws AdminException {
        boolean bl = false;
        try {
            int n = string.indexOf(58);
            int n2 = string.lastIndexOf(47);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 2, n2);
            String string4 = string.substring(n2 + 1);
            bl = this.isEqual(string2, string3, string4);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public AdminMgmtScope newCopy() throws AdminException {
        return new AdminMgmtScope(this.scopetype, this.scopename, this.servername, this.domainname);
    }

    public String toString() {
        String string = this.getShowType();
        string = this.scopetype.equals(ADM_SCOPE_SYSTEM) ? String.valueOf(this.servername) + string : String.valueOf(this.domainname) + "-" + this.servername + string;
        return string;
    }

    public String toDirectoryTableURL() {
        String string = String.valueOf(this.scopetype) + ":/" + this.servername + "/" + this.domainname;
        return string;
    }

    private boolean isEqual(String string, String string2, String string3) {
        boolean bl = false;
        if (this.scopetype.equals(string)) {
            if (this.scopetype.equals(ADM_SCOPE_SYSTEM)) {
                bl = AdminMgmtScope.compareServerHostNames(this.servername, string2);
            } else {
                String string4 = this.domainname;
                String string5 = string3;
                if (this.scopetype.equals(ADM_SCOPE_NISPLUS)) {
                    if (!string4.endsWith(".")) {
                        string4 = string4.concat(".");
                    }
                    if (!string5.endsWith(".")) {
                        string5 = string5.concat(".");
                    }
                }
                bl = string4.equals(string5);
            }
        }
        return bl;
    }

    private String checkScopeType(String string) {
        String string2 = null;
        if (string != null) {
            int n = 0;
            while (n < type_name.length) {
                if (string.equals(type_name[n])) {
                    string2 = string;
                    break;
                }
                ++n;
            }
        }
        return string2;
    }

    private String getShowType() {
        String string = "";
        if (this.scopetype != null) {
            int n = 0;
            while (n < type_name.length) {
                if (this.scopetype.equals(type_name[n])) {
                    string = type_show[n];
                    break;
                }
                ++n;
            }
            if (string.length() > 0) {
                string = ResourceStrings.getString(string);
            }
        }
        return string;
    }

    private String defaultName() {
        String string;
        String string2 = this.servername.replace('.', '_');
        if (this.scopetype.equals(ADM_SCOPE_SYSTEM)) {
            string = "server-" + string2;
        } else {
            string = this.domainname.replace('.', '_');
            string = String.valueOf(this.scopetype) + "-" + string + "-" + string2;
        }
        return string;
    }
}

