/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.client;

import com.sun.admin.cis.client.AdminClientInfo;
import com.sun.admin.cis.client.AdminContext;
import com.sun.admin.cis.client.AdminSession;
import com.sun.admin.cis.client.IClientComm;
import com.sun.admin.cis.client.SBConstants;
import com.sun.admin.cis.common.AdminClientException;
import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.AdminMgmtScope;
import com.sun.admin.cis.common.AdminScopeNotOnServerException;
import com.sun.admin.cis.common.AdminServerNotFoundException;
import com.sun.admin.cis.common.AdminUserContext;
import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.service.security.AdminAuthenticationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class LogOnDialog
extends AdminDialog {
    LogOnDialog logOnDialog = this;
    public JButton okButton;
    public JButton cancelButton;
    JTextField uname;
    JPasswordField pwd;
    JComboBox scopeComboBox;
    URL url;
    GenInfoPanel infoPanel;
    String searchString = "";
    JPanel blankPanel;
    IClientComm clientComm;
    JFrame jFrame;
    private boolean doSystemExit;
    private Vector vAdminMgmtScope;
    String serverName;

    public LogOnDialog(JFrame jFrame, boolean bl) {
        this(jFrame, bl, "");
    }

    public LogOnDialog(JFrame jFrame, boolean bl, String string) {
        super(jFrame, "Logon", false);
        Object object;
        this.doSystemExit = bl;
        this.jFrame = jFrame;
        this.addKeyListener(new LogonKeyListener());
        if (string.equals("")) {
            this.logOnDialog.setTitle(ResourceStrings.getString("logon"));
        } else {
            this.logOnDialog.setTitle(string);
        }
        this.infoPanel = this.getInfoPanel();
        this.clientComm = (IClientComm)((Object)jFrame);
        try {
            if (this.logOnDialog.getTitle().equals(ResourceStrings.getString("logon"))) {
                object = this.clientComm.getHelpUrl(SBConstants.getUMBHelpLocation(), "/logon.html");
                this.infoPanel.setUrl(new URL((String)object));
            } else if (this.logOnDialog.getTitle().equals(ResourceStrings.getString("change_scope"))) {
                object = this.clientComm.getHelpUrl(SBConstants.getUMBHelpLocation(), "/manage_change.html");
                this.infoPanel.setUrl(new URL((String)object));
            }
        }
        catch (MalformedURLException malformedURLException) {
            AdminCommonTools.CMN_HandleOutput("Malformed URL: " + malformedURLException);
        }
        this.blankPanel = this.getRightPanel();
        this.blankPanel.setLayout(new BorderLayout());
        this.blankPanel.add("Center", this.createLogOnPanel());
        this.okButton = this.getOKBtn();
        this.okButton.addActionListener(new logOnButtonListener());
        this.cancelButton = this.getCancelBtn();
        this.cancelButton.addActionListener(new logOnButtonListener());
        this.pack();
        object = this.getSize();
        ((Dimension)object).height = Constants.SMALL_HELP_DLG.height;
        this.setMySize((Dimension)object);
        ((Component)this).setSize(this.getMySize(this.hidden));
        if (this.logOnDialog.getTitle().equals(ResourceStrings.getString("logon"))) {
            this.uname.addFocusListener(new ContextHelpListener(this.clientComm, this.infoPanel, "cis", "logon_username.html"));
            this.pwd.addFocusListener(new ContextHelpListener(this.clientComm, this.infoPanel, "cis", "logon_passwd.html"));
            this.addHelpListener(this.infoPanel, this.scopeComboBox, "logon_manage.html");
        } else if (this.logOnDialog.getTitle().equals(ResourceStrings.getString("change_scope"))) {
            this.uname.addFocusListener(new ContextHelpListener(this.clientComm, this.infoPanel, "cis", "manage_change_username.html"));
            this.pwd.addFocusListener(new ContextHelpListener(this.clientComm, this.infoPanel, "cis", "manage_change_passwd.html"));
            this.addHelpListener(this.infoPanel, this.scopeComboBox, "manage_change_managed.html");
        }
        if (bl) {
            this.uname.requestFocus();
        } else {
            this.pwd.requestFocus();
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
        this.addWindowListener(new myWindowListener());
    }

    private void doExit() {
        if (this.doSystemExit) {
            System.exit(0);
            return;
        }
        this.logOnDialog.dispose();
    }

    private void addHelpListener(GenInfoPanel genInfoPanel, Component component, String string) {
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.addHelpListener(genInfoPanel, componentArray[n], string);
                ++n;
            }
        }
        component.addFocusListener(new ContextHelpListener(this.clientComm, genInfoPanel, "cis", string));
    }

    private JPanel createLogOnPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(ResourceStrings.getString("user_name"));
        jLabel.setFont(Constants.PROPS_LABEL_FONT);
        jLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        Constraints.constrain(jPanel, jLabel, 0, 0, 1, 1, 0, 14, 2.0, 1.0, 40, 5, 10, 5);
        this.uname = new JTextField(8);
        if (!this.doSystemExit) {
            this.uname.setText(AdminContext.instance().getUserName());
        }
        this.uname.addKeyListener(new LogonKeyListener());
        this.uname.setMinimumSize(this.uname.getPreferredSize());
        Constraints.constrain(jPanel, this.uname, 1, 0, 1, 1, 2, 16, 1.0, 0.0, 40, 10, 10, 5);
        JLabel jLabel2 = new JLabel(ResourceStrings.getString("passwd"));
        jLabel2.setFont(Constants.PROPS_LABEL_FONT);
        jLabel2.setForeground(Constants.PROPS_LABEL_COLOR);
        Constraints.constrain(jPanel, jLabel2, 0, 1, 1, 1, 0, 13, 0.0, 0.0, 0, 5, 10, 5);
        this.pwd = new JPasswordField(15);
        this.pwd.addKeyListener(new LogonKeyListener());
        this.pwd.setFont(Constants.PASSWORD_VALUE_FONT);
        Constraints.constrain(jPanel, this.pwd, 1, 1, 1, 1, 2, 17, 0.0, 0.0, 0, 10, 10, 5);
        JLabel jLabel3 = new JLabel(ResourceStrings.getString("scope"));
        jLabel3.setFont(Constants.PROPS_LABEL_FONT);
        jLabel3.setForeground(Constants.PROPS_LABEL_COLOR);
        Constraints.constrain(jPanel, jLabel3, 0, 2, 1, 1, 0, 12, 0.0, 0.0, 0, 5, 10, 5);
        this.scopeComboBox = new JComboBox();
        this.scopeComboBox.setPreferredSize(new Dimension(220, 23));
        this.scopeComboBox.setFont(Constants.DOMAIN_NAME_FONT);
        this.scopeComboBox.addKeyListener(new LogonKeyListener());
        try {
            this.vAdminMgmtScope = LogOnDialog.getMgmtScopes();
        }
        catch (AdminServerNotFoundException adminServerNotFoundException) {
            new ErrorDialog(this.jFrame, String.valueOf(ResourceStrings.getString("Er_server_NotRunning")) + "\n\n" + adminServerNotFoundException.getLocalizedMessage());
            this.doExit();
        }
        catch (AdminAuthenticationException adminAuthenticationException) {
            new ErrorDialog(this.jFrame, String.valueOf(ResourceStrings.getString("Er_auth_Failure")) + "\n\n" + adminAuthenticationException.getLocalizedMessage());
            this.doExit();
        }
        catch (AdminScopeNotOnServerException adminScopeNotOnServerException) {
            new ErrorDialog(this.jFrame, String.valueOf(ResourceStrings.getString("Er_bad_Scope")) + "\n\n" + adminScopeNotOnServerException.getLocalizedMessage());
            this.doExit();
        }
        catch (AdminException adminException) {
            new ErrorDialog(this.jFrame, String.valueOf(ResourceStrings.getString("Er_fatal_Scope")) + "\n\n" + adminException.getLocalizedMessage());
            this.doExit();
        }
        if (this.vAdminMgmtScope != null && !this.vAdminMgmtScope.isEmpty()) {
            int n = 0;
            while (n < this.vAdminMgmtScope.size()) {
                AdminMgmtScope adminMgmtScope = (AdminMgmtScope)this.vAdminMgmtScope.elementAt(n);
                String string = this.createFullScopeName(adminMgmtScope);
                this.scopeComboBox.addItem(string);
                ++n;
            }
        } else {
            new ErrorDialog(this.jFrame, ResourceStrings.getString("Er_fatal_Scope"));
            this.doExit();
        }
        if (this.vAdminMgmtScope != null && !this.vAdminMgmtScope.isEmpty()) {
            this.scopeComboBox.setSelectedIndex(0);
        }
        Constraints.constrain(jPanel, this.scopeComboBox, 1, 2, 1, 1, 2, 18, 0.0, 2.0, 0, 10, 10, 5);
        AdminCommonTools.CMN_HandleOutput("Combo size =" + this.scopeComboBox.getPreferredSize());
        return jPanel;
    }

    public boolean isLogOnSyntaxOK() {
        AdminCommonTools.CMN_HandleOutput("Uname length =" + this.uname.getText().length());
        if (!CheckSyntax.isNameOK(this.uname.getText())) {
            AdminCommonTools.CMN_HandleOutput("isLogOnSyntaxOK is false");
            new ErrorDialog(this.jFrame, ResourceStrings.getString("login_error"));
            return false;
        }
        if (this.pwd.getPassword().length < 1) {
            AdminCommonTools.CMN_HandleOutput("isLogOnSyntaxOK is false");
            new ErrorDialog(this.jFrame, ResourceStrings.getString("Er_bad_pwd"));
            return false;
        }
        return true;
    }

    private String createFullScopeName(AdminMgmtScope adminMgmtScope) {
        String string = new String("None available");
        if (adminMgmtScope.getMgmtScopeType().equals("file")) {
            string = String.valueOf(adminMgmtScope.getMgmtServerName()) + " " + ResourceStrings.getString("LG_server");
        }
        if (adminMgmtScope.getMgmtScopeType().equals("nis")) {
            string = String.valueOf(adminMgmtScope.getMgmtDomainName()) + " - " + adminMgmtScope.getMgmtServerName() + " " + ResourceStrings.getString("LG_nis");
        }
        if (adminMgmtScope.getMgmtScopeType().equals("nisplus")) {
            string = String.valueOf(adminMgmtScope.getMgmtDomainName()) + " - " + adminMgmtScope.getMgmtServerName() + " " + ResourceStrings.getString("LG_nis+");
        }
        return string;
    }

    private static Vector getMgmtScopes() throws AdminException {
        AdminContext adminContext = AdminContext.instance();
        AdminClientInfo adminClientInfo = adminContext.getAdminClientInfo();
        Vector vector = null;
        vector = adminClientInfo.getMgmtScopeList();
        if (vector == null || vector.isEmpty()) {
            AdminClientException adminClientException = new AdminClientException("EXM_BMS");
            throw adminClientException;
        }
        return vector;
    }

    public static AdminMgmtScope getMgmtScope(String string) throws AdminException {
        Vector vector = null;
        vector = LogOnDialog.getMgmtScopes();
        if (vector == null) {
            return null;
        }
        AdminMgmtScope adminMgmtScope = null;
        int n = 0;
        while (n < vector.size()) {
            adminMgmtScope = (AdminMgmtScope)vector.elementAt(n);
            String string2 = adminMgmtScope.getMgmtScopeName();
            if (string2.equals(string)) break;
            ++n;
        }
        if (n == vector.size()) {
            adminMgmtScope = null;
        }
        return adminMgmtScope;
    }

    public static void setUpConnection(String string, String string2, AdminMgmtScope adminMgmtScope) throws Exception {
        try {
            AdminUserContext adminUserContext = new AdminUserContext(0, string, string2);
            AdminContext adminContext = AdminContext.instance();
            AdminClientInfo adminClientInfo = adminContext.getAdminClientInfo();
            AdminSession adminSession = new AdminSession(adminClientInfo, adminUserContext, adminMgmtScope);
            adminSession.connect();
            AdminCommonTools.CMN_HandleOutput("Updating Session in adminContext");
            adminContext.setAdminSession(adminSession);
            adminContext.setAdminUserContext(adminUserContext);
            adminContext.setAdminMgmtScope(adminMgmtScope);
            return;
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("Unable to authenticate with " + adminMgmtScope.getMgmtScopeName());
            throw exception;
        }
    }

    class logOnButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource() == LogOnDialog.this.cancelButton) {
                    LogOnDialog.this.doExit();
                    return;
                }
                if (actionEvent.getSource() == LogOnDialog.this.okButton && LogOnDialog.this.isLogOnSyntaxOK()) {
                    LogOnDialog.this.logOnDialog.setCursor(Cursor.getPredefinedCursor(3));
                    String string = LogOnDialog.this.uname.getText();
                    char[] cArray = LogOnDialog.this.pwd.getPassword();
                    String string2 = new String(cArray);
                    AdminMgmtScope adminMgmtScope = null;
                    int n = LogOnDialog.this.scopeComboBox.getSelectedIndex();
                    if (!LogOnDialog.this.vAdminMgmtScope.isEmpty()) {
                        adminMgmtScope = (AdminMgmtScope)LogOnDialog.this.vAdminMgmtScope.elementAt(n);
                    }
                    LogOnDialog.setUpConnection(string, string2, adminMgmtScope);
                    LogOnDialog.this.logOnDialog.setCursor(Cursor.getPredefinedCursor(0));
                    LogOnDialog.this.logOnDialog.dispose();
                    return;
                }
            }
            catch (AdminServerNotFoundException adminServerNotFoundException) {
                new ErrorDialog(LogOnDialog.this.jFrame, String.valueOf(ResourceStrings.getString("Er_server_NotRunning")) + "\n\n" + adminServerNotFoundException.getLocalizedMessage());
                LogOnDialog.this.logOnDialog.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            catch (AdminAuthenticationException adminAuthenticationException) {
                new ErrorDialog(LogOnDialog.this.jFrame, String.valueOf(ResourceStrings.getString("Er_auth_Failure")) + "\n\n" + adminAuthenticationException.getLocalizedMessage());
                LogOnDialog.this.logOnDialog.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            catch (AdminScopeNotOnServerException adminScopeNotOnServerException) {
                new ErrorDialog(LogOnDialog.this.jFrame, String.valueOf(ResourceStrings.getString("Er_bad_Scope")) + "\n\n" + adminScopeNotOnServerException.getLocalizedMessage());
                LogOnDialog.this.logOnDialog.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            catch (AdminException adminException) {
                new ErrorDialog(LogOnDialog.this.jFrame, String.valueOf(ResourceStrings.getString("Er_fatal_Scope")) + "\n\n" + adminException.getLocalizedMessage());
                LogOnDialog.this.logOnDialog.setCursor(Cursor.getPredefinedCursor(0));
                LogOnDialog.this.doExit();
                return;
            }
            catch (Exception exception) {
                new ErrorDialog(LogOnDialog.this.jFrame, exception.getLocalizedMessage());
                LogOnDialog.this.logOnDialog.setCursor(Cursor.getPredefinedCursor(0));
                LogOnDialog.this.doExit();
            }
        }

        logOnButtonListener() {
            LogOnDialog.this = LogOnDialog.this;
        }
    }

    class myWindowListener
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            LogOnDialog.this.doExit();
        }

        myWindowListener() {
            LogOnDialog.this = LogOnDialog.this;
        }
    }

    class LogonKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                LogOnDialog.this.okButton.doClick();
            }
            if (keyEvent.getKeyCode() == 27) {
                LogOnDialog.this.cancelButton.doClick();
            }
        }

        LogonKeyListener() {
            LogOnDialog.this = LogOnDialog.this;
        }
    }
}

