/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.client;

import com.sun.admin.cis.client.AdminClientInfo;
import com.sun.admin.cis.client.ConnectionExistsException;
import com.sun.admin.cis.common.AdminClientException;
import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.AdminMgmtScope;
import com.sun.admin.cis.common.AdminServerNotFoundException;
import com.sun.admin.cis.common.AdminUserContext;
import com.sun.admin.cis.common.AdminVersion;
import com.sun.admin.cis.server.AdminFactory;
import com.sun.admin.cis.server.AdminServer;
import com.sun.admin.cis.service.logging.LogRecord;
import com.sun.admin.cis.service.security.AdminPrincipal;
import com.sun.admin.cis.service.security.AuthenticatorSecurityToken;
import com.sun.admin.cis.service.security.ClientSecurityContext;
import com.sun.admin.cis.service.security.ConfirmSecurityToken;
import com.sun.admin.cis.service.security.DigestClientSecurityContext;
import com.sun.admin.cis.service.security.RequestSecurityToken;
import com.sun.admin.cis.service.security.ResponseSecurityToken;
import com.sun.admin.cis.service.security.SecurityPolicyObj;
import com.sun.admin.cis.service.security.SecurityToken;
import com.sun.admin.cis.service.security.VerifierSecurityToken;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Vector;

public class AdminSession {
    private String hostname;
    private int portnum;
    private String admsvrname;
    private AdminServer admsvr;
    private ClientSecurityContext clientCtx;
    private AdminClientInfo clientSec;
    private AdminUserContext userCtx;
    private AdminMgmtScope scope;
    private boolean connEst;

    public AdminSession(AdminClientInfo adminClientInfo, AdminUserContext adminUserContext, AdminMgmtScope adminMgmtScope) throws AdminException {
        this.clientSec = adminClientInfo;
        if (adminUserContext == null) {
            throw new AdminClientException("EXM_NUC");
        }
        this.userCtx = adminUserContext;
        if (adminMgmtScope == null) {
            throw new AdminClientException("EXM_BMS");
        }
        this.scope = adminMgmtScope;
        this.hostname = this.scope.getMgmtServerName();
        this.portnum = this.clientSec.getServerPort();
        this.admsvrname = this.clientSec.getServerName();
        this.initSecurityContext(this.userCtx);
    }

    public void connect() throws AdminException {
        SecurityToken securityToken;
        SecurityToken securityToken2;
        if (this.isConnected()) {
            throw new ConnectionExistsException(this.hostname);
        }
        if (this.clientCtx.getAuthState() != 0) {
            throw new AdminClientException("EXM_PCF");
        }
        long l = System.currentTimeMillis();
        String string = this.getServerHostName();
        int n = this.getServerPort();
        String string2 = this.getServerRemoteName();
        String string3 = "rmi://" + string + ":" + n + "/" + string2;
        try {
            this.admsvr = (AdminServer)Naming.lookup(string3);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("Session connect: error from RMI lookup: " + exception.getMessage());
            AdminCommonTools.CMN_Trace1("Session connect: no server registerd with RMI at host " + string + " on port " + n);
            throw new AdminServerNotFoundException(this.hostname);
        }
        long l2 = System.currentTimeMillis();
        try {
            securityToken2 = this.clientCtx.generateRequest();
        }
        catch (AdminException adminException) {
            this.clearSecurityContext();
            throw adminException;
        }
        try {
            securityToken = this.admsvr.startAuthentication((RequestSecurityToken)securityToken2, this.scope, AdminVersion.getVersionNumber());
        }
        catch (RemoteException remoteException) {
            this.clearSecurityContext();
            AdminCommonTools.CMN_Trace1("Session connect 1: remote execption: " + remoteException.getMessage());
            throw new AdminClientException("EXM_REX", remoteException);
        }
        catch (AdminException adminException) {
            this.clearSecurityContext();
            throw adminException;
        }
        if (securityToken instanceof ResponseSecurityToken) {
            try {
                securityToken2 = this.clientCtx.verifyResponse((ResponseSecurityToken)securityToken);
            }
            catch (AdminException adminException) {
                this.clearSecurityContext();
                throw adminException;
            }
            try {
                securityToken = this.admsvr.completeAuthentication((AuthenticatorSecurityToken)securityToken2);
            }
            catch (RemoteException remoteException) {
                this.clearSecurityContext();
                AdminCommonTools.CMN_Trace1("Session connect 2: remote execption: " + remoteException.getMessage());
                throw new AdminClientException("EXM_REX", remoteException);
            }
            catch (AdminException adminException) {
                this.clearSecurityContext();
                throw adminException;
            }
        }
        try {
            securityToken2 = this.clientCtx.verifyConfirm((ConfirmSecurityToken)securityToken);
        }
        catch (AdminException adminException) {
            this.clearSecurityContext();
            throw adminException;
        }
        long l3 = System.currentTimeMillis();
        long l4 = l3 - l;
        long l5 = l4 / 1000L;
        long l6 = l4 - l5 * 1000L;
        l4 = l2 - l;
        long l7 = l4 / 1000L;
        long l8 = l4 - l7 * 1000L;
        AdminCommonTools.CMN_Trace1("Session connect: session established to server " + string);
        AdminCommonTools.CMN_Trace2("Perform: total connect=" + l5 + "." + l6 + "  rmi lookup=" + l7 + "." + l8);
    }

    public void close() throws AdminException {
        SecurityToken securityToken;
        try {
            securityToken = this.getSecurityToken();
        }
        catch (Exception exception) {
            securityToken = this.clientCtx.getSecurityToken();
        }
        if (securityToken != null && this.admsvr != null) {
            try {
                this.admsvr.close(securityToken);
            }
            catch (RemoteException remoteException) {
                AdminCommonTools.CMN_Trace1("Session close: remote exception: " + remoteException.getMessage());
                throw new AdminClientException("EXM_REC", remoteException);
            }
            catch (AdminException adminException) {
                this.clearSecurityContext();
                throw adminException;
            }
            AdminCommonTools.CMN_Trace1("Session close: session closed");
        }
        this.clearSecurityContext();
    }

    public void reset(AdminClientInfo adminClientInfo, AdminUserContext adminUserContext, AdminMgmtScope adminMgmtScope) throws AdminException {
        if (this.isConnected()) {
            throw new ConnectionExistsException(this.hostname);
        }
        if (adminClientInfo != null) {
            this.clientSec = adminClientInfo;
        }
        if (adminUserContext != null) {
            this.userCtx = adminUserContext;
        }
        if (adminMgmtScope != null) {
            this.scope = adminMgmtScope;
        }
        this.initSecurityContext(this.userCtx);
    }

    public AdminFactory getAppFactory(String string) throws AdminException {
        AdminFactory adminFactory = null;
        SecurityToken securityToken = null;
        try {
            Object[] objectArray = new Object[]{string};
            securityToken = this.getSecurityToken(objectArray);
            adminFactory = this.admsvr.getAppFactory((VerifierSecurityToken)securityToken, string);
        }
        catch (RemoteException remoteException) {
            AdminCommonTools.CMN_Trace1("Session: remote exception getting application factory: " + remoteException.getMessage());
            throw new AdminClientException("EXM_REF", remoteException);
        }
        return adminFactory;
    }

    public void closeAppFactory(String string) throws AdminException {
        SecurityToken securityToken = null;
        try {
            Object[] objectArray = new Object[]{string};
            securityToken = this.getSecurityToken(objectArray);
            this.admsvr.closeAppFactory((VerifierSecurityToken)securityToken, string);
            return;
        }
        catch (RemoteException remoteException) {
            AdminCommonTools.CMN_Trace1("Session: remote exception closing application factory: " + remoteException.getMessage());
            throw new AdminClientException("EXM_REF", remoteException);
        }
    }

    public Vector getUserRights() throws AdminException {
        SecurityToken securityToken = null;
        Vector vector = null;
        try {
            securityToken = this.getSecurityToken();
            vector = this.admsvr.getUserRights((VerifierSecurityToken)securityToken);
        }
        catch (RemoteException remoteException) {
            AdminCommonTools.CMN_Trace1("Session: remote exception getting user rights: " + remoteException.getMessage());
            throw new AdminClientException("EXM_REF", remoteException);
        }
        return vector;
    }

    public SecurityPolicyObj getSecurityPolicy() throws AdminException {
        SecurityToken securityToken = null;
        SecurityPolicyObj securityPolicyObj = null;
        try {
            securityToken = this.getSecurityToken();
            securityPolicyObj = this.admsvr.getSecurityPolicy((VerifierSecurityToken)securityToken);
        }
        catch (RemoteException remoteException) {
            AdminCommonTools.CMN_Trace1("Session: remote exception getting security policy: " + remoteException.getMessage());
            throw new AdminClientException("EXM_REF", remoteException);
        }
        return securityPolicyObj;
    }

    public void setSecurityPolicy(SecurityPolicyObj securityPolicyObj) throws AdminException {
        SecurityToken securityToken = null;
        try {
            Object[] objectArray = new Object[]{securityPolicyObj};
            securityToken = this.getSecurityToken(objectArray);
            this.admsvr.setSecurityPolicy((VerifierSecurityToken)securityToken, securityPolicyObj);
            return;
        }
        catch (RemoteException remoteException) {
            AdminCommonTools.CMN_Trace1("Session: remote exception setting security policy: " + remoteException.getMessage());
            throw new AdminClientException("EXM_REF", remoteException);
        }
    }

    public void writeLogRecord(String string, int n, String string2, String string3, String[] stringArray) throws AdminException {
        Vector<String> vector = null;
        if (stringArray != null && stringArray.length > 0) {
            vector = new Vector<String>(stringArray.length);
            int n2 = 0;
            while (n2 < stringArray.length) {
                vector.addElement(stringArray[n2]);
                ++n2;
            }
        }
        LogRecord logRecord = new LogRecord(string, 0, n, this.getUserName(), this.getClientHostName(), this.getServerHostName(), string2, string3, vector, this.getMgmtScope());
        this.writeLogRecord(logRecord);
    }

    public void writeLogRecord(LogRecord logRecord) throws AdminException {
        SecurityToken securityToken = null;
        try {
            securityToken = this.getSecurityToken();
            this.admsvr.writeLogRecord((VerifierSecurityToken)securityToken, logRecord);
            return;
        }
        catch (RemoteException remoteException) {
            AdminCommonTools.CMN_Trace1("Session: remote exception writing log record: " + remoteException.getMessage());
            throw new AdminClientException("EXM_REF", remoteException);
        }
    }

    public boolean isConnected() {
        return this.clientCtx.getAuthState() == 4;
    }

    public SecurityToken getSecurityToken() throws AdminException {
        Object[] objectArray = null;
        return this.clientCtx.generateVerifier(objectArray);
    }

    public SecurityToken getSecurityToken(Object[] objectArray) throws AdminException {
        return this.clientCtx.generateVerifier(objectArray);
    }

    public ClientSecurityContext getSecurityContext() throws AdminException {
        return this.clientCtx;
    }

    public boolean isVerify() {
        boolean bl = false;
        if (this.clientCtx != null && this.clientCtx.getAuthType() == 1) {
            DigestClientSecurityContext digestClientSecurityContext = (DigestClientSecurityContext)this.clientCtx;
            bl = digestClientSecurityContext.isIntegrityRequired();
        }
        return bl;
    }

    public String getServerHostName() {
        return this.hostname;
    }

    public int getServerPort() {
        return this.portnum;
    }

    public String getServerRemoteName() {
        return this.admsvrname;
    }

    public AdminServer getServerHandle() throws AdminException {
        if (!this.isConnected()) {
            throw new AdminClientException("EXM_NCC");
        }
        return this.admsvr;
    }

    public AdminUserContext getUserContext() {
        return this.userCtx;
    }

    public AdminMgmtScope getMgmtScope() {
        return this.scope;
    }

    public AdminPrincipal getAdminPrincipal() throws AdminException {
        return new AdminPrincipal(this.userCtx.getUserType(), this.userCtx.getUserName(), this.scope.getMgmtScopeType(), this.scope.getMgmtDomainName());
    }

    public String getClientHostName() {
        return this.clientSec.getClientHostName();
    }

    public String getUserName() {
        return this.userCtx.getUserName();
    }

    private void initSecurityContext(AdminUserContext adminUserContext) throws AdminException {
        ClientSecurityContext clientSecurityContext = this.clientSec.getSecurityContext();
        this.clientCtx = clientSecurityContext.newCopy();
        this.clientCtx.setSecurityId(null);
        this.clientCtx.setAdminPrincipal(this.getAdminPrincipal());
        this.clientCtx.setUserPassword(adminUserContext.getUserPassword());
    }

    private void clearSecurityContext() {
        this.clientCtx.reset();
        this.admsvr = null;
    }
}

