/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.util;

import com.sun.prodreg.event.Subprocess;
import com.sun.prodreg.util.ExecuteCommand;
import com.sun.prodreg.util.JarLoader;
import com.sun.prodreg.util.Localizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;

public class TypedSystemSubprocess
extends Subprocess
implements Runnable {
    private String program_dir;
    private String jarMainClass = null;
    public static boolean debug = false;
    public static final int OPTION_JAR_MAINCLASS = 0;
    private String program;
    public static final int TYPE_JAR = 0;
    public static final int TYPE_CLASS = 1;
    public static final int TYPE_NATIVE = 2;
    public static final int MAX_LOG_LENGTH = 100;
    public static final int NOT_COMPLETE = -20;
    private int returnCode = -20;
    private int type = 2;

    public TypedSystemSubprocess(String string, String string2) {
        this(string, string2, 2);
        this.type = string2.endsWith(".jar") ? 0 : (string2.endsWith(".class") ? 1 : 2);
    }

    public TypedSystemSubprocess(String string, String string2, int n) {
        this.program_dir = string;
        this.program = string2;
        this.type = n;
    }

    public static String convertToString(String[] stringArray) {
        if (stringArray == null) {
            return "null";
        }
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            string = n == 0 ? String.valueOf(string) + stringArray[n] + " " : String.valueOf(string) + "'" + stringArray[n] + "' ";
            ++n;
        }
        return string.trim();
    }

    public static String escape(char c, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == c) {
                stringBuffer.insert(n, '\\');
                n += 2;
                continue;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public int getResult() {
        return this.returnCode;
    }

    public void run() {
        switch (this.type) {
            case 1: {
                this.runJavaClass(this.program_dir, this.program);
                break;
            }
            case 0: {
                this.runJarFile(this.program_dir, this.program, this.jarMainClass);
                break;
            }
            case 2: {
                this.runNativeProgram(String.valueOf(this.program_dir) + File.separator + this.program);
                break;
            }
            default: {
                throw new IllegalStateException("Program Runner: invalid type:" + this.type);
            }
        }
    }

    private void runJarFile(String string, String string2, String string3) {
        String string4 = String.valueOf(string) + File.separator + string2;
        try {
            String[] stringArray = new String[]{};
            new JarLoader(string4, string3, stringArray);
        }
        catch (Exception exception) {
            this.returnCode = -1;
            this.notifyListeners(-1, String.valueOf(string4) + "::" + string3, Localizer.resolve("<L ProdRegResources.JarError>:" + exception.toString()));
        }
    }

    private void runJavaClass(String string, String string2) {
        string2 = string2.substring(0, string2.length() - ".class".length());
        String string3 = "cd " + string + "; " + System.getProperty("java.home") + "/bin/java " + string2;
        this.runNativeProgram(string3);
    }

    private void runNativeProgram(String string) {
        boolean bl = true;
        String string2 = "";
        try {
            Object[] objectArray;
            String string3;
            while (new File(string3 = "/tmp/prodreg.runlog." + Math.random()).exists()) {
            }
            String string4 = "/tmp/prodreg.returnlog." + Math.random();
            while (new File(string4 = "/tmp/prodreg.returnlog." + Math.random()).exists()) {
            }
            if (debug) {
                System.out.println("TypedSystemSubprocess: log: " + string3 + " return log:" + string4);
            }
            String string5 = String.valueOf(System.getProperty("prodreg.home")) + "/bin/exitwrapper '" + string + "'" + " " + string4 + " ; sleep 2";
            String[] stringArray = new String[]{"/usr/dt/bin/dtterm", "-l", "-lf", string3, "-e", "/usr/bin/ksh", "-c", string5};
            if (debug) {
                System.out.println("TypedSystemSubprocess: -->" + ExecuteCommand.expandCommand(stringArray) + "<--");
            }
            ExecuteCommand executeCommand = new ExecuteCommand(stringArray);
            executeCommand.setLogFiles(new String[]{string3});
            executeCommand.execute();
            FileInputStream fileInputStream = new FileInputStream(string3);
            byte[] byArray = new byte[1024];
            int n = 1;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while ((n = fileInputStream.read(byArray)) > 0) {
                if (++n2 < 100) {
                    stringBuffer.append(new String(byArray));
                    continue;
                }
                if (!bl) continue;
                bl = false;
                objectArray = new String[]{string3};
                stringBuffer.append(Localizer.resolve("<L ProdRegResources.MoreLogInfo>: ", objectArray));
            }
            fileInputStream.close();
            if (debug) {
                System.out.println("Subprocess done: reading result from " + string4);
            }
            objectArray = new BufferedReader(new FileReader(string4));
            String string6 = objectArray.readLine();
            Integer n3 = new Integer(string6);
            int n4 = n3;
            objectArray.close();
            new File(string4).delete();
            if (bl) {
                new File(string3).delete();
            }
            this.returnCode = n4;
            string2 = stringBuffer.toString();
            if (debug) {
                System.out.println("Subprocess done: result: " + this.returnCode + " read from " + string4);
            }
        }
        catch (Exception exception) {
            if (debug) {
                System.out.println("Subprocess done: FAILED reading result:" + exception.toString());
                exception.printStackTrace();
            }
            this.returnCode = -1;
            string2 = Localizer.resolve("<L ProdRegResources.ProcessError>:" + exception.toString());
        }
        this.notifyListeners(this.returnCode, string, string2);
    }

    public void setOption(int n, String string) {
        if (false) {
            this.jarMainClass = string;
        }
    }
}

