/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

public class RelativeLayout
implements LayoutManager {
    private double[] relativeSizes;
    public static final int HORIZONTAL_LAYOUT = 0;
    public static final int VERTICAL_LAYOUT = 1;
    private int type = 0;

    public RelativeLayout(double[] dArray) {
        this(dArray, 0);
    }

    public RelativeLayout(double[] dArray, int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("RelativeLayout: invalid type:" + n);
        }
        this.relativeSizes = dArray;
        this.type = n;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        Component[] componentArray = container.getComponents();
        int[] nArray = new int[componentArray.length];
        int n = 0;
        while (n < nArray.length) {
            switch (this.type) {
                case 0: {
                    nArray[n] = (int)Math.round((double)dimension.width * this.relativeSizes[n]);
                    break;
                }
                case 1: {
                    nArray[n] = (int)Math.round((double)dimension.height * this.relativeSizes[n]);
                    break;
                }
                default: {
                    throw new IllegalStateException("RelativeLayout: type invalid during layout: " + this.type);
                }
            }
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            Component component = componentArray[n3];
            switch (this.type) {
                case 0: {
                    component.setBounds(n2, 0, nArray[n3], dimension.height);
                    break;
                }
                case 1: {
                    component.setBounds(0, n2, dimension.width, nArray[n3]);
                    break;
                }
                default: {
                    throw new IllegalStateException("RelativeLayout: type invalid during layout: " + this.type);
                }
            }
            n2 += nArray[n3];
            ++n3;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension preferredLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        Component[] componentArray = container.getComponents();
        int n3 = 0;
        while (n3 < componentArray.length) {
            Dimension dimension = componentArray[n3].getPreferredSize();
            switch (this.type) {
                case 0: {
                    n += dimension.width;
                    if (dimension.height <= n2) break;
                    n2 = dimension.height;
                    break;
                }
                case 1: {
                    n2 += dimension.height;
                    if (dimension.width <= n) break;
                    n = dimension.width;
                    break;
                }
                default: {
                    throw new IllegalStateException("RelativeLayout: type invalid during preferredSize calculation: " + this.type);
                }
            }
            ++n3;
        }
        return new Dimension(n, n2);
    }

    public void removeLayoutComponent(Component component) {
    }
}

