/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.awt;

import com.sun.prodreg.awt.InsetsPanel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;

public class ImagePanel
extends InsetsPanel {
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int TOP = 1;
    public static final int BOTTOM = 3;
    protected Image image = null;
    protected int hAlign = 2;
    protected int vAlign = 2;
    protected boolean loaded = false;

    public ImagePanel() {
    }

    public ImagePanel(int n, int n2) {
        this.hAlign = n;
        this.vAlign = n2;
    }

    public ImagePanel(Insets insets) {
        super(insets);
    }

    public ImagePanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(0, 0);
        if (this.image != null) {
            dimension.width = this.image.getWidth(this);
            dimension.height = this.image.getHeight(this);
        }
        return dimension;
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) != 0) {
            this.loaded = true;
            this.repaint();
            return false;
        }
        return true;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.loaded) {
            int n = 0;
            int n2 = 0;
            int n3 = this.image.getWidth(this);
            int n4 = this.image.getHeight(this);
            Dimension dimension = this.getSize();
            graphics.setClip(0, 0, dimension.width, dimension.height);
            switch (this.hAlign) {
                case 1: {
                    n = this.insets.left;
                    break;
                }
                case 2: {
                    n = (dimension.width - (this.insets.left + this.insets.right) - n3) / 2 + this.insets.left;
                    break;
                }
                case 3: {
                    n = dimension.width - n3 - this.insets.right;
                    break;
                }
            }
            switch (this.vAlign) {
                case 1: {
                    n2 = this.insets.top;
                    break;
                }
                case 2: {
                    n2 = (dimension.height - (this.insets.top + this.insets.bottom) - n4) / 2 + this.insets.top;
                    break;
                }
                case 3: {
                    n2 = dimension.height - n4 - this.insets.bottom;
                    break;
                }
            }
            graphics.drawImage(this.image, n, n2, this);
        }
    }

    public void setAlignment(int n, int n2) {
        this.hAlign = n;
        this.vAlign = n2;
    }

    public void setImage(Image image) {
        this.loaded = false;
        this.image = image;
        this.prepareImage(image, this);
    }
}

