/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scm.admin.server.syslog;

import com.sun.scm.admin.server.syslog.SCMSyslogAdmin;
import com.sun.scm.admin.server.syslog.SCMSyslogAdminI;
import com.sun.scm.admin.server.syslog.SCMSyslogBuffer;
import com.sun.scm.admin.server.syslog.SCMSyslogBufferI;
import com.sun.scm.admin.server.syslog.SCMSyslogLoaderI;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class SCMSyslogLoader
extends UnicastRemoteObject
implements SCMSyslogLoaderI,
Serializable {
    protected static String syslogFile_ = "/var/adm/messages";
    protected String currentFile_ = syslogFile_;
    protected static final int SECTIONSIZE = 20;
    protected static final int LINELENGTH = 80;
    protected static final int BUFFERSIZE = 1600;
    protected static SCMSyslogBufferI syslog_buffer_ = null;
    protected static SCMSyslogAdminI hsai_;
    protected static int MAXFILES;
    protected static String[] filesArray;
    protected static long lastRead_;
    protected static long last_messages_size_;
    protected long begin_;
    protected long end_;
    protected long oldend_;
    protected static int index_;
    protected static boolean reachedEnd_;
    protected static boolean reachedBegin_;
    protected static boolean done;
    protected int filei_;
    protected RandomAccessFile prev;
    protected boolean firstTime_ = true;
    protected boolean debug = true;

    public SCMSyslogLoader(SCMSyslogAdmin sCMSyslogAdmin) throws RemoteException {
        hsai_ = sCMSyslogAdmin;
        int n = 0;
        while (n < MAXFILES) {
            SCMSyslogLoader.filesArray[n] = n == 0 ? new String(syslogFile_) : new String(String.valueOf(syslogFile_) + "." + (n - 1));
            ++n;
        }
        this.initialize();
    }

    public synchronized SCMSyslogBufferI getSCMSyslogBuffer() throws RemoteException {
        return syslog_buffer_;
    }

    public synchronized void initialize() throws RemoteException {
        System.out.println("In initialize:syslogLoader");
        try {
            syslog_buffer_ = new SCMSyslogBuffer(this.updateBuffer());
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("SCMSyslogLoader.initialize- Error finding " + filesArray[0] + "   " + fileNotFoundException.getMessage());
            return;
        }
    }

    public synchronized SCMSyslogAdminI getSCMSyslogAdmin() throws RemoteException {
        return hsai_;
    }

    public synchronized boolean reachedEnd() throws RemoteException {
        return reachedEnd_;
    }

    public synchronized boolean reachedBegin() throws RemoteException {
        return reachedBegin_;
    }

    public synchronized SCMSyslogBufferI readNext() throws RemoteException {
        syslog_buffer_ = null;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(filesArray[this.filei_], "r");
            syslog_buffer_ = this.readBufferNext(randomAccessFile, this.end_);
            long l = randomAccessFile.length() - 1L;
            if (this.filei_ == 0 && this.end_ == l) {
                reachedEnd_ = true;
                reachedBegin_ = false;
            }
            randomAccessFile.close();
            if (this.debug) {
                System.out.println("readNext(): end_ " + this.end_ + "  filei_: " + this.filei_);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("SCMSyslogLoader.readNext - Error finding " + filesArray[this.filei_] + " " + fileNotFoundException.getMessage());
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("SCMSyslogLoader.readNext -Error opening " + filesArray[this.filei_]);
        }
        return syslog_buffer_;
    }

    public synchronized SCMSyslogBufferI readPrevious() throws RemoteException {
        syslog_buffer_ = null;
        try {
            reachedEnd_ = false;
            RandomAccessFile randomAccessFile = new RandomAccessFile(filesArray[this.filei_], "r");
            if (this.debug) {
                System.out.println("\n filei_: " + this.filei_ + "\n begin_" + this.begin_);
            }
            syslog_buffer_ = this.readBufferPrevious(randomAccessFile, this.begin_);
            randomAccessFile.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("SCMSyslogLoader.readPrevious - Error finding " + filesArray[this.filei_]);
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("SCMSyslogLoader.readPrevious -Error opening " + filesArray[this.filei_]);
            iOException.printStackTrace();
        }
        return syslog_buffer_;
    }

    public synchronized SCMSyslogBufferI updateBuffer() throws FileNotFoundException, RemoteException {
        this.filei_ = 0;
        try {
            this.currentFile_ = filesArray[this.filei_];
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.currentFile_, "r");
            reachedEnd_ = true;
            reachedBegin_ = false;
            syslog_buffer_ = new SCMSyslogBuffer(this.readBufferPrevious(randomAccessFile, randomAccessFile.length()));
            randomAccessFile.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("SCMSyslogLoader.updateBuffer - Error finding " + filesArray[this.filei_]);
            throw new FileNotFoundException();
        }
        catch (IOException iOException) {
            System.out.println("SCMSyslogLoader.updateBuffer -Error opening " + filesArray[this.filei_]);
            iOException.printStackTrace();
        }
        return syslog_buffer_;
    }

    private byte[] fillRest(RandomAccessFile randomAccessFile) {
        byte[] byArray = null;
        try {
            this.begin_ = 0L;
            if (randomAccessFile.length() > 0L) {
                randomAccessFile.seek(this.begin_);
                byArray = new byte[(int)this.end_ - 1];
                randomAccessFile.read(byArray);
                this.oldend_ = this.end_;
                this.end_ = randomAccessFile.getFilePointer();
                done = this.end_ == this.oldend_ && this.filei_ == MAXFILES;
            } else {
                this.end_ = 0L;
                byArray = new byte[]{};
            }
        }
        catch (IOException iOException) {
            System.out.println("SCMSyslogLoader.fillRest -Error reading ");
        }
        return byArray;
    }

    private byte[] fillRestNext(RandomAccessFile randomAccessFile, int n) {
        byte[] byArray = null;
        try {
            randomAccessFile.seek(this.begin_);
            this.end_ = randomAccessFile.length();
            byArray = new byte[(int)randomAccessFile.length() - (int)this.begin_];
            randomAccessFile.read(byArray);
        }
        catch (IOException iOException) {
            System.out.println("SCMSyslogLoader.fillRestNext -Error reading ");
        }
        return byArray;
    }

    private byte[] fillNormalNext(RandomAccessFile randomAccessFile, int n) {
        byte[] byArray = null;
        try {
            randomAccessFile.seek(this.begin_);
            int n2 = n;
            byArray = new byte[n2];
            randomAccessFile.read(byArray);
            this.end_ = randomAccessFile.getFilePointer();
        }
        catch (IOException iOException) {
            System.out.println("SCMSyslogLoader.fillNormalNext -Error reading ");
        }
        return byArray;
    }

    private byte[] fillNormal(RandomAccessFile randomAccessFile, int n) {
        byte[] byArray = null;
        try {
            randomAccessFile.seek(this.begin_);
            String string = randomAccessFile.readLine();
            this.begin_ = randomAccessFile.getFilePointer();
            int n2 = string != null ? 1600 - string.length() - n - 1 : 1599;
            byArray = new byte[n2];
            if (this.debug) {
                System.out.println(" in readBffer will try reading" + n2);
            }
            int n3 = randomAccessFile.read(byArray);
            this.end_ = randomAccessFile.getFilePointer();
            if (this.debug) {
                System.out.println("fillNormal():countbytes: " + n3 + " end_:" + this.end_ + " begin_:" + this.begin_);
            }
        }
        catch (IOException iOException) {
            System.out.println("SCMSyslogLoader.fillNormal -Error reading ");
        }
        return byArray;
    }

    private SCMSyslogBufferI setBuffer(RandomAccessFile randomAccessFile, byte[] byArray, boolean bl, boolean bl2) {
        SCMSyslogBuffer sCMSyslogBuffer = null;
        try {
            String string = new String(byArray);
            StringBuffer stringBuffer = new StringBuffer(string);
            sCMSyslogBuffer = new SCMSyslogBuffer(stringBuffer);
            int n = sCMSyslogBuffer.getLines();
            if (bl && !done) {
                this.begin_ = this.end_;
                SCMSyslogBufferI sCMSyslogBufferI = bl2 && !done ? this.readPreviousFile(n) : this.readBufferPrevious(randomAccessFile, this.end_);
                if (sCMSyslogBufferI != null) {
                    sCMSyslogBuffer.preappend(sCMSyslogBufferI.getText());
                }
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("SCMSyslogLoader.setBuffer - " + remoteException.getMessage());
            remoteException.printStackTrace();
        }
        return sCMSyslogBuffer;
    }

    private SCMSyslogBufferI setBufferNext(RandomAccessFile randomAccessFile, byte[] byArray, boolean bl, int n) {
        SCMSyslogBuffer sCMSyslogBuffer = null;
        try {
            String string = new String(byArray);
            StringBuffer stringBuffer = new StringBuffer(string);
            sCMSyslogBuffer = new SCMSyslogBuffer(stringBuffer);
            sCMSyslogBuffer.getLines();
            int n2 = sCMSyslogBuffer.trim();
            if (n2 > 0) {
                this.end_ -= (long)n2;
                randomAccessFile.seek(this.end_);
            }
            if (bl && this.filei_ != 0) {
                SCMSyslogBufferI sCMSyslogBufferI = this.readNextFile(n);
                sCMSyslogBuffer.append(sCMSyslogBufferI.getText());
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("SCMSyslogLoader.setBufferNext - " + remoteException.getMessage());
            remoteException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("SCMSyslogLoader.setBufferNext - " + iOException.getMessage());
            iOException.printStackTrace();
        }
        return sCMSyslogBuffer;
    }

    private SCMSyslogBufferI readBufferPrevious(RandomAccessFile randomAccessFile, long l) {
        SCMSyslogBufferI sCMSyslogBufferI = null;
        new StringBuffer();
        boolean bl = false;
        byte[] byArray = null;
        this.end_ = l;
        int n = (int)l - 1600;
        if (this.debug) {
            System.out.println("pos:" + n + " end_:" + this.end_ + " filei:" + this.filei_);
        }
        if (n < 0) {
            bl = true;
            byArray = this.fillRest(randomAccessFile);
        } else {
            this.begin_ = n;
            byArray = this.fillNormal(randomAccessFile, 0);
        }
        sCMSyslogBufferI = this.setBuffer(randomAccessFile, byArray, bl, bl);
        return sCMSyslogBufferI;
    }

    private SCMSyslogBufferI readBufferNext(RandomAccessFile randomAccessFile, long l) {
        boolean bl = false;
        int n = 0;
        try {
            byte[] byArray;
            this.begin_ = l;
            int n2 = (int)this.begin_ + 1600;
            if ((long)n2 > randomAccessFile.length()) {
                bl = true;
                n = n2 - (int)randomAccessFile.length();
                byArray = this.fillRestNext(randomAccessFile, n2);
            } else {
                byArray = this.fillNormalNext(randomAccessFile, 1600);
            }
            syslog_buffer_ = this.setBufferNext(randomAccessFile, byArray, bl, n);
        }
        catch (IOException iOException) {
            System.out.println("SCMSyslogLoader.readBufferNext -Error reading ");
            iOException.printStackTrace();
        }
        return syslog_buffer_;
    }

    protected SCMSyslogBufferI readPreviousFile(int n) throws RemoteException {
        boolean bl = false;
        SCMSyslogBufferI sCMSyslogBufferI = new SCMSyslogBuffer();
        byte[] byArray = null;
        boolean bl2 = false;
        try {
            if (this.filei_ < MAXFILES) {
                ++this.filei_;
                this.currentFile_ = filesArray[this.filei_];
                bl2 = true;
                reachedBegin_ = false;
            } else {
                reachedBegin_ = true;
            }
            this.prev = new RandomAccessFile(this.currentFile_, "r");
            if (bl2) {
                this.end_ = this.prev.length();
            }
            if (this.debug) {
                System.out.println(" file reading :" + this.currentFile_ + " end_: " + this.end_ + "\n  lines: " + n);
            }
            int n2 = n * 80;
            long l = this.end_ != 0L ? this.end_ - (long)(1600 - n2) : 0L;
            if (n2 < 1600) {
                if (this.debug) {
                    System.out.println("inBuffer :" + n2 + " pos: " + l);
                }
                if (l <= 0L) {
                    this.firstTime_ = false;
                    bl = true;
                    byArray = this.fillRest(this.prev);
                } else {
                    this.begin_ = l;
                    byArray = this.fillNormal(this.prev, n2);
                }
                sCMSyslogBufferI = this.setBuffer(this.prev, byArray, bl, this.firstTime_);
            } else {
                done = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            MAXFILES = this.filei_ - 1;
            --this.filei_;
            this.currentFile_ = filesArray[this.filei_];
            reachedBegin_ = true;
            System.out.println("SCMSyslogLoader.readPreviousFile MAXFILES for next time" + MAXFILES);
            iOException.printStackTrace();
        }
        return sCMSyslogBufferI;
    }

    protected SCMSyslogBufferI readNextFile(long l) throws RemoteException {
        boolean bl = false;
        SCMSyslogBufferI sCMSyslogBufferI = null;
        this.currentFile_ = this.filei_ > 0 ? filesArray[this.filei_--] : filesArray[0];
        try {
            byte[] byArray;
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.currentFile_, "r");
            this.begin_ = 0L;
            if (l > randomAccessFile.length()) {
                bl = true;
                l = (int)l - (int)this.end_;
                byArray = this.fillRestNext(randomAccessFile, (int)l);
            } else {
                byArray = this.fillNormalNext(randomAccessFile, (int)l);
            }
            sCMSyslogBufferI = this.setBufferNext(randomAccessFile, byArray, bl, (int)l);
            if (sCMSyslogBufferI.getText().length() == 0 && this.filei_ == 0) {
                sCMSyslogBufferI = this.updateBuffer();
            }
        }
        catch (IOException iOException) {
            System.out.println("SCMSyslogLoader.readNextFile -Error reading ");
            iOException.printStackTrace();
        }
        return sCMSyslogBufferI;
    }

    public synchronized boolean differentLastRead() {
        StringBuffer stringBuffer = null;
        boolean bl = false;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(filesArray[0], "r");
            if (last_messages_size_ != randomAccessFile.length()) {
                stringBuffer = this.getNewBuffer(last_messages_size_);
                this.end_ = randomAccessFile.length();
                last_messages_size_ = randomAccessFile.length();
                bl = true;
            }
            randomAccessFile.close();
        }
        catch (RemoteException remoteException) {
            System.out.println("SCMSyslogLoader.differentLastRead - " + remoteException.getMessage());
            remoteException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("SCMSyslogLoader.readNextFile - " + iOException.getMessage());
            iOException.printStackTrace();
        }
        return bl;
    }

    public synchronized StringBuffer getNewBuffer(long l) {
        StringBuffer stringBuffer = null;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(filesArray[0], "r");
            randomAccessFile.seek(l);
            int n = (int)randomAccessFile.length() - (int)l;
            byte[] byArray = new byte[n];
            randomAccessFile.read(byArray);
            String string = new String(byArray);
            stringBuffer = new StringBuffer(string);
            randomAccessFile.close();
        }
        catch (RemoteException remoteException) {
            System.out.println("SCMSyslogLoader.getNewBuffer - " + remoteException.getMessage());
            remoteException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("SCMSyslogLoader.getNewBuffer - " + iOException.getMessage());
            iOException.printStackTrace();
        }
        return stringBuffer;
    }

    public boolean moreData(String string) throws RemoteException {
        String string2 = "Previous";
        String string3 = "Next";
        if (string.equals(string3)) {
            return reachedEnd_;
        }
        if (string.equals(string2)) {
            return reachedBegin_;
        }
        return true;
    }

    static {
        MAXFILES = 9;
        filesArray = new String[MAXFILES];
        reachedEnd_ = true;
    }
}

