/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scm.admin.server.event;

import com.sun.scm.admin.server.event.EventMapKey;
import com.sun.scm.admin.server.event.EventMapRecord;
import com.sun.scm.admin.util.EVENT_TYPE;
import com.sun.scm.admin.util.OBJECT_STATE;
import com.sun.scm.admin.util.OBJECT_TYPE;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class EventMapTable {
    private int nInitialCapacity = 150;
    private float fLoadFactor = 0.75f;
    private Hashtable lEventMaps = new Hashtable(this.nInitialCapacity, this.fLoadFactor);
    private String sEventMapFile;
    private BufferedReader hEventMapData;

    public EventMapTable() {
        try {
            this.sEventMapFile = "/opt/SUNWcluster/scmgr/lib/eventmap.dat";
            this.hEventMapData = new BufferedReader(new FileReader(this.sEventMapFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("SCM:: EventMapTable.EventMapTable - can't open eventmap file");
            fileNotFoundException.printStackTrace();
            System.out.println("SCM:: EventMapTable.EventMapTable - exit program");
            System.exit(-1);
        }
        if (this.hEventMapData != null) {
            while (true) {
                String string = null;
                try {
                    string = this.hEventMapData.readLine();
                }
                catch (IOException iOException) {
                    System.out.println("SCM:: EventMapTable.EventMapTable - can't read eventmap file");
                    iOException.printStackTrace();
                    System.out.println("SCM:: EventMapTable.EventMapTable - exit program");
                    System.exit(-1);
                }
                if (string == null) break;
                if (string.trim().length() == 0 || string.trim().charAt(0) == '#') continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                String string2 = stringTokenizer.nextToken();
                Integer n = new Integer(stringTokenizer.nextToken());
                EventMapKey eventMapKey = new EventMapKey(string2, n);
                Integer n2 = new Integer(stringTokenizer.nextToken());
                EVENT_TYPE eVENT_TYPE = EVENT_TYPE.get(n2);
                Integer n3 = new Integer(stringTokenizer.nextToken());
                OBJECT_TYPE oBJECT_TYPE = OBJECT_TYPE.get(n3);
                Integer n4 = new Integer(stringTokenizer.nextToken());
                OBJECT_STATE oBJECT_STATE = OBJECT_STATE.get(n4);
                String string3 = stringTokenizer.nextToken();
                boolean bl = false;
                if (string3.equals("true")) {
                    bl = true;
                }
                String string4 = stringTokenizer.nextToken();
                EventMapRecord eventMapRecord = new EventMapRecord(eventMapKey, eVENT_TYPE, oBJECT_TYPE, oBJECT_STATE, string4, bl);
                this.put(eventMapKey, eventMapRecord);
            }
        }
    }

    public EventMapRecord get(EventMapKey eventMapKey) {
        EventMapRecord eventMapRecord = (EventMapRecord)this.lEventMaps.get(eventMapKey);
        return eventMapRecord;
    }

    private void put(EventMapKey eventMapKey, EventMapRecord eventMapRecord) {
        this.lEventMaps.put(eventMapKey, eventMapRecord);
    }
}

