/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scm.admin.server.event;

import com.sun.scm.admin.server.event.Connection;
import com.sun.scm.admin.server.event.EventQueue;
import com.sun.scm.admin.server.util.SCMRegistry;
import com.sun.scm.admin.server.util.SCMResourceI;
import com.sun.scm.admin.util.OBJECT_TYPE;
import com.sun.scm.admin.util.SCMEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

class EventManager
extends Thread {
    private EventQueue hEventQueue;
    private SCMRegistry hSCMRegistry;
    private String sHost;
    private Vector lConnections;
    private static int nBroadcastEventCount;
    private static int nForwardEventCount;

    public EventManager(String string, EventQueue eventQueue, SCMRegistry sCMRegistry) {
        this.hEventQueue = eventQueue;
        this.hSCMRegistry = sCMRegistry;
        this.sHost = string;
    }

    private Vector getConnections() {
        Vector<Connection> vector = new Vector<Connection>();
        try {
            Vector vector2 = this.hSCMRegistry.getResources(OBJECT_TYPE.CNODE);
            if (vector2 == null) {
                return vector;
            }
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                SCMResourceI sCMResourceI = (SCMResourceI)enumeration.nextElement();
                if (sCMResourceI.getName().equals(this.sHost)) continue;
                Connection connection = new Connection(sCMResourceI, this.hSCMRegistry);
                vector.addElement(connection);
                Thread thread = new Thread(connection);
                thread.start();
            }
        }
        catch (Exception exception) {
            System.out.println("SCM:: EventManager.getConnections - Can't get cluster nodes");
            exception.printStackTrace();
            System.out.println("SCM:: EventManager.getConnections - exit program");
            System.exit(-1);
        }
        return vector;
    }

    public void run() {
        this.lConnections = this.getConnections();
        while (true) {
            Connection connection = null;
            SCMEvent sCMEvent = null;
            System.out.println("SCM:: EventManager.run - get event from queue");
            sCMEvent = this.hEventQueue.get();
            if (sCMEvent != null) {
                ++nBroadcastEventCount;
                try {
                    System.out.println("SCM:: EventManager.forwardEvent - forwarding event #" + nBroadcastEventCount + " to SCMRegistry");
                    this.hSCMRegistry.dispatchEvent(sCMEvent);
                }
                catch (RemoteException remoteException) {
                    System.out.println("SCM:: EventManager.forwardEvent - can't forward event to SCMRegistry");
                    remoteException.printStackTrace();
                }
                if (sCMEvent.broadcast) {
                    sCMEvent.broadcast = false;
                    Enumeration enumeration = this.lConnections.elements();
                    while (enumeration.hasMoreElements()) {
                        connection = (Connection)enumeration.nextElement();
                        connection.forwardEvent(sCMEvent);
                    }
                }
            }
            Thread.yield();
        }
    }
}

