/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scm.admin.server.event;

import com.sun.scm.admin.server.event.EventManager;
import com.sun.scm.admin.server.event.EventObserverImpl;
import com.sun.scm.admin.server.event.EventQueue;
import com.sun.scm.admin.server.event.SyslogManager;
import com.sun.scm.admin.server.util.SCMRegistry;
import com.sun.scm.admin.util.REGISTRY_NAME;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.AlreadyBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;

public class EventDispatcher
implements Runnable {
    EventQueue hEventQueue;
    SCMRegistry hSCMRegistry;
    String sHost;

    public EventDispatcher(SCMRegistry sCMRegistry) {
        this.hSCMRegistry = sCMRegistry;
        this.hEventQueue = new EventQueue();
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("SCM:: EventDispatcher.EventDispatcher - can't get local hostname - ");
            unknownHostException.printStackTrace();
            System.out.println("SCM:: EventDispatcher.EventDispatcher - exit program");
            System.exit(-1);
        }
        String string = System.getProperty("EVENT_SIMULATOR");
        boolean bl = false;
        if (string != null && string.equals("ON")) {
            System.out.println("SCM:: EventDispatcher.EventDispatcher - EVENT_SIMULATOR is ON");
            bl = true;
        }
        this.sHost = bl ? "phys-john" : inetAddress.getHostName();
        System.out.println("SCM:: EventDispatcher.EventDispatcher - local host= " + this.sHost);
    }

    public void run() {
        Object object;
        Object object2;
        try {
            object2 = this.hSCMRegistry.getRegistry();
            object = new EventObserverImpl(this.sHost, this.hEventQueue);
            object2.bind(REGISTRY_NAME.ED_NAME, (Remote)object);
            System.out.println("SCM:: EventDispatcher.run - successful rebind EventObserver");
        }
        catch (AlreadyBoundException alreadyBoundException) {
            System.out.println("SCM:: EventDispatcher.run - can't bind EventObserver ");
            alreadyBoundException.printStackTrace();
            System.out.println("SCM:: EventDispatcher.run - exit program");
            System.exit(-1);
        }
        catch (RemoteException remoteException) {
            System.out.println("SCM:: EventDispatcher.run - can't bind EventObserver ");
            remoteException.printStackTrace();
            System.out.println("SCM:: EventDispatcher.run - exit program");
            System.exit(-1);
        }
        object2 = new EventManager(this.sHost, this.hEventQueue, this.hSCMRegistry);
        ((Thread)object2).start();
        object = new SyslogManager(this.sHost, this.hEventQueue, this.hSCMRegistry);
        ((Thread)object).start();
    }
}

