/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scm.admin.client.util;

import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.JOptionPane;
import com.sun.scm.admin.client.util.ClientUtilMC;
import com.sun.scm.admin.client.util.SCMApplet;
import com.sun.scm.admin.client.util.SCMConsole;
import com.sun.scm.admin.util.SCM_MC;
import java.applet.AppletContext;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class SCMApplication
extends SCMApplet
implements Runnable {
    private static final String sccs_id = "@(#)SCMApplication.java 1.6 07/21/00 SMI";
    private static final String MY_CLASSNAME = "SCMApplication";
    private final String serverName;
    private final String serverPort;
    private final SCMConsole console;
    private final String scmgrHome;
    private URL docBaseURL;
    private URL codeBaseURL;
    private Process browserProcess;
    private final Thread browserManager;
    private String browserCommand;

    public SCMApplication(String string, String string2, SCMConsole sCMConsole) {
        this.serverName = string;
        this.serverPort = string2;
        this.console = sCMConsole;
        this.scmgrHome = String.valueOf(System.getProperty("sc.packageHome", "/opt")) + "/SUNWcluster/scmgr/";
        this.browserManager = new Thread(this);
        this.browserManager.start();
        try {
            this.docBaseURL = new URL("file:" + this.scmgrHome);
            this.codeBaseURL = new URL("file:" + this.scmgrHome + "classes/");
            return;
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("ERROR: check your environment variable SC_HOME, it should have a value like \"/opt\"");
            try {
                this.docBaseURL = new URL("file://opt/SUNWcluster/scmgr/");
                this.codeBaseURL = new URL("file://opt/SUNWcluster/scmgr/classes/");
                return;
            }
            catch (MalformedURLException malformedURLException2) {
                this.docBaseURL = null;
                this.codeBaseURL = null;
                return;
            }
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerPort() {
        if (this.serverPort != null) {
            return this.serverPort;
        }
        return System.getProperty("sc.serverPort", String.valueOf(1097));
    }

    public void showStatus(String string) {
        System.err.println("ERROR: calling SCMApplication.showStatus()");
    }

    public URL getCodeBase() {
        return this.codeBaseURL;
    }

    public String getParameter(String string) {
        System.err.println("ERROR: calling SCMApplication.getParameter()");
        return null;
    }

    public AppletContext getAppletContext() {
        System.err.println("ERROR: calling SCMApplication.getAppletContext()");
        return null;
    }

    public URL getDocumentBase() {
        return this.docBaseURL;
    }

    public ImageIcon getImageIcon(String string, String string2) {
        return new ImageIcon(String.valueOf(this.scmgrHome) + "classes/" + string, string2);
    }

    public void showPage(String string, String string2) throws MalformedURLException {
        String string3 = System.getProperty("sc.browser", "/usr/dt/bin/hotjava");
        String string4 = "file:" + this.scmgrHome + "classes/" + string;
        try {
            this.browserCommand = String.valueOf(string3) + " " + string4;
            this.browserProcess = Runtime.getRuntime().exec(this.browserCommand);
            this.browserManager.resume();
            return;
        }
        catch (IOException iOException) {
            String string5 = SCM_MC.CL_UTIL.formatMCMsg(ClientUtilMC.SCMApplication_spawnBrowserErrorMsg, string3);
            this.post2LinesMessage(string5, iOException.getMessage());
            return;
        }
    }

    public void post2LinesMessage(String string, String string2) {
        String[] stringArray = new String[]{string != null ? string : "", string2 != null ? string2 : ""};
        JOptionPane.showMessageDialog(null, (Object)stringArray, (String)ClientUtilMC.WARNING_DG_TITLE, (int)2);
    }

    public synchronized void postConnLostDialog() {
        super.postConnLostDialog();
        System.exit(1);
    }

    public void run() {
        while (true) {
            if (this.browserProcess == null) {
                this.browserManager.suspend();
                continue;
            }
            int n = 0;
            try {
                n = this.browserProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {
                n = -1;
            }
            if (n != 0) {
                String string = ClientUtilMC.SCMApplication_browserErrorMsg;
                this.post2LinesMessage(string, this.browserCommand);
            }
            this.browserProcess = null;
            this.browserCommand = "";
            this.browserManager.suspend();
        }
    }
}

