/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scm.admin.client.util;

import com.sun.java.swing.JTree;
import com.sun.java.swing.tree.DefaultMutableTreeNode;
import com.sun.java.swing.tree.DefaultTreeModel;
import com.sun.java.swing.tree.MutableTreeNode;
import com.sun.java.swing.tree.TreeModel;
import com.sun.java.swing.tree.TreeNode;
import com.sun.java.swing.tree.TreePath;
import com.sun.scm.admin.client.util.SCMSplitFolder;
import com.sun.scm.admin.client.util.SCMTreeNode;
import com.sun.scm.admin.client.util.SCMTreeNodeData;
import com.sun.scm.admin.server.util.SCMResourceI;
import com.sun.scm.admin.util.EVENT_TYPE;
import com.sun.scm.admin.util.EnumConstant;
import com.sun.scm.admin.util.EventObserverI;
import com.sun.scm.admin.util.OBJECT_STATE;
import com.sun.scm.admin.util.OBJECT_TYPE;
import com.sun.scm.admin.util.SCMEvent;
import com.sun.scm.admin.util.SCM_MC;
import com.sun.scm.admin.util.UtilMC;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class SCMTree
extends JTree
implements EventObserverI,
Serializable {
    private static final String sccs_id = "@(#)SCMTree.java 1.12 99/02/22 SMI";
    private static final String MY_CLASSNAME = new String("SCMTree");
    private SCMSplitFolder folder;
    private String msg_str;

    public SCMTree(TreeModel treeModel, SCMSplitFolder sCMSplitFolder) {
        super(treeModel);
        this.folder = sCMSplitFolder;
    }

    public synchronized Vector getTreeNodes(String string, OBJECT_TYPE oBJECT_TYPE) {
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        TreeModel treeModel = this.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModel.getRoot();
        SCMTreeNodeData sCMTreeNodeData = (SCMTreeNodeData)defaultMutableTreeNode.getUserObject();
        SCMResourceI sCMResourceI = sCMTreeNodeData.getRsrcObject();
        if (this.sameResource(sCMResourceI, string, oBJECT_TYPE)) {
            vector.addElement(defaultMutableTreeNode);
        } else {
            this.lookupChildNodes(defaultMutableTreeNode, string, oBJECT_TYPE, vector);
        }
        return vector;
    }

    public synchronized void lookupChildNodes(DefaultMutableTreeNode defaultMutableTreeNode, String string, OBJECT_TYPE oBJECT_TYPE, Vector vector) {
        if (defaultMutableTreeNode.getChildCount() <= 0) {
            return;
        }
        SCMTreeNode sCMTreeNode = null;
        SCMTreeNodeData sCMTreeNodeData = null;
        SCMResourceI sCMResourceI = null;
        Enumeration enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            sCMTreeNode = (SCMTreeNode)((Object)enumeration.nextElement());
            sCMTreeNodeData = (SCMTreeNodeData)sCMTreeNode.getUserObject();
            if (!sCMTreeNodeData.isResourceType() && this.sameResource(sCMResourceI = sCMTreeNodeData.getRsrcObject(), string, oBJECT_TYPE)) {
                vector.addElement(sCMTreeNode);
            }
            this.lookupChildNodes(sCMTreeNode, string, oBJECT_TYPE, vector);
        }
    }

    public synchronized boolean sameResource(SCMResourceI sCMResourceI, String string, OBJECT_TYPE oBJECT_TYPE) {
        try {
            OBJECT_TYPE oBJECT_TYPE2 = sCMResourceI.getType();
            String string2 = sCMResourceI.getName();
            return oBJECT_TYPE2.equalTo(oBJECT_TYPE) && string2.compareTo(string) == 0;
        }
        catch (Exception exception) {
            this.msg_str = SCM_MC.UTIL.formatMCMsg(UtilMC.EXCEPTION_msg, MY_CLASSNAME, "sameResource", exception.getMessage());
            System.out.println(this.msg_str);
            exception.printStackTrace();
            return false;
        }
    }

    public synchronized void updateParentNodeState(SCMTreeNode sCMTreeNode) {
        SCMTreeNode sCMTreeNode2;
        SCMTreeNode sCMTreeNode3 = null;
        SCMTreeNodeData sCMTreeNodeData = null;
        OBJECT_STATE oBJECT_STATE = null;
        OBJECT_STATE oBJECT_STATE2 = OBJECT_STATE.ONLINE;
        Enumeration enumeration = sCMTreeNode.children();
        while (enumeration.hasMoreElements()) {
            sCMTreeNode3 = (SCMTreeNode)((Object)enumeration.nextElement());
            sCMTreeNodeData = (SCMTreeNodeData)sCMTreeNode3.getUserObject();
            oBJECT_STATE = sCMTreeNodeData.getCurrentState();
            if (oBJECT_STATE.equalTo(OBJECT_STATE.ONLINE)) continue;
            oBJECT_STATE2 = OBJECT_STATE.COMPONENT_DOWN;
            break;
        }
        SCMTreeNodeData sCMTreeNodeData2 = (SCMTreeNodeData)sCMTreeNode.getUserObject();
        OBJECT_STATE oBJECT_STATE3 = sCMTreeNodeData2.getCurrentState();
        boolean bl = false;
        if (oBJECT_STATE3.equalTo(OBJECT_STATE.ONLINE) && oBJECT_STATE2.equalTo(OBJECT_STATE.COMPONENT_DOWN)) {
            bl = true;
        } else if (oBJECT_STATE3.equalTo(OBJECT_STATE.COMPONENT_DOWN) && oBJECT_STATE2.equalTo(OBJECT_STATE.ONLINE)) {
            bl = true;
        }
        if (bl) {
            sCMTreeNodeData2.setCurrentState(oBJECT_STATE2);
            sCMTreeNode2 = (DefaultTreeModel)this.getModel();
            sCMTreeNode2.nodeChanged((TreeNode)sCMTreeNode);
        }
        if ((sCMTreeNode2 = sCMTreeNode.getAncestorNode()) != null) {
            this.updateParentNodeState(sCMTreeNode2);
        }
    }

    public synchronized void updateNodeSelection(SCMTreeNode sCMTreeNode) {
        SCMTreeNode sCMTreeNode2 = (SCMTreeNode)((Object)this.getLastSelectedPathComponent());
        if (sCMTreeNode2 == null) {
            Object[] objectArray = sCMTreeNode.getPath();
            TreePath treePath = new TreePath(objectArray);
            this.setSelectionPath(treePath);
        }
    }

    public synchronized void processStateUpdateEvent(Vector vector, SCMEvent sCMEvent) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        SCMResourceI sCMResourceI = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SCMTreeNode sCMTreeNode = (SCMTreeNode)((Object)enumeration.nextElement());
            SCMTreeNodeData sCMTreeNodeData = (SCMTreeNodeData)sCMTreeNode.getUserObject();
            sCMResourceI = sCMTreeNodeData.getRsrcObject();
            try {
                if (sCMEvent.object_state.equalTo(OBJECT_STATE.ONLINE) && sCMResourceI.isComponentDown()) {
                    sCMTreeNodeData.setCurrentState(OBJECT_STATE.COMPONENT_DOWN);
                } else {
                    sCMTreeNodeData.setCurrentState(sCMEvent.object_state);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.msg_str = SCM_MC.UTIL.formatMCMsg(UtilMC.EXCEPTION_msg, MY_CLASSNAME, "processStateUpdateEvent", exception.getMessage());
                System.out.println(this.msg_str);
                return;
            }
            defaultTreeModel.nodeChanged((TreeNode)sCMTreeNode);
            SCMTreeNode sCMTreeNode2 = sCMTreeNode.getAncestorNode();
            if (sCMTreeNode2 == null) continue;
            this.updateParentNodeState(sCMTreeNode2);
        }
    }

    public synchronized void processAddEvent(Vector vector, SCMEvent sCMEvent, SCMResourceI sCMResourceI) {
        String string = null;
        SCMResourceI sCMResourceI2 = null;
        String string2 = sCMEvent.object_type.toString();
        String string3 = null;
        SCMResourceI sCMResourceI3 = sCMResourceI;
        try {
            string = sCMResourceI3.getObjectTypeLB(string2);
            sCMResourceI2 = sCMResourceI3.getChild(string2, sCMEvent.object_name);
            if (sCMResourceI2 == null) {
                return;
            }
            string3 = sCMResourceI2.getUIName();
        }
        catch (Exception exception) {
            this.msg_str = SCM_MC.UTIL.formatMCMsg(UtilMC.EXCEPTION_msg, MY_CLASSNAME, "processAddEvent", exception.getMessage());
            System.out.println(this.msg_str);
            exception.printStackTrace();
            return;
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        SCMTreeNode sCMTreeNode = null;
        SCMTreeNodeData sCMTreeNodeData = null;
        SCMTreeNodeData sCMTreeNodeData2 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SCMTreeNode sCMTreeNode2 = (SCMTreeNode)((Object)enumeration.nextElement());
            SCMTreeNode sCMTreeNode3 = sCMTreeNode2.getTypeNode(string2);
            if (sCMTreeNode3 == null) {
                sCMTreeNodeData = string != null ? new SCMTreeNodeData(sCMResourceI3, string, string2) : new SCMTreeNodeData(sCMResourceI3, string2);
                sCMTreeNode3 = new SCMTreeNode(sCMTreeNodeData, sCMTreeNode2);
                defaultTreeModel.insertNodeInto((MutableTreeNode)sCMTreeNode3, (MutableTreeNode)sCMTreeNode2, sCMTreeNode2.getChildCount());
                this.updateParentNodeState(sCMTreeNode2);
                return;
            }
            if (sCMTreeNode3.lookupChildNode(string3) != null) continue;
            sCMTreeNodeData2 = new SCMTreeNodeData(sCMResourceI2);
            sCMTreeNode = new SCMTreeNode(sCMTreeNodeData2, sCMTreeNode3);
            defaultTreeModel.insertNodeInto((MutableTreeNode)sCMTreeNode, (MutableTreeNode)sCMTreeNode3, sCMTreeNode3.getChildCount());
            this.updateParentNodeState(sCMTreeNode2);
        }
    }

    public synchronized void processDeleteEvent(Vector vector, SCMEvent sCMEvent) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SCMTreeNode sCMTreeNode = (SCMTreeNode)((Object)enumeration.nextElement());
            SCMTreeNode sCMTreeNode2 = sCMTreeNode.getAncestorNode();
            defaultTreeModel.removeNodeFromParent((MutableTreeNode)sCMTreeNode);
            if (sCMTreeNode2 == null) continue;
            SCMTreeNodeData sCMTreeNodeData = (SCMTreeNodeData)sCMTreeNode2.getUserObject();
            if (sCMTreeNodeData.isResourceType() && sCMTreeNode2.getChildCount() == 0) {
                SCMTreeNode sCMTreeNode3 = sCMTreeNode2;
                sCMTreeNode2 = sCMTreeNode3.getAncestorNode();
                defaultTreeModel.removeNodeFromParent((MutableTreeNode)sCMTreeNode3);
            }
            this.updateParentNodeState(sCMTreeNode2);
            this.updateNodeSelection(sCMTreeNode2);
        }
    }

    public synchronized void processModifyEvent(Vector vector, SCMEvent sCMEvent) {
    }

    public synchronized void processOwnershipChangeEvent(Vector vector, SCMEvent sCMEvent) {
        this.processStateUpdateEvent(vector, sCMEvent);
    }

    public synchronized void receiveEvent(SCMEvent sCMEvent, SCMResourceI sCMResourceI) throws RemoteException {
        Object object;
        Vector vector = new Vector();
        try {
            object = sCMResourceI.getName();
            OBJECT_TYPE oBJECT_TYPE = sCMResourceI.getType();
            vector = this.getTreeNodes((String)object, oBJECT_TYPE);
        }
        catch (Exception exception) {
            this.msg_str = SCM_MC.UTIL.formatMCMsg(UtilMC.EXCEPTION_msg, MY_CLASSNAME, "receiveEvent", exception.getMessage());
            System.out.println(this.msg_str);
            exception.printStackTrace();
            return;
        }
        if (vector.isEmpty()) {
            return;
        }
        object = sCMEvent.event_type;
        if (((EnumConstant)object).equalTo(EVENT_TYPE.STATE_UPDATE)) {
            this.processStateUpdateEvent(vector, sCMEvent);
            return;
        }
        if (((EnumConstant)object).equalTo(EVENT_TYPE.ADD)) {
            this.processAddEvent(vector, sCMEvent, sCMResourceI);
            return;
        }
        if (((EnumConstant)object).equalTo(EVENT_TYPE.DELETE)) {
            this.processDeleteEvent(vector, sCMEvent);
            return;
        }
        if (((EnumConstant)object).equalTo(EVENT_TYPE.MODIFY)) {
            this.processModifyEvent(vector, sCMEvent);
            return;
        }
        if (((EnumConstant)object).equalTo(EVENT_TYPE.OWNERSHIP_CHANGE)) {
            this.processOwnershipChangeEvent(vector, sCMEvent);
            return;
        }
        this.msg_str = SCM_MC.UTIL.formatMCMsg(UtilMC.INVALID_EVENT_msg, MY_CLASSNAME, "receiveEvent");
        System.out.println(this.msg_str);
    }

    public String getClassVersion() {
        return sccs_id;
    }
}

