/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scm.admin.client.event;

import com.sun.java.swing.JPanel;
import com.sun.java.swing.event.TreeSelectionEvent;
import com.sun.java.swing.event.TreeSelectionListener;
import com.sun.java.swing.tree.TreeModel;
import com.sun.java.swing.tree.TreePath;
import com.sun.scm.admin.client.event.ClientEventMC;
import com.sun.scm.admin.client.event.SCMEventDisplay;
import com.sun.scm.admin.client.util.SCMApplet;
import com.sun.scm.admin.client.util.SCMPage;
import com.sun.scm.admin.client.util.SCMSelectable;
import com.sun.scm.admin.client.util.SCMSplitFolder;
import com.sun.scm.admin.client.util.SCMTree;
import com.sun.scm.admin.client.util.SCMTreeCellRenderer;
import com.sun.scm.admin.client.util.SCMTreeMouseListener;
import com.sun.scm.admin.client.util.SCMTreeNode;
import com.sun.scm.admin.client.util.SCMTreeNodeData;
import com.sun.scm.admin.server.eventq.SCMEventQueueI;
import com.sun.scm.admin.server.util.SCMResourceI;
import com.sun.scm.admin.util.EventObserverI;
import com.sun.scm.admin.util.OBJECT_TYPE;
import com.sun.scm.admin.util.SCMEvent;
import com.sun.scm.admin.util.SCM_MC;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.rmi.RemoteException;

public class SCMEventPanel
extends SCMSplitFolder
implements TreeSelectionListener,
EventObserverI,
SCMSelectable {
    private static final String sccs_id = "@(#)SCMEventPanel.java 1.10 99/02/05 SMI";
    private static final String MY_CLASSNAME = new String("SCMEventPanel");
    private SCMEventQueueI eventQ;
    private SCMApplet applet;
    private SCMPage page;
    private SCMTree tree;
    private String msg_str;

    public SCMEventPanel(SCMPage sCMPage) {
        this.page = sCMPage;
        this.applet = (SCMApplet)((Object)sCMPage.getApplet());
        ((Component)((Object)this)).setName("Cluster Events Panel");
        this.eventQ = this.applet.getCurrEventQueue();
        if (this.eventQ == null) {
            this.msg_str = SCM_MC.CL_EVENT.formatMCMsg(ClientEventMC.INVALID_EVENTQ_msg, MY_CLASSNAME, "SCMEventPanel");
            System.out.println(this.msg_str);
            return;
        }
        this.tree = new SCMTree((TreeModel)sCMPage.getTreeModel(), this);
        ((Component)((Object)this.tree)).setBackground(Color.white);
        this.tree.setCellRenderer(new SCMTreeCellRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        SCMTreeMouseListener sCMTreeMouseListener = new SCMTreeMouseListener(this.tree);
        ((Component)((Object)this.tree)).addMouseListener(sCMTreeMouseListener);
        this.tree.setSelectionRow(0);
        this.setIndexComponent((Component)((Object)this.tree));
        this.applet.registerComponent(this);
    }

    public synchronized void updateEvents(SCMTreeNodeData sCMTreeNodeData) {
        SCMEventDisplay sCMEventDisplay = new SCMEventDisplay(this.applet, this.eventQ, sCMTreeNodeData);
        this.setContextComponent((Component)((Object)sCMEventDisplay));
    }

    public synchronized void updateEventDisplay() {
        SCMTreeNode sCMTreeNode = (SCMTreeNode)((Object)this.tree.getLastSelectedPathComponent());
        SCMTreeNodeData sCMTreeNodeData = (SCMTreeNodeData)sCMTreeNode.getUserObject();
        this.updateEvents(sCMTreeNodeData);
        this.updateUIDisplay();
    }

    public synchronized void updateUIDisplay() {
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
        ((Component)((Object)this)).repaint();
        this.page.updateUIDisplay();
    }

    public synchronized void updateSelectedNodeDisplay() {
        SCMTreeNode sCMTreeNode = (SCMTreeNode)((Object)this.tree.getLastSelectedPathComponent());
        if (sCMTreeNode != null) {
            this.updateContextDisplay(sCMTreeNode.getUserObject());
        }
    }

    public synchronized void updateContextDisplay(Object object) {
        this.updateEvents((SCMTreeNodeData)object);
    }

    public synchronized SCMPage getPage() {
        return this.page;
    }

    public synchronized SCMTree getTree() {
        return this.tree;
    }

    public synchronized void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        if (treePath == null) {
            return;
        }
        if (!treeSelectionEvent.isAddedPath(treePath)) {
            return;
        }
        SCMTreeNode sCMTreeNode = (SCMTreeNode)((Object)treePath.getLastPathComponent());
        SCMTreeNodeData sCMTreeNodeData = (SCMTreeNodeData)sCMTreeNode.getUserObject();
        this.applet.updateFilterMode(sCMTreeNodeData);
        this.updateEvents(sCMTreeNodeData);
        this.updateUIDisplay();
    }

    public synchronized void receiveEvent(SCMEvent sCMEvent, SCMResourceI sCMResourceI) throws RemoteException {
        this.updateSelectedNodeDisplay();
        this.updateUIDisplay();
    }

    public synchronized void setSelection(Object object) {
        Object object2 = this.getSelection();
        JPanel jPanel = this.page.getPreviousFolder();
        if (jPanel == this.page.getHomePanel()) {
            if (this.tree.getRowForPath((TreePath)object2) == 0) {
                this.updateSelectedNodeDisplay();
                return;
            }
            this.tree.setSelectionRow(0);
            return;
        }
        if (jPanel == this.page.getPropertyPanel()) {
            if (object2 == object) {
                this.updateSelectedNodeDisplay();
                return;
            }
            this.tree.setSelectionPath((TreePath)object);
            return;
        }
        if (jPanel == this.page.getSyslogPanel()) {
            SCMTreeNodeData sCMTreeNodeData = (SCMTreeNodeData)object;
            String string = sCMTreeNodeData.getTypeKey();
            if (string.compareTo(OBJECT_TYPE.CLUSTER.toString()) == 0) {
                this.tree.setSelectionRow(0);
                return;
            }
            SCMTreeNode sCMTreeNode = (SCMTreeNode)((Object)this.tree.getModel().getRoot());
            SCMTreeNode sCMTreeNode2 = sCMTreeNode.getTypeNode(OBJECT_TYPE.CNODE.toString());
            SCMTreeNode sCMTreeNode3 = null;
            if (sCMTreeNodeData.isResourceType()) {
                sCMTreeNode3 = sCMTreeNode2;
            } else {
                TreePath treePath = new TreePath((Object[])sCMTreeNode2.getPath());
                this.tree.expandPath(treePath);
                sCMTreeNode3 = sCMTreeNode2.lookupChildNode(sCMTreeNodeData.getName());
            }
            if (sCMTreeNode3 != null) {
                this.tree.setSelectionPath(new TreePath((Object[])sCMTreeNode3.getPath()));
            }
        }
    }

    public synchronized Object getSelection() {
        return this.tree.getSelectionPath();
    }

    public String getClassVersion() {
        return sccs_id;
    }
}

