/*    Trivia Forum
          by
     Yannick Tessier
 
  Tessier Technologies, Inc
Copyrighted (c) 1988,89,90,91
    All Rights Reserved
 
Version 6.0 Protected Mode
 
*/
 
#include "stdio.h"
#include "ctype.h"
#include "majorbbs.h"
#include "usracc.h"
#include "math.h"
#include "btvstf.h"
#include "forum.h"
#include "portable.h"
#include "dos.h"
#include "string.h"
 
#define FORRAN 1              /*   Questions Random = 1 , Sequential = 0 */
 
int formcu(),inifor(),forum(),dfsthn(),clsfor(),thangup();
 
#define FORSTT      18        /*    Forum Interface Module            */
struct module module18={      /*    module interface block            */
     '*',                     /*    main menu select character        */
     "",                      /*    description for main menu         */
     inifor,                  /*    system initialization routine     */
     NULL,                    /*    user logon supplemental routine   */
     forum,                   /*    input routine if selected         */
     dfsthn,                  /*    status-input routine if selected  */
     thangup,                 /*    hangup (lost carrier) routine     */
     formcu,                  /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     clsfor,                  /*    finish-up (sys shutdown) routine  */
};
 
 
#define CATEGORY_PROMPT 1
#define TD 15                 /*   Time Delays Per Hints in Question  */
#define HINTS 6               /*   Total Number of Letter Hints       */
 
FILE *forumb;                 /*   Forum Message File Block Pointer   */
FILE *mari;                   /*   Adding files from Text File        */
FILE *rudel;                  /*   Writing Database to Text File      */
BTVFILE *forbb;               /*   Forum Btrieve Message File Block   */
BTVFILE *forinfo;             /*   Point to Current Game              */
BTVFILE *fortt;               /*   Forum Btrieve Top Ten File Block   */
BTVFILE *fortop;              /*   Actual Top Ten categories 1-99     */
 
struct forrec {               /*   Database of Questions              */
  char category[9];           /*   Category (01-99) Number(0-999999)  */
  char quest[200];            /*   Question in Record Block           */
  char answer[100];           /*   Answer to Question                 */
  char userid[10];            /*   User who Added the Question        */
  char reg[10];               /*   Registration Number                */
  char spare[500-328];        /*   Spare Total Length 500             */
};
 
struct forgam {               /*   Current Game Pointers              */
  int  category;              /*   Category Number                    */
  int  usecat;                /*   Category to USE FROM (Contests)    */
  char  name[30];             /*   Category Name                      */
  char gameq[200];            /*   Current Question in Game           */
  char gamea[100];            /*   Current Answer in Game             */
  char gamed[100];            /*   Current Display in Game            */
  long questn;                /*   Current Question Number            */
  int  play;                  /*   1-Playing    2-Not Playing         */
  int  hints;                 /*   Number of Hints Given              */
  int  letpoint;              /*   Letter Point for Hints             */
  int  type;                  /*   Type of Hints                      */
  int  maxhints;              /*   Maximum number of Hints Allowed    */
  int  cost;                  /*   Cost per Question (in credits)     */
  int  prize;                 /*   Prize for Winners (in credits)     */
  int  answer;                /*   Display Answer Option              */
  int  open;                  /*   Category Open Option               */
  int  minimum;               /*   Minimum Number of Questions        */
  int  access;                /*   Access Level Required (Adult)      */
  int  reset;                 /*   Scores to be RESET                 */
  long number;                /*   Number of Questions in Database    */
  char spare[500-466];        /*   Spare, Total Length 500            */
};
 
struct trvrec {               /*   User Records (Volatile Memory)     */
  char userid[UIDSIZ];        /*   User-ID Record                     */
  long total;                 /*   Total Score in all Categories      */
  long score[100];            /*   User Score in each Category        */
  int access;                 /*   Question Access                    */
  char reg[10];               /*   Registration Number                */
  char spare[480-416];        /*   Spare- Record Length = 500         */
};
 
struct trvusr {
  int area;                   /*   Which Area is User In ?            */
  long questnum;              /*   Question Number while Editing      */
  char question[200];         /*   Adding Question (if Access)        */
  char answer[100];           /*   Adding Answer (if Access)          */
  int added;                  /*   Total Number of Questions Added    */
  int category;               /*   Current Category for Adding        */
  char name[30];              /*   Category Name                      */
  int  usecat;                /*   Category to USE FROM (Contests)    */
  int  hints;                 /*   Number of Hints Given              */
  int  type;                  /*   Type of Hints                      */
  int  cost;                  /*   Cost per Question (in credits)     */
  int  prize;                 /*   Prize for Winners (in credits)     */
  int  canswer;               /*   Display Answer Option              */
  int  open;                  /*   Category Open Option               */
  int  minimum;               /*   Minimum Number of Questions        */
  int  caccess;               /*   Access Level Required (Adult)      */
  int  nextact;               /*   Next Case Statement                */
  int  nextq;                 /*   next question 0-none 1=active      */
  long qnext;                 /*   qnext                              */
  struct trvrec trvblk;       /*   For This User                      */
  struct trvrec othblk;       /*   For Editing User                   */
};
 
 
struct toptrv {
  int category;               /*   Category Number                    */
  long scores[10];            /*   Top Ten Scores                     */
  char names[10][10];         /*   Top Ten User-ids                   */
};
 
struct toptrv topv;
 
struct forrec forblk;
 
struct forgam fgm;
 
int question_timer;                             /* Question Timer */
int trivia_players[100];                 /* Players in each game */
static int nextq[100];                         /* # of players for NEXT */
int add_list_cat;
 
int forran;
 
#define trvptr ((struct trvusr *)vdaptr)
 
inifor2() {
     int x,y;
 
     forran=FORRAN;
     for (x=0;x<100;x++)
       trivia_players[x]=0;
     for (x=0;x<100;x++)
       nextq[x]=0;
     forumb=opnmsg("forum.mcv");
     setmbk(forumb);
     inimid(FORSTT,FORSEL,FORMNU);
 
}
 
formcu() {              /* Mid-night Clean-up - Used for Reset Scores */
 
   int x,y;
   int high;
   struct trvrec mcurec;
 
   high=highcat();
   for (x=1;x<=high;x++) {
     setbtv(forinfo);
     if(acqbtv(&fgm,&x,0)) {
       if (fgm.reset == 1) {
         fgm.reset=0;
         updbtv(&fgm);
         usrnum=-1;
         shocst(1,"%s Scores Reset",fgm.name);
         setbtv(fortop);
         if (acqbtv(&topv,&x,0)) {
           for (y=0;y<10;y++) {
             topv.scores[y]=0L;
             setmem(topv.names[y],10,0);
           }
           updbtv(&topv);
         }
         setbtv(fortt);
         if (qlobtv(0)) {
           do {
               gcrbtv(&mcurec,0);
               mcurec.total-=mcurec.score[x];
               mcurec.score[x]=0;
               updbtv(&mcurec);
           } while (qnxbtv());
         }
       }
     }
   }
}
 
forum()
{
  int n,x;
  int high;              /* High Category   */
  char cate[9];
 
  setmbk(forumb);
 
      if (usaptr->tckavl < 1) {
        prfmsg(NONLIVE);
        return(0);
      }
      switch (usrptr->substt) {
        case 0:
          trvinfo();
          trvptr->nextq=0;
          trvptr->area=0;
          trvmenu();
          usrptr->substt=CATEGORY_PROMPT;
          break;
        case CATEGORY_PROMPT:
          high=highcat();
          if (sameas(margv[0],"x")) {
            prfmsg(EXITOUT);
            return(0);
          }
          if (atoi(margv[0]) > 0 && atoi(margv[0]) <= high) {
            trvptr->area=atoi(margv[0]);
            getgame(trvptr->area);
            if (fgm.open == 0 && fgm.number >= fgm.minimum) {
              if (access_ok() >= fgm.access ) {
                trivia_players[trvptr->area]++;
                usrptr->substt=1000+trvptr->area;
                prfmsg(YTENTER,usaptr->userid);
                outrivia(trvptr->area);
                whosen(trvptr->area);
                prfmsg(THELP);
                btupmt(usrnum,':');
                break;
              }
              else {
                prfmsg(ACCESS,fgm.access);
              }
            }
            else {
              prfmsg(CLOSED);
            }
          }
          if (sameas(margv[0],"S") && access_ok() > 50) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          trvmenu();
          break;
        case MENU:
            if (sameas(margv[0],"0") && access_ok() > 100) {
              high=highcat();
              trvptr->category=high+1;
              prfmsg(usrptr->substt=CATNAME,trvptr->category);
              trvptr->nextact=CATACC;
              break;
            }
            if (sameas(margv[0],"1")) {
              high=highcat();
              prfmsg(usrptr->substt=ADDQ1,high);
              break;
            }
            if (sameas(margv[0],"2")) {
              high=highcat();
              prfmsg(usrptr->substt=MODQ1,high);
              break;
            }
            if (sameas(margv[0],"3") && access_ok() > 255) {
              prfmsg(usrptr->substt=EDITU);
              break;
            }
            if (sameas(margv[0],"4") && access_ok() > 255) {
              prfmsg(usrptr->substt=URESET);
              break;
            }
            if (sameas(margv[0],"5") && access_ok() > 100) {
              high=highcat();
              prfmsg(usrptr->substt=MODCAT,high);
              break;
            }
            if (sameas(margv[0],"6")) {
              high=highcat();
              prfmsg(usrptr->substt=DELQ1,high);
              break;
            }
            if (sameas(margv[0],"7") && access_ok() > 255) {
              high=highcat();
              prfmsg(usrptr->substt=DISCAT,high);
              break;
            }
            if (sameas(margv[0],"8") && access_ok() > 255) {
              prfmsg(usrptr->substt=CURSYS,question_timer);
              break;
            }
            if (sameas(margv[0],"9") && access_ok() > 255) {
              high=highcat();
              prfmsg(usrptr->substt=RESETC,high);
              break;
            }
            if (sameas(margv[0],"A") && access_ok() > 255) {
              high=highcat();
              prfmsg(usrptr->substt=ADDEC,high);
              break;
            }
            if (sameas(margv[0],"x")) {
              usrptr->substt=CATEGORY_PROMPT;
              trvmenu();
              break;
            }
            prfmsg(usrptr->substt=MENU);
            break;
        case ADDEC:
          high=highcat();
          if (atoi(margv[0]) > 0 && atoi(margv[0]) <= high) {
            trvptr->category=atoi(margv[0]);
            prfmsg(usrptr->substt=FILEN);
            break;
          }
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          prfmsg(ADDEC,high);
          break;
        case FILEN:
          rstrin();
          if (chk_file(margv[0]) == 1) {
            add_list_cat=trvptr->category;
            load_mari(margv[0]);
            prfmsg(FILESA);
            prfmsg(usrptr->substt=MENU);
            break;
          }
          else if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          prfmsg(FILEN);
          break;
        case RESETC:
          high=highcat();
          if (atoi(margv[0]) > 0 && atoi(margv[0]) <= high) {
            setbtv(forinfo);
            trvptr->category=atoi(margv[0]);
            acqbtv(&fgm,&trvptr->category,0);
            prfmsg(usrptr->substt=RESETYN,fgm.name);
            break;
          }
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          high=highcat();
          prfmsg(RESETC,high);
          break;
        case RESETYN:
          if (sameas(margv[0],"Y")) {
            setbtv(forinfo);
            acqbtv(&fgm,&trvptr->category,0);
            fgm.reset=1;
            updbtv(&fgm);
            prfmsg(RESETAC);
            prfmsg(usrptr->substt=MENU);
            break;
          }
          if (sameas(margv[0],"N") || sameas(margv[0],"X")) {
            prfmsg(NRESET);
            prfmsg(usrptr->substt=MENU);
            break;
          }
          setbtv(forinfo);
          acqbtv(&fgm,&trvptr->category,0);
          prfmsg(RESETYN,fgm.name);
          break;
        case DISCAT:
          high=highcat();
          if (sameas(margv[0],"x") || margc != 1)  {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          if (atoi(margv[0]) > 0 && atoi(margv[0]) <= high) {
            trvptr->category=atoi(margv[0]);
            highqu();
            prfmsg(usrptr->substt=STRTQ,ltoa(trvptr->questnum));
            break;
          }
          high=highcat();
          prfmsg(usrptr->substt=DISCAT,high);
          break;
        case STRTQ:
          if (sameas(margv[0],"x") || margc != 1)  {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          prfmsg(SHOWLIST);
          trvptr->questnum=atol(margv[0]);
          if (trvptr->questnum == 0L)
            trvptr->questnum=1;
          display_question();
          usrptr->substt=CONDIS;
          break;
        case CONDIS:
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          display_question();
          break;
        case ENDDIS:
          high=highcat();
          prfmsg(usrptr->substt=DISCAT,high);
          break;
        case URESET:
          if (sameas(margv[0],"x") || margc != 1)  {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          if (strlen(margv[0]) < 10 && strlen(margv[0]) > 2) {
            makhdl();
            if (resetu() == 1) {
              prfmsg(ISRESET);
              prfmsg(usrptr->substt=MENU);
              break;
            }
          }
          prfmsg(UVALID);
          prfmsg(URESET);
          break;
        case EDITU:
          if (sameas(margv[0],"x") || margc != 1)  {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          if (strlen(margv[0]) < 10 && strlen(margv[0]) > 2) {
            makhdl();
            if (edit_user() == 0) {
              prfmsg(RECORD,trvptr->othblk.userid,trvptr->othblk.access);
              high=highcat();
              for (x=1;x<high;x++)
                prfmsg(USCORE,x,ltoa(trvptr->othblk.score[x]));
              prfmsg(UTOTAL,ltoa(trvptr->othblk.total));
              prfmsg(usrptr->substt=EDIT1);
              break;
            }
          }
          prfmsg(EDITU);
          break;
        case EDIT1:
          if (sameas(margv[0],"x") || margc != 1)  {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          if (sameas(margv[0],"A")) {
            prfmsg(usrptr->substt=NEWACC);
            break;
          }
          prfmsg(EDIT1);
          break;
        case NEWACC:
          if (margc == 0 || sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          trvptr->othblk.access=atoi(margv[0]);
          save_user();
          prfmsg(RECORD,trvptr->othblk.userid,trvptr->othblk.access);
          high=highcat();
          for (x=1;x<high;x++)
            prfmsg(USCORE,x,ltoa(trvptr->othblk.score[x]));
          prfmsg(UTOTAL,ltoa(trvptr->othblk.total));
          prfmsg(usrptr->substt=EDIT1);
          break;
        case CURSYS:
          if (atoi(margv[0]) > 1 && atoi(margv[0]) < 1001)
            question_timer=atoi(margv[0]);
          update_sys();
          prfmsg(SET,question_timer);
          prfmsg(usrptr->substt=MENU);
          break;
        case DELQ1:
          high=highcat();
          if (atoi(margv[0]) > 0 && atoi(margv[0]) <= high) {
            trvptr->category=atoi(margv[0]);
            setbtv(forinfo);
            acqbtv(&fgm,&trvptr->category,0);
            prf("\n*** %s ***\n",fgm.name);
            highqu();
            prfmsg(usrptr->substt=DELQ2,ltoa(trvptr->questnum));
            break;
          }
          if (sameas(margv[0],"?")) {
            showcat();
            break;
          }
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          prfmsg(INVALID);
          high=highcat();
          prfmsg(DELQ1,high);
          break;
        case DELQ2:
          highqu();
          if (atol(margv[0]) > 0 && atol(margv[0]) <= trvptr->questnum) {
            trvptr->questnum=atol(margv[0]);
            if (getq() == 1) {
              prfmsg(usrptr->substt=DELQ3,ltoa(trvptr->questnum),trvptr->question,trvptr->answer);
              break;
            }
            else {
              prfmsg(BADQ);
            }
          }
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          setbtv(forinfo);
          acqbtv(&fgm,&trvptr->category,0);
          prf("\n*** %s ***\n",fgm.name);
          highqu();
          prfmsg(usrptr->substt=DELQ2,ltoa(trvptr->questnum));
          break;
        case DELQ3:
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          if (sameas(margv[0],"y")) {
            delq();
            prfmsg(DELETED);
            prfmsg(usrptr->substt=MENU);
            break;
          }
          if (sameas(margv[0],"n")) {
              high=highcat();
              prfmsg(usrptr->substt=DELQ1,high);
              break;
          }
          prfmsg(usrptr->substt=DELQ3,ltoa(trvptr->questnum),trvptr->question,trvptr->answer);
          break;
        case MODQ1:
          high=highcat();
          if (atoi(margv[0]) > 0 && atoi(margv[0]) <= high) {
            trvptr->category=atoi(margv[0]);
            setbtv(forinfo);
            acqbtv(&fgm,&trvptr->category,0);
            prf("\n*** %s ***\n",fgm.name);
            highqu();
            prfmsg(usrptr->substt=MODQ2,ltoa(trvptr->questnum));
            break;
          }
          if (sameas(margv[0],"?")) {
            showcat();
            break;
          }
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          prfmsg(INVALID);
          prfmsg(MODQ1);
          break;
        case MODQ2:
          highqu();
          if (atol(margv[0]) > 0 && atol(margv[0]) <= trvptr->questnum) {
            trvptr->questnum=atol(margv[0]);
            if (getq() == 1) {
              prfmsg(usrptr->substt=MODQ3,trvptr->question,trvptr->answer);
              break;
            }
            else {
              prfmsg(BADQ);
            }
          }
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          setbtv(forinfo);
          acqbtv(&fgm,&trvptr->category,0);
          prf("\n*** %s ***\n",fgm.name);
          highqu();
          prfmsg(usrptr->substt=MODQ2,ltoa(trvptr->questnum));
          break;
        case MODQ3:
          if (sameas(margv[0],"x")) {
            updateq();
            prfmsg(usrptr->substt=MENU);
            break;
          }
          if (sameas(margv[0],"Q")) {
            prfmsg(usrptr->substt=MODQ4);
            break;
          }
          if (sameas(margv[0],"A")) {
            prfmsg(usrptr->substt=MODQ5);
            break;
          }
          prfmsg(usrptr->substt=MODQ3,trvptr->question,trvptr->answer);
          break;
        case MODQ4:
          if (margc > 0) {
            rstrin();
            if (strlen(margv[0]) < 200) {
              strcpy(trvptr->question,margv[0]);
            }
            else {
              prfmsg(TOLONG);
            }
          }
          prfmsg(usrptr->substt=MODQ3,trvptr->question,trvptr->answer);
          break;
        case MODQ5:
          if (margc > 0) {
            rstrin();
            if (strlen(margv[0]) < 100) {
              strcpy(trvptr->answer,margv[0]);
            }
            else {
              prfmsg(TOLONG);
            }
          }
          prfmsg(usrptr->substt=MODQ3,trvptr->question,trvptr->answer);
          break;
        case ADDQ1:
          high=highcat();
          if (atoi(margv[0]) > 0 && atoi(margv[0]) <= high) {
            trvptr->category=atoi(margv[0]);
            setbtv(forinfo);
            acqbtv(&fgm,&trvptr->category,0);
            prf("\n*** %s ***\n",fgm.name);
            highqu();
            prfmsg(usrptr->substt=ADDQ2,ltoa(trvptr->questnum));
            break;
          }
          if (sameas(margv[0],"?")) {
            showcat();
            break;
          }
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          prfmsg(INVALID);
          high=highcat();
          prfmsg(ADDQ1,high);
          break;
        case ADDQ2:
          rstrin();
          if (strlen(margv[0]) > 10 && strlen(margv[0]) < 200) {
            strcpy(trvptr->question,margv[0]);
            prfmsg(usrptr->substt=ADDQ3);
            break;
          }
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          prfmsg(INVALID);
          prfmsg(usrptr->substt=ADDQ2,ltoa(trvptr->questnum));
          break;
        case ADDQ3:
          rstrin();
          if (strlen(margv[0]) > 4 && strlen(margv[0]) < 100) {
            strcpy(trvptr->answer,margv[0]);
            prfmsg(ADDED);
            high=highcat();
            addq(trvptr->category,trvptr->question,trvptr->answer);
            highqu();
            prfmsg(usrptr->substt=ADDQ2,ltoa(trvptr->questnum));
            break;
          }
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          prfmsg(INVALID);
          prfmsg(usrptr->substt=ADDQ2,ltoa(trvptr->questnum));
          break;
        case MODCAT:
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          high=highcat();
          if (atoi(margv[0]) > 0 && atoi(margv[0]) <= high) {
            trvptr->category=atoi(margv[0]);
            editcat();
            usrptr->substt=EDITOR;
            break;
          }
          prfmsg(MODCAT,high);
          break;
        case EDITOR:
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          if (atoi(margv[0]) >= 0 && atoi(margv[0]) < 10) {
            prfmsg(usrptr->substt=CATNAME+atoi(margv[0]),trvptr->category);
            trvptr->nextact=EDIT2;
            break;
          }
          editcat();
          break;
        case EDIT2:
          updatec();
          editcat();
          usrptr->substt=EDITOR;
          break;
        case CATNAME:
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          rstrin();
          if (strlen(margv[0]) > 5 && strlen(margv[0]) < 31) {
            strcpy(trvptr->name,margv[0]);
            trvptr->usecat=0;
            prfmsg(usrptr->substt=trvptr->nextact);
            trvptr->nextact=CATTYPE;
            break;
          }
          prfmsg(usrptr->substt=CATNAME,trvptr->category);
          break;
        case CATUSE:
          high=highcat();
          if (sameas(margv[0],"?")) {
            showcat();
            break;
          }
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          if ((trvptr->usecat=margc) == 0) {
            prfmsg(usrptr->substt=trvptr->nextact);
            trvptr->nextact=CATTYPE;
            break;
          }
          if ((trvptr->usecat=atoi(margv[0])) > 0 && trvptr->usecat <= high) {
            prfmsg(usrptr->substt=trvptr->nextact);
            trvptr->nextact=CATTYPE;
            break;
          }
          prfmsg(CATUSE);
          break;
        case CATACC:
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          if (atoi(margv[0]) >= 0 && atoi(margv[0]) < 500) {
            trvptr->caccess=atoi(margv[0]);
            prfmsg(usrptr->substt=trvptr->nextact);
            trvptr->nextact=CATHINT;
            break;
          }
          prfmsg(CATACC);
          break;
        case CATTYPE:
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          if ((trvptr->type=atoi(margv[0])) < 7) {
            prfmsg(usrptr->substt=trvptr->nextact);
            trvptr->nextact=CATCOST;
            break;
          }
          prfmsg(CATTYPE);
          break;
        case CATHINT:
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          trvptr->hints=atoi(margv[0]);
          prfmsg(usrptr->substt=trvptr->nextact);
          trvptr->nextact=CATPRIZE;
          break;
        case CATCOST:
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          trvptr->cost=atoi(margv[0]);
          prfmsg(usrptr->substt=trvptr->nextact);
          trvptr->nextact=CATANSW;
          break;
        case CATPRIZE:
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          trvptr->prize=atoi(margv[0]);
          prfmsg(usrptr->substt=trvptr->nextact);
          trvptr->nextact=CATOPEN;
          break;
        case CATANSW:
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          trvptr->canswer=atoi(margv[0]);
          prfmsg(usrptr->substt=trvptr->nextact);
          trvptr->nextact=CATMIN;
          break;
        case CATOPEN:
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          trvptr->open=atoi(margv[0]);
          prfmsg(usrptr->substt=trvptr->nextact);
          trvptr->nextact=REVIEW;
          break;
        case CATMIN:
          if (sameas(margv[0],"x")) {
            prfmsg(usrptr->substt=MENU);
            break;
          }
          trvptr->minimum=atoi(margv[0]);
          if (trvptr->nextact == REVIEW) {
            trvptr->nextact=REVIEW;
            review_cat();
          }
          else {
            prfmsg(usrptr->substt=trvptr->nextact);
          }
          break;
        case REVIEW:
          if (!sameas(margv[0],"y") && !sameas(margv[0],"n")) {
            review_cat();
            break;
          }
          if (sameas(margv[0],"y")) {
            addcat();
          }
          prfmsg(usrptr->substt=MENU);
          break;
        default:
          if (margc == 0) {
            whosen(trvptr->area);
            prfmsg(THELP,usaptr->userid);
            break;
          }
          if (sameas(margv[0],"scan")) {
            scant();
            break;
          }
          if (sameas(margv[0],"best")) {
            if (margc == 2) {
              if (sameas(margv[1],"all")) {
                trihigh();
                break;
              }
            }
            else {
              besttrv(trvptr->area);
            }
            break;
          }
          if (sameas(margv[0],"help") || sameas(margv[0],"?")) {
            prfmsg(GTHELP,usaptr->userid);
            break;
          }
          if (sameas(margv[0],"exit") || sameas(margv[0],"x")) {
            btupmt(usrnum,0);
            update_triv();
            trivia_players[trvptr->area]--;
            prfmsg(EXIT,usaptr->userid);
            outrivia(trvptr->area);
            trvmenu();
            usrptr->substt=CATEGORY_PROMPT;
            break;
          }
          if (sameto(margv[0],"display")) {
            getgame(trvptr->area);
            if (fgm.play == 1)
              prfmsg(DISPLAY,fgm.gameq,fgm.gamed);
            else
              prfmsg(NOQUEST);
            break;
          }
          if (sameto(margv[0],"next")) {
            getgame(trvptr->area);
            if (trvptr->nextq == 0 || trvptr->qnext != fgm.questn) {
              trvptr->qnext=fgm.questn;
              trvptr->nextq=1;
              nextq[trvptr->area]++;
              if (nextq[trvptr->area] == trivia_players[trvptr->area]) {
                nextq[trvptr->area]=0;
                next_q(trvptr->area);
                prf("Next Question coming up!\n");
              }
              else {
                prf("Everyone in this category needs to use the NEXT option!\n");
              }
            }
            else {
              prf("You already used the NEXT option!\n");
            }
            break;
          }
          if (sameto(margv[0],"score")) {
            prfmsg(SCORE,ltoa(trvptr->trvblk.score[trvptr->area]),
                         ltoa(trvptr->trvblk.total));
            break;
          }
          rstrin();
          getgame(trvptr->area);
          if (fgm.play == 1) {
            if (sameto(fgm.gamea,margv[0])) {
              prfmsg(UGOT,usaptr->userid);
              if (fgm.answer == 0 || fgm.answer == 2)
                prfmsg(ANSR3,fgm.gamea);
              outrivia(trvptr->area);
              prfmsg(IGOT);
              if (fgm.prize > 0) {
                prfmsg(PRIZE,fgm.prize);
                usaptr->tckavl+=fgm.prize;
              }
              fgm.play=2;
              updbtv(&fgm);
              trvptr->trvblk.score[trvptr->area]++;
              trvptr->trvblk.total++;
              updtrv(trvptr->area);
              update_triv();
              break;
            }
            if (fgm.type == 5) {
              for (x=0;x<strlen(fgm.gamea);x++) {
                if (margv[0][x] == fgm.gamea[x] ||
                    margv[0][x] == fgm.gamea[x] - 32  ||
                    margv[0][x] == fgm.gamea[x] + 32)
                  fgm.gamed[x]=fgm.gamea[x];
              }
              updbtv(&fgm);
            }
          }
          prfmsg(FROMSG,usaptr->userid,margv[0]);
          outrivia(trvptr->area);
          prfmsg(MSGSENT);
          break;
      }
      outprf(usrnum);
      clrprf();
      return(1);
}
 
outtall() {
 
     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          if (othusn != usrnum && user[othusn].state == FORSTT &&
              user[othusn].substt >= 1000) {
             outprf(othusn);
          }
     }
     clrprf();
}
charge_trv(int amount,int game) {
 
   othuap=usracc;
   setmbk(forumb);
   prfmsg(CHARGE,amount);
   for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++,othuap++) {
        if (user[othusn].state == FORSTT &&
            user[othusn].substt == game) {
            othuap->tckavl-=amount;
            outprf(othusn);
        }
   }
 
}
 
outrivia(int area)
{
     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          if (othusn != usrnum && user[othusn].state == FORSTT &&
              user[othusn].substt == 1000+area ) {
             outprf(othusn);
          }
     }
     clrprf();
}
outtriv(int area)
{
     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          if (user[othusn].state == FORSTT &&
              user[othusn].substt == 1000+area ) {
             outprf(othusn);
          }
     }
     clrprf();
}
whosen(int area)
{
     int ttuser;
     int tote;
     setmbk(forumb);
     othuap=usracc;
     tote=0;
     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
            if (othusp->state == FORSTT && user[othusn].substt == 1000+area) {
               tote++;
            }
     }
     if (tote==1) {
       prf("You are the only one here right now!\r");
     }
     if (tote==2) {
       for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
            if (othusn != usrnum && othusp->state == FORSTT
                && user[othusn].substt == 1000+area) {
               prfmsg(ONEU,othuap->userid);
            }
            othuap+=1;
       }
     }
     if (tote>2) {
       ttuser=tote-1;
       for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
            if (othusn != usrnum && othusp->state == FORSTT
                && user[othusn].substt == 1000+area) {
               if (ttuser == 1)
                 prfmsg(TWOU,othuap->userid);
               else {
                 if (ttuser == 2)
                   prf("%s ",othuap->userid);
                 else
                   prf("%s, ",othuap->userid);
               }
               ttuser--;
            }
            othuap+=1;
       }
     }
}
 
 
thangup() {
 
   if (user[usrnum].state == FORSTT && user[usrnum].substt >= 1000) {
     setmbk(forumb);
     prfmsg(ZAPPED,usaptr->userid);
     outrivia(trvptr->area);
     update_triv();
     trivia_players[trvptr->area]--;
   }
 
 
}
clsfor() {
 
   clsmsg(forumb);
   clsbtv(forbb);
   clsbtv(fortt);
   clsbtv(forinfo);
   clsbtv(fortop);
 
}
 
trvinfo() {
 
     int x;
 
     setbtv(fortt);
 
     if (!acqbtv(&trvptr->trvblk,usaptr->userid,0)) {
       strcpy(trvptr->trvblk.userid,usaptr->userid);
       for (x=0;x<100;x++)
         trvptr->trvblk.score[x]=0;
       trvptr->trvblk.total=0;
       trvptr->trvblk.access=0;
       insbtv(&trvptr->trvblk);
     }
}
 
update_triv() {
 
  setbtv(fortt);
  if (acqbtv(NULL,usaptr->userid,0))
    updbtv(&trvptr->trvblk);
}
 
trvmenu() {
 
   int high;          /* Highest Category Number */
   int x,err;         /* For Loop Counter        */
 
   setmbk(forumb);
 
   high=highcat();
   prfmsg(CATEGORY);
   setbtv(forinfo);
   for (x=1;x<=high;x++) {
     if (acqbtv(&fgm,&x,0))
       prfmsg(CAT,x,fgm.name,fgm.access);
   }
   if (usrptr->flags&ISYSOP || trvptr->trvblk.access > 99)
     prfmsg(SPECIAL);
   prfmsg(CATOPT,high);
}
 
 
 
int access_ok() {
 
   if (usrptr->flags&ISYSOP || trvptr->trvblk.access > 99) {
     if (usrptr->flags&ISYSOP)
       return(500);
     else
     return(trvptr->trvblk.access);
   }
   return(0);
 
}
 
review_cat() {
 
   int high;
   char hints[7][30];
   char status[2][8];
   char answer[3][45];
 
   setmbk(forumb);
 
   high=highcat();
   strcpy(hints[0],"Random Answer Hints        ");
   strcpy(hints[1],"Hints from Left to Right   ");
   strcpy(hints[2],"Hints from Right to Left   ");
   strcpy(hints[3],"Hints from 'A','B','C',etc.");
   strcpy(hints[4],"Hints from 'Z','Y','X',etc.");
   strcpy(hints[5],"Hints by User Input (Guess)");
   strcpy(hints[6],"No Hints Given             ");
 
   strcpy(status[0],"Open");
   strcpy(status[1],"Closed");
 
   strcpy(answer[0],"Always Display Answer after Question.    ");
   strcpy(answer[1],"Never Display Answer after Question.     ");
   strcpy(answer[2],"Display Answer only if there is a Winner.");
 
 
   prfmsg(usrptr->substt=trvptr->nextact,high+1,trvptr->name,trvptr->caccess,
          trvptr->usecat,
          hints[trvptr->type],trvptr->hints,trvptr->cost,trvptr->prize,
          answer[trvptr->canswer],status[trvptr->open],trvptr->minimum);
   prfmsg(CATMAKE);
}
 
 
addcat() {
 
 int high;
 
 setbtv(forinfo);
 
 high = highcat();
 high++;
 fgm.category       = high;
 fgm.usecat         = trvptr->usecat;
 strcpy(fgm.name,trvptr->name);
 strcpy(fgm.gameq,"");
 strcpy(fgm.gamea,"");
 strcpy(fgm.gamed,"");
 fgm.play           = 0;
 fgm.hints          = 0;
 fgm.questn         = 0L;
 fgm.maxhints       = trvptr->hints;
 fgm.letpoint       = 0;
 fgm.type           = trvptr->type;
 fgm.cost           = trvptr->cost;
 fgm.prize          = trvptr->prize;
 fgm.answer         = trvptr->canswer;
 fgm.open           = trvptr->open;
 fgm.minimum        = trvptr->minimum;
 fgm.access         = trvptr->caccess;
 fgm.reset          = 0;
 fgm.number         = 0L;
 
 insbtv(&fgm);
 
 setbtv(forbb);
 
   sprintf(forblk.category,"%02d000000",high);
   forblk.category[8]='\0';
   strcpy(forblk.quest,"");
   strcpy(forblk.answer,"");
   strcpy(forblk.userid,"");
 
 insbtv(&forblk);
 
}
editcat() {
 
   char hints[7][30];
   char status[2][8];
   char answer[3][45];
 
   setmbk(forumb);
   setbtv(forinfo);
 
   acqbtv(&fgm,&trvptr->category,0);
 
   strcpy(hints[0],"Random Answer Hints        ");
   strcpy(hints[1],"Hints from Left to Right   ");
   strcpy(hints[2],"Hints from Right to Left   ");
   strcpy(hints[3],"Hints from 'A','B','C',etc.");
   strcpy(hints[4],"Hints from 'Z','Y','X',etc.");
   strcpy(hints[5],"Hints by User Input (Guess)");
   strcpy(hints[6],"No Hints Given             ");
 
   strcpy(status[0],"Open");
   strcpy(status[1],"Closed");
 
   strcpy(answer[0],"Always Display Answer after Question.    ");
   strcpy(answer[1],"Never Display Answer after Question.     ");
   strcpy(answer[2],"Display Answer only if there is a Winner.");
 
 
   prfmsg(usrptr->substt=EDITOR,trvptr->category,fgm.name,fgm.usecat,fgm.access,
          hints[fgm.type],fgm.maxhints,fgm.cost,fgm.prize,
          answer[fgm.answer],status[fgm.open],fgm.minimum);
 
   strcpy(trvptr->name,fgm.name);
   trvptr->usecat  = fgm.usecat;
   trvptr->caccess = fgm.access;
   trvptr->type    = fgm.type;
   trvptr->hints   = fgm.maxhints;
   trvptr->cost    = fgm.cost;
   trvptr->prize   = fgm.prize;
   trvptr->canswer = fgm.answer;
   trvptr->open    = fgm.open;
   trvptr->minimum = fgm.minimum;
   prfmsg(CATEDIT);
}
 
updatec() {
 
   setbtv(forinfo);
   acqbtv(&fgm,&trvptr->category,0);
 
   strcpy(fgm.name,trvptr->name);
   fgm.usecat = trvptr->usecat;
   fgm.access = trvptr->caccess;
   fgm.type   = trvptr->type;
   fgm.maxhints  = trvptr->hints;
   fgm.cost   = trvptr->cost;
   fgm.prize  = trvptr->prize;
   fgm.answer = trvptr->canswer;
   fgm.open   = trvptr->open;
   fgm.minimum= trvptr->minimum;
   updbtv(&fgm);
}
 
 
highqu() {
 
   char printit[80];
   setbtv(forinfo);
   if (acqbtv(&fgm,&trvptr->category,0)) {
     trvptr->questnum=fgm.number;
   }
}
 
 
 
getq() {
char questcat[9];
 
  setbtv(forbb);
  sprintf(questcat,"%02d%06ld",trvptr->category,trvptr->questnum);
  questcat[8]='\0';
  if (acqbtv(&forblk,questcat,0)) {
    strcpy(trvptr->question,forblk.quest);
    strcpy(trvptr->answer,forblk.answer);
    return(1);
  }
  return(0);
}
updateq() {
 
  char questcat[9];
 
  setbtv(forbb);
  sprintf(questcat,"%02d%06ld",trvptr->category,trvptr->questnum);
  questcat[8]='\0';
  acqbtv(&forblk,questcat,0);
  strcpy(forblk.quest,trvptr->question);
  strcpy(forblk.answer,trvptr->answer);
  updbtv(&forblk);
}
delq() {
 
  char questcat[9];
  char question[200];
  char answer[100];
  long currq;
 
  currq=trvptr->questnum;
  highqu();
  setbtv(forbb);
  sprintf(questcat,"%02d%06ld",trvptr->category,trvptr->questnum);
  questcat[8]='\0';
  if (acqbtv(&forblk,questcat,0) != NULL) {
    strcpy(question,forblk.quest);
    strcpy(answer,forblk.answer);
    delbtv();
  }
  sprintf(questcat,"%02d%06ld",trvptr->category,currq);
  questcat[8]='\0';
  if (acqbtv(&forblk,questcat,0) != NULL) {
    strcpy(forblk.quest,question);
    strcpy(forblk.answer,answer);
    updbtv(&forblk);
  }
 
  setbtv(forinfo);
 
  if(acqbtv(&fgm,&trvptr->category,0) != NULL) {
    fgm.number--;
    updbtv(&fgm);
  }
}
besttrv(int area) {
 
  int x;
 
  setmbk(forumb);
  setbtv(fortop);
 
  prfmsg(TOPTEN,area);
  if (acqbtv(&topv,&area,0)) {
    for (x=0;x<10;x++) {
      if (topv.scores[x] != 0)
        prfmsg(TOPT,topv.names[x],ltoa(topv.scores[x]));
    }
  }
  prfmsg(ENDIT);
}
 
updtrv(int area) {
 
  int onlist;
  int x,y;
  int position;
 
  char userid[10];
  long score;
 
  setbtv(fortop);
 
  onlist=0;
  if (acqbtv(&topv,&area,0)) {
    for (x=0;x<10;x++) {
      if (sameas(usaptr->userid,topv.names[x])) {
        topv.scores[x]=trvptr->trvblk.score[trvptr->area];
        onlist=1;
        position=x;
      }
    }
    if (onlist == 1 && position > 0) {
        if (topv.scores[position] > topv.scores[position-1]) {
          score=topv.scores[position-1];
          strcpy(userid,topv.names[position-1]);
          topv.scores[position-1]=topv.scores[position];
          strcpy(topv.names[position-1],topv.names[position]);
          topv.scores[position]=score;
          strcpy(topv.names[position],userid);
        }
    }
    if (onlist == 0) {
      position=10;
      for (x=9;x>=0;x--) {
        if (trvptr->trvblk.score[trvptr->area] > topv.scores[x])
          position=x;
      }
      if (position < 10) {
        for (x=9;x>position;x--)  {
          strcpy(topv.names[x],topv.names[x -1]);
          topv.scores[x]= topv.scores[x -1];
        }
        topv.scores[position] = trvptr->trvblk.score[trvptr->area];
        strcpy(topv.names[position],usaptr->userid);
      }
    }
    updbtv(&topv);
  }
  else {
    for (x=0;x<9;x++) {
      strcpy(topv.names[x+1],"--------");
      topv.scores[x+1]=0;
    }
    topv.category=area;
    strcpy(topv.names[0],usaptr->userid);
    topv.scores[0]=trvptr->trvblk.score[trvptr->area];
    setbtv(fortop);
    insbtv(&topv);
  }
}
 
getgame(int area) {
 
  setbtv(forinfo);
  acqbtv(&fgm,&area,0);
 
}
 
update_sys() {
 
  FILE *gspeed;
  gspeed=fopen("trvsys.dat","w");
  fprintf(gspeed,"%d\n",question_timer);
  fclose(gspeed);
}
 
edit_user() {
 
  setbtv(fortt);
  if (acqbtv(&trvptr->othblk,input,0)) {
    updbtv(&trvptr->othblk);
    return(0);
  }
  return(1);
}
save_user() {
 
  setbtv(fortt);
  if (acqbtv(NULL,trvptr->othblk.userid,0))
    updbtv(&trvptr->othblk);
 
}
 
resetu() {              /* Reset all User Scores */
 
  int x;
  setbtv(fortt);
  if (acqbtv(&trvptr->othblk,input,0)) {
    trvptr->othblk.total=0L;
    for (x=0;x<100;x++)
      trvptr->othblk.score[x]=0L;
    updbtv(&trvptr->othblk);
    return(1);
  }
  return(0);
}
 
display_question() {
 
   int x,y;
   long high;
   char category[10];
   int end;
   end=0;
 
   setbtv(forinfo);
   acqbtv(&fgm,&trvptr->category,0);
   high=fgm.number;
   setbtv(forbb);
   prf("");
   for (x=0;x<8;x++) {
    if (trvptr->questnum < high) {
      sprintf(category,"%02d%06ld",trvptr->category,trvptr->questnum);
      category[8]='\0';
      acqbtv(&forblk,category,0);
      if (forblk.quest[strlen(forblk.quest)] == 10)
          forblk.quest[strlen(forblk.quest)] = 32;
      if (forblk.answer[strlen(forblk.answer)] == 10)
          forblk.answer[strlen(forblk.answer)] = 32;
 
      if(forblk.quest[strlen(forblk.quest)-1] == 10 ||
         forblk.quest[strlen(forblk.quest)-1] == 13)
          forblk.quest[strlen(forblk.quest)-1]=0;
        if(forblk.answer[strlen(forblk.answer)-1] == 10 ||
           forblk.answer[strlen(forblk.answer)-1] == 13)
          forblk.answer[strlen(forblk.answer)-1]=0;
      updbtv(&forblk);
      prfmsg(QUEDIS,ltoa(trvptr->questnum),forblk.quest,forblk.answer);
      outprf(usrnum);
      trvptr->questnum++;
    }
    else {
      if (end == 0)
        prfmsg(usrptr->substt=ENDDIS);
      end = 1;
    }
  }
  if (end == 0)
    prfmsg(usrptr->substt=CONDIS);
}
scant() {
 
     int area;
     setmbk(forumb);
     othuap=usracc;
     prfmsg(SCANT);
     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
            if (othusp->state == FORSTT) {
              if (othusp->substt == 0 || othusp->substt == CATEGORY_PROMPT) {
                prfmsg(MAINP,othuap->userid);
              }
              else if (othusp->substt >= 1000) {
                area=othusp->substt-1000;
                getgame(area);
                prfmsg(MAING,othuap->userid,fgm.name);
              }
              else {
                prfmsg(MAINC,othuap->userid);
              }
            }
       othuap+=1;
     }
}
 
 
