#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/select.h>
#include <sys/socket.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "config.h"

int main(int argc, char** argv, char** env)
{
  if (argc<2)
  {
    printf("Usage: %s <port>\n", argv[0]);
    return 1;
  }

  char* endp;
  unsigned short serverPort = strtol(argv[1], &endp, 10);
  if (!*argv[1] || *endp)
  {
    printf("Invalid target port: %s\n", argv[1]);
    return 1;
  }

  printf("Configured to %hu port\n", serverPort);

  int sockListener = socket(AF_INET, SOCK_DGRAM, 0);
  if (sockListener==-1)
  {
    perror("Can't create listen socket");
    return 1;
  }

  printf("Created listen socket %d\n", sockListener);

  struct sockaddr_in serverAddr;
  memset(&serverAddr, 0, sizeof(serverAddr));
#ifdef HAVE_SIN_LEN
  serverAddr.sin_len = sizeof(serverAddr);
#endif  
  serverAddr.sin_family = AF_INET;
  serverAddr.sin_addr.s_addr = 0;
  serverAddr.sin_port = htons(serverPort);

  int rc = bind(sockListener, (struct sockaddr*)&serverAddr, sizeof(serverAddr));
  if (rc)
  {
    perror("Listener bound error");
    return 1;
  }
  
  struct sockaddr_in localAddr;
  int localAddrLen = sizeof(localAddr);
  rc = getsockname(sockListener, (struct sockaddr*)&localAddr, &localAddrLen);
  if (rc)
  {
    perror("Reading local address failed");
    return 1;
  }

  printf("Listener local address is %s:%hu\n", inet_ntoa(localAddr.sin_addr), ntohs(localAddr.sin_port));

  while (1)
  {
    fd_set fdRSet;
    FD_ZERO(&fdRSet);
  
    FD_SET(sockListener, &fdRSet);
    int activeCount = select(sockListener+1, &fdRSet, NULL, NULL, NULL);
    if (activeCount == -1)
    {
      perror("Select error");
      return 1;
    }
  
    if (FD_ISSET(sockListener, &fdRSet))
    {
      char request[1024];
      struct sockaddr_in clientAddr;
      int clientAddrLen = sizeof(clientAddr);
      ssize_t reqLen = recvfrom(sockListener, request, sizeof(request), 0,
                                (struct sockaddr*)&clientAddr, &clientAddrLen);
      if (reqLen==-1)
      {
        perror("Request read error");
        continue;
      }

      printf("Received from %s:%hu request %zd bytes. Content:",
             inet_ntoa(clientAddr.sin_addr), ntohs(clientAddr.sin_port), reqLen, *(unsigned*)request);
      size_t i;
      for (i=0; i<reqLen; ++i)
      {
        printf(" %02hhx", *(((unsigned char*)request) + i));
      }
      putchar('\n');

      ssize_t respLen = sendto(sockListener, request, reqLen, 0,
                               (struct sockaddr*)&clientAddr, clientAddrLen);
      if (respLen == -1)
      {
        perror("Can't send response");
        continue;
      }
      printf("Response sent with %zd bytes\n", respLen);
    }
  }

  rc = close(sockListener);
  if (!rc)
  {
    puts("Listener socket closed");
  }
  else
  {
    perror("Listener socket close error");
    return 1;
  }

  return 0;
}
