#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/select.h>
#include <sys/socket.h>
#include <sys/time.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "config.h"

typedef struct
{
  int id;
} SendBuf;

typedef struct
{
  int id;
} ReceiveBuf;

int main(int argc, char** argv, char** env)
{
  if (argc<3)
  {
    printf("Usage: %s <host> <port>\n", argv[0]);
    return 1;
  }

  struct in_addr serverIp;
  serverIp.s_addr = inet_addr(argv[1]);
  if (serverIp.s_addr == (in_addr_t)-1)
  {
    printf("Invalid target IP: %s\n", argv[1]);
    return 1;
  }

  char* endp;
  unsigned short serverPort = strtol(argv[2], &endp, 10);
  if (!*argv[2] || *endp)
  {
    printf("Invalid target port: %s\n", argv[2]);
    return 1;
  }

  printf("Configured to server at %s:%hu\n", inet_ntoa(serverIp), serverPort);

  struct sockaddr_in serverAddr;
  memset(&serverAddr, 0, sizeof(serverAddr));
#ifdef HAVE_SIN_LEN
  serverAddr.sin_len = sizeof(serverAddr);
#endif  
  serverAddr.sin_family = AF_INET;
  serverAddr.sin_addr = serverIp;
  serverAddr.sin_port = htons(serverPort);

  int sock = socket(AF_INET, SOCK_DGRAM, 0);
  printf("Created socket %d\n", sock);
  if (sock==-1)
  {
    perror("Can't create socket");
    return 1;
  }

  int rc = connect(sock, (struct sockaddr*)&serverAddr, sizeof(serverAddr));
  if (rc)
  {
    perror("Connect to server failed");
    return 1;
  }

  struct sockaddr_in localAddr;
  int localAddrLen = sizeof(localAddr);
  rc = getsockname(sock, (struct sockaddr*)&localAddr, &localAddrLen);
  if (rc)
  {
    perror("Reading local address failed");
    return 1;
  }

  printf("Packets will be sent from %s:%hu\n", inet_ntoa(localAddr.sin_addr), ntohs(localAddr.sin_port));

  SendBuf sendBuf;
  sendBuf.id = 0;
  while (1)
  {
    ++sendBuf.id;
    ssize_t sendLen = send(sock, &sendBuf, sizeof(sendBuf), 0);
    if (sendLen == -1)
    {
      perror("Send failed");
    }
    else
    {
      printf("Send done with ID=%d\n", sendBuf.id);
    }

    fd_set readSet;
    FD_ZERO(&readSet);
    FD_SET(sock, &readSet);

    struct timeval timeout;
    timeout.tv_sec = 1;
    timeout.tv_usec = 0;

    while (1) /* until timeout expired */
    {
      int sockCount = select(sock+1, &readSet, NULL, NULL, &timeout);
      if (sockCount == -1)
      {
        perror("Select error");
        return 1;
      }

      if (!sockCount || !FD_ISSET(sock, &readSet))
      {
        break; /* timeout */
      }

      ReceiveBuf rcvBuf;
      struct sockaddr_in srvAddr;
      int srvAddrLen = sizeof(srvAddr);
      ssize_t rcvLen = recvfrom(sock, &rcvBuf, sizeof(rcvBuf), 0,
                                (struct sockaddr*)&srvAddr, &srvAddrLen);
      if (rcvLen == -1)
      {
        perror("Recv error");
      }
      else
      {
        printf("Received echo from %s:%hu. ", inet_ntoa(srvAddr.sin_addr), ntohs(srvAddr.sin_port));
        if (rcvLen < sizeof(rcvBuf))
        {
          printf("Only %z bytes are received in datagramm\n", rcvLen);
        }
        else
        {
          printf("ID=%d\n", rcvBuf.id);
        }
      }

      if (!timeout.tv_sec && timeout.tv_usec)
      {
        break;
      }
    }
  }

  close(sock);
  puts("Client terminated");

  return 0;
}
