/* Script for Sending SMS to Phone */

Call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'
Call RxFuncAdd 'SysGetKey', 'RexxUtil', 'SysGetKey'
Call RxFuncAdd 'SysCls', 'RexxUtil', 'SysCls'
Call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'
Call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
Call RxFuncAdd 'RxAsyncRead', 'RXASYNC', 'RxAsyncRead'
Call RxFuncAdd 'RxAsyncWait', 'RXASYNC', 'RxAsyncWait'
Call RxFuncAdd 'RxAsyncSetMdmOutput', 'RXASYNC', 'RxAsyncSetMdmOutput'
call RxFuncAdd 'RxAsyncLoadFuncs', 'RXASYNC', 'RxAsyncLoadFuncs'
call RxAsyncLoadFuncs

signal on halt

/* [Global] */
comport="com1"
init='ate0&c1&d1'
command_delay=4    /* delay between AT commands (sec) */
phonevol=7

/* [Internal] Don't modify w/o necessity !!! */
PortHandle=''
remaining=''
debug=1
mainlog=1
cr=d2c(13)
crlf=d2c(13)d2c(10)
ctrlz=d2c(26)

/* ------------- Entry Point -------------- */
Call SysCls

rc=crlf "    Automatic Ericsson Message Sender v 1.00 (c) By Alek Winner." crlf
say rc
if mainlog then call charout rclog,rc

call comport_check


patrol:

parse arg phone message


if message="" | phone="" then
  do
  say "Phone Number & Text for Sending required..."
  exit
  end


message=translate(message,x2c(0)||x2c(2)||x2c(11)||x2c(0A)||x2c(28)||x2c(29)||x2c(2F)||x2c(3C)||x2c(3D)||x2c(3E)||x2c(40),'@$_^{}\[~]|')

say c2x(message)
say length(message)

rc = RxAsyncWrite( PortHandle, 0, init||cr, 'Remaining' )
if rc <> 0 then signal err1

call check_string "Init", "OK", "  No response to Init string... Exitting... ;("

rc=" "date()"  " time() "  Phone Modem Initialized OK" crlf
say rc
if mainlog then call charout rclog,rc

i=1
outf=""
l=length(phone)
do while i < l
outf=outf||substr(phone,i+1,1)||substr(phone,i,1)
i=i+2
end

if i = l then
  do
  outf=outf||'F'||substr(phone,i,1) 
  len=length(outf)-1
  end
else len=length(outf)


outmess=""
l=length(message)

do i = 1 to l
do k=1 to 7
parmbin1=format(x2b(c2x(substr(message,i,1))))
parmbin2=format(x2b(c2x(substr(message,i+1,1))))

parmbin1=right(parmbin1,7,'0')
parmbin2=right(parmbin2,7,'0')

outhex=b2x(right(parmbin2,k)||left(parmbin1,8-k))
outmess=outmess||outhex
if i=l then leave
i=i+1
end
end


if k=8 then cc='1'||right(parmbin2,7,'0')
else cc=left(parmbin2,7-k)

pin=b2x(cc)
pin=right(pin,2,'0')

pin=""
outmess=outmess||pin

/* outmess="1B20" */
say outmess

destlen='0'||d2x(len)

l=right(d2x(l),2,'0')


pdu='001100'||destlen||'91'||outf||'0000A7'||l||outmess

glob=length(pdu)-1

say pdu

/* pdu='0011000B916407861582F50000A704D4E2940A' */
pdu_ln=(length(pdu)-2)/2 
/* pdu_ln=10 */
say "pp=" pdu_ln


rc = RxAsyncWrite( PortHandle, 0, "AT+CMGS="||pdu_ln||cr, 'Remaining' )
if rc <> 0 then signal err1

call syssleep command_delay

rc = RxAsyncWrite( PortHandle, 0, pdu||ctrlz, 'Remaining' )  
if rc <> 0 then signal err1

call syssleep command_delay

call check_string "pdu", "OK", "  Modem not ready... Exitting... ;("


exit


/* --- Check Port State --------*/
comport_check:
if stream(comport,'c','open') = 'NOTREADY:32' then signal err0

call stream comport,'c','close'
rc = RxAsyncOpen( Comport, 'PortHandle' )

com_init:

rc = RxAsyncSetLnCtrl( PortHandle, 115200, 8, 'N', 1 )
if rc <> 0 then signal err0

rc=RxAsyncSetDcbInfo(PortHandle,400,50,'00001001','10000000','','','','','' )
return

err0:
rc=" "date()"  " time() "  Comport is not respond... ;(" crlf
say rc
if mainlog then call charout rclog,rc
/* call beep 262,250 */
exit
/* -----------------------------*/



/* -- Check Modem String --------- */
check_string:
PARSE ARG deb_str, ok_str, err_str

InpStr = ""
do until InpStr=ok_str||crlf | InpStr='ERROR'||crlf
rc = RxAsyncRead( PortHandle, 0, 3000, 'InpStr' )
if rc <> 0 then signal err1
db=deb_str InpStr crlf
if debug then call charout debug.log,db
end

if InpStr = ok_str||crlf then return

err1:
rc=" ["rc"]"date()"  " time() err_str crlf
say rc
if mainlog then call charout rclog,rc
/* call beep 262,250 */
signal term
/* -- Check Modem String - Ends -- */



/* ----- Close All Files -------*/
close_all:
call stream rclog,'c','close'
call stream debug.log,'c','close'
return
/* -----------------------------*/

term:
