/* Script for Sending SMS to Phone */

Call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'
Call RxFuncAdd 'SysGetKey', 'RexxUtil', 'SysGetKey'
Call RxFuncAdd 'SysCls', 'RexxUtil', 'SysCls'
Call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'
Call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
Call RxFuncAdd 'RxAsyncRead', 'RXASYNC', 'RxAsyncRead'
Call RxFuncAdd 'RxAsyncWait', 'RXASYNC', 'RxAsyncWait'
Call RxFuncAdd 'RxAsyncSetMdmOutput', 'RXASYNC', 'RxAsyncSetMdmOutput'
call RxFuncAdd 'RxAsyncLoadFuncs', 'RXASYNC', 'RxAsyncLoadFuncs'
call RxAsyncLoadFuncs

signal on halt

/* [Global] */
comport="com1"
init="ate0x4&c1&d2"
command_delay=0.5    /* delay between AT commands (sec) */
phonevol=7

/* [Internal] Don't modify w/o necessity !!! */
PortHandle=''
remaining=''
debug=1
mainlog=1
crlf=d2c(13)d2c(10)
ctrlz=d2c(26)

/* ------------- Entry Point -------------- */
Call SysCls

rc=crlf "    Automatic Ericsson Message Sender v 1.05 (c) By Alek Winner." crlf
say rc
if mainlog then call charout rclog,rc

call comport_check


patrol:


rc = RxAsyncWrite( PortHandle, 0, init||crlf, 'Remaining' )
if rc <> 0 then signal err1

call check_string "Init", "OK", "  Modem not ready... Exitting... ;("


rc=" "date()"  " time() "  Phone Modem Initialized OK" crlf
say rc
if mainlog then call charout rclog,rc


rc = RxAsyncWrite( PortHandle, 0, 'AT+CPMS?'||crlf, 'Remaining' )
if rc <> 0 then signal err1

do 2
rc = RxAsyncRead( PortHandle, 0, 3000, 'InpStr' )
end

parse value inpstr with id_1 mem1_equ ',' mem1_us ',' mem1_tot ',' mem2_equ ',' mem2_us ',' mem2_tot ',' mem3_equ ',' mem3_us ',' mem3_tot
if id_1 <> '+CPMS: ' then signal err1

call check_string "AT+CPMS?", "OK", "  Modem not ready... Exitting... ;("

say "Mem1 Equipment" mem1_equ "used" mem1_us "from" mem1_tot 
say "Mem2 Equipment" mem2_equ "used" mem2_us "from" mem2_tot 
say "Mem3 Equipment" mem3_equ "used" mem3_us "from" mem3_tot


rc = RxAsyncWrite( PortHandle, 0, 'AT+CPMS="SM","SM","ME"'||crlf, 'Remaining' )
if rc <> 0 then signal err1

do 2
rc = RxAsyncRead( PortHandle, 0, 3000, 'InpStr' )
end

call check_string "AT+CPMS?", "OK", "  Modem not ready... Exitting... ;("


rc="SIM Memory listing:"
say rc
call lineout sms.log,rc


rc = RxAsyncWrite( PortHandle, 0, 'AT+CMGL=1'||crlf, 'Remaining' )
if rc <> 0 then signal err1

rc="Inbox Read listing:"
say rc
call lineout sms.log,rc
messtype=0
call list_mess


rc = RxAsyncWrite( PortHandle, 0, 'AT+CMGL=2'||crlf, 'Remaining' )
if rc <> 0 then signal err1

rc="Outbox listing:"
say rc
call lineout sms.log,rc
messtype=2
call list_mess


rc = RxAsyncWrite( PortHandle, 0, 'AT+CMGL=3'||crlf, 'Remaining' )
if rc <> 0 then signal err1

rc="Sent listing:"
say rc
call lineout sms.log,rc
messtype=2
call list_mess


rc = RxAsyncWrite( PortHandle, 0, 'AT+CPMS="ME"'||crlf, 'Remaining' )
if rc <> 0 then signal err1

do 2
rc = RxAsyncRead( PortHandle, 0, 3000, 'InpStr' )
end

call check_string "AT+CPMS?", "OK", "  Modem not ready... Exitting... ;("


rc="Phone Memory listing:"
say rc
call lineout sms.log,rc


rc = RxAsyncWrite( PortHandle, 0, 'AT+CMGL=0'||crlf, 'Remaining' )
if rc <> 0 then signal err1

rc="Inbox Unread listing:"
say rc
call lineout sms.log,rc
messtype=0
call list_mess


rc = RxAsyncWrite( PortHandle, 0, 'AT+CMGL=1'||crlf, 'Remaining' )
if rc <> 0 then signal err1

rc="Inbox Read listing:"
say rc
call lineout sms.log,rc
messtype=0
call list_mess


rc = RxAsyncWrite( PortHandle, 0, 'AT+CMGL=2'||crlf, 'Remaining' )
if rc <> 0 then signal err1

rc="Outbox listing:"
say rc
call lineout sms.log,rc
messtype=2
call list_mess


rc = RxAsyncWrite( PortHandle, 0, 'AT+CMGL=3'||crlf, 'Remaining' )
if rc <> 0 then signal err1

rc="Sent listing:"
say rc
call lineout sms.log,rc
messtype=2
call list_mess



exit

/* ---- List Message -------- */
list_mess:
i=0
do until inpstr = 'OK'||crlf

rc = RxAsyncRead( PortHandle, 0, 3000, 'InpStr' )
call charout cmgl.log,inpstr

try=0
pdu=""
if left(inpstr,6)='+CMGL:' then
  do while try=0
  parse value inpstr with id_2 poz ',' nop ',' nop ',' length_m nop

   do while try=0
 
   rc = RxAsyncRead( PortHandle, 0, 3000, 'InpStr' )
   call charout cmgl.log,inpstr

   pdu=pdu||inpstr
  
   if right(inpstr,2)='0d0a'x then try=1

   end

  end
else iterate

parse value pdu with pdu '0d0a'x . .


i=i+1
rc=left(i,4)
rc=rc||left(poz,4)


rc=rc||left(length_m,length(length_m)-2)


/* say "rc1="pdu */
call lineout 0pdulog.txt,"PDU=" pdu "=PDU"
poffset=(x2d(left(pdu,2))+2)*2+1+messtype
/* len(1) + INT(1) + SCA(len) PDUtype(1) + messtype */
pdutype=substr(pdu,poffset-2-messtype,2)

if substr(x2b(pdutype),2,1)=1 then udh=1
else udh=0

if messtype=2 then
  do
  if substr(x2b(pdutype),4,2)='00' then vp=0
  if substr(x2b(pdutype),4,2)='10' then vp=1
  if substr(x2b(pdutype),4,2)='11' then vp=7
  end
else vp=7

call lineout 0pdulog.txt,"Poffset=" poffset "=Poffset"
call lineout 0pdulog.txt,"PDUtype=" pdutype "=PDUtype"
call lineout 0pdulog.txt,"VPtype=" vp "=VPtype"

/*  say "poffset="poffset */
plength=x2d(substr(pdu,poffset,2))
if right(substr(pdu,poffset+4,plength),1)='F' then plength=plength+1

call lineout 0pdulog.txt,"plength=" plength "=plength"
/*  say "plength="plength */
pnumber=substr(pdu,poffset+4,plength)

call lineout 0pdulog.txt,"Pnumber=" pnumber "=Pnumber"

intl=substr(pdu,poffset+2,2)
call lineout 0pdulog.txt,"intl=" intl "=intl"

if intl='D0' then 
  do
  message=pnumber
  udl=length(pnumber)/2
  call sms_decode
  pnumber=cur_sms
  end
else
  do
  outf=""
  k=1
   do while k < plength
   outf=outf||substr(pnumber,k+1,1)||substr(pnumber,k,1)
   k=k+2
   end

  pnumber=outf
  pnumber=TRANSLATE(pnumber,'','F')
  end


sctsoff=poffset+4+plength+4

/* say "pnumber="pnumber  "scts="scts */

if messtype=0 then scts=substr(pdu,sctsoff,10)

  dcs=substr(pdu,sctsoff-1,1)
  call lineout 0pdulog.txt,"dcs=" dcs "=dcs"

  udoffs=sctsoff+vp*2+2
  udl=substr(pdu,udoffs-2,2)
  call lineout 0pdulog.txt,"udl=" udl "=udl"

  call lineout 0pdulog.txt,"mes=" substr(pdu,udoffs) "=mes"
  if udh=1 then
    do
    typ=substr(pdu,udoffs+2,2)
    udhoffs=substr(pdu,udoffs,2)+3
    end

  message=substr(pdu,udoffs)

  if udh=1 & typ > 0 then
    do
    udl='0f'
    /* Unknown attach! */
    message='55F7DAFDBEBB41413A3D3C4687'
    end

if dcs=8 then call ucs2_decode
else
 do
 call sms_decode
 if udh=1 & typ=0 then cur_sms=substr(cur_sms,udhoffs)
 end

/* --- scts --- */
if messtype=0 then
  do
  scout=""
   do k=1 to 10 by 2
   scout=scout||substr(scts,k+1,1)||substr(scts,k,1)"."
   end

  sdate=left(scout,8)
  stime=substr(scout,10,5)
  end


rc=rc||"  "||pnumber"  "||plength||"       DATE/TIME: " sdate stime crlf cur_sms
say rc
call lineout sms.log,rc

sdate=""
stime=""

end
rc="Total" i "messages"
say rc
call lineout sms.log,rc
return
/* ---- List Message Ends --- */







parse arg phone message


if message="" | phone="" then
  do
  say "Phone Number & Text for Sending required..."
  exit
  end


message=translate(message,x2c(0)||x2c(2)||x2c(11)||x2c(0A)||x2c(28)||x2c(29)||x2c(2F)||x2c(3C)||x2c(3D)||x2c(3E)||x2c(40),'@$_^{}\[~]|')

say c2x(message)
say length(message)

rc = RxAsyncWrite( PortHandle, 0, init||crlf, 'Remaining' )
if rc <> 0 then signal err1

call check_string "Init", "OK", "  Modem not ready... Exitting... ;("


rc=" "date()"  " time() "  Phone Modem Initialized OK" crlf
say rc
if mainlog then call charout rclog,rc

i=1
outf=""
l=length(phone)
do while i < l
outf=outf||substr(phone,i+1,1)||substr(phone,i,1)
i=i+2
end

if i = l then
  do
  outf=outf||'F'||substr(phone,i,1) 
  len=length(outf)-1
  end
else len=length(outf)


outmess=""
l=length(message)

do i = 1 to l
do k=1 to 7
parmbin1=format(x2b(c2x(substr(message,i,1))))
parmbin2=format(x2b(c2x(substr(message,i+1,1))))

parmbin1=right(parmbin1,7,'0')
parmbin2=right(parmbin2,7,'0')

outhex=b2x(right(parmbin2,k)||left(parmbin1,8-k))
outmess=outmess||outhex
if i=l then leave
i=i+1
end
end


if k=8 then cc='1'||right(parmbin2,7,'0')
else cc=left(parmbin2,7-k)

pin=b2x(cc)
pin=right(pin,2,'0')

pin=""
outmess=outmess||pin

/* outmess="1B20" */
say outmess

destlen='0'||d2x(len)

l=right(d2x(l),2,'0')


pdu='001100'||destlen||'91'||outf||'00F0A7'||l||outmess

glob=length(pdu)-1

say pdu

rc = RxAsyncWrite( PortHandle, 0, "AT+CMGS=160"||crlf, 'Remaining' )
if rc <> 0 then signal err1

call syssleep 2

rc = RxAsyncWrite( PortHandle, 0, pdu||ctrlz, 'Remaining' )
if rc <> 0 then signal err1

call syssleep 2

call check_string "pdu", "OK", "  Modem not ready... Exitting... ;("


exit


/* --- Check Port State --------*/
comport_check:

if stream(comport,'c','open') = 'NOTREADY:32' then signal err0

call stream comport,'c','close'
rc = RxAsyncOpen( Comport, 'PortHandle' )

com_init:

rc = RxAsyncSetLnCtrl( PortHandle, 57600, 8, 'N', 1 )
if rc <> 0 then signal err0

rc=RxAsyncSetDcbInfo(PortHandle,400,50,'00001001','10000000','','','','','' )
return

err0:
rc=" "date()"  " time() "  Comport is not respond... ;(" crlf
say rc
if mainlog then call charout rclog,rc
/* call beep 262,250 */
exit
/* -----------------------------*/



/* -- Check Modem String --------- */
check_string:
PARSE ARG deb_str, ok_str, err_str

InpStr = ""
do until InpStr=ok_str||crlf | InpStr='ERROR'||crlf
rc = RxAsyncRead( PortHandle, 0, 3000, 'InpStr' )
if rc <> 0 then signal err1
db=deb_str InpStr crlf
if debug then call charout debug.log,db
end

if InpStr = ok_str||crlf then return

err1:
rc=" "date()"  " time() err_str crlf
say rc
if mainlog then call charout rclog,rc
/* call beep 262,250 */
signal term
/* -- Check Modem String - Ends -- */


/* -------- SMS PDU Decode ------- */

/* unpack 7bit 140 byte to 160 symb code */
sms_decode:

if DATATYPE(message,'X') = 0 then
  do
  cur_sms='Message Decoding Error...'||crlf||"Dump: "||message
  return
  end

i=1
outmess=""
leftpr=""
l=length(message)

do while i < l
do k=1 to 7

mbinary=substr(message,i,2)
parmbin1=right(format(x2b(mbinary)),8,0)

outhex=b2x(right(parmbin1,8-k)||leftpr)
leftpr=left(parmbin1,k)

outmess=outmess||outhex

i=i+2
if i>l then signal end_prg
end
outmess=outmess||b2x(leftpr)

leftpr=""
end

end_prg:

outmess=left(outmess||b2x(leftpr),x2d(udl)*2)


do forever
pz=pos('1B',outmess)
say "ETOPZ="pz
say "ETOPZ="outmess
if pz=0 then leave
doble=substr(outmess,pz,4)
select
when doble='1B0A' then duble='0C'
when doble='1B14' then duble='5E'
when doble='1B28' then duble='7B'
when doble='1B29' then duble='7D'
when doble='1B2F' then duble='5C'
when doble='1B3C' then duble='5B'
when doble='1B3D' then duble='7E'
when doble='1B3E' then duble='5D'
when doble='1B40' then duble='7C'
otherwise duble='7C'

end
outmess=left(outmess,pz-1)||duble||substr(outmess,pz+4)
end

outmess=x2c(outmess)
cur_sms=translate(outmess,'@$_',x2c(0)||x2c(2)||x2c(11))

rus_on=0
if rus_on then
do
cur_sms=translate(cur_sms,"","bBvVwWgGdDjJzZiIklLmnNpPrRsStuUfFhHcC'")
end

/* say cur_sms */
end_p:
return

/* ---- SMS PDU Decode Ends ---- */


/* ---- UCS2 PDU Decode  ---- */
ucs2_decode:

i=1
cur_sms=""
l=length(message)

do while i < l

bin1=substr(message,i,4)
rbyte=right(bin1,2)

if left(bin1,2)='00' then NOP
else
  do
  dbyte=x2d(rbyte)
  if dbyte < 64 then rbyte=d2x(dbyte+112)
  else rbyte=d2x(dbyte+160)
  end

cur_sms=cur_sms||rbyte

i=i+4 
end

cur_sms=x2c(cur_sms)
return
/* ---- UCS2 PDU Decode Ends ---- */


/* ----- Close All Files -------*/
close_all:
call stream rclog,'c','close'
call stream debug.log,'c','close'
return
/* -----------------------------*/

term:
